;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc test_trape
@@l:

  mov    edi,[_0A0000h]
  mov    ecx,64000/4
  xor    eax,eax
  rep    stosd

  mov    eax,[@@x]
  sal    eax,16
  mov    [fpoly3_xl_hi],eax
  mov    eax,[@@x]
  add    eax,100
  sal    eax,16
  mov    [fpoly3_xr_hi],eax
  mov    [fpoly3_l_incr],1000h
  mov    [fpoly3_r_incr],(1000h*-1)
  mov    ebx,[@@y]
  mov    ecx,100
  add    ecx,[@@y]
  call   fpoly3_trape

  call   get_key
  cmp    al,27
  je     @@end
  cmp    al,"q"
  je     @@up
  cmp    al,"a"
  je     @@dn
  cmp    al,"z"
  je     @@lt
  cmp    al,"x"
  je     @@rt
  jmp    @@l
@@up:
  dec    [dword @@y]
  jmp    @@l
@@dn:
  inc    [dword @@y]
  jmp    @@l
@@lt:
  dec    [dword @@x]
  jmp    @@l
@@rt:
  inc    [dword @@x]
  jmp    @@l
@@end:
  ret
@@x                   dd 0
@@y                   dd 0
endp

proc test_fpoly3
  mov    edi,[_0A0000h]
  mov    ecx,64000/4
  xor    eax,eax
  rep    stosd

;struc fpoly3_stack
;  caller              dd ?
;  colour              dd ?
;  y3                  dd ?
;  x3                  dd ?
;  y2                  dd ?
;  x2                  dd ?
;  y1                  dd ?
;  x1                  dd ?
;ends

;  push   80 0 0 100 100 100 14


  push   50 100     0 0      100 0    14
  call   fpoly3
  add    esp,(size fpoly3_stack)-4

  call   get_key

  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc fd3_ani_world
  mov    edx,offset f3d_filename
  call   load_f3dfile
  mov    eax,[esi]
  mov    [f3d_no_facets],eax
  add    esi,4
  mov    [f3d_world_ptr],esi

  mov    esi,offset data_pal
  mov    ecx,256*3
  xor    al,al
  @WritePalette

  call   f3d_init

@@l:
  mov    edi,[_0A0000h]
  mov    ecx,64000/4
  xor    eax,eax
  rep    stosd

  call   f3d_project_world
  call   f3d_draw_world

  call   get_key
  cmp    al,27
  je     @@end

  cmp    al,"q"
  je     @@xi
  cmp    al,"a"
  je     @@xd

  cmp    al,"w"
  je     @@yi
  cmp    al,"s"
  je     @@yd

  cmp    al,"e"
  je     @@zi
  cmp    al,"d"
  je     @@zd

  cmp    al,"-"
  je     @@dddd
  cmp    al,"+"
  je     @@iiid

  jmp    @@l
@@xi:
  sub    [dword f3d_xangle],30h
  jmp    @@l
@@xd:
  add    [dword f3d_xangle],30h
  jmp    @@l

@@yi:
  sub    [dword f3d_yangle],30h
  jmp    @@l
@@yd:
  add    [dword f3d_yangle],30h
  jmp    @@l

@@zi:
  sub    [dword f3d_zangle],30h
  jmp    @@l
@@zd:
  add    [dword f3d_zangle],30h
  jmp    @@l

@@dddd:
  mov    eax,[dword f3d_Distance]
  sar    eax,5
  sub    [dword f3d_Distance],eax
  jmp    @@l
@@iiid:
  mov    eax,[dword f3d_Distance]
  sar    eax,5
  add    [dword f3d_Distance],eax
  jmp    @@l

@@end:

  call   f3d_deinit
  ret
endp

