// Pintado de polgonos de n lados con textura. Correccin cada 32 pixels
// 8 bbp
// Versin portable

// Requiere que la FPU est en modo Ceil.
// Es recomendable bajar la precisin del copro para las divisiones

#include "scan.h"

#if !Intel

extern WORD *texel;
extern DWORD iwidth;
extern FIXED16 ulimit,vlimit,uadjust,vadjust;

extern float Oa,Ha,Va;
extern float Ob,Hb,Vb;
extern float Oc,Hc,Vc;
extern float a0,b0,c0;

extern VERTEX *first_vrt,*last_vrt;
extern VERTEX *left_vrt,*right_vrt;

extern FIXED16 right_dxdy;        // 16.16
extern FIXED16 left_dxdy;         // 16.16

extern FIXED16 left_x,right_x;    // 16.16

// Aristas izquierdas. Recorren el array hacia adelante

static DWORD left_side(void) {

    SDWORD height;
    VERTEX *v1,*v2;         // Arriba - Abajo

    v1=left_vrt;
    if(left_vrt==last_vrt) v2=first_vrt;
    else v2=left_vrt+1;
    left_vrt=v2;

    height=ceil(v2->y)-ceil(v1->y);
    if(height<=0) return 0;

//    left_dxdy=((v2->x-v1->x)*65536.0)/(v2->y-v1->y);
    left_dxdy=v1->slope;

    left_x=v1->x*65536.0+(ceil(v1->y)-v1->y)*left_dxdy;

    return height;

}

// Aristas derechas. Recorren el array hacia atrs

static DWORD right_side(void) {

    SDWORD height;
    VERTEX *v1,*v2;         // Arriba - Abajo

    v1=right_vrt;
    if(right_vrt==first_vrt) v2=last_vrt;
    else v2=right_vrt-1;

    right_vrt=v2;

    height=ceil(v2->y)-ceil(v1->y);
    if(height<=0) return 0;

//    right_dxdy=((v2->x-v1->x)*65536.0)/(v2->y-v1->y);
    right_dxdy=v2->slope;

    right_x=v1->x*65536.0+(ceil(v1->y)-v1->y)*right_dxdy;

    return height;

}

void scan_poly32(VERTEX *vrt, DWORD no_vrt) {

    float miny,maxy;

    WORD *scan;
    VERTEX *vmin,*vmax;
    SDWORD i,count;
    float count_1;
    SDWORD left_height,right_height;
    SDWORD x1,width;
    FIXED16 u,v;
    FIXED16 nextu,nextv;
    FIXED16 ustep,vstep;

    float Ha32,Hb32,Hc32;

    float a,b,c,ci,cin;

    Ha32=Ha*32.0;
    Hb32=Hb*32.0;
    Hc32=Hc*32.0;

    first_vrt=vrt;
    last_vrt=vrt+no_vrt-1;

    vmin=vmax=vrt;
    miny=vrt->y;
    maxy=vrt->y;

    // Calcular la mxima y mnima altura
    // Las comparaciones deben hacerse en modo entero

    for(i=1;i<no_vrt;i++) {
        if((vrt+i)->y<miny) {
            vmin=vrt+i;
            miny=(vrt+i)->y;
        }
        else if ((vrt+i)->y>maxy) {
            vmax=vrt+i;
            maxy=(vrt+i)->y;
        }
    }

    left_vrt=right_vrt=vmin;

    do {
        if(right_vrt==vmax) return;
        right_height=right_side();
    } while(right_height<=0);

    do {
        if(left_vrt==vmax) return;
        left_height=left_side();
    } while(left_height<=0);

    // Avanzar por izquierda y por derecha

    scan=(WORD *)(virtual+((DWORD)ceil(miny))*graphics_system.bytes_scanline);

    a=a0+ceil(miny)*Va;
    b=b0+ceil(miny)*Vb;
    c=c0+ceil(miny)*Vc;

    for(;;) {

        x1 = (left_x+0xffff)>>16;
        width = ((right_x+0xffff)>>16) - x1;

//        if(width>0) memset(scan+x1,color,width);

        // Correccin cada 32 pixels

        if(width>0) {

            a0=a+x1*Ha;
            b0=b+x1*Hb;
            c0=c+x1*Hc;

            ci=65536.0/c0;
            c0+=Hc32;
            cin=65536.0/c0;

            u=uadjust+(DWORD)(a0*ci);
            v=vadjust+(DWORD)(b0*ci);

            if(u>ulimit) u=ulimit;
            else if(u<0) u=0;

            if(v>vlimit) v=vlimit;
            else if(v<0) v=0;

            do {
                if(width>=32) count=32;
                else count=width;

                width-=count;

                // Podemos hacer la divisin por shifts
                if(width) {

                    a0+=Ha32;
                    b0+=Hb32;

                    nextu=uadjust+(DWORD)(a0*cin);
                    nextv=vadjust+(DWORD)(b0*cin);

                    c0+=Hc32;
                    cin=65536.0/c0;

                    if(nextu>ulimit) nextu=ulimit;
                    else if(nextu<0) nextu=0;

                    if(nextv>vlimit) nextv=vlimit;
                    else if(nextv<0) nextv=0;

                    ustep=(nextu-u)>>5;
                    vstep=(nextv-v)>>5;

                }
                // No se puede usar shifts
                else {
                    if(count>1) {

                        count_1=(float)count-1;
                        a0+=Ha*count_1;
                        b0+=Hb*count_1;

                        c0-=Hc32-count_1*Hc;
                        cin=65536.0/c0;

                        nextu=uadjust+(DWORD)(a0*cin);
                        nextv=vadjust+(DWORD)(b0*cin);

                        if(nextu>ulimit) nextu=ulimit;
                        else if(nextu<0) nextu=0;

                        if(nextv>vlimit) nextv=vlimit;
                        else if(nextv<0) nextv=0;

                        ustep=(nextu-u)/(count-1);
                        vstep=(nextv-v)/(count-1);

                    }
                }

                for(i=0;i<count;i++) {

                    *(scan+x1++)=*(texel+((v>>16)*iwidth)+(u>>16));
                    u+=ustep;
                    v+=vstep;
                }

                u=nextu;
                v=nextv;

            } while (width>0);
        }

        scan+=graphics_system.xresolution;

        a+=Va;
        b+=Vb;
        c+=Vc;

        if(--right_height<=0) {
            do {
                if(right_vrt==vmax) return;
                right_height=right_side();
            } while(right_height<=0);
        }
        else right_x+=right_dxdy;

        if(--left_height<=0) {
            do {
                if(left_vrt==vmax) return;
                left_height=left_side();
            } while(left_height<=0);
        }
        else left_x+=left_dxdy;

    }
}

#endif
