//*****************************************************************************
//   Abrir ficheros, leer mundo, cmaras, objetos, animaciones ...
//*****************************************************************************

#include <icp.h>
#include <log.h>
#include <string.h>
#include "file.h"

DWORD memory_needed;

BOOLEAN load_world(BYTE *name) {

    FILE *fp;
    DWORD i,j,hijo,tsize;
    WORD a,b;
    FILEINFO wrl;

    wrl=lib_getfileinfo(name);

    if((fp=fopen(wrl.name,"rb"))==NULL) return TRUE;
    fseek(fp,wrl.offset,SEEK_SET);

    fread(&world_mesh.no_vertex,1,sizeof(DWORD),fp);
    fread(&world_mesh.no_edges,1,sizeof(DWORD),fp);
    fread(&world_mesh.no_polys,1,sizeof(DWORD),fp);
    fread(&world_mesh.used_edges,1,sizeof(DWORD),fp);
    fread(&world_mesh.no_maps,1,sizeof(DWORD),fp);
    fread(&tsize,1,sizeof(DWORD),fp);

    lib_log(2,"Vrtices  : %d",world_mesh.no_vertex);
    lib_log(2,"Aristas   : %d",world_mesh.no_edges);
    lib_log(2,"Polgonos : %d",world_mesh.no_polys);
    lib_log(2,"Texturas  : %d",world_mesh.no_maps);
    lib_log(2,"Tsize     : %d",tsize);

    memory_needed=world_mesh.no_vertex*sizeof(VECTOR) +
           world_mesh.no_edges*sizeof(EDGE)    +
           world_mesh.no_polys*sizeof(BSP_TREE)+
           world_mesh.used_edges*sizeof(SWORD) +
           CACHED_EDGES*sizeof(STACK_EDGE)     +
           world_mesh.no_maps*sizeof(TEXTURE)  +
           tsize*sizeof(BYTE);

//    printf("\n   -Memoria requerida: %d bytes",memory_needed);
    world_mesh.base=malloc(memory_needed);
    if(world_mesh.base==NULL) fatal_error("No hay memoria (load_world)");

    world_mesh.pts=(VECTOR *)world_mesh.base;
    fread(world_mesh.pts,world_mesh.no_vertex,sizeof(VECTOR),fp);

    world_mesh.edges=(EDGE *)(world_mesh.pts+world_mesh.no_vertex);
    for(i=0;i<world_mesh.no_edges;i++) {
        fread(&a,1,sizeof(a),fp);
        fread(&b,1,sizeof(b),fp);
        (world_mesh.edges+i)->a=a;
        (world_mesh.edges+i)->b=b;
    }

    world_mesh.bsp=(BSP_TREE *)(world_mesh.edges+world_mesh.no_edges);

    world_mesh.edge_list=(SWORD *)(world_mesh.bsp+world_mesh.no_polys);
    fread(world_mesh.edge_list,world_mesh.used_edges,sizeof(SWORD),fp);

    cached_edges=(STACK_EDGE *)(world_mesh.edge_list+world_mesh.used_edges);

    world_mesh.maps=(TEXTURE *)(cached_edges+CACHED_EDGES);
    world_mesh.bitmap=(BYTE *)(world_mesh.maps+world_mesh.no_maps);

//  BSP 

    for(i=0;i<world_mesh.no_polys;i++) {

        fread(&(world_mesh.bsp+i)->root.eq,1,sizeof(MAT_PLANO),fp);

        fread(&(world_mesh.bsp+i)->root.texture,1,sizeof(BYTE),fp);

        fread(&(world_mesh.bsp+i)->root.p,1,sizeof(VECTOR),fp);
        fread(&(world_mesh.bsp+i)->root.m,1,sizeof(VECTOR),fp);
        fread(&(world_mesh.bsp+i)->root.n,1,sizeof(VECTOR),fp);

        fread(&(world_mesh.bsp+i)->root.start_edge,1,sizeof(DWORD),fp);
        fread(&(world_mesh.bsp+i)->root.no_edges,1,sizeof(BYTE),fp);

        for(j=0;j<6;j++)
            fread((world_mesh.bsp+i)->limit+j,1,sizeof(float),fp);

        fread(&hijo,1,sizeof(DWORD),fp);
        if(hijo==-1) (world_mesh.bsp+i)->left=NULL;
        else (world_mesh.bsp+i)->left=world_mesh.bsp+(DWORD)hijo;

        fread(&hijo,1,sizeof(DWORD),fp);
        if(hijo==-1) (world_mesh.bsp+i)->right=NULL;
        else (world_mesh.bsp+i)->right=world_mesh.bsp+(DWORD)hijo;

        (world_mesh.bsp+i)->root.scache[0]=NULL;
        (world_mesh.bsp+i)->root.scache[1]=NULL;
        (world_mesh.bsp+i)->root.scache[2]=NULL;
        (world_mesh.bsp+i)->root.scache[3]=NULL;

    }

// Texturas

    for(i=0;i<world_mesh.no_maps;i++) {
        fread(&(world_mesh.maps+i)->name,20,sizeof(BYTE),fp);
        fread(&(world_mesh.maps+i)->width,1,sizeof(float),fp);
        fread(&(world_mesh.maps+i)->height,1,sizeof(float),fp);
        fread(&(world_mesh.maps+i)->pal[0],256,sizeof(ORGB),fp);
        fread(&(world_mesh.maps+i)->pal[1],256,sizeof(ORGB),fp);
        fread(&(world_mesh.maps+i)->pal[2],256,sizeof(ORGB),fp);
        fread(&(world_mesh.maps+i)->pal[3],256,sizeof(ORGB),fp);
        fread(&(world_mesh.maps+i)->offset[0],1,sizeof(DWORD),fp);
        fread(&(world_mesh.maps+i)->offset[1],1,sizeof(DWORD),fp);
        fread(&(world_mesh.maps+i)->offset[2],1,sizeof(DWORD),fp);
        fread(&(world_mesh.maps+i)->offset[3],1,sizeof(DWORD),fp);
    }

    fread(world_mesh.bitmap,tsize,sizeof(BYTE),fp);

    fclose(fp);

    for(i=0;i<world_mesh.no_polys;i++)
        calc_surface_bounds(&(world_mesh.bsp+i)->root);

    return FALSE;

}

// Calcula cuantos pixel de textura tiene aplicado un polgono. Modifica
//  los vectores p,m y n para ajustarse a una textura expandida sin tiling.
// La textura deber expandirse con el correspondiente procedimiento.

void calc_surface_bounds(NGON *s) {

    float umin,vmin,umax,vmax;
    float u,v;
    float det1,det2,det3;
    float width,height;
    float tx,ty;

    SDWORD minu,minv;
    SDWORD i;
    SWORD edge;
    VECTOR vr;

    umin=vmin=999999;
    umax=vmax=-999999;

    for(i=0;i<s->no_edges;i++) {
        edge=*(world_mesh.edge_list+s->start_edge+i);
        if(edge>0)
            vr=*(world_mesh.pts+(world_mesh.edges+edge)->a);
        else
            vr=*(world_mesh.pts+(world_mesh.edges-edge)->b);

        det1=s->m.x*s->n.y-s->n.x*s->m.y;
        det2=s->m.x*s->n.z-s->n.x*s->m.z;
        det3=s->m.y*s->n.z-s->n.y*s->m.z;

        if(zero(det1) && zero(det2) && zero(det3))
            fatal_error("!Det!=0");

        if(fabs(det1)>fabs(det2) && fabs(det1)>fabs(det3)) {
            u=((vr.x-s->p.x)*s->n.y - s->n.x*(vr.y-s->p.y))/det1;
            v=(s->m.x*(vr.y-s->p.y) - (vr.x-s->p.x)*s->m.y)/det1;
        }
        else if(fabs(det2)>fabs(det1) && fabs(det2)>fabs(det3)) {
            u=((vr.x-s->p.x)*s->n.z - s->n.x*(vr.z-s->p.z))/det2;
            v=(s->m.x*(vr.z-s->p.z) - (vr.x-s->p.x)*s->m.z)/det2;
        }
        else {
            u=((vr.y-s->p.y)*s->n.z - s->n.y*(vr.z-s->p.z))/det3;
            v=(s->m.y*(vr.z-s->p.z) - (vr.y-s->p.y)*s->m.z)/det3;
        }

        if(u<umin) umin=u;
        if(u>umax) umax=u;

        if(v<vmin) vmin=v;
        if(v>vmax) vmax=v;

    }

    s->p.x=s->p.x + s->m.x*umin + s->n.x*vmin;
    s->p.y=s->p.y + s->m.y*umin + s->n.y*vmin;
    s->p.z=s->p.z + s->m.z*umin + s->n.z*vmin;

    s->m.x*=(umax-umin);
    s->m.y*=(umax-umin);
    s->m.z*=(umax-umin);

    s->n.x*=(vmax-vmin);
    s->n.y*=(vmax-vmin);
    s->n.z*=(vmax-vmin);

    tx=(world_mesh.maps+s->texture)->width;
    ty=(world_mesh.maps+s->texture)->height;

    width=(umax-umin)*tx;
    height=(vmax-vmin)*ty;

    if(width>256.0 || height>256.0)        {
        fatal_error("Textura muy grande");
    }

    s->mipadjust=128/((umax-umin)*tx+(vmax-vmin)*ty);

    while(umin<0) umin+=1.0;
    while(vmin<0) vmin+=1.0;

    minu=umin*65536.0*tx;
    minv=vmin*65536.0*ty;

    s->minu=minu;
    s->minv=minv;
    s->width=width;
    s->height=height;

}

BOOLEAN load_camera(BYTE *name) {

    BYTE *buffer;

    camera_loaded=FALSE;

    if((buffer=lib_fopen(name))==NULL) return TRUE;

    camera_frames=*((DWORD *)buffer);
    lib_log(2,"camera_frames: %d",camera_frames);

    if((track_camera=malloc(camera_frames*sizeof(CAMERA_FRAME)))==NULL) {
        free(buffer);
        return TRUE;
    }
    else {
        memcpy(track_camera,buffer+sizeof(DWORD),camera_frames*sizeof(CAMERA_FRAME));
        free(buffer);
        camera_loaded=TRUE;
        return FALSE;
    }
}
