--      PHONGPAL.PAS    -- written by FAC

--      nice little utility that creates a palette using
--      the phong ilumination model.

{ PhongPal  --  por: Alfonso Alba Cadena }

{ Crea una paleta utilizando el modelo Phong }

unit PhongPal;

interface

uses Mode13pm;

procedure MakePhongPal( ra, rd, rs, ga, gd, gs, ba, bd, bs : single;
                        n : word; var p : TPalette; start, range : word);

{ Parameters:   ra, ga, ba - Ambiental illumination coefs for each
                             color component (R, G, B)

                rd, gd, bd - Diffuse illumination coefs.

                rs, gs, bs - Specular highlight coefs

                n  - Specular reflection parameter

                p  - Destination palette

                start - first palette color used for the gradient

                range - number of colors in the gradient
}


implementation

procedure MakePhongPal( ra, rd, rs, ga, gd, gs, ba, bd, bs : single;
                        n : word; var p : TPalette; start, range : word);
var i, r, g, b : word;
    ang, angadd : single;
    dif, spec : single;

    { we need a pow function }
    function pow(base, exponente : single) : single;
    begin
         if base <= 0 then pow := 0 else pow := exp(ln(base) * exponente);
    end;

begin
     if range > 256 then range := 256;
     ang := pi / 2;
     angadd := (pi / range) / 2;
     for i := 0 to (range - 1) do
     begin
          dif := cos(ang) * rd;
          spec := pow(cos(ang), n) * rs;
	  r := trunc((ra + dif + spec) / 4.0);
          if r > 63 then r := 63;

          dif := cos(ang) * gd;
          spec := pow(cos(ang), n) * gs;
	  g := trunc((ga + dif + spec) / 4.0);
          if g > 63 then g := 63;

	  dif := cos(ang) * bd;
          spec := pow(cos(ang), n) * bs;
	  b := trunc((ba + dif + spec) / 4.0);
          if b > 63 then b := 63;

	  p[start + i][0] := r;
          p[start + i][1] := g;
          p[start + i][2] := b;

	  ang := ang - angadd;
     end;
end;


end.
