--      geninfo1.pas
--      this prog generates the file charset.chr which contains
--      the information of the character set.

--      the structure of the file can be found in PCHARSET.PAS


uses pCharSet;

const fn = 'charset.chr';

var info : TCharSetInfo;
    f : file of TCharSetInfo;
    i, x, y : word;
    c : char;

begin
     fillchar(info, sizeof(info), 0);

     info.charmap := 'charset.pcx';
     info.SizeX := 32;
     info.SizeY := 32;

     for c := ' ' to '=' do
     begin
          y := ((ord(c) - ord(' ')) div 10 + 3) * 32;
          x := ((ord(c) - ord(' ')) mod 10) * 32;
          info.Chars[c].x := x;
          info.Chars[c].y := y;
     end;

     for c := 'a' to '~' do
     begin
          y := ((ord(c) - ord('a')) div 10) * 32;
          x := ((ord(c) - ord('a')) mod 10) * 32;
          info.Chars[c].x := x;
          info.Chars[c].y := y;
     end;

     assign(f, fn);
     rewrite(f);
     write(f, info);
     close(f);
end.

