;
; Poly Versin 3.50
;
; Code: Chc/Chc!Productions
;
; Version 2.45: 20-27 de Mayo y 1-2 de Junio de 1994
; Version 3.00: 19 y 20 de Julio de 1995
; Version 3.50: 29,30 y 31 de Agosto de 1995
;
; MODIFICACIONES EN LA VERSION 2.45:
;
;       1 de Mayo: ya hay fijados algunos bugs desde la versin 2.15
;       2 de Mayo: ahora ya acepta multiples vertices y el rellenado es ms
;                  exacto...
;       3 de Mayo: ya soporta tweaked...
;
; MODIFICACIONES EN LA VERSION 3.00:
;
;       19 de Julio: eliminado el bug de la conversin a DWORD (Hey Jon!) y
;                    acelerada la velocidad mediante la inclusin de una
;                    tabla intermedia para el trazado
;       20 de Julio: ya soporta environment mapping para simular PHONG!
;
; MODIFICACIONES EN LA VERSION 3.50:
;
;       29 de Agosto: soporte slo para tringulos
;       30 de Agosto: soporte para environment mapping slo con tringulos
;
;       NOTA: alguien puede pensar que el hacer los casos no es necesario,
;             pero realmente hay que fijarse en que para no tener que
;             inicializar los buffers del trazado debe ser el ltimo
;             polgono que vaya de arriba hacia abajo, el que debe dejar
;             la marca de final de polgono, que no es ms que una linea
;             negativa...
;
;
; FORMATO DE ENTRADA EN VERSION 3.50:
;
;       OFFSET     LONGITUD    SIGNIFICADO
;     
;          0          2        Nmero de vrtices en el polgono
;          2          2        Color del polgono
;          4          4        No usado (En real3D 3.00 es la distancia media)
;          8          2        X[0] (coordenadas de la pantalla)
;          10         2        Y[0] (coordenadas de la pantalla)
;          12         2        NormalX[0]
;          14         2        NormalY[0]
;          ..         2        X[1] ....
;
;

; Algunas definiciones estpidas...

LENGTH_ROWS EQU 4800         ;longitud de la tabla de trazado
VIS   EQU 800                ;inicio de la posicion visible
DER   EQU 2400               ;hemos de almacenar X slo
POSX1 EQU 0
POSY1 EQU 2
NORX1 EQU 4
NORY1 EQU 6
POSX2 EQU 8
POSY2 EQU 10
NORX2 EQU 12
NORY2 EQU 14
POSX3 EQU 16
POSY3 EQU 18
NORX3 EQU 20
NORY3 EQU 22


; Inicializa el tringulo para ser trazado
; Busca el vrtice de Y menor para trazar hacia abajo

                    ALIGN 16

Inicializa_Clipping MACRO
                    LOCAL @@menor_Y1,@@menor_Y1o2,@@no_negativo,@@abort,@@sigue,@@sigue0,@@sigue1


                     ; Si todos los puntos estan a la izquierda no dibuja

                     cmp word ptr [si+POSX1],0
                     jge @@sigue0
                     cmp word ptr [si+POSX2],0
                     jge @@sigue0
                     cmp word ptr [si+POSX3],0
                     jl  @@fuera

                     ; Si todos los puntos estan a la derecha no dibuja
@@sigue0:
                     cmp word ptr [si+POSX1],320
                     jl  @@sigue1
                     cmp word ptr [si+POSX2],320
                     jl  @@sigue1
                     cmp word ptr [si+POSX3],320
                     jge @@fuera

                    ; Si todos los puntos estn fuera de la pantalla,
                    ; ignora el polgono entero...
@@sigue1:
                    cmp word ptr [si+POSY1],0
                    jge @@sigue
                    cmp word ptr [si+POSY2],0
                    jge @@sigue
                    cmp word ptr [si+POSY3],0
                    jl  @@fuera

@@sigue:
                    mov bx,OFFSET triangulo1

                    ; Busca el punto ms elevado y comienza a trazar ah

                    mov ax,[si+POSY1]
                    cmp ax,[si+POSY2]
                    jle @@menor_Y1

                    mov ax,[si+POSY2]
                    mov bx,OFFSET triangulo2
@@menor_Y1:
                    cmp ax,[si+POSY3]
                    jle @@menor_Y1o2

                    mov ax,[si+POSY3]
                    mov bx,OFFSET triangulo3

@@menor_Y1o2:
                    ; recorte por abajo

                    cmp ax,200
                    jge @@fuera

                    test ax,0ffffh
                    jns @@no_negativo

                    mov [inicio],0
                    mov [rinicio],0
                    jmp @@abort
@@no_negativo:
                    mov di,ax
                    sal ax,2
                    mov [inicio],ax
                    shl di,1
                    mov ax,[OFFSET multiplicar + di]
                    mov [rinicio],ax
@@abort:
                    ENDM

; Ahora traza las lineas

ScanLine   MACRO
           LOCAL @@next,@@abort,@@no_clipx,@@no_clipy,@@next2,@@m0,@@n_pixel

           push fs
           mov ax,data2
           mov fs,ax

           mov si,OFFSET destino+VIS
           add si,[inicio]
           mov di,[rinicio]

@@next:    mov bp,di

           mov cx,[si+DER+2]
           mov ax,[si+2]

           cmp cx,ax
           jl  @@abort

           ; recorte horizontal del polgono (an no implementado)

;           cmp cx,320
;           jl  @@no_clipx
;
;           mov cx,319
;@@no_clipx:
;           cmp ax,0
;           jge @@no_clipy
;
;           sub ax,ax
;@@no_clipy:

           ; ahora traza la linea

           sub cx,ax
           inc cx
           jle @@next2

           add di,ax

           ; ahora clculos para la interpolacion de las normales

           mov bx,[si+DER+LENGTH_ROWS+2]        ;norx. destino
           sub bx,[si+LENGTH_ROWS+2]            ;norx. source
           mov bl,bh
           mov bh,cl
           shl bx,1
           mov ax,gs:[bx]
           shl eax,16

           mov bx,[si+DER+LENGTH_ROWS]          ;nory. destino
           sub bx,[si+LENGTH_ROWS]              ;nory. source
           mov bl,bh
           mov bh,cl
           shl bx,1
           mov ax,gs:[bx]
           mov edx,eax

           mov ax,[si+LENGTH_ROWS+2]
           shl eax,16
           mov ax,[si+LENGTH_ROWS]

@@n_pixel:
           shld ebx,eax,16
           mov bl,ah
           mov bl,fs:[bx + light + 128 + 128*256]
           mov es:[di],bl
           add eax,edx
           inc di
           dec cx
           jnz @@n_pixel

@@next2:
           mov di,bp
           add di,320
           add si,4
           jmp @@next

@@abort:   pop fs

           ENDM

; Introduce una linea en el buffer de lineas

Linea      MACRO x1,y1,x2,y2,nx1,ny1,nx2,ny2
           LOCAL @@abort,@@izquierda,@@derecha,@@next0,@@DYmayorDX,@@next000,@@nothingtodo

           push si

           mov [dxmayordy],0
           mov [negativo],0

           ; clculo de las variables para interpolar las normales

           mov cx,[si+nx2]
           mov ax,[si+nx1]
           sub cx,ax
           mov [nx],cx
           mov [nrx1],ax

           mov cx,[si+ny2]
           mov ax,[si+ny1]
           sub cx,ax
           mov [ny],cx
           mov [nry1],ax

           ; clculo del resto de variables para trazar la linea

           mov bx,[si+x1]
           mov bp,[si+y1]

           mov ax,[si+x2]       ; AX == diferencial de X
           sub ax,[si+x1]

           mov cx,[si+y2]
           sub cx,[si+y1]       ; CX == diferencial de Y
           jz @@abort
           jns @@derecha

           ; esto corresponde a la izquierda

@@izquierda:
           ; se han de intercambiar los valores, ya que ahora vamos al revs

           mov bx,[si+nx2]
           mov [nrx1],bx
           mov bx,[si+ny2]
           mov [nry1],bx

           neg [nx]
           neg [ny]

           mov bx,[si+x2]
           mov bp,[si+y2]
           sub di,DER
           neg cx
           neg ax
           mov [negativo],1
@@derecha:
           cmp ax,cx            ;DX > DY -> primero incrementar y despues trazar
           jl  @@nothingtodo

           mov [dxmayordy],1
@@nothingtodo:
           movsx ecx,cx
           shl eax,16
           cdq
           idiv ecx

           sal bp,2            ;*4
           add di,bp           ;ahora colcate donde debes
           mov ebp,eax

           shl ebx,16
           add ebx,08000h  ;sitate en el centro
           mov edx,ebx

           ; ahora calcula la interpolacion de normales X e Y

           mov ax,[nx]
           mov bl,ah
           mov bh,cl
           shl bx,1
           mov si,gs:[bx]
           shl esi,16

           mov ax,[ny]
           mov bl,ah
           mov bh,cl
           shl bx,1
           mov si,gs:[bx]

           mov ax,[nrx1]
           shl eax,16
           mov ax,[nry1]

           cmp [dxmayordy],1
           jne @@next0

           add edx,ebp
           add eax,esi
@@next0:
           mov [di],edx
           mov [di+LENGTH_ROWS],eax
           add edx,ebp
           add eax,esi
           add di,4
           dec cx
           jnz @@next0

           cmp [negativo],1
           je  @@abort

           mov dword ptr [di],080000000h
           mov dword ptr [di-DER],0

@@abort:   pop si

           ENDM


;  Unidad de polgonos  

        ALIGN 16

; Dibuja un polgono

DPoly   PROC NEAR

        cld
        push gs
        mov gs,[multable]
        add si,4                ; esquiva valores iniciales que no se usan
                                ; en esta versin...
        Inicializa_Clipping     ; busca el vrtice mayor...
        jmp bx

triangulo1:
        mov di,OFFSET destino+DER+VIS
        Linea POSX1,POSY1,POSX2,POSY2,NORX1,NORY1,NORX2,NORY2
        mov di,OFFSET destino+DER+VIS
        Linea POSX2,POSY2,POSX3,POSY3,NORX2,NORY2,NORX3,NORY3
        mov di,OFFSET destino+DER+VIS
        Linea POSX3,POSY3,POSX1,POSY1,NORX3,NORY3,NORX1,NORY1
        mov di,OFFSET destino+DER+VIS*2
        mov dword ptr [di],080000000h
        mov dword ptr [di-DER],0
        ScanLine
        pop gs
        ret

triangulo2:
        mov di,OFFSET destino+DER+VIS
        Linea POSX2,POSY2,POSX3,POSY3,NORX2,NORY2,NORX3,NORY3
        mov di,OFFSET destino+DER+VIS
        Linea POSX3,POSY3,POSX1,POSY1,NORX3,NORY3,NORX1,NORY1
        mov di,OFFSET destino+DER+VIS
        Linea POSX1,POSY1,POSX2,POSY2,NORX1,NORY1,NORX2,NORY2
        mov di,OFFSET destino+DER+VIS*2
        mov dword ptr [di],080000000h
        mov dword ptr [di-DER],0
        ScanLine
        pop gs
        ret

triangulo3:
        mov di,OFFSET destino+DER+VIS
        Linea POSX3,POSY3,POSX1,POSY1,NORX3,NORY3,NORX1,NORY1
        mov di,OFFSET destino+DER+VIS
        Linea POSX1,POSY1,POSX2,POSY2,NORX1,NORY1,NORX2,NORY2
        mov di,OFFSET destino+DER+VIS
        Linea POSX2,POSY2,POSX3,POSY3,NORX2,NORY2,NORX3,NORY3
        mov di,OFFSET destino+DER+VIS*2
        mov dword ptr [di],080000000h
        mov dword ptr [di-DER],0
        ScanLine
@@fuera:
        pop gs
        ret

        ENDP

