;                                                                            
; COOL!.COM                                Call GENIAAL BBS 2 for more info: 
;                                          +31-2294-2959/3154                
; Written by Michiel Ouwehand                                                
; Sample program of a small BBS advert, requires VGA and a 8086.
;
;<][>
;
; Note: This is only the first EXE program I wrote, so I had to rip the init
;       stuff from REN-93.ASM, thanks Renaissance!
;
;<][>
;
; Warning: This program may look very big after assembling and linking, but it
; reduces size humoungously after using programs like PKLITE, LZEXE, DATADIET
;
;<][>
;
; Contact me at: (InterNet) michiel@progsup.tess.wlink.nl
;                  (FidNet) 2:2802/108.11
;
; Assembled using: TASM 3.1
; Image processing utility programs compiled with: Borland C++ 3.1
;

;.model tiny

CODE    SEGMENT                                 ; Now, open code segment
        ASSUME CS:CODE, DS:CODE                 ; I've seen this before

        org     100h

Start:
        CLD                                     ; Clear direction
        MOV     AX, CS                          ; Allright, code segment...
        MOV     DS, AX                          ; ...is data segment

        XOR     BX, BX                          ; Check for VGA
        MOV     AX, 01A00h                      ; Get mode support byte
        INT     10h                             ; Video function
        CMP     BL, 7                           ; This is the least we need
        JGE     VGAPresent                      ; VGA is present

        MOV     DX, OFFSET NoVGA                ; Offset of error message
        MOV     AH, 9                           ; Show message function
        INT     21h                             ; Show it
        MOV     AX, 4CFFh                       ; Exit program
        INT     21h                             ; And exit

VGAPresent:
        MOV     SI, OFFSET Screen1              ; Reading from packed font
        MOV     AX, CS                          ; Going to CS/DS for depacked font
        MOV     ES, AX                          ; The destination segment
        MOV     DI, OFFSET FontData             ; To the depacked font
        MOV     CX, 6695                        ; Converting 6695 bytes

TWOTOEIGHT:
        PUSH    CX                              ; Save CX
        XOR     BX, BX                          ; 0 Bytes to shift this time
        MOV     CX, 4                           ; 4 Times 2 bits in a byte
        MOV     BL, [SI]                        ; Get one byte
        CMP     BL, 160                         ; Are we changing table?
        JNE     NOPROBLEM                       ; Nope
        ;
        ; <<*!*! Warning !*!*>>
        ;
        ; What I just did with that compare to 160 *_*VERY*_* groce... That's
        ; why I used it. The number 160 only seems to be present in the line
        ; line numbers bitmap and thus is a sort of marker.
        ;
        MOV     byte ptr [ConvertTable+1], 109
        MOV     byte ptr [ConvertTable+2], 129
        MOV     byte ptr [ConvertTable+3], 145
NOPROBLEM:
        INC     SI                              ; Next byte next time
FOURBYTESOUT:
        PUSH    CX                              ; And again a loop
        MOV     CL, BH                          ; Number of bytes to rotate
        MOV     DL, 3                           ; 3 is %00000011
        SHL     DL, CL                          ; Now, the mask for filter
        MOV     AL, BL                          ; (We may *not* touch BL!)
        AND     AL, DL                          ; Now, filter bits out of BL
        SHR     AL, CL                          ; And rotate (move bits to right)
        CALL    Convert                         ; Convert to normal type
        STOSB                                   ; Store in destination
        ADD     BH, 2                           ; Next time 2 bits more
        POP     CX                              ; Save for this loop
        LOOP    FOURBYTESOUT                    ; And loop

        POP     CX                              ; CX is also used for SHR
        LOOP    TWOTOEIGHT                      ; Convert next byte

;
;  Set Video mode
;

        MOV     AX, 13h                         ; Graphics mode
        INT     10h                             ; Do it!

;
;  Set palette
;

        MOV     DX, 03C8h                       ; Port 3C8 for palette
        XOR     AL, AL                          ; We'll send 0 through the port
        OUT     DX, AL                          ; Start with colour 0
        INC     DX                              ; Next port is data port

        MOV     CX, 64                          ; 64 Grayshades
SETONE:
        OUT     DX, AL                          ; One byte
        OUT     DX, AL                          ; One byte
        OUT     DX, AL                          ; One byte
        INC     AL                              ; One grayshade up
        LOOP    SETONE                          ; And go on

        MOV     CX, 96                          ; 96 Bytes for logo palette
        MOV     BX, 0                           ; Internal counter
SETLOGO:
        MOV     AL, [LogoPal+BX]                ; Get Byte
        INC     BX                              ; Next colour next time
        OUT     DX, AL                          ; And send it
        LOOP    SETLOGO                         ; Next one

        XOR     AL, AL                          ; Clear output
        MOV     CX, 64                          ; 64 Grayshades
SETTTONE:
        OUT     DX, AL                          ; One byte (only red is set)
        INC     AL                              ; One redshade up
        PUSH    AX                              ; Save AL
        XOR     AL, AL                          ; Clear it
        OUT     DX, AL                          ; One byte
        OUT     DX, AL                          ; One byte
        POP     AX                              ; Restore AL
        LOOP    SETTTONE                        ; And go on

;
; Prepare first screen
;

        MOV     AX, CS                          ; Segment of screen 1...
        MOV     ES, AX                          ; ...in ES
        MOV     DI, OFFSET Screen1              ; Offset of screen 1
        MOV     CX, 3840                        ; Number of words to clear
        XOR     AX, AX                          ; Fill with 0's
        REP     STOSW                           ; And clear it

        MOV     DI, OFFSET Screen1              ; Show on screen 1
        CALL    ShowText                        ; Show it

        MOV     DI, 6457                        ; Starting offset
        MOV     SI, OFFSET Mixer                ; The offset
        MOV     CX, 36                          ; 36 Lines in LOGO
        MOV     DX, 207                         ; Bytes per line
        CALL    MoveToScreen                    ; Show this

        MOV     DI, 44869                       ; Starting offset
        MOV     SI, OFFSET FontData+21312       ; The offset
        MOV     CX, 18                          ; 18 Lines
        MOV     DX, 108                         ; 108 Bytes-a-line
        PUSH    DX CX SI                        ; Save most of it
        CALL    MoveToScreen                    ; Show it

        POP     SI CX DX                        ; Restore stuff
        MOV     DI, 51589                       ; Starting offset
        CALL    MoveToScreen                    ; Show it

        MOV     SI, OFFSET FontData+23256       ; The offset
        MOV     DI, 44979                       ; Starting offset
        MOV     CX, 39                          ; 36 Lines
        MOV     DX, 72                          ; 72 bytes per line
        CALL    MoveToScreen                    ; Show it

;
; Main program
;

MAINLOOP:
        MOV     DI, OFFSET Screen2              ; Show on screen 2
        CALL    ShowText                        ; Show it!

        XOR     DH, DH                          ; Intensity 2

INTENSITYLOOP:
        MOV     DL, 64                          ; Take 64 as default
        SUB     DL, DH                          ; Substract other sensitivity

        MOV     CX, 7680                        ; Now, calculate 7680 bytes
        XOR     BX, BX                          ; BX is the positive counter

        MOV     AX, CS                          ; Segment of Mixer screen
        MOV     ES, AX                          ; In destination segment
        MOV     DI, OFFSET Mixer                ; Offset  of Mixer screen

MORPHLOOP:
        MOV     AL, [Screen1+BX]                ; Take a byte from screen 1
        MUL     DL                              ; Now we've got the new value
        MOV     SI, AX                          ; Save this new one
        MOV     AL, [Screen2+BX]                ; Take a byte from screen 2
        MUL     DH                              ; Now we've got the new value
        ADD     AX, SI                          ; Save this new one
        SHR     AX, 6                           ; Divide by 64
        STOSB                                   ; Put this byte on the screen
        INC     BX                              ; Positive counter increases
        LOOP    MORPHLOOP                       ; Hehehe morph the thing

;
; Wait for a VBL to pass to avoid 'flicker'
;

        MOV     BX, DX                          ; Save DX in BX
        MOV     DX, 3DAh                        ; VGA's port

WVBL1:  IN      AL, DX                          ; Get a byte
        TEST    AL, 8                           ; Now, 3d bit set?
        JZ      WVBL1                           ; Jope!

WVBL2:  IN      AL, DX                          ; And again
        TEST    AL, 8                           ; Now, VSYNC?
        JNZ     WVBL2                           ; Nope

        MOV     DX, BX                          ; Restore DX from BX

        MOV     AX, 0A000h                      ; Screen segment...
        MOV     ES, AX                          ; ...in ES
        MOV     DI, 25600                       ; Start at Y = 80
        MOV     SI, OFFSET Mixer                ; And it's offset
        MOV     CX, 3840                        ; Move all with words
        REP     MOVSW                           ; Move it!

        MOV     AX, 0100h                       ; Function 1, check buffer...
        INT     16h                             ; ...for keystroke
        JNZ     OUTOFLOOP                       ; Key, then exit

        ADD     DH, 2                           ; Increase intensity
        CMP     DH, 64                          ; Well?
        JLE     INTENSITYLOOP                   ; Still go on

;
; This morph is done, copy screens
;

        MOV     SI, OFFSET Screen2              ; Offset of screen 2
        MOV     AX, CS                          ; Segment of screen 1...
        MOV     ES, AX                          ; ...in ES
        MOV     DI, OFFSET Screen1              ; Offset of screen 1
        MOV     CX, 3840                        ; Number of words to copy
        REP     MOVSW                           ; And clear it

;
; We've copied it, now let's clear the old screen
;

        MOV     AX, CS                          ; Segment of screen 2...
        MOV     ES, AX                          ; ...in ES
        MOV     DI, OFFSET Screen2              ; Offset of screen 2
        MOV     CX, 3840                        ; Number of words to clear
        XOR     AX, AX                          ; Fill with 0's
        REP     STOSW                           ; And clear it

        XOR     AX, AX                          ; AX=0, request system time
        INT     1Ah                             ; Ask time
        ADD     DX, 10                          ; Next timer-tick
        ADC     CX, 0                           ; Carries etc.
WAITLOOP:
        PUSH    CX DX                           ; Save user's trigger

        XOR     AX, AX                          ; Clear AX, ask timer value
        INT     1Ah                             ; Ask for system-time
        MOV     AX, CX                          ; Now, CX => AX
        MOV     BX, DX                          ; Now, DX => BX

        POP     DX CX                           ; Restore user's trigger
        CMP     AX, CX                          ; Let's see
        JG      EXITWLOOP                       ; Let's exit
        CMP     BX, DX                          ; Let's see
        JG      EXITWLOOP                       ; Let's exit
        CMP     DX, 64000                       ; User's trigger greater than..
        JLE     WAITLOOP                        ; Nope, loop
        CMP     BX, 2000                        ; Out trigger
        JLE     EXITWLOOP                       ; His is larger, out smaller...
        JMP     WAITLOOP                        ; And loop
EXITWLOOP:

        JMP     MAINLOOP                        ; It's endless fun

OUTOFLOOP:

;
; Restore video mode
;

        MOV     AX, 3                           ; Text mode
        INT     10h                             ; VIDEO Function

        MOV     AX, 4C00h                       ; Exit program
        INT     21h                             ; And that's it

ShowText proc
        PUSH    SI ES                           ; Save Segment registers

        ; Registers:
        ;   AX      = Current character
        ;   ES:[DI] = Screen  address
        ;   [SI] = Address of text

        MOV     SI, OFFSET Text                 ; Offset  of text
        ADD     SI, [TextIndex]                 ; Saved it last time
        MOV     AX, CS                          ; CS will be...
        MOV     ES, AX                          ; ...Destination segment
        MOV     AX, 26                          ; Multiply with 26
        MUL     byte ptr [SI]                   ; Multiply with length of string
        MOV     BX, 320                         ; 320 in BX
        SUB     BX, AX                          ; Now, remove the stuff we've got
        SHR     BX, 1                           ; And divide by two
        ADD     DI, BX                          ; And center it
        INC     SI                              ; Forget centerring byte
        INC     [TextIndex]                     ; Got one more

TEXTLOOP:
        XOR     AX, AX                          ; Clear AX (only AL is updated)
        MOV     AL, [SI]                        ; Take one character
        INC     [TextIndex]                     ; Got one more
        INC     SI                              ; Next char next time
        CMP     AL, 200                         ; 200 is next line
        JE      EXITLOOP                        ; It is a pipe, exit
        CMP     AL, 199                         ; 199 is end-of-text
        JE      STARTOVER                       ; It is, so start all over

        ;
        ; We now know it's a normal character
        ;
        ; Register change:
        ;   [SI] => Pointer to graphic font
        ;

        CMP     AL, 198                         ; But, is it a space?
        JE      JUSTNEXT                        ; Then skip this

        PUSH    SI DI                           ; Save these registers

        MOV     SI, OFFSET FontData             ; Offset of font

        MOV     BX, AX                          ; Character in BX
        MOV     AX, 576                         ; Each char's 576 bytes
        MUL     BX                              ; Now, calculate the offset
        ADD     SI, AX                          ; Address source

        MOV     CX, 24                          ; 24 lines in char
MOVLINE:
        PUSH    CX                              ; Another loop
        MOV     CX, 12                          ; 12 Words a line of char
        REP     MOVSW                           ; Move one line
        POP     CX                              ; Back to normal loop
        ADD     DI, 296                         ; Next line
        LOOP    MOVLINE                         ; Next line

        POP     DI SI                           ; Restore these registers

JUSTNEXT:
        ADD     DI, 26                          ; Next char
        JMP     TEXTLOOP                        ; Do next char

STARTOVER:
        MOV     [TextIndex], 0               ; Clear Index in text
EXITLOOP:
        POP     ES SI                           ; Restore stuff
        RET                                     ; Return to caller
ShowText endp


;
; This routine takes a value in AL and converts it.
;
Convert proc
        PUSH    BX                              ; Save BX
        XOR     BX, BX                          ; Clear BX (Index)
        MOV     BL, AL                          ; Index in table
        MOV     AL, [ConvertTable+BX]        ; And convert it
        POP     BX                              ; Restore BX
        RET
Convert endp

;
;  This routine moves a bitmap from memory to the screen
;
MoveToScreen proc
        MOV     AX, 0A000h                      ; Screen segment...
        MOV     ES, AX                          ; ...is destination segment
        MOV     BX, 320                         ; Asume 320
        SUB     BX, DX                          ; How much to jump for next line
MOVESCREENLINE:
        PUSH    CX                              ; Another loop
        MOV     CX, DX                          ; Bytes-a-line
        REP     MOVSB                           ; Move it!
        ADD     DI, BX                          ; Next line on screen
        POP     CX                              ; For outer loop
        LOOP    MOVESCREENLINE                  ; Next!
        RET                                     ; Done
MoveToScreen endp

TextIndex       DW      ?                       ; Index in text string
Screen2         DB      7680 DUP (?)            ; Screen 2 for morpher
FontData        DB      28064 DUP (?)           ; Space for Font data
TempVal         DW      ?                       ; Temporary value for morpher
ConvertTable    DB      0,20,44,63              ; Conversion table for 2 >> 8

NoVGA           DB      'VGA Not found!$'       ; Error message

Text            DB      0,200                                   ; ...
                DB      9,19,7,8,18,198,5,8,11,4,200            ; This File
                DB      3,22,0,18,200                           ; Was
                DB      10,3,14,22,13,11,14,0,3,4,3,200         ; Downloaded
                DB      4,5,17,14,12,200                        ; From
                DB      9,6,4,13,8,0,0,11,198,28,200            ; GENIAAL 2
                DB      6,22,4,198,0,17,4,200                   ; We Are
                DB      10,20,11,19,17,0,18,14,20,13,3,200      ; UltraSound
                DB      11,18,20,15,15,14,17,19,198,1,1,18,200  ; Support BBS
                DB      7,7,14,11,11,0,13,3,200                 ; Holland
                DB      0,200                                   ; ...
                DB      6,22,4,198,0,17,4,200                   ; We are
                DB      11,18,15,4,2,8,0,11,8,18,4,3,200        ; Specialised
                DB      3,8,13,16,200                           ; In:
                DB      0,200                                   ; ...
                DB      10,20,11,19,17,0,18,14,20,13,3,200      ; UltraSound
                DB      12,18,14,20,13,3,1,11,0,18,19,4,17,200  ; SoundBlaster
                DB      5,0,3,11,8,1,200                        ; AdLib
                DB      8,6,17,0,15,7,8,2,18,200                ; Graphics
                DB      7,4,17,14,19,8,2,0,200                  ; Erotica
                DB      9,0,13,3,198,3,4,12,14,18,200           ; And Demos
                DB      0,200                                   ; ...
                DB      12,33,14,14,198,12,4,6,0,1,24,19,4,200  ; 700 Megabyte
                DB      7,14,13,10,11,8,13,4,200                ; ON-Line
                DB      0,200                                   ; ...
                DB      6,18,24,18,14,15,16,200                 ; SysOp:
                DB      0,200                                   ; ...
                DB      12,0,19,8,11,11,0,198,12,4,8,9,18,200   ; Atilla Meijs
                DB      0,200                                   ; ...
                DB      10,2,14,10,18,24,18,14,15,18,16,200     ; Co-SysOps:
                DB      0,200                                   ; ...
                DB      12,9,0,0,15,198,21,4,17,1,14,14,13,200  ; Jaap Verboon
                DB      3,0,13,3,200                            ; And
                DB      7,12,8,2,7,8,4,11,200                   ; Michiel
                DB      8,14,20,22,4,7,0,13,3,200               ; Ouwehand
                DB      0,200                                   ; ...
                DB      12,2,0,11,11,198,20,18,198,13,14,22,26,200; Call Us Now!
                DB      0,200                                   ; ...
                DB      10,1,14,19,7,198,11,8,13,4,18,200       ; Both lines
                DB      5,20,15,198,19,14,200                   ; Up to
                DB      11,27,30,23,30,14,14,198,1,0,20,3,200   ; 14.400 Baud
                DB      12,2,0,11,11,198,20,18,198,13,14,22,26,200; Call Us Now!
                DB      0,200                                   ; ...
                DB      0,200                                   ; ...
                DB      0,199                                   ; End-of-message

Screen1         DB 64,254,255,255,191,1,228,255,255,255,255,27,248,255,255,255
                DB 255,47,253,255,255,255,255,127,254,255,255,255,255,191,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,6,144
                DB 255,255,255,191,1,64,254,255,255,127,0,0,253,255,255,63,0
                DB 0,252,255,255,63,0,0,252,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,63
                DB 0,0,252,255,255,63,0,0,252,255,255,63,0,0,252,255,255,63,0
                DB 0,252,255,255,63,0,0,252,255,255,63,0,0,252,255,255,255,255
                DB 255,191,1,255,255,255,255,255,27,255,255,255,255,255,47,255
                DB 255,255,255,255,127,255,255,255,255,255,191,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,63,0,144,255,255,255,63
                DB 0,64,254,191,255,63,0,0,255,127,255,63,0,64,255,47,255,63
                DB 0,128,255,31,255,63,0,128,255,31,255,63,0,64,255,47,255,63
                DB 0,0,255,127,255,63,0,64,254,191,255,63,0,144,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 191,255,255,255,255,255,127,255,255,255,255,255,47,255,255
                DB 255,255,255,27,255,255,255,255,191,1,0,144,255,255,6,0,0,249
                DB 255,255,111,0,64,254,255,255,191,1,144,255,255,255,255,6,228
                DB 255,255,255,255,27,248,255,255,255,255,47,253,255,255,255
                DB 255,127,254,255,27,228,255,191,255,255,1,64,255,255,255,191
                DB 0,0,255,255,255,127,0,0,0,0,255,63,0,0,0,0,255,63,0,0,0,0
                DB 255,127,0,0,0,0,255,191,0,0,255,255,255,255,1,64,255,255,254
                DB 255,27,228,255,191,253,255,255,255,255,127,248,255,255,255
                DB 255,47,228,255,255,255,255,27,144,255,255,255,255,6,64,254
                DB 255,255,191,1,0,249,255,255,111,0,0,144,255,255,6,0,255,255
                DB 255,255,191,1,255,255,255,255,255,27,255,255,255,255,255,47
                DB 255,255,255,255,255,127,255,255,255,255,255,191,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,63,0,144,255,255,255
                DB 63,0,64,254,255,255,63,0,0,253,255,255,63,0,0,252,255,255
                DB 63,0,0,252,255,255,63,0,0,252,255,255,63,0,0,252,255,255,63
                DB 0,0,253,255,255,63,0,64,254,255,255,63,0,144,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 191,255,255,255,255,255,127,255,255,255,255,255,47,255,255
                DB 255,255,255,27,255,255,255,255,191,1,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,63,0,0,0,0,255,63,0,0,0,0,255
                DB 255,255,255,3,0,255,255,255,255,3,0,255,255,255,255,3,0,255
                DB 255,255,255,3,0,255,255,255,255,3,0,255,255,255,255,3,0,255
                DB 63,0,0,0,0,255,63,0,0,0,0,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,63,0,0,0,0,255,63,0,0,0,0,255,255,255,255,3,0,255
                DB 255,255,255,3,0,255,255,255,255,3,0,255,255,255,255,3,0,255
                DB 255,255,255,3,0,255,255,255,255,3,0,255,63,0,0,0,0,255,63
                DB 0,0,0,0,255,63,0,0,0,0,255,63,0,0,0,0,255,63,0,0,0,0,255,63
                DB 0,0,0,0,255,63,0,0,0,0,255,63,0,0,0,0,255,63,0,0,0,0,0,144
                DB 255,255,6,0,0,249,255,255,111,0,64,254,255,255,191,1,144,255
                DB 255,255,255,6,228,255,255,255,255,27,248,255,255,255,255,47
                DB 253,255,255,255,255,127,254,255,27,228,255,191,255,255,1,64
                DB 255,255,255,191,0,0,0,0,255,127,192,255,255,255,255,63,192
                DB 255,255,255,255,63,192,255,255,255,255,127,192,255,255,255
                DB 255,191,192,255,255,255,255,255,193,255,255,255,254,255,27
                DB 228,255,191,253,255,255,255,255,127,248,255,255,255,255,47
                DB 228,255,255,255,255,27,144,255,255,255,255,6,64,254,255,255
                DB 191,1,0,249,255,255,111,0,0,144,255,255,6,0,255,255,0,0,255
                DB 255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255
                DB 255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255
                DB 255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0
                DB 0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255
                DB 0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255
                DB 0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255
                DB 0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255
                DB 255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255
                DB 255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0
                DB 0,255,255,0,0,0,64,255,255,0,0,0,144,255,255,0,0,0,228,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,191,255,255,255,255,255,127,255,255,255,255,255
                DB 47,255,255,255,255,255,27,255,255,255,255,191,1,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255
                DB 0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255
                DB 255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0
                DB 0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255
                DB 0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,111,0,0,249
                DB 255,255,191,1,64,254,255,255,255,6,144,255,255,255,255,27
                DB 228,255,255,255,255,111,249,255,255,255,255,191,254,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,191,255,255,254,255
                DB 255,127,254,191,253,255,255,63,249,111,252,255,255,63,228
                DB 27,252,255,255,63,144,6,252,255,255,63,64,1,252,255,255,63
                DB 0,0,252,255,255,63,0,0,252,255,255,63,0,0,252,255,255,63,0
                DB 0,252,255,255,63,0,0,252,255,255,63,0,0,252,255,255,63,0,0
                DB 252,255,255,63,0,0,252,255,255,255,127,0,255,255,255,255,191
                DB 0,255,255,255,255,255,1,255,255,255,255,255,2,255,255,255
                DB 255,255,7,255,255,255,255,255,11,255,255,255,255,255,31,255
                DB 255,255,255,255,47,255,255,255,255,255,127,255,255,255,255
                DB 255,191,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 254,255,255,255,255,255,253,255,255,255,255,255,248,255,255
                DB 255,255,255,244,255,255,255,255,255,224,255,255,255,255,255
                DB 208,255,255,255,255,255,128,255,255,255,255,255,64,255,255
                DB 255,255,255,0,254,255,255,255,255,0,253,255,255,0,144,255
                DB 255,6,0,0,249,255,255,111,0,64,254,255,255,191,1,144,255,255
                DB 255,255,6,228,255,255,255,255,27,248,255,255,255,255,47,253
                DB 255,255,255,255,127,254,255,27,228,255,191,255,255,1,64,255
                DB 255,255,191,0,0,254,255,255,127,0,0,253,255,255,63,0,0,252
                DB 255,255,63,0,0,252,255,255,127,0,0,253,255,255,191,0,0,254
                DB 255,255,255,1,64,255,255,254,255,27,228,255,191,253,255,255
                DB 255,255,127,248,255,255,255,255,47,228,255,255,255,255,27
                DB 144,255,255,255,255,6,64,254,255,255,191,1,0,249,255,255,111
                DB 0,0,144,255,255,6,0,255,255,255,255,191,1,255,255,255,255
                DB 255,27,255,255,255,255,255,47,255,255,255,255,255,127,255
                DB 255,255,255,255,191,255,255,255,255,255,255,255,63,0,144,255
                DB 255,255,63,0,64,254,255,255,63,0,0,253,255,255,63,0,0,252
                DB 255,255,63,0,0,253,255,255,63,0,64,254,255,255,63,0,144,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,191,255,255
                DB 255,255,255,127,255,255,255,255,255,47,255,255,255,255,255
                DB 27,255,255,255,255,191,1,255,63,0,0,0,0,255,63,0,0,0,0,255
                DB 63,0,0,0,0,255,63,0,0,0,0,255,63,0,0,0,0,0,0,0,0,0,0,0,0,144
                DB 27,0,0,0,0,248,191,0,0,0,0,253,255,1,0,0,0,254,255,2,0,0,0
                DB 255,255,3,0,0,0,254,255,2,0,0,0,253,255,1,0,0,0,248,191,0
                DB 0,0,0,144,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,144,27,0,0,0,0,248,191,0,0,0,0,253,255,1,0,0,0,254
                DB 255,2,0,0,0,255,255,3,0,0,0,254,255,2,0,0,0,253,255,1,0,0
                DB 0,248,191,0,0,0,0,144,27,0,0,0,0,0,0,0,0,255,255,255,255,191
                DB 1,255,255,255,255,255,27,255,255,255,255,255,47,255,255,255
                DB 255,255,127,255,255,255,255,255,191,255,63,0,144,255,255,255
                DB 63,0,64,254,255,255,63,0,0,253,255,255,63,0,0,252,255,255
                DB 63,0,0,253,255,255,63,0,64,254,255,255,63,0,144,255,255,255
                DB 255,255,255,255,191,255,255,255,255,255,127,255,255,255,255
                DB 255,47,255,255,255,255,255,27,255,255,255,255,255,6,255,63
                DB 0,249,255,27,255,63,0,228,255,111,255,63,0,144,255,191,255
                DB 63,0,64,254,255,255,63,0,0,249,255,255,63,0,0,228,255,255
                DB 63,0,0,144,255,64,254,255,255,191,1,228,255,255,255,255,27
                DB 248,255,255,255,255,47,253,255,255,255,255,127,254,255,255
                DB 255,255,191,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,15,0,0,0,255,255,15,0,0,0,255,255,255,255,191,1,254
                DB 255,255,255,255,27,253,255,255,255,255,47,248,255,255,255
                DB 255,127,228,255,255,255,255,191,64,254,255,255,255,255,0,0
                DB 0,240,255,255,0,0,0,240,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,254,255,255,255,255,191,253,255,255,255
                DB 255,127,248,255,255,255,255,47,228,255,255,255,255,27,64,254
                DB 255,255,191,1,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255
                DB 255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0
                DB 0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255
                DB 0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255
                DB 255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,255,255,0,0,255,255
                DB 255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255
                DB 255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255
                DB 255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255
                DB 255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255
                DB 255,255,1,64,255,255,255,255,2,128,255,255,255,255,7,208,255
                DB 255,254,255,111,249,255,191,253,255,255,255,255,127,248,255
                DB 255,255,255,47,228,255,255,255,255,27,144,255,255,255,255
                DB 6,64,254,255,255,191,1,0,249,255,255,111,0,0,144,255,255,6
                DB 0,255,31,0,0,244,255,255,47,0,0,248,255,255,127,0,0,253,255
                DB 255,191,0,0,254,255,255,255,1,64,255,255,255,255,2,128,255
                DB 255,254,255,7,208,255,191,253,255,11,224,255,127,248,255,31
                DB 244,255,47,244,255,47,248,255,31,224,255,127,253,255,11,208
                DB 255,191,254,255,7,128,255,255,255,255,2,64,255,255,255,255
                DB 1,0,254,255,255,191,0,0,253,255,255,127,0,0,248,255,255,47
                DB 0,0,244,255,255,31,0,0,224,255,255,11,0,0,208,255,255,7,0
                DB 0,128,255,255,2,0,0,64,255,255,1,0,0,0,254,191,0,0,0,0,253
                DB 127,0,0,255,63,0,0,252,255,255,63,0,0,252,255,255,63,0,0,252
                DB 255,255,63,0,0,252,255,255,63,0,0,252,255,255,63,0,0,252,255
                DB 255,63,0,0,252,255,255,63,0,0,252,255,255,63,64,1,252,255
                DB 255,63,144,6,252,255,255,63,228,27,252,255,255,63,249,111
                DB 252,255,255,127,254,191,253,255,255,191,255,255,254,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,191,254,255,255,255
                DB 255,111,249,255,255,255,255,27,228,255,255,255,255,6,144,255
                DB 255,255,191,1,64,254,255,255,111,0,0,249,255,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,27,0,0,0,0,248
                DB 191,0,0,0,0,253,255,1,0,0,0,254,255,2,0,0,0,255,255,3,0,0
                DB 0,254,255,2,0,0,0,253,255,1,0,0,0,248,191,0,0,0,0,144,27,0
                DB 0,0,0,0,0,0,0,255,111,0,0,249,255,255,191,1,64,254,255,255
                DB 255,6,144,255,255,255,255,27,228,255,255,255,255,111,249,255
                DB 255,255,255,191,254,255,255,254,255,255,255,255,191,249,255
                DB 255,255,255,111,228,255,255,255,255,27,144,255,255,255,255
                DB 6,64,254,255,255,191,1,0,249,255,255,111,0,0,228,255,255,27
                DB 0,0,144,255,255,6,0,0,64,255,255,1,0,0,0,255,255,0,0,0,0,255
                DB 255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0
                DB 0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255
                DB 0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,191,255,255,255,255,255,111,0,0,144
                DB 255,255,27,0,0,228,255,255,6,0,0,249,255,191,1,0,64,254,255
                DB 111,0,0,144,255,255,27,0,0,228,255,255,6,0,0,249,255,191,1
                DB 0,64,254,255,111,0,0,144,255,255,27,0,0,228,255,255,6,0,0
                DB 249,255,255,255,255,255,254,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,0,0,144,27
                DB 0,0,0,0,248,191,0,0,0,0,253,255,1,0,0,0,254,255,2,0,0,0,255
                DB 255,3,0,0,0,255,255,3,0,0,0,255,255,3,0,0,0,255,255,3,0,0
                DB 0,254,255,2,0,0,0,253,255,1,0,0,0,252,255,0,0,0,0,248,191
                DB 0,0,0,0,244,127,0,0,0,0,224,47,0,0,0,0,64,6,0,0,0,0,0,0,0
                DB 0,0,0,0,1,0,0,0,0,144,27,0,0,0,0,224,47,0,0,0,0,244,127,0
                DB 0,0,0,224,47,0,0,0,0,144,27,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0
                DB 0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255
                DB 0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255
                DB 255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0
                DB 0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255
                DB 0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255
                DB 255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0
                DB 0,255,255,0,0,0,0,255,255,0,0,64,254,255,255,191,1,228,255
                DB 255,255,255,27,248,255,255,255,255,47,253,255,255,255,255
                DB 127,254,255,255,255,255,191,255,255,255,255,255,191,255,255
                DB 255,255,255,127,255,255,67,254,255,47,255,255,147,255,255
                DB 27,0,0,228,255,255,6,0,0,249,255,191,1,0,64,254,255,111,0
                DB 0,144,255,255,27,0,0,228,255,255,6,0,0,249,255,191,1,0,64
                DB 254,255,111,0,0,144,255,255,27,0,0,228,255,255,255,255,255
                DB 249,255,255,255,255,255,254,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,64,254,255,255,191,1,228,255,255,255
                DB 255,27,248,255,255,255,255,47,253,255,255,255,255,127,254
                DB 255,255,255,255,191,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,0,0,252,255,0,0,0,0,252,255,0,0,252,255,255
                DB 255,0,0,252,255,255,255,0,0,252,255,255,255,0,0,252,255,255
                DB 255,0,0,252,255,255,255,0,0,252,255,255,255,0,0,0,0,252,255
                DB 255,255,0,0,252,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,254,255,255,255,255,191,253,255,255,255,255,127,248
                DB 255,255,255,255,47,228,255,255,255,255,27,64,254,255,255,191
                DB 1,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255
                DB 255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255
                DB 255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,0,0,0,0,255,255,0,0,0,0,255,255
                DB 0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255
                DB 255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,64,254
                DB 255,255,191,1,228,255,255,255,255,27,248,255,255,255,255,47
                DB 253,255,255,255,255,127,254,255,255,255,255,191,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,15,0,0,0,255,255
                DB 15,0,0,0,255,255,255,255,191,1,254,255,255,255,255,27,253
                DB 255,255,255,255,47,248,255,255,255,255,127,228,255,255,255
                DB 255,191,64,254,255,255,255,255,0,0,0,240,255,255,0,0,0,240
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,254
                DB 255,255,255,255,191,253,255,255,255,255,127,248,255,255,255
                DB 255,47,228,255,255,255,255,27,64,254,255,255,191,1,252,255
                DB 3,0,0,0,252,255,3,0,0,0,252,255,3,0,0,0,252,255,3,0,0,0,252
                DB 255,3,0,0,0,252,255,3,0,0,0,252,255,255,255,255,6,252,255
                DB 255,255,255,111,252,255,255,255,255,191,252,255,255,255,255
                DB 255,252,255,255,255,255,255,252,255,255,255,255,255,252,255
                DB 27,64,254,255,252,255,6,0,249,255,252,255,1,0,244,255,252
                DB 255,1,0,244,255,252,255,6,0,249,255,252,255,27,64,254,255
                DB 252,255,255,255,255,255,248,255,255,255,255,255,244,255,255
                DB 255,255,255,224,255,255,255,255,191,144,255,255,255,255,111
                DB 0,249,255,255,255,6,0,249,255,255,255,6,144,255,255,255,255
                DB 31,224,255,255,255,255,47,244,255,255,255,255,127,248,255
                DB 255,255,255,191,252,255,255,255,255,191,252,255,255,255,255
                DB 127,0,0,64,254,255,47,0,0,144,255,255,27,0,0,228,255,255,6
                DB 0,0,249,255,191,1,0,64,254,255,111,0,0,144,255,255,27,0,0
                DB 228,255,255,6,0,0,249,255,191,1,0,64,254,255,111,0,0,144,255
                DB 255,27,0,0,228,255,255,6,0,0,248,255,191,1,0,0,252,255,111
                DB 0,0,0,252,255,27,0,0,0,252,255,6,0,0,0,252,191,1,0,0,0,252
                DB 111,0,0,0,0,64,254,255,255,191,1,228,255,255,255,255,27,248
                DB 255,255,255,255,47,253,255,255,255,255,127,254,255,6,144,255
                DB 191,255,191,1,64,254,255,255,127,0,0,253,255,255,63,0,0,252
                DB 255,254,127,0,0,253,191,249,191,1,64,254,111,148,255,6,144
                DB 255,22,64,254,255,255,191,1,64,254,255,255,191,1,148,255,6
                DB 144,255,22,249,191,1,64,254,111,254,127,0,0,253,191,255,63
                DB 0,0,252,255,255,127,0,0,253,255,255,191,1,64,254,255,254,255
                DB 6,144,255,191,253,255,255,255,255,127,248,255,255,255,255
                DB 47,228,255,255,255,255,27,64,254,255,255,191,1,64,254,255
                DB 255,191,1,228,255,255,255,255,27,248,255,255,255,255,47,253
                DB 255,255,255,255,127,254,255,255,255,255,191,255,255,255,255
                DB 255,255,255,255,6,144,255,255,255,191,1,64,254,255,255,127
                DB 0,0,253,255,255,63,0,0,252,255,255,127,0,0,253,255,255,191
                DB 1,64,254,255,255,255,6,144,255,255,255,255,255,255,255,255
                DB 254,255,255,255,255,255,253,255,255,255,255,255,248,255,255
                DB 255,255,255,228,255,255,255,255,255,64,254,255,255,255,255
                DB 0,0,0,0,252,255,0,0,0,0,252,255,0,0,0,0,252,255,0,0,0,0,252
                DB 255,0,0,0,0,252,255,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255
                DB 255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0
                DB 0,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
                DB 255,255,255,255,255,255,255,0,0,255,255,0,0,0,0,255,255,0
                DB 0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255
                DB 255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,0,0,0,0

                ;
                ; This is the place where the phone numbers bitmap start, but
                ; I put it here because it's also 2 bits and thus can be
                ; easily converted.
                ;

                DB 0,0,0,160,26,0,0,5,0,0,0,160,191,1,128,254,6,0,186,190,2,0
                DB 0,128,1,0,0,0,0,0,169,191,1,144,11,0,0,0,253,255,11,244,255
                DB 47,208,47,224,31,0,0,224,1,0,0,0,0,0,2,253,66,254,11,0,0,0
                DB 91,249,31,108,229,127,224,15,192,47,0,0,248,1,0,0,0,0,0,0
                DB 248,7,253,11,0,0,64,1,224,47,5,128,191,244,11,128,127,0,0
                DB 254,1,0,0,0,0,0,0,248,3,248,11,0,0,0,0,208,47,0,64,191,248
                DB 11,128,191,0,128,255,1,0,0,0,1,0,0,252,2,248,11,0,0,0,0,208
                DB 47,0,64,191,248,11,128,191,0,208,255,1,0,0,64,7,0,0,190,0
                DB 248,11,0,0,0,0,224,15,0,128,63,248,11,128,191,0,116,255,1
                DB 0,0,64,7,0,128,191,0,248,11,0,0,0,0,244,6,0,208,27,240,15
                DB 128,191,0,93,255,1,0,0,64,7,0,0,254,3,248,11,0,0,0,0,189,0
                DB 0,244,2,224,31,192,191,64,71,255,1,85,5,169,171,1,0,248,11
                DB 248,11,168,170,0,64,11,0,0,45,0,128,191,229,127,208,65,255
                DB 129,255,47,169,171,1,0,244,15,248,11,168,170,0,208,1,0,64
                DB 7,0,0,164,218,127,116,64,255,1,85,5,64,7,0,1,244,31,248,11
                DB 0,0,0,116,0,0,208,1,0,0,0,208,47,188,170,255,6,0,0,64,7,208
                DB 11,244,31,248,11,0,0,0,44,0,32,176,0,128,0,0,224,31,244,255
                DB 255,11,0,0,64,7,224,31,244,15,248,11,0,0,0,174,170,46,184
                DB 170,186,0,0,244,11,64,85,255,1,0,0,0,1,224,31,244,11,248,11
                DB 0,0,0,255,255,31,252,255,127,0,0,248,2,0,64,255,1,0,0,0,0
                DB 208,31,248,2,248,11,0,0,128,255,255,15,254,255,63,0,64,110
                DB 0,0,128,255,2,0,0,0,0,0,186,110,0,254,47,0,0,64,170,170,6
                DB 169,170,26,0,148,6,0,0,144,170,6,0,0,0,0,0,80,5,0,85,21,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,228,175,0,144,175,111
                DB 0,244,255,47,128,174,175,0,0,0,0,0,254,255,7,248,7,253,2,248
                DB 255,31,244,11,248,7,0,0,0,0,91,254,11,253,2,248,7,168,170
                DB 10,248,3,240,11,0,0,0,0,0,244,31,254,1,244,11,24,0,0,253,2
                DB 224,31,0,0,0,0,0,224,95,255,1,244,15,9,0,0,254,2,224,47,0
                DB 0,0,0,0,224,79,255,1,244,31,173,26,0,254,2,224,47,0,0,0,0
                DB 0,244,11,255,1,244,31,253,255,2,254,2,224,47,0,0,0,0,0,248
                DB 2,254,2,244,31,254,255,11,252,3,224,47,0,0,0,0,0,110,0,252
                DB 2,248,31,169,255,31,248,7,240,47,0,0,0,0,128,7,0,228,91,254
                DB 11,0,228,47,224,111,249,31,0,0,0,0,160,0,0,64,170,249,11,0
                DB 128,127,0,169,246,31,0,0,0,0,40,0,16,0,0,248,7,4,0,127,0,0
                DB 244,11,0,0,0,0,14,0,20,0,0,252,66,47,0,62,0,0,248,7,0,0,0
                DB 0,175,170,30,0,0,254,129,127,0,46,0,0,253,2,0,0,0,0,255,255
                DB 11,0,64,127,128,127,0,15,0,0,190,0,0,0,0,0,255,255,11,0,224
                DB 11,0,254,150,6,0,144,27,0,0,0,0,0,170,170,2,0,105,0,0,144
                DB 106,0,0,165,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,1,0,0,0,64,85,21
                DB 0,0,0,0,0,0,0,0,0,0,249,47,0,128,7,208,255,191,0,0,64,2,0
                DB 0,0,0,0,64,150,255,64,249,7,224,255,127,0,0,208,2,0,0,0,0
                DB 0,64,0,254,66,255,7,160,170,42,0,0,244,2,0,0,0,0,0,0,0,253
                DB 2,253,7,96,0,0,0,0,253,2,0,0,0,0,0,0,0,253,1,253,7,36,0,0
                DB 0,0,255,2,0,0,0,0,0,0,0,190,0,253,7,180,106,0,0,128,255,2
                DB 0,0,0,0,0,0,144,47,0,253,7,244,255,11,0,160,254,2,0,0,0,0
                DB 0,0,128,191,1,253,7,248,255,47,0,40,254,2,0,0,0,0,0,0,0,253
                DB 2,253,7,164,254,127,0,10,254,2,0,0,0,0,0,0,0,248,7,253,7,0
                DB 144,191,128,2,254,2,0,0,0,0,0,0,0,248,11,253,7,0,0,254,161
                DB 0,254,2,0,0,0,0,0,144,2,248,11,253,7,16,0,252,181,170,255
                DB 11,0,0,0,0,0,240,11,248,11,253,7,189,0,248,224,255,255,31
                DB 0,0,0,0,0,244,11,248,7,253,7,254,1,184,64,85,254,6,0,0,0,0
                DB 0,240,11,252,2,253,7,254,1,60,0,0,254,2,0,0,0,0,0,144,95,190
                DB 0,254,11,248,91,26,0,64,255,7,0,0,0,0,0,0,169,10,64,170,26
                DB 64,170,1,0,144,170,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 1080 DUP (?)

LogoPal         DB 0,0,0,0,1,1,1,1,3,5,5,8,7,8,14,10,10,18,11,12,23,12,13,25
                DB 12,13,27,13,14,27,14,14,27,14,14,29,14,16,29,16,17,29,16,17
                DB 31,17,17,29,17,17,31,17,18,31,18,18,33,18,18,34,18,19,34,19
                DB 19,34,19,20,36,20,20,36,20,21,38,21,21,36,21,21,38,21,22,38
                DB 22,22,40,23,23,40,24,24,42,26,26,44

Mixer           DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,67,68,67,67,0,0,0,0,0
                DB 0,0,0,0,0,0,0,70,95,82,74,70,68,67,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,71,95,95,95,86,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,69,74
                DB 85,93,93,94,94,94,92,71,67,0,0,0,0,0,0,0,0,0,70,95,95,95,95
                DB 95,95,95,94,84,73,70,67,67,0,0,0,0,0,0,0,0,71,95,95,95,95
                DB 95,86,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,66,70,85,93,92,93,93,93,93,94,94,94
                DB 94,94,90,72,68,67,65,0,0,0,0,0,74,95,95,95,95,95,95,95,95
                DB 95,95,95,95,95,95,93,85,71,70,66,0,0,71,95,95,95,95,95,95
                DB 95,90,67,0,0,0,0,0,0,0,67,68,68,68,68,68,68,68,66,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,68,68,68,68,68,68
                DB 68,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,67
                DB 0,0,0,0,0,0,0,0,0,0,0,67,68,68,68,68,68,68,68,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,71
                DB 82,94,94,94,80,73,68,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,77
                DB 92,92,92,92,92,93,93,93,94,94,94,94,94,94,94,94,75,70,70,68
                DB 67,65,0,0,82,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95
                DB 95,95,95,83,70,67,71,95,95,95,95,95,95,95,95,94,68,0,0,0,0
                DB 0,0,80,95,95,95,95,95,95,95,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,85,95,95,95,95,95,95,95,90,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,66,68,74,74,85,93,95,95,95,95,95,0,0,0,0,0
                DB 0,0,0,65,68,72,95,95,95,95,95,95,95,95,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,67,69,92,95,94,94,94
                DB 94,94,94,93,93,92,71,65,0,0,0,0,0,0,0,0,0,0,65,74,92,92,92
                DB 92,93,92,93,93,93,93,94,94,94,94,94,94,94,94,92,72,72,72,70
                DB 68,66,0,82,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95
                DB 95,95,83,76,75,86,95,95,95,95,95,95,95,95,95,83,72,67,0,0
                DB 0,0,73,95,95,95,95,95,95,95,72,68,0,0,0,0,0,69,74,74,74,74
                DB 68,68,68,66,0,0,0,0,0,0,0,66,95,95,95,95,95,95,95,95,95,66
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,66,72,95,95,95,95,95,95,95,95,95
                DB 95,67,0,0,0,0,0,0,68,72,72,72,94,95,95,95,95,95,95,93,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,66,67,68,68
                DB 83,95,95,95,95,94,94,94,94,94,94,93,93,93,88,67,0,0,0,0,0
                DB 0,0,0,67,87,92,92,92,92,92,92,92,93,93,93,93,94,94,94,94,94
                DB 94,94,94,94,88,72,72,72,72,70,66,94,95,95,95,95,95,95,95,95
                DB 95,95,95,95,95,95,95,95,95,95,83,76,75,83,95,95,95,95,95,95
                DB 95,95,95,95,72,72,66,0,0,0,68,95,95,95,95,95,95,95,83,72,0
                DB 0,0,0,0,95,95,95,95,95,95,95,95,68,0,0,0,0,0,0,0,69,95,95
                DB 95,95,95,95,95,95,95,70,0,0,0,0,0,0,0,0,0,0,0,0,66,70,88,95
                DB 95,95,95,95,95,95,95,95,95,80,0,0,0,0,0,66,72,72,72,72,92
                DB 95,95,95,95,95,95,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,66,68,68,68,70,70,86,95,95,95,95,95,94,94,94,94,94,94
                DB 94,93,93,93,92,67,0,0,0,0,0,0,65,84,92,92,92,92,92,92,92,92
                DB 93,93,93,94,94,94,94,94,94,94,94,94,94,94,78,72,72,72,72,70
                DB 95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,83
                DB 76,75,83,95,95,95,95,95,95,95,95,95,95,83,72,68,0,0,0,66,95
                DB 95,95,95,95,95,95,83,75,0,0,0,0,0,95,95,95,95,95,95,95,95
                DB 70,0,0,0,0,0,0,0,93,95,95,95,95,95,95,95,95,95,90,0,0,0,0
                DB 0,0,0,0,0,0,0,0,68,70,95,95,95,95,95,95,95,95,95,95,95,95
                DB 0,0,0,0,0,66,72,72,72,72,92,95,95,95,95,95,95,93,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,70,70,70,72,72,76,95,95
                DB 95,95,95,95,93,93,94,94,94,94,94,93,93,92,92,87,65,0,0,0,0
                DB 65,80,90,92,92,92,92,92,93,92,93,93,93,93,94,94,94,94,94,94
                DB 94,94,94,94,94,94,76,72,72,72,72,95,95,95,95,95,95,95,95,95
                DB 95,95,95,95,95,95,95,95,95,95,76,76,76,83,95,95,95,95,95,95
                DB 95,95,95,95,95,72,72,66,0,0,0,95,95,95,95,95,95,95,83,72,66
                DB 0,0,0,66,95,95,95,95,95,95,95,95,70,0,0,0,0,0,0,67,95,95,95
                DB 95,95,95,95,95,95,95,95,66,0,0,0,0,0,0,0,0,0,0,0,70,72,95
                DB 95,95,95,95,95,95,95,95,95,95,95,67,0,0,0,0,0,72,72,72,72
                DB 83,95,95,95,95,95,95,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,68,72,72,72,72,72,72,94,95,95,95,95,95,92,72,72,83,94
                DB 94,94,94,93,93,92,92,92,69,0,0,0,65,80,90,92,92,92,92,92,92
                DB 93,92,93,93,93,93,94,94,94,94,94,94,94,94,94,94,94,95,92,75
                DB 72,72,75,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95
                DB 95,95,76,76,75,83,95,95,95,95,95,95,95,95,95,95,95,88,72,70
                DB 0,0,0,90,95,95,95,95,95,95,83,72,67,0,0,0,68,95,95,95,95,95
                DB 95,95,95,68,0,0,0,0,0,0,80,95,95,95,95,95,95,95,95,95,95,95
                DB 69,0,0,0,0,0,0,0,0,0,0,66,70,76,95,95,95,95,95,95,95,95,95
                DB 95,95,95,80,0,0,0,0,0,72,72,72,72,83,95,95,95,95,95,95,74
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,72,72,72,72,72,76
                DB 83,95,95,95,95,95,95,83,72,75,75,78,94,94,94,93,93,92,92,92
                DB 84,0,0,65,80,90,90,92,92,92,92,92,92,92,90,76,72,72,83,94
                DB 94,94,94,94,94,94,94,94,94,95,95,95,86,76,75,78,95,95,95,95
                DB 95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,76,76,75,83,95
                DB 95,95,95,95,95,95,95,95,95,95,95,75,72,67,0,0,82,95,95,95
                DB 95,95,95,88,75,67,0,0,0,68,95,95,95,95,95,95,95,95,68,0,0
                DB 0,0,0,0,95,95,95,95,95,95,95,95,95,95,95,95,85,0,0,0,0,0,0
                DB 0,0,0,0,67,72,88,95,95,95,95,95,95,95,95,95,95,95,95,95,0
                DB 0,0,0,0,72,72,72,75,83,95,95,95,95,95,95,74,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,72,72,75,75,76,76,76,88,95,95,95,95
                DB 95,95,76,76,76,76,76,83,94,94,93,93,92,93,92,92,65,0,71,90
                DB 90,90,92,92,92,92,92,92,83,72,72,72,72,72,76,94,94,94,94,94
                DB 94,94,94,94,95,94,87,78,72,75,78,95,95,95,95,95,95,95,95,95
                DB 95,95,95,95,95,95,95,95,95,95,76,76,75,83,95,95,95,95,95,95
                DB 95,95,95,95,95,95,88,72,70,0,0,73,95,95,95,95,95,95,92,75
                DB 67,0,0,0,74,95,95,95,95,95,95,95,95,67,0,0,0,0,0,69,95,95
                DB 95,95,95,95,95,95,95,95,95,95,95,0,0,0,0,0,0,0,0,0,0,68,72
                DB 95,95,95,95,95,95,95,95,95,95,95,95,95,95,67,0,0,0,0,70,72
                DB 72,75,75,95,95,95,95,95,95,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,75,76,75,76,76,76,76,86,95,95,95,95,95,95,76,76
                DB 76,76,78,78,92,94,94,93,93,93,92,92,67,65,90,90,90,90,92,92
                DB 92,92,87,75,72,72,72,72,72,72,72,87,94,94,94,85,83,76,71,69
                DB 68,68,68,68,68,68,76,95,95,95,95,94,78,73,69,69,71,76,76,76
                DB 76,76,76,76,76,78,72,76,75,83,95,95,95,95,95,95,95,95,95,95
                DB 95,95,95,75,72,67,0,68,95,95,95,95,95,95,92,75,67,0,0,0,74
                DB 95,95,95,95,95,95,95,92,67,0,0,0,0,0,84,95,95,95,95,95,95
                DB 95,95,95,95,95,95,95,69,0,0,0,0,0,0,0,0,65,72,72,95,95,95
                DB 95,95,95,95,95,95,95,95,95,95,95,80,0,0,0,0,70,72,72,75,75
                DB 95,95,95,95,95,95,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 75,75,76,76,76,76,76,86,95,95,95,95,95,95,76,78,76,78,83,83
                DB 88,94,94,93,93,92,92,92,67,67,90,90,90,90,92,92,92,83,72,72
                DB 72,72,72,72,72,72,71,70,68,67,67,67,67,67,67,67,67,67,67,67
                DB 67,67,71,95,95,95,95,88,76,76,76,75,75,68,66,66,66,66,66,66
                DB 66,66,66,66,68,83,95,95,95,95,95,95,95,95,95,95,95,95,95,94
                DB 72,72,0,67,95,95,95,95,95,95,92,75,68,0,0,0,89,95,95,95,95
                DB 95,95,95,92,67,0,0,0,0,66,95,95,95,95,95,95,95,95,95,95,95
                DB 95,95,95,87,0,0,0,0,0,0,0,0,67,72,83,95,95,95,95,95,95,95
                DB 95,95,95,95,95,95,95,95,0,0,0,0,68,72,72,75,75,95,95,95,95
                DB 95,95,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,75,76,76
                DB 76,76,78,83,95,95,95,95,95,95,76,76,78,78,76,78,88,94,94,93
                DB 93,92,92,92,67,69,90,90,90,90,92,92,83,72,72,73,72,72,72,72
                DB 72,71,68,65,0,0,0,0,66,66,66,66,66,66,0,0,0,0,70,95,95,95
                DB 95,83,76,76,76,76,75,67,0,0,0,0,0,66,67,0,0,0,0,0,95,95,95
                DB 95,95,95,95,95,95,95,95,95,95,95,78,72,68,0,95,95,95,95,95
                DB 95,94,75,68,0,0,0,93,95,95,95,95,95,95,95,88,66,0,0,0,0,70
                DB 95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,0,0,0,0,0,0,0
                DB 0,68,72,92,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,67
                DB 0,0,0,68,72,75,75,75,95,95,95,95,95,95,68,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,72,75,76,76,76,76,78,78,95,95,95,95
                DB 95,95,76,76,75,75,75,76,92,94,94,93,93,92,92,87,0,69,90,90
                DB 90,92,92,86,76,76,75,75,75,75,73,72,72,67,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,85,95,95,95,95,78,76,76,76,76,75,66,66,68
                DB 71,87,95,95,83,76,70,68,67,0,95,95,95,95,95,95,95,95,95,95
                DB 95,95,95,95,95,83,70,66,94,95,95,95,95,95,95,75,68,0,0,0,94
                DB 95,95,95,95,95,95,95,83,0,0,0,0,0,95,95,95,95,95,95,95,95
                DB 70,95,95,95,95,95,95,95,67,0,0,0,0,0,0,0,70,72,95,95,95,95
                DB 95,95,95,95,83,95,95,95,95,95,95,95,71,0,0,0,68,72,75,75,75
                DB 95,95,95,95,95,95,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 70,76,76,76,76,76,76,78,94,95,95,95,95,94,72,72,72,72,72,83
                DB 94,94,94,93,93,92,92,71,0,76,90,90,90,92,92,86,76,75,75,75
                DB 75,75,73,78,70,67,67,70,70,70,70,70,70,70,70,69,68,68,67,66
                DB 0,0,85,95,95,95,94,78,76,83,86,90,94,95,95,95,95,95,95,95
                DB 83,76,76,75,75,0,95,95,95,95,95,95,95,95,95,95,95,95,95,95
                DB 95,95,90,70,92,95,95,95,95,95,95,75,68,0,0,0,95,95,95,95,95
                DB 95,95,95,83,0,0,0,0,67,95,95,95,95,95,95,95,95,66,92,95,95
                DB 95,95,95,95,80,0,0,0,0,0,0,65,72,72,95,95,95,95,95,95,95,95
                DB 72,92,95,95,95,95,95,95,95,0,0,0,67,72,75,75,75,95,95,95,95
                DB 95,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,76,76,76
                DB 76,76,76,78,94,95,92,83,72,72,70,70,70,70,76,94,94,94,94,93
                DB 93,92,92,67,0,76,90,90,90,92,92,88,76,75,75,75,75,73,73,87
                DB 94,94,94,94,94,94,94,94,94,94,94,92,76,76,76,76,75,72,92,95
                DB 95,95,94,94,95,95,95,95,95,95,95,95,95,95,95,95,83,76,76,75
                DB 75,0,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95
                DB 92,95,95,95,95,95,95,75,70,0,0,0,95,95,95,95,95,95,95,95,76
                DB 0,0,0,0,80,95,95,95,95,95,95,95,94,66,74,95,95,95,95,95,95
                DB 95,0,0,0,0,0,0,67,72,83,95,95,95,95,95,95,95,95,72,83,95,95
                DB 95,95,95,95,95,67,0,0,67,75,75,75,75,94,95,95,95,95,95,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,76,76,76,72,72,70,68
                DB 68,67,69,70,70,70,70,70,72,90,94,94,94,94,94,93,93,92,74,0
                DB 0,90,90,90,90,92,92,92,78,75,75,75,75,73,73,78,94,94,94,94
                DB 94,94,94,94,94,94,94,92,76,76,76,76,75,75,95,95,95,95,95,95
                DB 95,95,95,95,95,95,95,95,95,95,95,95,83,76,76,75,75,0,95,95
                DB 95,95,95,95,95,95,95,95,95,95,95,95,95,95,95
; from here
                DB 95,95,95,95,95,95,95,95,76,72,0,0,67,95,95,95,95,95,95,95
                DB 95,72,0,0,0,0,95,95,95,95,95,95,95,95,74,66,68,95,95,95,95
                DB 95,95,95,67,0,0,0,0,0,68,72,94,95,95,95,95,95,95,95,86,72
                DB 72,95,95,95,95,95,95,95,71,0,0,67,75,75,75,75,94,95,95,95
                DB 95,95,0,0,0,0,0,0
; to here was missing.  90 values missing and , was at end of last 95 above
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,0,0,0,0,0,65,68,69,70,70
                DB 70,70,70,83,94,94,94,94,94,94,94,93,93,82,65,0,0,90,90,90
                DB 90,92,92,92,83,76,75,75,75,73,73,72,92,94,94,94,94,94,94,94
                DB 94,94,94,92,76,76,76,76,75,75,95,95,95,95,95,95,95,95,95,95
                DB 95,95,95,95,95,95,95,95,83,76,76,75,75,0,95,95,95,95,95,95
                DB 95,95,83,94,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,76
                DB 72,0,0,68,95,95,95,95,95,95,95,95,72,0,0,0,69,95,95,95,95
                DB 95,95,95,95,68,0,67,95,95,95,95,95,95,95,80,0,0,0,0,0,70,72
                DB 95,95,95,95,95,95,95,95,75,72,72,95,95,95,95,95,95,95,95,0
                DB 0,0,75,75,75,75,88,95,95,95,95,95,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,68,70,70,70,70,70,75,94,95
                DB 95,94,94,94,94,94,94,93,73,65,0,0,0,90,90,90,90,92,92,92,90
                DB 76,75,75,75,75,73,73,86,94,94,94,94,94,94,94,94,94,94,92,76
                DB 76,76,76,75,76,95,95,95,95,83,83,73,78,86,78,71,71,87,90,90
                DB 90,94,95,83,76,76,75,75,0,94,95,95,95,95,95,95,95,83,83,95
                DB 95,95,95,95,95,95,95,95,95,95,95,95,95,95,76,72,0,0,69,95
                DB 95,95,95,95,95,95,95,68,0,0,0,90,95,95,95,95,95,95,95,95,0
                DB 0,66,82,95,95,95,95,95,95,95,0,0,0,0,66,72,72,95,95,95,95
                DB 95,95,95,90,72,72,72,88,95,95,95,95,95,95,95,67,0,0,75,75
                DB 75,75,86,95,95,95,95,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,66,68,70,70,70,70,70,72,86,95,95,95,95,94,94
                DB 94,94,94,94,70,0,0,0,0,0,90,90,90,90,92,92,92,92,83,76,75
                DB 75,75,75,73,78,94,94,94,94,94,94,94,94,94,94,92,76,76,76,76
                DB 75,78,95,95,95,95,86,76,75,75,75,72,66,0,0,0,0,0,0,0,66,66
                DB 67,67,68,0,89,95,95,95,95,95,95,95,83,76,92,95,95,95,95,95
                DB 95,95,95,95,95,95,95,95,95,76,72,0,0,74,95,95,95,95,95,95
                DB 95,95,68,0,0,66,95,95,95,95,95,95,95,95,95,0,0,65,69,95,95
                DB 95,95,95,95,95,67,0,0,0,67,72,83,95,95,95,95,95,95,95,70,68
                DB 72,72,75,95,95,95,95,95,95,95,71,0,0,75,75,75,75,86,95,95
                DB 95,95,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67
                DB 70,70,70,70,72,72,76,95,95,95,95,95,95,94,94,94,94,90,68,0
                DB 0,0,0,0,0,90,90,90,90,92,92,92,92,92,83,76,75,75,75,75,73
                DB 88,80,80,92,94,94,94,94,94,94,92,76,76,76,76,75,78,95,95,95
                DB 95,94,76,76,76,75,75,69,0,0,0,0,0,0,0,0,0,0,0,0,0,89,95,95
                DB 95,95,95,95,95,83,76,75,94,95,95,95,95,95,95,95,95,95,95,95
                DB 95,95,76,75,0,0,74,95,95,95,95,95,95,95,95,68,0,0,71,95,95
                DB 95,95,95,95,95,95,80,0,0,66,82,95,95,95,95,95,95,95,71,0,0
                DB 0,68,72,94,95,95,95,95,95,95,95,67,67,72,75,92,95,95,95,95
                DB 95,95,95,95,0,0,72,75,75,75,76,95,95,95,95,90,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,69,70,72,72,72,72,72,90,95
                DB 95,95,95,95,95,94,94,94,94,84,66,0,0,0,0,0,0,0,90,90,90,90
                DB 92,92,92,92,92,86,78,72,72,72,72,70,70,67,66,87,94,94,94,94
                DB 94,94,92,76,76,76,76,75,83,95,95,95,95,95,88,76,76,75,75,72
                DB 66,0,0,66,67,68,71,71,86,72,70,68,68,92,95,95,95,95,95,95
                DB 95,83,76,75,72,93,95,95,95,95,95,95,95,95,95,95,95,95,83,75
                DB 0,0,93,95,95,95,95,95,95,95,95,67,0,0,95,95,95,95,95,95,95
                DB 95,95,69,67,76,95,95,95,95,95,95,95,95,95,95,0,0,0,72,72,95
                DB 95,95,95,95,95,95,95,70,88,95,95,95,95,95,95,95,95,95,95,95
                DB 67,0,72,75,75,75,75,95,95,95,95,74,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,67,72,72,72,72,72,72,76,94,95,95,95,95,95
                DB 95,95,94,94,94,70,0,0,0,0,0,0,0,0,0,88,90,90,90,90,92,92,92
                DB 92,92,92,86,72,72,72,72,72,72,86,94,94,94,94,94,94,94,92,76
                DB 76,76,76,75,86,95,95,95,95,95,95,83,83,87,87,94,88,95,95,95
                DB 95,95,95,95,95,78,76,76,75,94,95,95,95,95,95,95,95,83,76,75
                DB 70,66,93,95,95,95,95,95,95,95,95,95,95,95,86,75,0,0,93,95
                DB 95,95,95,95,95,95,92,67,0,67,95,95,95,95,95,95,95,95,95,90
                DB 95,95,95,95,95,95,95,95,95,95,95,95,67,0,66,72,72,95,95,95
                DB 95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,71,0
                DB 70,75,75,75,75,95,95,95,95,74,0,0,0,0,0,0,0,0,0,65,66,66,66
                DB 0,0,0,0,0,0,68,72,72,72,72,72,72,76,95,95,95,95,95,95,95,95
                DB 95,94,92,67,0,0,0,0,0,0,0,0,0,0,88,90,90,90,90,92,92,92,92
                DB 92,92,92,86,75,70,70,75,87,94,94,94,94,94,94,94,94,92,76,76
                DB 76,76,75,86,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95
                DB 95,95,95,95,86,76,76,75,94,95,95,95,95,95,95,95,83,76,75,70
                DB 0,66,93,95,95,95,95,95,95,95,95,95,95,86,75,66,0,95,95,95
                DB 95,95,95,95,95,92,67,0,85,95,95,95,95,95,95,95,95,95,95,95
                DB 95,95,95,95,94,80,95,95,95,95,95,71,0,67,72,83,95,95,95,95
                DB 95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,0,68
                DB 75,75,75,75,95,95,95,95,74,0,0,0,66,67,68,69,69,70,78,90,95
                DB 73,0,0,0,0,0,70,72,75,76,76,75,76,78,95,95,95,95,95,95,95
                DB 95,95,95,94,94,94,94,94,94,93,93,92,92,92,87,0,82,90,90,90
                DB 90,92,92,92,92,92,93,92,93,93,93,93,94,94,94,94,94,94,94,94
                DB 94,94,92,76,76,76,76,75,90,95,95,95,95,95,95,95,95,95,95,95
                DB 95,95,95,95,95,95,95,95,95,86,76,76,75,94,95,95,95,95,95,95
                DB 95,83,76,75,70,0,0,66,93,95,95,95,95,95,95,95,95,95,86,75
                DB 67,0,95,95,95,95,95,95,95,95,88,66,0,95,95,95,95,95,95,95
                DB 95,95,95,95,95,95,85,69,66,65,67,95,95,95,95,95,90,0,68,72
                DB 95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95
                DB 95,95,95,67,68,75,75,75,75,95,95,95,95,69,67,68,70,70,70,72
                DB 83,94,95,95,95,95,73,0,0,0,0,0,75,76,76,76,76,76,78,88,95
                DB 95,95,95,95,95,95,95,95,95,94,94,94,94,94,94,93,93,92,92,92
                DB 71,0,71,90,90,90,90,92,92,92,92,92,92,92,92,93,93,93,94,94
                DB 94,94,94,94,94,94,94,94,92,76,76,76,76,75,92,95,95,95,95,95
                DB 95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,86,76,76,75,94
                DB 95,95,95,95,95,95,95,83,76,75,70,0,0,0,67,95,95,95,95,95,95
                DB 95,95,95,88,75,67,66,95,95,95,95,95,95,95,95,83,0,69,95,95
                DB 95,95,95,95,95,95,95,95,71,67,0,0,0,0,65,67,95,95,95,95,95
                DB 95,66,72,72,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95
                DB 95,95,95,95,95,95,95,71,68,75,75,75,75,95,95,95,95,75,70,70
                DB 75,90,95,95,95,95,95,95,95,95,73,0,0,0,0,0,75,75,75,76,76
                DB 76,78,88,95,95,95,95,95,95,95,95,95,94,94,94,94,94,94,93,93
                DB 92,93,92,92,68,0,66,86,90,90,90,92,92,92,92,92,92,92,92,93
                DB 93,93,94,94,94,94,94,94,94,94,94,94,92,76,76,76,76,75,92,95
                DB 95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,86
                DB 76,76,75,88,95,95,95,95,95,95,95,83,76,75,70,0,0,0,0,67,95
                DB 95,95,95,95,95,95,95,92,76,67,68,95,95,95,95,95,95,95,95,83
                DB 0,0,68,95,95,95,95,95,95,95,66,0,0,0,0,0,0,0,65,67,95,95,95
                DB 95,95,95,74,72,75,95,95,95,95,95,95,95,95,95,95,95,95,95,95
                DB 92,92,95,95,95,95,95,95,95,95,67,75,75,75,75,92,95,95,95,92
                DB 94,95,95,95,95,95,95,95,95,95,95,95,74,0,0,0,0,0,75,75,75
                DB 75,76,76,76,88,95,95,95,95,95,95,95,95,95,94,94,94,94,94,94
                DB 93,93,92,92,92,92,65,0,0,68,90,90,90,92,92,92,92,92,92,93
                DB 92,93,93,93,93,94,94,94,92,92,94,94,94,94,92,76,76,76,76,75
                DB 94,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95
                DB 95,92,76,76,75,88,95,95,95,95,95,95,95,83,76,75,70,0,0,0,0
                DB 0,67,95,95,95,95,95,95,95,92,76,67,66,86,95,95,95,95,95,95
                DB 95,72,0,0,0,0,74,95,95,95,95,95,0,0,0,0,0,0,0,0,65,67,95,95
                DB 95,95,95,95,78,72,88,95,95,95,95,95,95,95,95,95,80,69,67,72
                DB 72,72,88,95,95,95,95,95,95,95,95,68,75,75,75,75,92,95,95,95
                DB 95,95,95,95,95,95,95,95,95,95,95,95,95,74,0,0,0,0,0,70,75
                DB 75,75,75,76,76,83,95,95,95,95,95,95,95,95,95,94,94,94,94,94
                DB 94,93,93,92,92,92,74,0,0,0,0,70,90,90,90,92,92,92,92,92,93
                DB 92,93,93,93,93,94,94,83,70,83,94,94,94,94,92,76,76,76,76,75
                DB 95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95
                DB 95,92,76,76,75,88,95,95,95,95,95,95,95,83,76,75,70,0,0,0,0
                DB 0,0,67,95,95,95,95,95,95,92,76,68,0,0,66,69,86,95,95,95,95
                DB 72,0,0,0,0,0,66,93,95,95,71,0,0,0,0,0,0,0,0,65,67,95,95,95
                DB 93,70,0,68,72,94,95,95,95,95,95,95,95,95,95,0,0,0,72,72,72
                DB 92,95,95,95,95,95,95,95,95,74,72,75,75,75,92,95,95,95,95,95
                DB 95,95,95,95,95,95,95,95,95,95,95,71,0,0,0,0,0,68,72,72,75
                DB 75,75,76,76,95,95,95,95,95,95,95,95,94,94,94,94,94,94,93,93
                DB 93,93,92,92,68,0,0,0,0,0,71,90,90,92,92,92,92,92,92,92,92
                DB 93,93,92,78,68,68,68,75,94,94,94,94,92,76,76,76,76,70,95,95
                DB 95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,92
                DB 76,76,72,86,95,95,95,95,95,95,95,83,76,72,68,0,0,0,0,0,0,0
                DB 66,82,95,95,95,95,92,76,68,0,0,0,0,0,66,69,93,95,68,0,0,0
                DB 0,0,0,0,69,95,66,0,0,0,0,0,0,0,0,65,67,95,84,67,0,0,0,68,72
                DB 95,95,95,95,95,95,95,95,95,95,67,0,67,72,72,72,95,95,95,95
                DB 95,95,95,95,95,95,72,72,75,75,83,95,95,95,95,95,95,95,95,95
                DB 95,95,95,95,95,95,95,71,0,0,0,0,0,66,70,72,72,75,75,75,76
                DB 94,95,95,95,95,95,95,95,94,94,94,94,94,94,93,93,92,92,92,92
                DB 65,0,0,0,0,0,0,70,90,92,92,92,92,92,92,92,90,78,69,67,67,67
                DB 67,66,67,67,67,67,67,67,67,0,0,0,67,95,95,95,95,95,95,95,95
                DB 95,95,95,95,95,95,95,93,85,82,71,71,68,67,65,0,0,66,68,68
                DB 68,68,68,68,68,66,0,0,0,0,0,0,0,0,0,0,0,0,67,90,95,95,95,76
                DB 68,0,0,0,0,0,0,0,0,66,0,0,0,0,0,0,0,0,0,66,0,0,0,0,0,0,0,0
                DB 0,0,66,66,0,0,0,0,0,0,66,69,80,95,95,95,95,95,95,95,95,84
                DB 0,68,72,72,72,95,95,95,95,95,95,95,93,74,69,72,72,75,75,83
                DB 95,95,95,95,95,95,95,95,94,90,90,76,73,73,69,68,66,0,0,0,0
                DB 0,0,0,0,66,66,67,67,68,68,76,87,94,95,95,95,94,94,94,94,94
                DB 94,94,93,93,92,92,92,74,0,0,0,0,0,0,0,0,66,71,77,85,77,74
                DB 69,67,66,66,65,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,95,95,95
                DB 95,95,95,86,84,76,70,70,67,67,65,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,95,95,76,68,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,67,70,84,95,95,95,95,95,0,67,70,72,72
                DB 95,95,93,74,69,66,0,0,0,0,0,0,67,67,69,74,74,68,68,68,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,66,66,67,67
                DB 68,71,82,93,94,94,94,94,94,93,93,92,93,92,92,68,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 66,70,68,67,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,67,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,71,90,95,69,0,0,0,66,66,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,66,66,67,67,68,71,78
                DB 92,94,93,93,92,92,92,92,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,65,66,66,66,67,68,70,78,88,92,92,74,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,65,67,69,67,0
                DB 0,0,0
                DB 228 DUP (?)

CODE    ENDS                                    ; End of code

        END     Start
