; In : U = 0..100 percent red
;      V = 0..100 percent green
;      W = 0..100 percent blue
;
; Will alter: A,R,G,B,U,V,W,X,Y

PROC    ColorMask

  mov   a,100
  div   u,a
  div   v,a
  div   w,a

  mov   y,255
> YLoopColorMask
  mov   x,255
> XLoopColorMask

  ldc   x,y
  mul   r,u
  clip  r
  mul   g,v
  clip  g
  mul   b,w
  clip  b
  stc   x,y

  dec   x
  cmp   x,0
  jge   XLoopColorMask

  dec   y
  cmp   y,0
  jge   YLoopColorMask

  ret

ENDP


; In: U = middle point hilight x (0..255)
;     V = middle point hilight y (0..255)

PROC    GrayHiLight

  MOV   Y,255
> YLoop
  MOV   X,255
> XLoop

  mov   a,x
  sub   a,u
  sqr   a

  mov   b,y
  sub   b,v
  sqr   b

  add   b,a
  sqrt  b

  mov   a,128
  sub   a,b

  LDC   X,Y

  add   r,a
  clip  r
  mul   r,0.30
  add   g,a
  clip  g
  mul   g,0.59
  add   b,a
  clip  b
  mul   b,0.11

  add   r,b
  add   r,g
  mov   g,r
  mov   b,r

  STC   X,Y


  DEC   X
  CMP   X,0
  JGE   XLoop
  DEC   Y
  CMP   Y,0
  JGE   YLoop

  RET

ENDP


> Main
  LDZ   R               ; R = 0                       84
  LDZ   G               ; G = 0                       86
  LDZ   B               ; B = 0                       88

  CLRM                  ; Clear the map               89

  RNDD 15

  mov a,10
> blurloop
  BLUR
  dec a
  cmp a,0
  jge blurloop

  mov  u,192
  mov  v,64
  CALL GrayHiLight

  mov  u,92
  mov  v,56
  mov  w,36
  CALL ColorMask

  SAVM                  ; Save the map                93

  END
