;            ͻ
;                    EX2.ASM        
;                                                               
;                        Memory and Timer example               
;                                                               
;            ĺ
;               by Freddy Vtel (FreddyV/Useless)              
;                                                               
;               Code starts .................. 27/10/1996       
;               Last update .................. 31/08/1997       
;            ͼ
; Warning: you must change the path to EOS files in makefile file.
; SETUP.INC is included only for the MAX_TIMERS constant
.386p
INCLUDE OS.INC        ; waitkey macro and EOS.INC include

CODE32 SEGMENT PUBLIC PARA 'CODE' USE32
ASSUME  CS:CODE32,DS:CODE32,ES:CODE32

INCLUDE MEMORY.INC
INCLUDE TIMER.INC

INCLUDE UTILS.INC     ; Display macros (write, writeln) 

;=============================================================================

TimerCount DD 0

;=============================================================================

Start32:

        Writeln 'Memory and Timer Example.'

;                    ** Memory examples **

	U_Maxavail
	
	Write 'Free memory: '
	call Print_Dec
	Writeln ' bytes.'

        Writeln 'Allocating 1000 bytes.'
        
        U_Malloc 1000   ; Allocate a memory buffer.
                        ; Buffer adress is now in eax        
        U_Free eax      ; Free the memory buffer


;                     ** Timer Example **


        Writeln 'Now, asking for a 70Hz Timer.'

        mov eax,Offset TimerProc ; The function to be called by the timer.
        mov ebx,TimerSpeed/(70)  ; 70Hz Timer.
        call Timer_Start_
        
	Writeln 'Press a key to stop the timer.'

	waitkey

        mov eax,Offset TimerProc
        call Timer_Stop_         ; Stop the timer !

        Write 'Timer called: '
        mov eax,TimerCount
        call print_dec
        write ' Times.'
                
        mov   ax,4C00h ; Bye...
        int   21h

; This IRQ can be used as a frame counter.

TimerProc Proc
        inc TimerCount  ; TimerCount will be incremented 70 times/s
        ret             ; It's very usefull for GFX synchro.
TimerProc Endp          

CODE32 ENDS
;=============================================================================
END  
