;            ͻ
;                 USSVAR.INC        
;                                                               
;                     Useless Sound System 'Variables'          
;            ĺ
;               By Freddy Vtel (FreddyV/Useless)              
;                                                               
;               Code starts .................. 03/08/1996       
;               Last update .................. 17/07/1997       
;            ͼ

MAX_Samples     EQU 128
MAX_Instruments EQU 128

; ** Devices var **

Global _DEV_Number      :WORD
Global _DEV_Name        :DWORD
Global _DEV_BasePort    :WORD
Global _DEV_IRQ         :BYTE
Global _DEV_DMA         :BYTE
Global _DEV_Freq        :WORD
Global _DEV_Mode        :WORD
Global _DEV_MaxChannels :WORD

; ** Devices Type Mask **

DM_8bit   EQU 1      ; 8 bit device
DM_16bit  EQU 2      ; 16 bit device
DM_Mono   EQU 4      ; Mono Device
DM_Stereo EQU 8      ; Stereo Device
DM_Signed EQU 16     ; Need a signed or an unsigned buffer (used in mix.asm)
DM_Interp EQU 32     ; 16 bit interpolation and 32 bit mixing...

DM_Mixed  EQU 256    ; Software mixed or hardware mixed device
DM_DRAM   EQU 512
DM_MIDI   EQU 1024   ; MIDI Device (Not used yet)
DM_FM     EQU 2048   ; FM Device (Adlib, Not used yet)

; ** Global var **

Global SSSampleOffsetT  :DWORD  ; Sample Offset Table
Global SSInstrOffsetT   :DWORD  ; Instrument Offset Table
Global SSPeriodMin      :WORD
Global SSPeriodMax      :WORD
Global SSInstrumentMode :BYTE
Global SSGlobalVol      :BYTE
Global SSActiveChannels :DWORD

; ** Channels var **

Global VChControl    :WORD      ; Channel control

Global VChInsAdress  :DWORD
Global VChPeriod     :WORD
Global VChFreq       :DWORD
Global VChannelVol   :BYTE
Global VChVolume     :BYTE
Global VChFVolume    :BYTE
Global VChPanning    :BYTE
Global VChFPanning   :BYTE

Global VChSmpAdress  :DWORD
Global VChSmpOffset  :DWORD

Global VChFadeoutVol   :WORD

Global VChVolEnvPos    :WORD
Global VChVolEnvSegPos :WORD
Global VChEnvVol       :BYTE

Global VChPanEnvPos    :WORD
Global VChPanEnvSegPos :WORD
Global VChEnvPan       :BYTE

Global VChAVibPos      :BYTE
Global VChAVibSwpPos   :BYTE
Global VChAVibPitch    :WORD

Global USSVarStart
Global USSVarEnd

Global Period_Table :WORD

; ** Channel Control masques **

CC_Stopped   EQU 1      ; Active/Stopped channel                 (0)
CC_Playing   EQU 2      ; A sample is played on this channel     (1)
CC_StopVoice EQU 4      ; Stop the channel                       (2)
CC_FadeVol   EQU 8      ; Fading active                          (3)

CC_ChSample  EQU 16     ; Change channel sample                  (4)
CC_ChPeriod  EQU 32     ; Change channel period                  (5)
CC_ChVolume  EQU 64     ; Change channel volume                  (6)
CC_ChPanning EQU 128    ; Change channel panning                 (7)
CC_Surround  EQU 256    ; Surround                               (8)

CC_Backgrnd  EQU 512    ; Background channel

CNNA_Stop    EQU 1024
CNNA_Fade    EQU 2048

; ** Instrument and sample definition **

USSInstrSize EQU IPEnvelope+24*2

USSInstr Struc
	IId         DD 0		;'INST'
	IName       DB 32  DUP (0)
	INNA        DB 0
	IDCT        DB 0

        IGVolume    DB 0                ;Global instrument volume
        IDefPanning DB 0
        IPPC        DB 0                ;Pitch-pan center
        IPPS        DB 0                ;Pitch-pan separation
        IVFadeout   DW 0                ;Fadeout
        
        ISNumber    DB 120 DUP (0) 	;Sample number for all notes  (1-255)

	IVType	    DB 0
	IVPoints    DB 0
	IVSustain   DB 0
	IVLoopStart DB 0
	IVLoopEnd   DB 0
        IVEnvelope  DW 24  DUP (0)

	IPType      DB 0
        IPPoints    DB 0
        IPSustain   DB 0
	IPLoopStart DB 0
	IPLoopEnd   DB 0
	IPEnvelope  DW 24  DUP (0)

USSInstr Ends

; Envelope Type Mask

E_On      EQU 1
E_Sustain EQU 2
E_Loop    EQU 4

USSSampleSize EQU SVibrate+1		; ! Can't be >255 !

USSSample Struc
        SId	    DD 0		; 'SMPL'
        SName       DB 32 DUP (0)

        SLength     DD 0
        SLoop	    DD 0
        SLoopEnd    DD 0
        SSustain    DD 0
        SSustEnd    DD 0

        SType       DB 0
        SFlag       DB 0
        SDefVolume  DB 0
        SVolume     DB 0
        
        SDefPanning DB 0                ;Sample default panning
        SRelNote    DB 0
        SFine	    DD 0
        SPointer    DD 0

        SVibType    DB 0                ;Sample auto vibrato
        SVibSweep   DB 0
        SVibdepth   DB 0
        SVibrate    DB 0
USSSample Ends

; Sample Type Mask 
; Warning: Don't change 16bit, Loop and Bidi. I've used GUS values.

SM_Stereo  EQU 1

SM_16bit   EQU 4
SM_Loop    EQU 8
SM_Bidi    EQU 16
SM_Sustain EQU 32
SM_SBidi   EQU 64

; Sample Flag Mask

SF_Loaded      EQU 1
SF_UsePanning  EQU 2    ;Use the panning default value
SF_UseIPanning EQU 4    ;Use Instrument panning for default sample panning
SF_Linear      EQU 8    ;Use Linear/Amiga period

SF_Unsigned    EQU 16
SF_Delta       EQU 32

; USSVAR.INC (c) 1997 FreddyV/Useless
