{
  Copyright (c) 1998 Erland Van Olmen (erlandvo@hotmail.com)
  NOT Protected Mode Ready

  For the SB 1.0, SB PRO 1.0, SB 2.0, SB PRO 2.0 & compatibles there are some
  remarkable frequencies:

           Freq. (Hz) | Reg. value
           -----------|-----------
             8000     |   131
            10000     |   156
            12500     |   176
            15625     |   192
            20000     |   206
            25000     |   216
            31250     |   224
            40000     |   231

  Bugfixes/changes/additions since version 1.0 (first public release):

      - Reduced clicks when using interpolation.

}
{DEFINE USE_BP_MIXER}     { ENABLE THIS IF YOU WANT TO USE THE PASCAL MIXER }
Unit SB_DRV1;

interface

Uses
  Crt,       { for delay fn }
  MODType1,
  Replay;

CONST
  DefMBufLn = $400;                    { Last Digit MUST be 0!               }
  MixBufLen: word = DefMBufLn;         { Ideal: $400; Min: $200; Max: $3FF0  }
  SBVolumeBoost: Boolean = False;      { If SB HW global volume is used too  }
  StereoReplay : Boolean = False;      { If SB replay is in stereo           }
  MixRate      : Word = 40000;
  Amplify      : Word = 20;            { range: 8..127, resolution: 4 bits   }

VAR
  SBDevice     : TOutputDevice;        { the driver                          }
  MaxA, MinA   : LongInt;              { amplify values                      }


Procedure SetInterPolation(InterPolate: Boolean);

{}
{}

implementation

Uses
  Dos,
  HardWare;

Type
  ChnMixInfoType = Record
{Some general Info: }
{0 }OnMix       : Boolean; { If this channel is active                       }
{1 }Vol,                   { the channel volume (for mono mixing)            }
{2 }LeftVol,               { the left -side channel volume (for panning)     }
{3 }RightVol    : Byte;    { the right-side channel volume (for panning)     }
{Info about the sample: }
{4 }RepeatSample: Boolean; { If the sample is a looping one                  }
{5 }RepeatOffset,          { Repeat Offset of the sample                     }
{7 }RepeatLength,          { Repeat Length of the sample                     }
{9 }Length      ,          { Length        of the sample                     }
{11}SampleSeg   ,          { Segment of the sample data                      }
{13}SampleOfs   : Word;    { Offset  of the sample data                      }
{15}IncEr,                 { Frequency constant                              }
{19}RealIndex   : LongInt; { Index in sample data                            }
  End; { size  = 23 bytes }
{
  LeftVol  = ($FF-Pan) * Scale;     // ex. for scale: 1, 0.5, 0.25, etc.
  RightVol = Pan       * Scale;
}
  MixInfoType = Array[1..32] of ChnMixInfoType;
  MixInfoPTR  = ^MixInfoType;

  _DWBuf   = array[0..16000] of LongInt;
  DBufType = ^_DWBuf;

CONST
  MaxSamples = 31;

{Some SB registers & register indices: --------------------------------------}
  SBPROFilterBit = $20;
  SBPROStereoBit = $2;

  SBMasterVolReg = $22;
  SBVoiceVolReg  = $4;
  SBFMVolReg     = $26;
  SBOutPutReg    = $E;
  SBResetReg     = $0;

{Var's for the SB Mixing device(s): -----------------------------------------}
  CallBpm          : Word = 40000 div 50;
  MixCount         : Word = 0;
  MixInfo_Size     : Word = SizeOf(ChnMixInfoType);
  BuffersAllocated : Boolean = False;
  Interpolation    : Boolean = False;  { If interpoaltion should be done     }
  UseOutFilter     : Boolean = False;  { If the SB PRO Filter should be used }

VAR
{Following var's are needed for SB I/O routines: ----------------------------}
  DSP_RESET,
  DSP_READ_DATA,
  DSP_WRITE_DATA,
  DSP_WRITE_STATUS,
  DSP_DATA_AVAIL   : Word;

{These three buffers are used by the SB double-buffering mixing routine: ----}
  PlayBuffer,
  MixBuffer        : PByteBuffer;
  TMixBuffer       : DBufType;

{These var's are backup values of the SB Mixer Register values: -------------}
  OldMasterVolume,
  OldVoiceVolume,
  OldOutPutMode    : Byte;

  MixIRQActive     : Boolean;               { If the IRQ procedure is active }
  MixInfo          : MixInfoType;
  SamplePointers   : Array[1..MaxSamples] of PByteBuffer;
  OldSBIRQInterrupt: Procedure;    { The previously-installed SB IRQ handler }


{}
{}

{$IFDEF USE_BP_MIXER}
{$I c:\erland\bp7\bin\mpts\bp_mixer.pas} { Include PASCAL MIXER }
{$ELSE}
{$F-}
Procedure SBUpdateMultipleStepsEffects; BEGIN UpdateMultipleStepsEffects; END;
Procedure SBUpdateNotes;                BEGIN UpdateNotes;                END;
{$L DMA_MIX.OBJ}             { Include the ASM file with the mixing routines }
Procedure _SBMono_Mixer;     external;
Procedure _SBMono_Mixer_I;   external;
Procedure _SBStereo_Mixer;   external;
Procedure _SBStereo_Mixer_I; external;
Procedure _SwapBuffers;      external;
{$F+}
{$ENDIF}

Procedure Playback(Sound: Pointer; Size: Word); Forward;


{}
{}
{ Here come the SoundBlaster I/O Routines: }
{}
{}

{$F+}
procedure IRQProc; interrupt;
Var
   temp: byte;
   Label ExitProc;
BEGIN
  Asm cli End;
  If MixIRQActive then goto ExitProc;
  MixIRQActive:=True;
  temp:=port[DSP_DATA_AVAIL];                         { Aknowledge IRQ to SB }
  _SwapBuffers;
  Playback(PlayBuffer, MixBufLen);

{$IFNDEF USE_BP_MIXER}
  If StereoReplay then
    Begin
      If Interpolation then _SbStereo_Mixer_I
      Else _SbStereo_Mixer;
    End
  Else
{$ENDIF}
    Begin
      If Interpolation then _SbMono_Mixer_I
      Else _SbMono_Mixer;
    End;

  MixIRQActive:=False;                         { Indicate we're ready mixing }
ExitProc:
  If MixIRQActive then temp:=port[DSP_DATA_AVAIL];    { Aknowledge IRQ to SB }
  If SBDevice.MIRQ>7 then port[$A0]:=$20; { IRQ > 7 ? -=> send EOI to slave  PIC }
  port[$20]:=$20;                                   { send EOI to master PIC }
END;

{}

Procedure SetInterPolation(InterPolate: Boolean);
Begin
  Interpolation:=InterPolate;
End;

{}

Function ResetDSP: boolean;
BEGIN
{ Calculate the port addresses: ---------------------------------------------}
  DSP_RESET       :=SBDevice.MPort+$6;
  DSP_READ_DATA   :=SBDevice.MPort+$A;
  DSP_WRITE_DATA  :=SBDevice.MPort+$C;
  DSP_WRITE_STATUS:=SBDevice.MPort+$C;
  DSP_DATA_AVAIL  :=SBDevice.MPort+$E;

{ Reset the DSP, and give some nice long delays just to be safe: ------------}
  Port[DSP_RESET]:=1; Crt.Delay(10); Port[DSP_RESET]:=0; Crt.Delay(10);
  If ((Port[DSP_DATA_AVAIL] And $80)=$80) And (Port[DSP_READ_DATA]=$AA)
    then ResetDSP:=True
  Else   ResetDSP:=False;
END;

{}

procedure WriteDSP(value: byte);
VAR I: LongInt;
begin
  I:=0;
  while (Port[DSP_WRITE_STATUS] And $80 <> 0) and (I<1000000000) do Inc(I);
  If(I<1000000000) then Port[DSP_WRITE_DATA]:=value;
end;

{}

function ReadDSP: byte;
VAR I: LongInt;
begin
  I:=0;
  while ((Port[DSP_DATA_AVAIL] And $80) = 0) and (I<1000000000) do Inc(I);
  If(I<1000000000) then ReadDSP:=Port[DSP_READ_DATA];
end;

{

procedure WriteDAC(level: byte);
begin
  WriteDSP($10);
  WriteDSP(level);
end;

{

function ReadDAC: byte;
begin
  WriteDSP($20);
  ReadDAC := ReadDSP;
end;

{}

function SpeakerOn: byte;
begin
  WriteDSP($D1);
end;

{}

Function SpeakerOff: byte;
begin
  WriteDSP($D3);
end;

{}

Procedure SetMixerReg(index, value: byte);
begin
  Port[SBDevice.MPort+4]:=index;
  Port[SBDevice.MPort+5]:=value;
end;

{}

Function GetMixerReg(index: byte): byte;
begin
  Port[SBDevice.MPort+4]:=index;
  GetMixerReg:=Port[SBDevice.MPort+5];
end;

{}

procedure Playback(Sound: Pointer; Size: Word);
VAR
  page, offset: Word;
  _MixRate: LongInt;
Begin
{ Set up the DMA chip: ------------------------------------------------------}
  offset:= Seg(sound^) Shl 4 + Ofs(sound^);
  page  := (Seg(sound^) + Ofs(sound^) shr 4) shr 12;
  Port[$0A]:=4+SBDevice.MDMA;             { set mask + select dma channel 1  }
  Port[$0C]:=0;                           { reset the internal pointers      }
  Port[$0B]:=$8+$40+SBDevice.MDMA;        { read op., signal mode, dma chn   }
  Port[$02]:=Lo(offset);
  Port[$02]:=Hi(offset);
  Port[$83]:=page;
  Dec(size);
  Port[$03]:=Lo(size);
  Port[$03]:=Hi(size);
  Port[$0A]:=SBDevice.MDMA;               { select DMA channel               }

{ Set the playback type (8-bit): --------------------------------------------}
{$IFNDEF USE_BP_MIXER}
  If StereoReplay then _MixRate:=LongInt(MixRate)*2
  Else
{$ENDIF}
  _MixRate:=MixRate;

  If _MixRate<22000 then
  Begin
    WriteDSP($14);
    WriteDSP(Lo(size));
    WriteDSP(Hi(size));
  End
  Else
  Begin
    WriteDSP($48);
    WriteDSP(Lo(size));
    WriteDSP(Hi(size));
    WriteDSP($91);
  End;

{ auto-init mode:
  WriteDSP($48);
  WriteDSP(Lo(size));
  WriteDSP(Hi(size));
  WriteDSP($1C);
}
end;

{}
{}
{}
{}
{$IFDEF DPMI}
Function OpenCard(NrVoices: Byte): Word;
BEGIN
  OpenCard:=0;
END;
{$ELSE}
Function OpenCard(NrVoices: Byte): Word;
Var
  SBReg: Byte;
  I    : Word;
  d    : PByteBuffer;
BEGIN
  GetIntVec($8+SBDevice.MIRQ, @OldSBIRQInterrupt);
{Init Freq Table: -----------------------------------------------------------}
  For I:=MinPeriod to MaxPeriod do FreqTable[I]:=Round(((3546895/I)*$10000)/MixRate);
  IF SBDevice.Subtype<$300 then StereoReplay:=False;
{Init Amplify barrier values: -----------------------------------------------}
  If StereoReplay then
    Begin
      MaxA:=LongInt( 127*64*16);
      MinA:=LongInt(-128*64*16);
    End
  Else
    Begin
      MaxA:=LongInt( 127*64*16);
      MinA:=LongInt(-128*64*16);
    End;

  Case Filter of
    SBPROHW      : UseOutFilter:=True;
    Interpolative: Interpolation:=True;
  End;

{Is there a "DSP" chip? -----------------------------------------------------}
  If Not ResetDSP then Begin OpenCard:=255; exit; end; { Reset DSP           }
  SetMixerReg(SBResetReg, 0);                          { Reset Mixer         }
  SpeakerOn;                                           { Connect Amplifier   }

{Save the old register values: ----------------------------------------------}
  OldOutPutMode  :=GetMixerReg(SBOutPutReg);
  OldVoiceVolume :=GetMixerReg(SBVoiceVolReg);
  OldMasterVolume:=GetMixerReg(SBMasterVolReg);

{  UseOutFilter:=True; {!!!!}
{Set the SB output mode: Low/High Filter, Stereo/Mono. ----------------------}
  If UseOutFilter then SBReg:=(SBReg AND ($FF XOR SBPROFilterBit)) AND ($FF XOR SBPROStereoBit)
  Else                 SBReg:=(SBReg  OR SBPROFilterBit)           AND ($FF XOR SBPROStereoBit);
{$IFNDEF USE_BP_MIXER}
  If StereoReplay then
    Begin
      If UseOutFilter then SBReg:=(SBReg OR SBPROStereoBit) AND ($FF XOR SBPROFilterBit)
      Else                 SBReg:= SBReg OR (SBPROStereoBit + SBPROFilterBit);
    End
  Else
    Begin
      If UseOutFilter then SBReg:=(SBReg AND ($FF XOR SBPROFilterBit)) AND ($FF XOR SBPROStereoBit)
      Else                 SBReg:=(SBReg  OR SBPROFilterBit)           AND ($FF XOR SBPROStereoBit);
    End;
{$ENDIF}

  SetMixerReg(SBOutPutReg, SBReg);

{Set the SB output volume: --------------------------------------------------}
  GlobalVolume:=(Word(GlobalVolume-10) * $10) div 100;
  SetMixerReg(SBVoiceVolReg, GlobalVolume shl 4 + GlobalVolume);
  If SBVolumeBoost then SetMixerReg(SBMasterVolReg, $FF);

  SetMixerReg(SBMasterVolReg, $FF); SetMixerReg(SBVoiceVolReg , $FF); {!!!!}

  If not BuffersAllocated Then
  Begin
{    GetMem(d, $100); For I:=0 to 100-1 do d^[I]:=0;}
{Allocate mem for the DWORD temporary MIX Buffer: ---------------------------}
    If MaxAvail>(MixBufLen shl 2) then GetMem(TMixBuffer, MixBufLen shl 2)
    Else Begin OpenCard:=255; exit; end;
{be sure to get 2 buffers that doesn't cross page breaks: -------------------}
{ (Stupid DMA controller can't transfer blocks that cross page breaks) }
    GetDMABuffer(Pointer(MixBuffer), MixBufLen);
    If Not GetDMABuffer(Pointer(PlayBuffer), MixBufLen) Then
                                               Begin OpenCard:=255; exit; end;
    For I:=0 to MixBufLen-1 do begin PlayBuffer^[I]:=0; MixBuffer^[I]:=0; end;
{    WriteLn('TMIXBuffer seg:ofs: ', Seg(TMixBuffer^), ':', Ofs(TMixBuffer^)); ReadLn; }
    BuffersAllocated:=True;
  End;
{ Set the playback frequency: -----------------------------------------------}
  WriteDSP($40);
{$IFNDEF USE_BP_MIXER}
  If StereoReplay then WriteDSP(256 - 1000000 div (LongInt(MixRate)*2))
  Else
{$ENDIF}
  WriteDSP(256 - 1000000 div MixRate);
  OpenCard:=1;
END;
{$ENDIF}
{}

Function IsDec(Test: Char): Boolean;
VAR
   T: Byte;
BEGIN
  T:=Ord(Test); If (T>=48) AND (T<=57) then IsDec:=True Else IsDec:=False;
END;

{}

Function IsHex(Test: Char): Boolean;
VAR
   T: Byte;
BEGIN
  T:=Ord(Test);
  If ((T>=48) AND (T<=57 )) OR ((T>=65) AND (T<=70 )) OR
     ((T>=97) AND (T<=102)) then IsHex:=True Else IsHex:=False;
END;

{}

Function CharToHex(Test: Char): Byte;
VAR
  T: Byte;
BEGIN
  T:=Ord(Test);
  If ((T>=48) AND (T<=57 )) then CharToHex:=T-48 Else
  If ((T>=65) AND (T<=70 )) then CharToHex:=T-55 Else
  If ((T>=97) AND (T<=102)) then CharToHex:=T-87 Else T:=255; {not hex}
END;

{}

Procedure IRQ_Test; Interrupt;
VAR
  temp: Byte;
BEGIN
  Asm cli End; temp:=port[DSP_DATA_AVAIL]; MixIRQActive:=True;
  If SBDevice.MIRQ>7 then port[$A0]:=$20;  { IRQ > 7 ? -=> send EOI to slave PIC }
  Port[$20]:=$20;
END;

{============================================================================}

Function HW_Check: Boolean;     { checks if the detected hardware is present }
Const
  BufLen = 100;
VAR
  Result: Boolean;
  tmpBuf: array[0..BufLen-1] of Byte;
  I: Byte;
  temp: Word;
BEGIN
  HW_Check:=False;

{ Check the BasePort: -------------------------------------------------------}
  Result:=ResetDSP; If not Result then Exit;

  WriteDSP($E1); Temp:=Word(ReadDSP) SHL 8; Inc(Temp, ReadDSP);
  SBDevice.SubType:=Temp;
  If SBDevice.SubType<$200 then SBDevice.ID:=SB100Device Else
  If SBDevice.SubType<$201 then SBDevice.ID:=SB200Device Else
  If SBDevice.SubType<$300 then SBDevice.ID:=SB201Device Else
  If SBDevice.SubType<$400 then SBDevice.ID:=SBPRODevice Else
  SBDevice.ID:=SB16Device; {or better}
{  If SBDevice.SubType>Temp then exit;          { SB IS present, but an older one }

{ Check the IRQ/DMA: --------------------------------------------------------}
  GetIntVec($8+SBDevice.MIRQ, Addr(OldSBIRQInterrupt)); { Save old IRQ handler }
  SetIntVec($8+SBDevice.MIRQ, Addr(IRQ_Test));
  For I:=0 to BufLen-1 do tmpBuf[I]:=0;
  irq_Enable(SBDevice.MIRQ);
  MixIRQActive:=False;

{ Set the playback frequency & start transfer: ------------------------------}
  WriteDSP($40); WriteDSP(256 - 1000000 div 20000);
  Playback(@tmpBuf, BufLen); Crt.Delay(50);         { Give a nice long delay }
  HW_Check:=MixIRQActive; MixIRQActive:=False;      { Did I got the IRQ?     }
  irq_Disable(SBDevice.MIRQ);
  setIntVec($8+SBDevice.MIRQ, Addr(OldSBIRQInterrupt));{ Restore old IRQ handler }
END;

{}

Function SBSW_Detect: Boolean;          { Detects All SB-cards via software. }
{
SoundBlaster's Environment Variable format:

  BLASTER=Ax Ip Dq Hr Ms Pt Ty Ez

  x: Primary I/O port. (in hex.)
  p: IRQ channel       (in hex.)
  q: Primary (8-bit) DMA channel
  r: Secondary (16-bit) DMA channel (SB16+ only)
  s: Primary I/O Port of the SB-Mixer (in hex.)
  t: MIDI I/O Port                    (in hex.)
  y: Type of SB card. Possible values:
        1: SoundBlaster 1.x
        2: SoundBlaster PRO 1 (old SB PRO)
        3: SoundBlaster 2.0
        4: SoundBlaster PRO 2, PRO 3 ("new" SB PRO)
        5: SoundBlaster PRO MCV (MicroChannel BUS), same as SB PRO 2
        6: SoundBlaster 16 family.
  z: the 'E' parameter is ONLY needed for SB AWE32 cards. Its default value
     is 620 ("E620").

Ex: BLASTER=A220 I7 D1 T4 (SB PRO 2 at 220h, using DMA channel 1 & IRQ 7)
}

VAR
  tmp, EVS_index: Byte;
  EVS_Field: Char;
  EVS: String;            {Environment string}
  _Base, _Base2, _IRQ1, _IRQ2, _DMA1, _DMA2, I, _Type: Word;
  HWOk, EnvOk: Boolean;
Label TestHW;
BEGIN
  EVS_index:=1; EVS:=GetEnv(SBDevice.MEnvStr);

  If EVS<>'' then
    begin
      EnvOk:=True; SBDevice.SWDetected:=True; {Temporary!!!}
      Repeat
        EVS_Field:=Upcase(EVS[EVS_index]);
        Case EVS_Field of
          'A': Begin
                 If IsDec(EVS[EVS_index+2]) then
                 Begin
                   _Base:=$200+Word(CharToHex(EVS[EVS_index+2]))*$10;
                   SBDevice.MPort:=_Base;
                 End;
                 Inc(EVS_Index, 5);
               End;
          'I': Begin
                 tmp:=Ord(EVS[EVS_index+1]);
                 If (tmp<=Ord('9')) AND (tmp>=Ord('0')) then _IRQ1:=tmp-48
                 Else If (tmp>=Ord('A')) AND (tmp<=Ord('F')) then
                                 _IRQ1:=tmp-55
                      Else If (tmp>=Ord('a')) AND (tmp<=Ord('f')) then
                                 _IRQ1:=tmp-87;
                 SBDevice.MIRQ:=_IRQ1;
                 Inc(EVS_Index, 3);
               End;
          'D': Begin
                 tmp:=Ord(EVS[EVS_index+1]);
                 If (tmp<=Ord('3')) AND (tmp>=Ord('0')) then
                   Begin _DMA1:=tmp-48; SBDevice.MDMA:=_DMA1; End;
                 Inc(EVS_Index, 3);
               End;
          'H': Begin
                 tmp:=Ord(EVS[EVS_index+1]);
                 If (tmp<=Ord('7')) AND (tmp>=Ord('3')) then
                   Begin _DMA2:=tmp-48; SBDevice.SDMA:=_DMA2; End;
                 Inc(EVS_Index, 3);  {are 8-bit DMA channels allowed here?}
               End;
{          'M': Begin // MixerPort, useless
               End;}
          'P': Begin
                 _Base2:=0;
                 If IsHex(EVS[EVS_index+1]) then Inc(_Base2, $100*CharToHex(EVS[EVS_index+1])) Else EnvOk:=False;
                 If IsHex(EVS[EVS_index+2]) then Inc(_Base2,  $10*CharToHex(EVS[EVS_index+2])) Else EnvOk:=False;
                 If IsHex(EVS[EVS_index+3]) then Inc(_Base2,      CharToHex(EVS[EVS_index+3])) Else EnvOk:=False;
                 If EnvOk then SBDevice.SPort:=_Base2;
                 Inc(EVS_Index, 5);
               End;
          'T': Begin
                 _Type:=CharToHex(EVS[EVS_index+1]);
                 Inc(EVS_Index, 3);
               End;
          Else; Begin {unknown, skip}
                  While ((EVS_index<Length(EVS)) AND (EVS[EVS_index]<>' ')) Do Inc(EVS_index);
                  If (EVS[EVS_index]=' ') AND (EVS_index<Length(EVS)) then Inc(EVS_index);
                End;
        End;
      Until EVS_index>=Length(EVS);

      With SBDevice do
      Case _Type of
        1:  Begin SubType:=$100; ID:=SB100Device; End; { SB 1.0              }
        2:  Begin SubType:=$200; ID:=SB200Device; End; { SB PRO 1 (old)      }
        3:  Begin SubType:=$201; ID:=SB201Device; End; { SB 2.0              }
        4:  Begin SubType:=$300; ID:=SBPRODevice; End; { SB PRO 2 or PRO 3   }
        5:  Begin SubType:=$300; ID:=SBPRODevice; End; { Same, with MCV BUS  }
        6:  Begin SubType:=$400; ID:=SB16Device;  End; { SB 16 (ASP)         }
      Else; Begin SubType:=$100; ID:=SB100Device; End; { ? -> SB 1.0 Assumed }
      End;
    end
  Else Begin SBDevice.SWDetected:=False; EnvOk:=False; End;

  If SBDevice.ID=SBPRODevice then
  Begin
    If MixRate<=22050 then StereoReplay:=True;
  End;

{  SBSW_Detect:=HW_Check;}
  SBSW_Detect:=True;
END;

{}
{ Warning: this function may hang the system! }
Function HW_Detect: Boolean;     { Detects SB-compatibel cards via hardware. }
Const
  BufLen = 100;
VAR
  Found, Result: Boolean;
  tmpBuf: array[0..BufLen-1] of Byte;
  I: Word;

{============================================================================}

Function CheckIRQ(IRQNr: Byte): Boolean;
VAR
   Freq: Word;
BEGIN
  SBDevice.MIRQ:=IRQNr; MixIRQActive:=False;
  setIntVec($8+SBDevice.MIRQ, Addr(IRQ_Test));

{ Set the playback frequency & start transfer: ------------------------------}
  WriteDSP($40); WriteDSP(256 - 1000000 div I);
  irq_Enable(SBDevice.MIRQ);
  Playback(@tmpBuf, BufLen); Crt.Delay(50);         { Give a nice long delay }
  CheckIRQ:=MixIRQActive; MixIRQActive:=False;      { Did I got the IRQ?     }
  irq_Disable(SBDevice.MIRQ);
END;

{============================================================================}
Label ExitOK;
BEGIN
  HW_Detect:=False;  SBDevice.HWDetected:=False;

{ Look after the BasePort: --------------------------------------------------}
  I:=0; Found:=False;
  Repeat
    Inc(I); SBDevice.MPort:=$200+I*$10; Found:=ResetDSP;
  Until (I>=8) or Found;
  If not Found then Exit;

{Look after the Version of the card: ----------------------------------------}
  WriteDSP($E1); I:=Word(ReadDSP) SHL 8; Inc(I, ReadDSP); SBDevice.SubType:=I;

  If SBDevice.SubType<$200 then SBDevice.ID:=SB100Device Else
  If SBDevice.SubType<$201 then SBDevice.ID:=SB200Device Else
  If SBDevice.SubType<$300 then SBDevice.ID:=SB201Device Else
  If SBDevice.SubType<$400 then SBDevice.ID:=SBPRODevice Else
  SBDevice.ID:=SB16Device; {or better}

  If SBDevice.ID=SBPRODevice then
  Begin
    If MixRate<=22050 then StereoReplay:=True;
  End;

{Check the IRQ/DMA: ---------------------------------------------------------}
  GetIntVec($8+SBDevice.MIRQ, Addr(OldSBIRQInterrupt));{ Save old IRQ handler }
  For I:=0 to BufLen-1 do tmpBuf[I]:=0;       { Make empty (= silent) buffer }
  If SBDevice.SubType>$201 then I:=45454 Else I:=22000;      { set frequency }

  HW_Detect:=True; SBDevice.HWDetected:=True;
  Found:=CheckIRQ(7); If Found then goto ExitOK;          { IRQ = IRQ nr 7 ? }
  Found:=CheckIRQ(5); If Found then goto ExitOK;          { IRQ = IRQ nr 5 ? }
  Found:=CheckIRQ(3); If Found then goto ExitOK;          { IRQ = IRQ nr 3 ? }
  Found:=CheckIRQ(2); If Found then goto ExitOK;          { IRQ = IRQ nr 2 ? }

  HW_Detect:=False; SBDevice.HWDetected:=False;
ExitOK:
  setIntVec($8+SBDevice.MIRQ, Addr(OldSBIRQInterrupt));{ Restore old IRQ handler }
END;












Function LoadMODSample(var F: File; SampleNr: Byte): Word;
VAR
  Size,
  Size2,
  Alloc : LongInt;
  K,
  Result: Word;
BEGIN
  LoadMODSample:=255;
  Size:=ModInfo.Samples[SampleNr].Length; Size2:=Size;
  If Size2>$FFF0 then Size2:=$FFF0;
  Alloc:=MaxAvail;
  If Alloc<Size2+1 then Begin LoadMODSample:=OutOfMemory; Exit; End;
  GetMem(SamplePointers[SampleNr], Size2+1);

  BlockRead(F, SamplePointers[SampleNr]^, Size2, Result);
  If Result<>Size2 then Begin LoadMODSample:=SampleLoadError; Exit; End;
{Fix mainly for Interpolative mixing routines: ------------------------------}
  If ModInfo.Samples[SampleNr].RepeatSample then
    Begin
      If ModInfo.Samples[SampleNr].RepeatOffset=0 then
          SamplePointers[SampleNr]^[Size2]:=SamplePointers[SampleNr]^[0]
      Else
        If (ModInfo.Samples[SampleNr].RepeatOffset +
            ModInfo.Samples[SampleNr].RepeatLength) =
            ModInfo.Samples[SampleNr].Length then
          SamplePointers[SampleNr]^[Size2]:=
            SamplePointers[SampleNr]^[ModInfo.Samples[SampleNr].RepeatOffset-1];
    End
  Else
    SamplePointers[SampleNr]^[Size2]:=SamplePointers[SampleNr]^[Size2-1];

  If Size>Size2 then
    Begin
      Seek(F, FilePos(F)+Size-Size2);
      ModInfo.Samples[SampleNr].Length:=Size2;
      ModInfo.Samples[SampleNr].RepeatSample:=False;
{      ModInfo.Samples[SampleNr].RepeatLength:=
                                     ModInfo.Samples[SampleNr].Length-
                                     ModInfo.Samples[SampleNr].RepeatOffset;}
    End;
  LoadMODSample:=NoError;
END;


Function SW_Detect: Boolean;
BEGIN
  With SBDevice do
  Begin
    SubType:=$100;                 { Dsp Version 1.00: SoundBlaster 1.0      }
    ID     :=MODType1.SB100Device; { SoundBlaster 1.00 reference nr          }
    Name   :=DeviceNames[ID];
    MEnvStr:='BLASTER';
    SEnvStr:='SOUND';
    MPort  :=$220;                 { Default for Main I/O Port               }
    SPort  :=$330;                 { Default for Secondary I/O Port          }
    MIRQ   :=7;                    { Default for Main IRQ                    }
    SIRQ   :=$FF;                  { Default for Secondary IRQ: unavailable  }
    MDMA   :=1;                    { Default for Main DMA channel            }
    SDMA   :=5;                    { Default for Secondary(16bit)DMA channel }
    HWDetected:=False;             { Card is not detected by Default         }
    SWDetected:=SBSW_Detect;
    SW_Detect:=SWDetected;
  End;
END;

Function CloseCard: Word;
BEGIN
  irq_Disable(SBDevice.MIRQ);         { Disable the IRQ                      }
  SetIntVec($8+SBDevice.MIRQ, @OldSBIRQInterrupt);       { restore interrupt }
  ResetDSP;                           { Reset the DSP                        }
  SetMixerReg(SBResetReg, 0);         { Reset the Mixer Chip                 }

{Restore the old register values: -------------------------------------------}
  SetMixerReg(SBOutPutReg   , OldOutPutMode);
  SetMixerReg(SBVoiceVolReg , OldVoiceVolume);
  SetMixerReg(SBMasterVolReg, OldMasterVolume);
  SpeakerOff;                         { Disconnect speaker (less parasites)  }
  CloseCard:=NoError;
END;

Function StartReplay: Word;
BEGIN
  ResetSong;
  GetIntVec($8+SBDevice.MIRQ, @OldSBIRQInterrupt);
  SetIntVec($8+SBDevice.MIRQ, Addr(IRQProc));
  SBDevice.SetBPM;

{$IFNDEF USE_BP_MIXER}
  If StereoReplay then
    Begin
      If Interpolation then _SbStereo_Mixer_I
      Else _SbStereo_Mixer;
    End
  Else
{$ENDIF}
    Begin
      If Interpolation then _SbMono_Mixer_I
      Else _SbMono_Mixer;
    End;

  irq_Enable(SBDevice.MIRQ);
  Playback(PlayBuffer, MixBufLen);
  Playing:=True;
  StartReplay:=NoError;
END;

Function StopReplay: Word;
BEGIN
  irq_Disable(SBDevice.MIRQ);
  SetIntVec($8+SBDevice.MIRQ, @OldSBIRQInterrupt);
  StopReplay:=NoError;
END;

Function SetBPM: Word;
BEGIN
  CallBpm:=Round(MixRate/(Timing.Bpm*0.4));
  SetBPM:=NoError;
END;

Function VSetMode(Voice, Mode: Byte): Word;
BEGIN
  VSetMode:=NoError;
END;

Function VGetMode(Voice: Byte): Byte;
BEGIN
  VGetMode:=0;
END;

Function VPlay(Voice, Sample: Byte; Offset: Word): Word;
BEGIN
  If (Sample<1) or (Sample>MaxSamples) then exit;
  With MixInfo[Voice] do
  Begin
    RepeatSample:=ModInfo.Samples[Sample].RepeatSample;
    RepeatOffset:=ModInfo.Samples[Sample].RepeatOffset;
    RepeatLength:=ModInfo.Samples[Sample].RepeatLength;
    Length      :=ModInfo.Samples[Sample].Length;
    SampleSeg   :=Seg(SamplePointers[Sample]^);
    SampleOfs   :=Ofs(SamplePointers[Sample]^);
    RealIndex   :=LongInt(Offset) shl 16;
    OnMix       :=True;
  End;
  VPlay:=NoError;
END;

Function VSetPanning(Voice, Panning: Byte): Word;
BEGIN
  With MixInfo[Voice] do
  Begin
    LeftVol :=Byte(Word(Word(255-Panning)*Vol) shr 8);
    RightVol:=Byte(Word(Word(    Panning)*Vol) shr 8);
  End;
  VSetPanning:=NoError;
END;

Function VSetVolume(Voice, Volume: Byte): Word;
BEGIN
  If Volume>64 then Volume:=64;
  With MixInfo[Voice] do
  Begin
    Vol     :=Volume;
    LeftVol :=Byte(Word(Word(255-Channels[Voice].Pan)*Vol) shr 8);
    RightVol:=Byte(Word(Word(    Channels[Voice].Pan)*Vol) shr 8);
  End;

  VSetVolume:=NoError;
END;

Function VSetFrequency(Voice: Byte; Frequency: LongInt): Word;
VAR
  tmp: Word;
BEGIN
  MixInfo[Voice].IncEr:=Frequency;
  VSetFrequency:=NoError;
END;

VAR
  I: Word;
BEGIN
  SW_Detect;
  Addr(SBDevice.LoadMODSample):=Addr(LoadMODSample);
  Addr(SBDevice.HW_Detect    ):=Addr(HW_Detect);
  Addr(SBDevice.OpenCard     ):=Addr(OpenCard);
  Addr(SBDevice.CloseCard    ):=Addr(CloseCard);
  Addr(SBDevice.StartReplay  ):=Addr(StartReplay);
  Addr(SBDevice.StopReplay   ):=Addr(StopReplay);
  Addr(SBDevice.SetBPM       ):=Addr(SetBPM);
  Addr(SBDevice.VSetMode     ):=Addr(VSetMode);
  Addr(SBDevice.VGetMode     ):=Addr(VGetMode);
  Addr(SBDevice.VPlay        ):=Addr(VPlay);
  Addr(SBDevice.VSetPanning  ):=Addr(VSetPanning);
  Addr(SBDevice.VSetVolume   ):=Addr(VSetVolume);
  Addr(SBDevice.VSetFrequency):=Addr(VSetFrequency);
  For I:=1 to MaxSamples do SamplePointers[I]:=Nil;
END.
{$F-}

