{
  These are the MOD replay routines.
  Protected Mode Ready

  Copyright (c) 1998 Erland Van Olmen (erlandvo@hotmail.com)

  Known Bugs:

      - No tremolo fx
      - buggy vibrato fx (too heavy, too discrete..)
      - no glissando control (fx $E3)

  Bugs fixed since version 1.0 (first public release):

      - Fx $9 past sample loop end jump bug (whole note is now ignored)
      - Fixed song repeat a bit
      - Fixed nested pattern loops
      - FX $E6 (pattern loop) and FX $D (pattern break) combination fixed.
        Loop has now precedence over pattern break when on the same row.
        !! Note that FT2 always breaks a pattern when effect $D occurs, no
        matter if a loop has been specified or not. Impulse tracker to the
        contrary works the same as MP.
}

Unit Replay;

interface

Procedure UpDateNotes;
Procedure UpdateMultipleStepsEffects;
Procedure ResetSong;
Procedure SetGlobalPanning(Soften: Byte);


{}
{}

implementation

Uses
  MODType1;

Procedure UpDateTrackEffects; Forward;

Const
{Some Panning constants for the Stereo initialisations: ---------------------}
  DefaultGlobalPanning = $40;
  GlobalPanning: Byte  = DefaultGlobalPanning;
  LeftPan  = 0;
  RightPan = 255;
  InverseChannels: Boolean = False;           { If the channels are inversed }

VAR
  DepackCount: Word;              { Needed for real-time pattern depacking   }
{VAR's for the replay procedures: -------------------------------------------}
{  LoopInfo   : Record                              { for pattern loop effect }
{               End;}
  TrackInfo  : Record
                 Pattern,                            { Actual pattern        }
                 Line,                               { Actual Line           }
                 Track     : Byte;                   { Actual Track position }
               End;


{}
{}

Procedure SetPtnOfs(Ptn, Line: Byte);
VAR
  NCnt, Note: Byte;
BEGIN
  DepackCount:=0; TrackInfo.line:=0;
  If (Line = 0) or (Line>63) then exit;
  While (TrackInfo.line < Line) do
  begin
    For NCnt:=1 to ModInfo.NrChannels do
    Begin
      Note:=Patterns[Ptn]^[DepackCount]; Inc(DepackCount);
      If (Note and $80)<>0 then Inc(DepackCount, 2);
      If (Note and $40)<>0 then Inc(DepackCount);
    End;
    Inc(TrackInfo.Line);
  End;
END;

{}

Procedure ResetSong;
VAR
  Chn,
  I   : Byte;
BEGIN
  DepackCount:=0;
  With Timing do Begin Count:=0; Speed:=6; BPM:=125; End;
  PlayDevice.SetBPM;
  With TrackInfo do
           Begin Line:=0; Track:=0; Pattern:=ModInfo.PatternTable[Track]; End;

  For Chn:=1 to ModInfo.NrChannels do
    With Channels[Chn] do
    Begin
      Muted          :=False;
      Replay         :=False;
      Period         :=0;
      Instr          :=0;
      Note           :=0;
      Vol            :=0;
{Needed for the effect engine: ----------------------------------------------}
      Effect         :=0;
      EffectArg      :=0;
      LastEffect     :=0;
      LastEffectArg  :=0;
      SmpOffset      :=0;
      ArpeggioCount  :=0;
      arp1           :=0;
      arp2           :=0;
      DestPeriod     :=0;
      LastSlideRate  :=0;
      Glissando      :=False;
      VibratoCount   :=0;
      VibratoWave    :=0;
      LastVibrato    :=0;
      TremoloCount   :=0;
      TremoloWave    :=0;
      LastTremolo    :=0;
      DelayCount     :=0;
      RetrigCount    :=0;
    End;
{ Reset finetunes }
  For I:=1 to ModInfo.MaxSamples do with ModInfo.Samples[I] do
                                                        Finetune:=OldFinetune;
  For Chn:=0 to 7 do
  begin
    Channels[Chn shl 2+1].pan:=LeftPan;
    Channels[Chn shl 2+2].pan:=RightPan;
    Channels[Chn shl 2+3].pan:=RightPan;
    Channels[Chn shl 2+4].pan:=LeftPan;
  end;
END;

{}

Procedure SetGlobalPanning(Soften: Byte);
BEGIN
  If Soften>127 then InverseChannels:=True Else InverseChannels:=False;
  GlobalPanning:=Soften;
END;

{}

Procedure SetBalances;
VAR
  Chn,
  Temp,
  FPan: Byte;
BEGIN
  If InverseChannels then
    Begin
      Temp:=255-GlobalPanning;
      For Chn:=1 to ModInfo.NrChannels do
        Begin
          FPan:=(Channels[Chn].Pan*(255-2*Temp)) div 255+Temp;
          PlayDevice.VSetPanning(chn, 255-FPan);
        End;
    End
  Else
    Begin
      Temp:=GlobalPanning;
      For Chn:=1 to ModInfo.NrChannels do
        Begin
          FPan:=(Channels[Chn].Pan*(255-2*Temp)) div 255+Temp;
          PlayDevice.VSetPanning(chn, FPan);
        End;
    End;
END;

{}

Procedure RepeatSong;
VAR
  Chn: Byte;
BEGIN
  DepackCount:=0;
  If ModInfo.CustomRepeat then
    With TrackInfo do
    Begin
      Line   :=0;
      Track  :=ModInfo.RestartPosition;
      Pattern:=ModInfo.PatternTable[Track];
    End
  Else
    Begin
      With TrackInfo do
      Begin
        Line   :=0;
        Track  :=0;
        Pattern:=ModInfo.PatternTable[Track];
        With PlayDevice do For Chn:=1 to ModInfo.NrChannels do
                       Begin VSetFrequency(Chn, 0); VSetVolume(Chn, 0); End;
      End;

      With Timing do
      Begin
        If Speed<=6 then Count:=6-Speed Else Inc(PatternDelay, Speed);
        Speed:=6; BPM:=125;
      End;
      PlayDevice.SetBPM;

      For Chn:=1 to ModInfo.NrChannels do
      With Channels[Chn] do
      Begin
        Period         :=0;
        Instr          :=0;
        Note           :=0;
{        Vol            :=0;}
{Needed for the effect engine: ----------------------------------------------}
        Effect         :=0;
        EffectArg      :=0;
        LastEffect     :=0;
        LastEffectArg  :=0;
        SmpOffset      :=0;
        ArpeggioCount  :=0;
        arp1           :=0;
        arp2           :=0;
        DestPeriod     :=0;
        LastSlideRate  :=0;
        Glissando      :=False;
        VibratoCount   :=0;
        VibratoWave    :=0;
        LastVibrato    :=0;
        TremoloCount   :=0;
        TremoloWave    :=0;
        LastTremolo    :=0;
        DelayCount     :=0;
        RetrigCount    :=0;
      End;
{ Reset finetunes }
      For chn:=1 to ModInfo.MaxSamples do with ModInfo.Samples[chn] do
                                                        Finetune:=OldFinetune;
      For Chn:=0 to 7 do
      Begin
        Channels[Chn shl 2+1].pan:=LeftPan;
        Channels[Chn shl 2+2].pan:=RightPan;
        Channels[Chn shl 2+3].pan:=RightPan;
        Channels[Chn shl 2+4].pan:=LeftPan;
      End;
    End;
END;

{}

Procedure UpDateNotes;
VAR
   Chn      : Byte;
   dummy    : Word;
   HoldLine : Boolean;
   TempData : Record
                Note,
                Inst    : Byte;
                NewInst,
                NewNote,
                InstOk,
                NoteOk  : Boolean;
              End;
BEGIN
  HoldLine:=False;
  With PatternInfo do
  Begin
    Line:=TrackInfo.line; Track:=TrackInfo.Track; Pattern:=TrackInfo.Pattern;
    PatternData:=Patterns[Pattern];
  End;

  For Chn:=1 to ModInfo.NrChannels do
  With Channels[Chn] do
  Begin
    UpdateLine:=True;
    With TempData do
    Begin
      NewInst:=False; NewNote:=False; InstOk:=False; NoteOk:=False;
    End;
{First depack note info: ----------------------------------------------------}
    TempData.Note:=Patterns[TrackInfo.Pattern]^[DepackCount]; Inc(DepackCount);

    LastEffect:=Effect; LastEffectArg:=EffectArg;
    If (TempData.Note and $80)<>0 then
      begin
        Effect   :=Patterns[TrackInfo.Pattern]^[DepackCount]; Inc(DepackCount);
        EffectArg:=Patterns[TrackInfo.Pattern]^[DepackCount]; Inc(DepackCount);
      end
    Else begin Effect:=0; EffectArg:=0; end;

    If (LastEffect=$10) and (Effect<>$10) then Period:=ArpeggioPeriod;

    If (TempData.Note and $40)<>0 then
      begin
        TempData.Inst    :=Patterns[TrackInfo.Pattern]^[DepackCount]; Inc(DepackCount);
        if TempData.Inst<>instr then TempData.NewInst:=True; instr:=TempData.Inst;
        If (Instr>0) and (Instr<=ModInfo.MaxSamples) then TempData.InstOk:=True;
        If not TempData.InstOk then TempData.NewInst:=False; {???}
        PatternInfo.ActLine[Chn].Sample:=instr;
        SmpOffset:=0;
        Vol      :=ModInfo.Samples[Instr].Volume;
      end
    Else
      Begin
        PatternInfo.ActLine[Chn].Sample:=0;
        TempData.Inst:=0;
        If (Instr>0) and (Instr<=ModInfo.MaxSamples) then TempData.InstOk:=True;
      End;

    TempData.Note:=TempData.Note and $3F;

    If (VibratoWave and 4) = 0 then VibratoCount:=0;
{Make pattern data available to the main program: ---------------------------}
    PatternInfo.ActLine[Chn].Note:=TempData.Note;
    If (Effect shr 4)=$E then
      Begin
        PatternInfo.ActLine[Chn].Effect:=Effect shr 4;
        PatternInfo.ActLine[Chn].EffectArg:=Effect shl 4 + EffectArg;
      End
    Else
      Begin
        PatternInfo.ActLine[Chn].Effect:=Effect;
        PatternInfo.ActLine[Chn].EffectArg:=EffectArg;
      End;

    If Effect=$ED then DelayFlag:=True Else DelayFlag:=False;

    If (TempData.Note>=1) and (TempData.Note<=60) then
      begin
        TempData.NewNote:=True; TempData.NoteOk:=True;
{for the $3 & $5 effects: ---------------------------------------------------}
        DestPeriod:=PeriodTable[ModInfo.Samples[Instr].FineTune, TempData.Note];
        If (Effect<>$3) and (Effect<>$5) then
                                   begin Note:=TempData.Note; Period:=DestPeriod; end;
      end
    Else If (Note>=1) and (Note<=60) then TempData.NoteOk:=True;

    Replay:=False;
    If TempData.NewNote and TempData.NoteOk then
    Begin
      If TempData.InstOk then Replay:=True;
      if ((Effect=$3) or (Effect=$5)) and (not TempData.NewInst) then Replay:=FALSE;
    End;

{UPDATE EFFECTS (IMMEDIATE EFFECTS) -----------------------------------------}
    Case Effect of
{ARPEGGIO: ------------------------------------------------------------------}
      $10: If EffectArg<>0 then
          begin
            Arp1:=EffectArg shr 4; Arp2:=EffectArg and $F; ArpeggioCount:=0;
            If LastEffect<>$10 then ArpeggioPeriod:=Period;
          end;
{TONE PORTAMENTO: -----------------------------------------------------------}
      $3: If EffectArg<>0 then LastSlideRate:=EffectArg;
{VIBRATO: -------------------------------------------------------------------}
      $4: Begin
            If (EffectArg and $F) = 0 then EffectArg:=EffectArg or (LastVibrato and $F);
            If (EffectArg shr 4 ) = 0 then EffectArg:=EffectArg or (LastVibrato and $F0);
            LastVibrato:=EffectArg;
          End;
{TREMOLO: -------------------------------------------------------------------}
      $7: Begin
            If (EffectArg and $F) = 0 then EffectArg:=EffectArg or (LastTremolo and $F);
            If (EffectArg shr 4 ) = 0 then EffectArg:=EffectArg or (LastTremolo and $F0);
            LastTremolo:=EffectArg;
          End;
{SET FINE PANNING: ----------------------------------------------------------}
      $8: Pan:=EffectArg;
{SET SAMPLE OFFSET: ( No checking, is done in loader! ) ---------------------}
      $9: If (Word(EffectArg) shl 8)<ModInfo.Samples[Instr].Length then
                                              SmpOffset:=Word(EffectArg) shl 8
          Else Replay:=False;
{POSITION JUMP: -------------------------------------------------------------}
      $B,
{PATTERN BREAK: -------------------------------------------------------------}
      $D: UpDateLine:=False;
{SET VOLUME: ----------------------------------------------------------------}
      $C: Vol:=EffectArg; { No checking, is done in loader! }

{EXTENDED EFFECTS: ==========================================================}
{FINE SLIDE UP: -------------------------------------------------------------}
      $E1: If Period>EffectArg+MinPeriod then Dec(Period, EffectArg)
           Else Period:=MinPeriod;
{FINE SLIDE DOWN: -----------------------------------------------------------}
      $E2: If Period+EffectArg<MaxPeriod then Inc(Period, EffectArg)
           Else Period:=MaxPeriod;
{SET GLISSANDO CONTROL: -----------------------------------------------------
      $E3: Glissando  :=Boolean(EffectArg);
{SET VIBRATO WAVEFORM: ------------------------------------------------------}
      $E4: VibratoWave:=EffectArg;
{SET FINETUNE: --------------------------------------------------------------}
      $E5: begin
{             ModInfo.Samples[Instr].FineTune:=EffectArg;  {?}
             Period:=PeriodTable[EffectArg, Note];
           end;
{SET TREMOLO WAVEFORM: ------------------------------------------------------}
      $E7: TremoloWave:=EffectArg;
{SET ROUGH PANNING: ---------------------------------------------------------}
      $E8: Pan:=EffectArg shl 4;
{SAMPLE RETRIG: -------------------------------------------------------------}
      $E9: If EffectArg>0 then RetrigCount:=EffectArg Else Effect:=0;
{FINE VOLUME SLIDE UP: ------------------------------------------------------}
      $EA: Begin Inc(Vol, EffectArg); If Vol>64 then Vol:=64; end;
{FINE VOLUME SLIDE DOWN: ----------------------------------------------------}
      $EB: If Vol>=EffectArg then dec(Vol, EffectArg) Else Vol:=0;
{SAMPLE CUT: ----------------------------------------------------------------}
      $EC: If EffectArg = 0 then vol:=0;
{SAMPLE DELAY: --------------------------------------------------------------}
      $ED: DelayCount:=EffectArg;
    end;

    With PlayDevice do
    Begin
      If Not DelayFlag then
      Begin
        If (Effect<>$3) and (Effect<>$5) and (Period<>0) then
                                        VSetFrequency(Chn, FreqTable[Period]);
        If Replay then VPlay(Chn, Instr, SmpOffset);
        If Muted  then VSetVolume(Chn, 0) Else VSetVolume(Chn, Vol);
      End;
    End;
    SmpOffset:=0;
    If Not UpdateLine then HoldLine:=True;
  End;

  SetBalances;
  UpDateTrackEffects;

{  For chn:=1 to ModInfo.NrChannels do
   If Not Channels[Chn].UpdateLine then HoldLine:=True;}
{UpDate Track Position: -----------------------------------------------------}
  If Not HoldLine then With TrackInfo do
    Begin
      If Line>=63 then
        Begin
          For chn:=1 to ModInfo.NrChannels do Channels[Chn].LoopStartLine:=0;
          If Track>=ModInfo.SongLength-1 then RepeatSong Else Inc(Track);
          DepackCount:=0; Line:=0; Pattern:=ModInfo.PatternTable[Track];
        End
      Else Inc(Line);
    End;
  WaitState:=True;
END;

{}

Procedure UpDateTrackEffects;
VAR
  Temp,
  Chn             : Byte;
  HoldLine,
  PtnBreak_Occured: Boolean;
BEGIN
  PtnBreak_Occured:=False; HoldLine:=False;
  For Chn:=1 to ModInfo.NrChannels do
                                  If Channels[Chn].Looping then HoldLine:=True;
  For Chn:=1 to ModInfo.NrChannels do
  With Channels[Chn] do
  Begin
    Case Effect of
{POSITION JUMP: -------------------------------------------------------------}
      $B: begin
            PtnBreak_Occured:=true;
            If EffectArg<ModInfo.SongLength then
              begin
                TrackInfo.Track  :=EffectArg;
                TrackInfo.Pattern:=ModInfo.PatternTable[TrackInfo.Track];
                TrackInfo.Line   :=0;
                DepackCount:=0;
              end
            else RepeatSong;
          end;
{PATTERN BREAK: -------------------------------------------------------------}
      $D: If (Not PtnBreak_Occured) And (Not HoldLine) then
          begin
            PtnBreak_Occured:=true;
            If TrackInfo.Track<ModInfo.SongLength-1 then
              begin
                Inc(TrackInfo.Track);
                TrackInfo.Pattern:=ModInfo.PatternTable[TrackInfo.Track];
                DepackCount:=0;
                SetPtnOfs(TrackInfo.pattern, (EffectArg shr 4) * 10 + EffectArg AND $F);
              end
            Else Begin RepeatSong; SetPtnOfs(TrackInfo.pattern, Temp); End;
          end;
{PATTERN LOOP: --------------------------------------------------------------}
      $E6: If EffectArg = 0 then
             begin If not Looping then LoopStartLine:=TrackInfo.line end
           Else
             begin
               If Looping then
                 begin
                   If LoopCounter = 0 then
                               Begin Looping:=False; LoopStartLine:=255; end
                   Else
                     begin
                       UpdateLine:=false; Dec(LoopCounter);
                       SetPtnOfs(TrackInfo.Pattern, LoopStartLine);
                     end;
                 end
               Else
                 If LoopStartLine<>255 then
                 begin
                   UpDateLine:=False; Looping:=true;
                   LoopCounter:=EffectArg-1;
                   SetPtnOfs(TrackInfo.Pattern, LoopStartLine);
                 end;
             end;
{PATTERN DELAY: -------------------------------------------------------------}
      $EE: If EffectArg>0 then Timing.PatternDelay:=Word(EffectArg+1)*Timing.Speed;
{SET SPEED / SET BPM: -------------------------------------------------------}
      $F: If EffectArg<$20 then
               begin If EffectArg>0 then Timing.Speed:=EffectArg; end
          Else If Timing.VBlank then Timing.Speed:=EffectArg
               Else begin Timing.Bpm:=EffectArg; PlayDevice.SetBPM; end;
    end;
  end;
END;

{}

Procedure UpdateMultipleStepsEffects;
VAR
  Chn,
  dummy     : Byte;
  Diff1,             { for tone portamento, if glissando = true }
  Diff2,
  TempPeriod: Word;
  S         : LongInt;

BEGIN
  For Chn:=1 to ModInfo.NrChannels do
  With Channels[Chn] do
  Begin
    Case Effect of
{VOLUME SLIDE: --------------------------------------------------------------}
      $5,
      $6,
      $A: begin
            dummy:=EffectArg shr 4;
            If dummy<>0 then
              Begin
                Inc(Vol, dummy);
                If Vol>64 then Vol:=64;
              end
            Else
              begin
                dummy:=EffectArg and $F;
                If Vol>dummy then Dec(Vol, dummy)
                Else Vol:=0;
              end;
          end;
    end;

    Case Effect of
{ARPEGGIO: ------------------------------------------------------------------}
     $10: begin
            case (ArpeggioCount mod 3) of
              0: Period:=PeriodTable[ModInfo.Samples[Instr].FineTune, Note];
              1: Period:=PeriodTable[ModInfo.Samples[Instr].FineTune, Note+arp1];
              2: Period:=PeriodTable[ModInfo.Samples[Instr].FineTune, Note+arp2];
            end;
            Inc(ArpeggioCount);
          end;
{PITCH SLIDE UP: ------------------------------------------------------------}
      $1: begin
            If Period>EffectArg then Dec(Period, EffectArg)
            else Period:=MinPeriod;
            If Period<MinPeriod then Period:=MinPeriod;
          end;
{PITCH SLIDE DOWN: ----------------------------------------------------------}
      $2: begin
            Inc(Period, EffectArg);
            If Period>MaxPeriod then Period:=MaxPeriod;
          end;
{TONE PORTAMENTO: -----------------------------------------------------------}
      $3,
      $5: If Glissando then
            Begin
              If Period<DestPeriod then
                Begin
                  Inc(Period, LastSlideRate);
                  If Period>DestPeriod then Period:=DestPeriod;
                  TempPeriod:=Period;
                  If TempPeriod<>DestPeriod then
                  Begin
                    Dummy:=1;
                    While (Period<=PeriodTable[ModInfo.Samples[instr].Finetune,
                                         Dummy]) and (Dummy<60) do Inc(Dummy);
                    If Dummy>1 then
                         Diff1:=Period-PeriodTable[ModInfo.Samples[instr].Finetune, Dummy-1]
                    Else Diff1:=Period-MinPeriod;
                    Diff2:=PeriodTable[ModInfo.Samples[instr].Finetune, Dummy] - Period;
                    If Diff2>Diff1 then TempPeriod:=Period-Diff1
                    Else                TempPeriod:=Period+Diff2;
                  End;
                end
              Else If Period>DestPeriod then
                begin
                  If Period<LastSlideRate then Period:=DestPeriod
                  Else Dec(Period, LastSlideRate);
                  If Period<DestPeriod then Period:=DestPeriod;
                  TempPeriod:=Period;
                  If TempPeriod<>DestPeriod then
                  Begin
                    Dummy:=1;
                    While (Period<=PeriodTable[ModInfo.Samples[instr].Finetune,
                                         Dummy]) and (Dummy<60) do Inc(Dummy);
                    If Dummy>1 then
                         Diff1:=Period-PeriodTable[ModInfo.Samples[instr].Finetune, Dummy-1]
                    Else Diff1:=Period-MinPeriod;
                    Diff2:=PeriodTable[ModInfo.Samples[instr].Finetune, Dummy] - Period;
                    If Diff2>Diff1  then TempPeriod:=Period+Diff2
                    Else                 TempPeriod:=Period-Diff1;
                  End;
                end;
              PlayDevice.VsetFrequency(chn, FreqTable[TempPeriod]);
            End
          Else
            Begin
              If Period<DestPeriod then
                Begin
                  Inc(Period, LastSlideRate);
                  If Period>DestPeriod then Period:=DestPeriod;
                end
              Else If Period>DestPeriod then
                begin
                  If Period<LastSlideRate then Period:=DestPeriod
                  Else Dec(Period, LastSlideRate);
                  If Period<DestPeriod then Period:=DestPeriod;
                end;
              PlayDevice.VsetFrequency(chn, FreqTable[Period]);
            End;
{VIBRATO: -------------------------------------------------------------------}
      $4,
      $6: Begin
            s:=LongInt(VibratoTable[VibratoWave, VibratoCount]);
            Dummy:=LastVibrato and $F;
{            Dummy:=(LongInt(Dummy)*Period*5) div 800;}
            s:=(s * Dummy) div 130;
            TempPeriod:=Period+s;
            if TempPeriod>MaxPeriod then TempPeriod:=MaxPeriod;
            if TempPeriod<MinPeriod then TempPeriod:=MinPeriod;
            Inc(VibratoCount, (LastVibrato shr 4)*4);
{            if VibratoCount > 255 then Dec(VibratoCount, 255);}
            PlayDevice.VSetFrequency(chn, FreqTable[TempPeriod]);
          End;

{EXTENDED EFFECTS: ==========================================================}
{RETRIG SAMPLE: -------------------------------------------------------------}
     $E9: begin
            Inc(RetrigCount);
            If (RetrigCount mod EffectArg) = 0 then PlayDevice.VPlay(Chn, instr, 0);
          End;
{SAMPLE CUT: ----------------------------------------------------------------}
     $EC: If Timing.Count>EffectArg then vol:=0;
{SAMPLE DELAY: --------------------------------------------------------------}
     $ED: begin
            If DelayCount=Timing.Count then
            Begin
              DelayFlag:=False;
              If Replay then PlayDevice.VPlay(Chn, Instr, 0);
            End;
          end;
    End;

    With PlayDevice do
    Begin
      If Not DelayFlag then
      Begin
        If (Effect<>$3) and (Effect<>$5) and
           (Effect<>$4) and (Effect<>$6) and (Period<>0) then
                                        VSetFrequency(Chn, FreqTable[Period]);
        If not Muted then VSetVolume(Chn, Vol)
        Else              VSetVolume(Chn, 0);
      End;
    End;
  end;
{PATTERN DELAY: -------------------------------------------------------------}
  If Timing.PatternDelay>0 then Dec(Timing.PatternDelay);
  SetBalances;
END;

{}
{}

BEGIN
  DepackCount:=0;
END.
