;     Ŀ
;        Sound Deluxe System 5, a Maple Leaf production               
;        1996-1997                                                    
;           
;        general use tables                                           
;           
;        This is the biggest part of the SDS object file              
;     


;
;  Default vibrato table (overwritten by efx S3x/S4x)
;  size: 64 bytes
;

VibratoTable     db       000h,00Ch,019h,025h,031h,03Ch,047h,051h,05Ah,063h,06Ah,071h,076h,07Ah,07Dh,07Eh,07Eh,07Eh,07Bh,078h
                 db       073h,06Dh,067h,05Fh,056h,04Ch,042h,037h,02Bh,01Fh,012h,006h,0FAh,0EEh,0E1h,0D5h,0C9h,0BEh,0B4h,0AAh
                 db       0A1h,099h,093h,08Dh,088h,085h,082h,082h,082h,083h,086h,08Ah,08Fh,096h,09Dh,0A6h,0AFh,0B9h,0C4h,0CFh
                 db       0DBh,0E7h,0F4h,000h

;
;  Vibrato/Tremolo waveforms (used by efx S3x/S4x)
;  size: 4x64=256 bytes
; (added: 28th May 1996)
;


WaveForms        db       000h,00Ch,019h,025h,031h,03Ch,047h,051h,05Ah,063h,06Ah,071h,076h,07Ah,07Dh,07Eh,07Eh,07Eh,07Bh,078h
                 db       073h,06Dh,067h,05Fh,056h,04Ch,042h,037h,02Bh,01Fh,012h,006h,0FAh,0EEh,0E1h,0D5h,0C9h,0BEh,0B4h,0AAh
                 db       0A1h,099h,093h,08Dh,088h,085h,082h,082h,082h,083h,086h,08Ah,08Fh,096h,09Dh,0A6h,0AFh,0B9h,0C4h,0CFh
                 db       0DBh,0E7h,0F4h,000h   ; 0 = normal sine  /\/


                 db       07Fh,07Bh,077h,073h,06Fh,06Bh,067h,063h,05Fh,05Bh,057h,053h,04Fh,04Bh,047h,043h,03Fh,03Bh,037h,033h
                 db       02Fh,02Bh,027h,023h,01Fh,01Bh,017h,013h,00Fh,00Bh,007h,003h,0FFh,0FBh,0F7h,0F3h,0EFh,0EBh,0E7h,0E3h
                 db       0DFh,0DBh,0D7h,0D3h,0CFh,0CBh,0C7h,0C3h,0BFh,0BBh,0B7h,0B3h,0AFh,0ABh,0A7h,0A3h,09Fh,09Bh,097h,093h
                 db       08Fh,08Bh,087h,083h   ; 1 = ramp down  \|\|\

                 db       07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh
                 db       07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,080h,080h,080h,080h,080h,080h,080h,080h
                 db       080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h
                 db       080h,080h,080h,080h   ; 2 = square wave |~|_|~|_

; For type 3, some players use a "ramp up" waveform, others (ex. ST3) use
; a real random one. Choose one of these two and comment the other.

;                db       081h,085h,089h,08Dh,091h,095h,099h,09Dh,0A1h,0A5h,0A9h,0ADh,0B1h,0B5h,0B9h,0BDh,0C1h,0C5h,0C9h,0CDh
;                db       0D1h,0D5h,0D9h,0DDh,0E1h,0E5h,0E9h,0EDh,0F1h,0F5h,0F9h,0FDh,001h,005h,009h,00Dh,011h,015h,019h,01Dh
;                db       021h,025h,029h,02Dh,031h,035h,039h,03Dh,041h,045h,049h,04Dh,051h,055h,059h,05Dh,061h,065h,069h,06Dh
;                db       071h,075h,079h,07Dh   ; 3 = random(?) = (here) ramp up /|/|/

                 db       080h,088h,05Ch,0B3h,0C5h,02Bh,0D1h,0A9h,0DFh,0ECh,094h,0F9h,092h,057h,08Fh,0CBh,06Ah,0DEh,046h,0D3h
                 db       032h,058h,037h,0CEh,0A9h,0D4h,0F7h,0BFh,053h,0C7h,0FBh,0A6h,05Fh,0C9h,045h,079h,0FEh,063h,053h,085h
                 db       0A4h,0A4h,000h,085h,017h,082h,046h,026h,045h,035h,00Eh,0B4h,02Eh,017h,074h,024h,07Fh,0BEh,02Dh,0CBh
                 db       095h,045h,0FEh,061h   ; 3 = random (ST3 compatib.)

;
;  Volumes table
;  size: 16 KB
;

VolTab   db       080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h
         db       080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h
         db       080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h
         db       080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h
         db       080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h
         db       080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h
         db       080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h
         db       080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h
         db       080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h
         db       080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h
         db       080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h
         db       080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h
         db       080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h
         db       080h,080h,080h,080h,080h,080h,080h,081h,081h,081h,081h,081h,081h,081h,081h,081h,081h,081h,081h,081h
         db       081h,081h,081h,081h,081h,081h,081h,082h,082h,082h,082h,082h,082h,082h,082h,082h,082h,082h,082h,082h
         db       082h,082h,082h,082h,082h,082h,082h,083h,083h,083h,083h,083h,083h,083h,083h,083h,083h,083h,083h,083h
         db       083h,083h,083h,083h,083h,083h,083h,083h,084h,084h,084h,084h,084h,084h,084h,084h,084h,084h,084h,084h
         db       084h,084h,084h,084h,084h,084h,084h,084h,085h,085h,085h,085h,085h,085h,085h,085h,085h,085h,085h,085h
         db       085h,085h,085h,085h,085h,085h,085h,085h,086h,086h,086h,086h,086h,086h,086h,086h,086h,086h,086h,086h
         db       086h,086h,086h,086h,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah
         db       07Ah,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh
         db       07Bh,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch
         db       07Ch,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh
         db       07Dh,07Dh,07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,07Eh
         db       07Eh,07Eh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh
         db       07Fh,07Fh,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h
         db       081h,081h,081h,081h,081h,081h,081h,081h,081h,081h,081h,081h,081h,081h,082h,082h,082h,082h,082h,082h
         db       082h,082h,082h,082h,082h,082h,082h,082h,083h,083h,083h,083h,083h,083h,083h,083h,083h,083h,083h,083h
         db       083h,083h,083h,084h,084h,084h,084h,084h,084h,084h,084h,084h,084h,084h,084h,084h,084h,085h,085h,085h
         db       085h,085h,085h,085h,085h,085h,085h,085h,085h,085h,085h,086h,086h,086h,086h,086h,086h,086h,086h,086h
         db       086h,086h,086h,086h,086h,087h,087h,087h,087h,087h,087h,087h,087h,087h,087h,087h,087h,087h,087h,087h
         db       088h,088h,088h,088h,088h,088h,088h,088h,088h,088h,088h,088h,088h,088h,089h,089h,089h,089h,089h,089h
         db       077h,077h,077h,077h,077h,077h,077h,078h,078h,078h,078h,078h,078h,078h,078h,078h,078h,078h,078h,078h
         db       078h,079h,079h,079h,079h,079h,079h,079h,079h,079h,079h,079h,079h,079h,079h,079h,07Ah,07Ah,07Ah,07Ah
         db       07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh
         db       07Bh,07Bh,07Bh,07Bh,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Dh,07Dh
         db       07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,07Eh
         db       07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh
         db       07Fh,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,080h,081h,081h,081h,081h,081h,081h
         db       081h,081h,081h,081h,081h,082h,082h,082h,082h,082h,082h,082h,082h,082h,082h,082h,083h,083h,083h,083h
         db       083h,083h,083h,083h,083h,083h,083h,084h,084h,084h,084h,084h,084h,084h,084h,084h,084h,084h,084h,085h
         db       085h,085h,085h,085h,085h,085h,085h,085h,085h,085h,086h,086h,086h,086h,086h,086h,086h,086h,086h,086h
         db       086h,087h,087h,087h,087h,087h,087h,087h,087h,087h,087h,087h,088h,088h,088h,088h,088h,088h,088h,088h
         db       088h,088h,088h,089h,089h,089h,089h,089h,089h,089h,089h,089h,089h,089h,08Ah,08Ah,08Ah,08Ah,08Ah,08Ah
         db       08Ah,08Ah,08Ah,08Ah,08Ah,08Bh,08Bh,08Bh,08Bh,08Bh,08Bh,08Bh,08Bh,08Bh,08Bh,08Bh,075h,075h,075h,075h
         db       075h,075h,075h,075h,075h,075h,075h,075h,076h,076h,076h,076h,076h,076h,076h,076h,076h,076h,076h,077h
         db       077h,077h,077h,077h,077h,077h,077h,077h,077h,077h,078h,078h,078h,078h,078h,078h,078h,078h,078h,078h
         db       078h,079h,079h,079h,079h,079h,079h,079h,079h,079h,079h,079h,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah
         db       07Ah,07Ah,07Ah,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch
         db       07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Eh,07Eh,07Eh
         db       07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,080h
         db       080h,080h,080h,080h,080h,080h,080h,080h,080h,081h,081h,081h,081h,081h,081h,081h,081h,081h,082h,082h
         db       082h,082h,082h,082h,082h,082h,082h,083h,083h,083h,083h,083h,083h,083h,083h,083h,084h,084h,084h,084h
         db       084h,084h,084h,084h,084h,084h,085h,085h,085h,085h,085h,085h,085h,085h,085h,086h,086h,086h,086h,086h
         db       086h,086h,086h,086h,087h,087h,087h,087h,087h,087h,087h,087h,087h,088h,088h,088h,088h,088h,088h,088h
         db       088h,088h,089h,089h,089h,089h,089h,089h,089h,089h,089h,08Ah,08Ah,08Ah,08Ah,08Ah,08Ah,08Ah,08Ah,08Ah
         db       08Bh,08Bh,08Bh,08Bh,08Bh,08Bh,08Bh,08Bh,08Bh,08Ch,08Ch,08Ch,08Ch,08Ch,08Ch,08Ch,08Ch,08Ch,08Dh,08Dh
         db       08Dh,08Dh,08Dh,08Dh,08Dh,08Dh,08Dh,08Dh,08Eh,08Eh,08Eh,08Eh,072h,072h,072h,072h,072h,073h,073h,073h
         db       073h,073h,073h,073h,073h,073h,073h,074h,074h,074h,074h,074h,074h,074h,074h,074h,075h,075h,075h,075h
         db       075h,075h,075h,075h,075h,076h,076h,076h,076h,076h,076h,076h,076h,076h,077h,077h,077h,077h,077h,077h
         db       077h,077h,077h,078h,078h,078h,078h,078h,078h,078h,078h,078h,079h,079h,079h,079h,079h,079h,079h,079h
         db       079h,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Ch
         db       07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Eh,07Eh
         db       07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,080h,080h,080h,080h
         db       080h,080h,080h,080h,081h,081h,081h,081h,081h,081h,081h,081h,082h,082h,082h,082h,082h,082h,082h,082h
         db       083h,083h,083h,083h,083h,083h,083h,083h,084h,084h,084h,084h,084h,084h,084h,084h,085h,085h,085h,085h
         db       085h,085h,085h,085h,086h,086h,086h,086h,086h,086h,086h,087h,087h,087h,087h,087h,087h,087h,087h,088h
         db       088h,088h,088h,088h,088h,088h,088h,089h,089h,089h,089h,089h,089h,089h,089h,08Ah,08Ah,08Ah,08Ah,08Ah
         db       08Ah,08Ah,08Ah,08Bh,08Bh,08Bh,08Bh,08Bh,08Bh,08Bh,08Bh,08Ch,08Ch,08Ch,08Ch,08Ch,08Ch,08Ch,08Ch,08Dh
         db       08Dh,08Dh,08Dh,08Dh,08Dh,08Dh,08Eh,08Eh,08Eh,08Eh,08Eh,08Eh,08Eh,08Eh,08Fh,08Fh,08Fh,08Fh,08Fh,08Fh
         db       08Fh,08Fh,090h,090h,090h,090h,090h,090h,070h,070h,070h,070h,070h,070h,070h,071h,071h,071h,071h,071h
         db       071h,071h,071h,072h,072h,072h,072h,072h,072h,072h,072h,073h,073h,073h,073h,073h,073h,073h,074h,074h
         db       074h,074h,074h,074h,074h,074h,075h,075h,075h,075h,075h,075h,075h,075h,076h,076h,076h,076h,076h,076h
         db       076h,076h,077h,077h,077h,077h,077h,077h,077h,077h,078h,078h,078h,078h,078h,078h,078h,078h,079h,079h
         db       079h,079h,079h,079h,079h,079h,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh
         db       07Bh,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Eh,07Eh,07Eh
         db       07Eh,07Eh,07Eh,07Eh,07Eh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,080h,080h,080h,080h,080h,080h,080h
         db       081h,081h,081h,081h,081h,081h,081h,082h,082h,082h,082h,082h,082h,082h,083h,083h,083h,083h,083h,083h
         db       084h,084h,084h,084h,084h,084h,084h,085h,085h,085h,085h,085h,085h,085h,086h,086h,086h,086h,086h,086h
         db       086h,087h,087h,087h,087h,087h,087h,087h,088h,088h,088h,088h,088h,088h,089h,089h,089h,089h,089h,089h
         db       089h,08Ah,08Ah,08Ah,08Ah,08Ah,08Ah,08Ah,08Bh,08Bh,08Bh,08Bh,08Bh,08Bh,08Bh,08Ch,08Ch,08Ch,08Ch,08Ch
         db       08Ch,08Ch,08Dh,08Dh,08Dh,08Dh,08Dh,08Dh,08Dh,08Eh,08Eh,08Eh,08Eh,08Eh,08Eh,08Fh,08Fh,08Fh,08Fh,08Fh
         db       08Fh,08Fh,090h,090h,090h,090h,090h,090h,090h,091h,091h,091h,091h,091h,091h,091h,092h,092h,092h,092h
         db       092h,092h,092h,093h,06Dh,06Dh,06Eh,06Eh,06Eh,06Eh,06Eh,06Eh,06Eh,06Fh,06Fh,06Fh,06Fh,06Fh,06Fh,06Fh
         db       070h,070h,070h,070h,070h,070h,070h,071h,071h,071h,071h,071h,071h,071h,072h,072h,072h,072h,072h,072h
         db       073h,073h,073h,073h,073h,073h,073h,074h,074h,074h,074h,074h,074h,074h,075h,075h,075h,075h,075h,075h
         db       075h,076h,076h,076h,076h,076h,076h,076h,077h,077h,077h,077h,077h,077h,077h,078h,078h,078h,078h,078h
         db       078h,079h,079h,079h,079h,079h,079h,079h,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Bh,07Bh,07Bh,07Bh,07Bh
         db       07Bh,07Bh,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Eh,07Eh,07Eh,07Eh,07Eh
         db       07Eh,07Eh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,07Fh,080h,080h,080h,080h,080h,080h,080h,081h,081h,081h,081h
         db       081h,081h,082h,082h,082h,082h,082h,082h,083h,083h,083h,083h,083h,083h,084h,084h,084h,084h,084h,084h
         db       085h,085h,085h,085h,085h,085h,086h,086h,086h,086h,086h,086h,087h,087h,087h,087h,087h,087h,088h,088h
         db       088h,088h,088h,088h,089h,089h,089h,089h,089h,089h,089h,08Ah,08Ah,08Ah,08Ah,08Ah,08Ah,08Bh,08Bh,08Bh
         db       08Bh,08Bh,08Bh,08Ch,08Ch,08Ch,08Ch,08Ch,08Ch,08Dh,08Dh,08Dh,08Dh,08Dh,08Dh,08Eh,08Eh,08Eh,08Eh,08Eh
         db       08Eh,08Fh,08Fh,08Fh,08Fh,08Fh,08Fh,090h,090h,090h,090h,090h,090h,091h,091h,091h,091h,091h,091h,092h
         db       092h,092h,092h,092h,092h,092h,093h,093h,093h,093h,093h,093h,094h,094h,094h,094h,094h,094h,095h,095h
         db       06Bh,06Bh,06Bh,06Ch,06Ch,06Ch,06Ch,06Ch,06Ch,06Dh,06Dh,06Dh,06Dh,06Dh,06Dh,06Eh,06Eh,06Eh,06Eh,06Eh
         db       06Eh,06Eh,06Fh,06Fh,06Fh,06Fh,06Fh,06Fh,070h,070h,070h,070h,070h,070h,071h,071h,071h,071h,071h,071h
         db       072h,072h,072h,072h,072h,072h,073h,073h,073h,073h,073h,073h,074h,074h,074h,074h,074h,074h,075h,075h
         db       075h,075h,075h,075h,076h,076h,076h,076h,076h,076h,077h,077h,077h,077h,077h,077h,077h,078h,078h,078h
         db       078h,078h,078h,079h,079h,079h,079h,079h,079h,07Ah,07Ah,07Ah,07Ah,07Ah,07Ah,07Bh,07Bh,07Bh,07Bh,07Bh
         db       07Bh,07Ch,07Ch,07Ch,07Ch,07Ch,07Ch,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,07Fh
         db       07Fh,07Fh,07Fh,07Fh,07Fh,080h,080h,080h,080h,080h,080h,081h,081h,081h,081h,081h,081h,082h,082h,082h
         db       082h,082h,083h,083h,083h,083h,083h,083h,084h,084h,084h,084h,084h,085h,085h,085h,085h,085h,085h,086h
         db       086h,086h,086h,086h,087h,087h,087h,087h,087h,087h,088h,088h,088h,088h,088h,089h,089h,089h,089h,089h
         db       089h,08Ah,08Ah,08Ah,08Ah,08Ah,08Bh,08Bh,08Bh,08Bh,08Bh,08Ch,08Ch,08Ch,08Ch,08Ch,08Ch,08Dh,08Dh,08Dh
         db       08Dh,08Dh,08Eh,08Eh,08Eh,08Eh,08Eh,08Eh,08Fh,08Fh,08Fh,08Fh,08Fh,090h,090h,090h,090h,090h,090h,091h
         db       091h,091h,091h,091h,092h,092h,092h,092h,092h,092h,093h,093h,093h,093h,093h,094h,094h,094h,094h,094h
         db       094h,095h,095h,095h,095h,095h,096h,096h,096h,096h,096h,096h,097h,097h,097h,097h,069h,069h,069h,069h
         db       069h,06Ah,06Ah,06Ah,06Ah,06Ah,06Ah,06Bh,06Bh,06Bh,06Bh,06Bh,06Ch,06Ch,06Ch,06Ch,06Ch,06Ch,06Dh,06Dh
         db       06Dh,06Dh,06Dh,06Eh,06Eh,06Eh,06Eh,06Eh,06Eh,06Fh,06Fh,06Fh,06Fh,06Fh,070h,070h,070h,070h,070h,070h
         db       071h,071h,071h,071h,071h,072h,072h,072h,072h,072h,072h,073h,073h,073h,073h,073h,074h,074h,074h,074h
         db       074h,074h,075h,075h,075h,075h,075h,076h,076h,076h,076h,076h,077h,077h,077h,077h,077h,077h,078h,078h
         db       078h,078h,078h,079h,079h,079h,079h,079h,079h,07Ah,07Ah,07Ah,07Ah,07Ah,07Bh,07Bh,07Bh,07Bh,07Bh,07Bh
         db       07Ch,07Ch,07Ch,07Ch,07Ch,07Dh,07Dh,07Dh,07Dh,07Dh,07Dh,07Eh,07Eh,07Eh,07Eh,07Eh,07Fh,07Fh,07Fh,07Fh
         db       07Fh,07Fh,080h,080h,080h,080h,080h,081h,081h,081h,081h,081h,082h,082h,082h,082h,082h,083h,083h,083h
         db       083h,083h,084h,084h,084h,084h,084h,085h,085h,085h,085h,085h,086h,086h,086h,086h,086h,087h,087h,087h
         db       087h,087h,088h,088h,088h,088h,088h,089h,089h,089h,089h,089h,08Ah,08Ah,08Ah,08Ah,08Ah,08Bh,08Bh,08Bh
         db       08Bh,08Bh,08Ch,08Ch,08Ch,08Ch,08Ch,08Dh,08Dh,08Dh,08Dh,08Dh,08Eh,08Eh,08Eh,08Eh,08Eh,08Fh,08Fh,08Fh
         db       08Fh,08Fh,090h,090h,090h,090h,090h,091h,091h,091h,091h,091h,092h,092h,092h,092h,092h,093h,093h,093h
         db       093h,093h,094h,094h,094h,094h,094h,095h,095h,095h,095h,095h,096h,096h,096h,096h,096h,097h,097h,097h
         db       097h,097h,098h,098h,098h,098h,098h,099h,099h,099h,099h,099h,066h,067h,067h,067h,067h,067h,068h,068h
         db       068h,068h,068h,069h,069h,069h,069h,069h,06Ah,06Ah,06Ah,06Ah,06Ah,06Bh,06Bh,06Bh,06Bh,06Bh,06Ch,06Ch
         db       06Ch,06Ch,06Ch,06Dh,06Dh,06Dh,06Dh,06Dh,06Eh,06Eh,06Eh,06Eh,06Eh,06Fh,06Fh,06Fh,06Fh,06Fh,070h,070h
         db       070h,070h,070h,071h,071h,071h,071h,071h,072h,072h,072h,072h,072h,073h,073h,073h,073h,073h,074h,074h
         db       074h,074h,074h,075h,075h,075h,075h,075h,076h,076h,076h,076h,076h,077h,077h,077h,077h,077h,078h,078h
         db       078h,078h,078h,079h,079h,079h,079h,079h,07Ah,07Ah,07Ah,07Ah,07Ah,07Bh,07Bh,07Bh,07Bh,07Bh,07Ch,07Ch
         db       07Ch,07Ch,07Ch,07Dh,07Dh,07Dh,07Dh,07Dh,07Eh,07Eh,07Eh,07Eh,07Eh,07Fh,07Fh,07Fh,07Fh,07Fh,080h,080h
         db       080h,080h,080h,081h,081h,081h,081h,082h,082h,082h,082h,082h,083h,083h,083h,083h,083h,084h,084h,084h
         db       084h,085h,085h,085h,085h,085h,086h,086h,086h,086h,086h,087h,087h,087h,087h,088h,088h,088h,088h,088h
         db       089h,089h,089h,089h,08Ah,08Ah,08Ah,08Ah,08Ah,08Bh,08Bh,08Bh,08Bh,08Bh,08Ch,08Ch,08Ch,08Ch,08Dh,08Dh
         db       08Dh,08Dh,08Dh,08Eh,08Eh,08Eh,08Eh,08Fh,08Fh,08Fh,08Fh,08Fh,090h,090h,090h,090h,090h,091h,091h,091h
         db       091h,092h,092h,092h,092h,092h,093h,093h,093h,093h,093h,094h,094h,094h,094h,095h,095h,095h,095h,095h
         db       096h,096h,096h,096h,097h,097h,097h,097h,097h,098h,098h,098h,098h,098h,099h,099h,099h,099h,09Ah,09Ah
         db       09Ah,09Ah,09Ah,09Bh,09Bh,09Bh,09Bh,09Ch,064h,064h,065h,065h,065h,065h,066h,066h,066h,066h,066h,067h
         db       067h,067h,067h,068h,068h,068h,068h,068h,069h,069h,069h,069h,069h,06Ah,06Ah,06Ah,06Ah,06Bh,06Bh,06Bh
         db       06Bh,06Bh,06Ch,06Ch,06Ch,06Ch,06Dh,06Dh,06Dh,06Dh,06Dh,06Eh,06Eh,06Eh,06Eh,06Eh,06Fh,06Fh,06Fh,06Fh
         db       070h,070h,070h,070h,070h,071h,071h,071h,071h,071h,072h,072h,072h,072h,073h,073h,073h,073h,073h,074h
         db       074h,074h,074h,075h,075h,075h,075h,075h,076h,076h,076h,076h,076h,077h,077h,077h,077h,078h,078h,078h
         db       078h,078h,079h,079h,079h,079h,07Ah,07Ah,07Ah,07Ah,07Ah,07Bh,07Bh,07Bh,07Bh,07Bh,07Ch,07Ch,07Ch,07Ch
         db       07Dh,07Dh,07Dh,07Dh,07Dh,07Eh,07Eh,07Eh,07Eh,07Eh,07Fh,07Fh,07Fh,07Fh,080h,080h,080h,080h,080h,081h
         db       081h,081h,081h,082h,082h,082h,082h,083h,083h,083h,083h,084h,084h,084h,084h,084h,085h,085h,085h,085h
         db       086h,086h,086h,086h,087h,087h,087h,087h,088h,088h,088h,088h,088h,089h,089h,089h,089h,08Ah,08Ah,08Ah
         db       08Ah,08Bh,08Bh,08Bh,08Bh,08Bh,08Ch,08Ch,08Ch,08Ch,08Dh,08Dh,08Dh,08Dh,08Eh,08Eh,08Eh,08Eh,08Fh,08Fh
         db       08Fh,08Fh,08Fh,090h,090h,090h,090h,091h,091h,091h,091h,092h,092h,092h,092h,093h,093h,093h,093h,093h
         db       094h,094h,094h,094h,095h,095h,095h,095h,096h,096h,096h,096h,097h,097h,097h,097h,097h,098h,098h,098h
         db       098h,099h,099h,099h,099h,09Ah,09Ah,09Ah,09Ah,09Bh,09Bh,09Bh,09Bh,09Bh,09Ch,09Ch,09Ch,09Ch,09Dh,09Dh
         db       09Dh,09Dh,09Eh,09Eh,062h,062h,062h,063h,063h,063h,063h,064h,064h,064h,064h,065h,065h,065h,065h,065h
         db       066h,066h,066h,066h,067h,067h,067h,067h,068h,068h,068h,068h,069h,069h,069h,069h,069h,06Ah,06Ah,06Ah
         db       06Ah,06Bh,06Bh,06Bh,06Bh,06Ch,06Ch,06Ch,06Ch,06Dh,06Dh,06Dh,06Dh,06Dh,06Eh,06Eh,06Eh,06Eh,06Fh,06Fh
         db       06Fh,06Fh,070h,070h,070h,070h,071h,071h,071h,071h,071h,072h,072h,072h,072h,073h,073h,073h,073h,074h
         db       074h,074h,074h,075h,075h,075h,075h,075h,076h,076h,076h,076h,077h,077h,077h,077h,078h,078h,078h,078h
         db       078h,079h,079h,079h,079h,07Ah,07Ah,07Ah,07Ah,07Bh,07Bh,07Bh,07Bh,07Ch,07Ch,07Ch,07Ch,07Ch,07Dh,07Dh
         db       07Dh,07Dh,07Eh,07Eh,07Eh,07Eh,07Fh,07Fh,07Fh,07Fh,080h,080h,080h,080h,081h,081h,081h,081h,082h,082h
         db       082h,082h,083h,083h,083h,083h,084h,084h,084h,084h,085h,085h,085h,085h,086h,086h,086h,086h,087h,087h
         db       087h,087h,088h,088h,088h,088h,089h,089h,089h,089h,08Ah,08Ah,08Ah,08Ah,08Bh,08Bh,08Bh,08Bh,08Ch,08Ch
         db       08Ch,08Ch,08Dh,08Dh,08Dh,08Dh,08Eh,08Eh,08Eh,08Eh,08Fh,08Fh,08Fh,08Fh,090h,090h,090h,090h,091h,091h
         db       091h,091h,092h,092h,092h,092h,093h,093h,093h,093h,094h,094h,094h,094h,095h,095h,095h,095h,096h,096h
         db       096h,096h,097h,097h,097h,097h,098h,098h,098h,098h,099h,099h,099h,099h,09Ah,09Ah,09Ah,09Ah,09Bh,09Bh
         db       09Bh,09Bh,09Ch,09Ch,09Ch,09Ch,09Dh,09Dh,09Dh,09Dh,09Eh,09Eh,09Eh,09Eh,09Fh,09Fh,09Fh,09Fh,0A0h,0A0h
         db       060h,060h,060h,061h,061h,061h,061h,062h,062h,062h,062h,063h,063h,063h,063h,064h,064h,064h,064h,065h
         db       065h,065h,065h,066h,066h,066h,066h,067h,067h,067h,067h,068h,068h,068h,068h,069h,069h,069h,069h,06Ah
         db       06Ah,06Ah,06Ah,06Bh,06Bh,06Bh,06Bh,06Ch,06Ch,06Ch,06Ch,06Dh,06Dh,06Dh,06Dh,06Eh,06Eh,06Eh,06Eh,06Fh
         db       06Fh,06Fh,06Fh,070h,070h,070h,070h,071h,071h,071h,071h,072h,072h,072h,072h,073h,073h,073h,073h,074h
         db       074h,074h,074h,075h,075h,075h,075h,076h,076h,076h,076h,077h,077h,077h,077h,078h,078h,078h,078h,079h
         db       079h,079h,079h,07Ah,07Ah,07Ah,07Ah,07Bh,07Bh,07Bh,07Bh,07Ch,07Ch,07Ch,07Ch,07Dh,07Dh,07Dh,07Dh,07Eh
         db       07Eh,07Eh,07Eh,07Fh,07Fh,07Fh,07Fh,080h,080h,080h,081h,081h,081h,081h,082h,082h,082h,082h,083h,083h
         db       083h,083h,084h,084h,084h,085h,085h,085h,085h,086h,086h,086h,086h,087h,087h,087h,087h,088h,088h,088h
         db       089h,089h,089h,089h,08Ah,08Ah,08Ah,08Ah,08Bh,08Bh,08Bh,08Bh,08Ch,08Ch,08Ch,08Dh,08Dh,08Dh,08Dh,08Eh
         db       08Eh,08Eh,08Eh,08Fh,08Fh,08Fh,08Fh,090h,090h,090h,091h,091h,091h,091h,092h,092h,092h,092h,093h,093h
         db       093h,094h,094h,094h,094h,095h,095h,095h,095h,096h,096h,096h,096h,097h,097h,097h,098h,098h,098h,098h
         db       099h,099h,099h,099h,09Ah,09Ah,09Ah,09Ah,09Bh,09Bh,09Bh,09Ch,09Ch,09Ch,09Ch,09Dh,09Dh,09Dh,09Dh,09Eh
         db       09Eh,09Eh,09Eh,09Fh,09Fh,09Fh,0A0h,0A0h,0A0h,0A0h,0A1h,0A1h,0A1h,0A1h,0A2h,0A2h,05Eh,05Eh,05Eh,05Fh
         db       05Fh,05Fh,05Fh,060h,060h,060h,060h,061h,061h,061h,062h,062h,062h,062h,063h,063h,063h,063h,064h,064h
         db       064h,064h,065h,065h,065h,066h,066h,066h,066h,067h,067h,067h,067h,068h,068h,068h,068h,069h,069h,069h
         db       06Ah,06Ah,06Ah,06Ah,06Bh,06Bh,06Bh,06Bh,06Ch,06Ch,06Ch,06Ch,06Dh,06Dh,06Dh,06Eh,06Eh,06Eh,06Eh,06Fh
         db       06Fh,06Fh,06Fh,070h,070h,070h,071h,071h,071h,071h,072h,072h,072h,072h,073h,073h,073h,073h,074h,074h
         db       074h,075h,075h,075h,075h,076h,076h,076h,076h,077h,077h,077h,077h,078h,078h,078h,079h,079h,079h,079h
         db       07Ah,07Ah,07Ah,07Ah,07Bh,07Bh,07Bh,07Bh,07Ch,07Ch,07Ch,07Dh,07Dh,07Dh,07Dh,07Eh,07Eh,07Eh,07Eh,07Fh
         db       07Fh,07Fh,07Fh,080h,080h,080h,081h,081h,081h,081h,082h,082h,082h,083h,083h,083h,083h,084h,084h,084h
         db       085h,085h,085h,085h,086h,086h,086h,087h,087h,087h,087h,088h,088h,088h,089h,089h,089h,089h,08Ah,08Ah
         db       08Ah,08Ah,08Bh,08Bh,08Bh,08Ch,08Ch,08Ch,08Ch,08Dh,08Dh,08Dh,08Eh,08Eh,08Eh,08Eh,08Fh,08Fh,08Fh,090h
         db       090h,090h,090h,091h,091h,091h,092h,092h,092h,092h,093h,093h,093h,094h,094h,094h,094h,095h,095h,095h
         db       096h,096h,096h,096h,097h,097h,097h,098h,098h,098h,098h,099h,099h,099h,09Ah,09Ah,09Ah,09Ah,09Bh,09Bh
         db       09Bh,09Ch,09Ch,09Ch,09Ch,09Dh,09Dh,09Dh,09Eh,09Eh,09Eh,09Eh,09Fh,09Fh,09Fh,09Fh,0A0h,0A0h,0A0h,0A1h
         db       0A1h,0A1h,0A1h,0A2h,0A2h,0A2h,0A3h,0A3h,0A3h,0A3h,0A4h,0A4h,05Ch,05Ch,05Ch,05Dh,05Dh,05Dh,05Dh,05Eh
         db       05Eh,05Eh,05Fh,05Fh,05Fh,05Fh,060h,060h,060h,061h,061h,061h,061h,062h,062h,062h,062h,063h,063h,063h
         db       064h,064h,064h,064h,065h,065h,065h,066h,066h,066h,066h,067h,067h,067h,068h,068h,068h,068h,069h,069h
         db       069h,06Ah,06Ah,06Ah,06Ah,06Bh,06Bh,06Bh,06Ch,06Ch,06Ch,06Ch,06Dh,06Dh,06Dh,06Eh,06Eh,06Eh,06Eh,06Fh
         db       06Fh,06Fh,070h,070h,070h,070h,071h,071h,071h,072h,072h,072h,072h,073h,073h,073h,074h,074h,074h,074h
         db       075h,075h,075h,076h,076h,076h,076h,077h,077h,077h,077h,078h,078h,078h,079h,079h,079h,079h,07Ah,07Ah
         db       07Ah,07Bh,07Bh,07Bh,07Bh,07Ch,07Ch,07Ch,07Dh,07Dh,07Dh,07Dh,07Eh,07Eh,07Eh,07Fh,07Fh,07Fh,07Fh,080h
         db       080h,080h,081h,081h,081h,082h,082h,082h,082h,083h,083h,083h,084h,084h,084h,085h,085h,085h,085h,086h
         db       086h,086h,087h,087h,087h,088h,088h,088h,088h,089h,089h,089h,08Ah,08Ah,08Ah,08Bh,08Bh,08Bh,08Bh,08Ch
         db       08Ch,08Ch,08Dh,08Dh,08Dh,08Eh,08Eh,08Eh,08Eh,08Fh,08Fh,08Fh,090h,090h,090h,091h,091h,091h,091h,092h
         db       092h,092h,093h,093h,093h,094h,094h,094h,094h,095h,095h,095h,096h,096h,096h,097h,097h,097h,097h,098h
         db       098h,098h,099h,099h,099h,09Ah,09Ah,09Ah,09Bh,09Bh,09Bh,09Bh,09Ch,09Ch,09Ch,09Dh,09Dh,09Dh,09Eh,09Eh
         db       09Eh,09Eh,09Fh,09Fh,09Fh,0A0h,0A0h,0A0h,0A1h,0A1h,0A1h,0A1h,0A2h,0A2h,0A2h,0A3h,0A3h,0A3h,0A4h,0A4h
         db       0A4h,0A4h,0A5h,0A5h,0A5h,0A6h,0A6h,0A6h,059h,05Ah,05Ah,05Ah,05Bh,05Bh,05Bh,05Ch,05Ch,05Ch,05Ch,05Dh
         db       05Dh,05Dh,05Eh,05Eh,05Eh,05Fh,05Fh,05Fh,05Fh,060h,060h,060h,061h,061h,061h,062h,062h,062h,062h,063h
         db       063h,063h,064h,064h,064h,065h,065h,065h,065h,066h,066h,066h,067h,067h,067h,068h,068h,068h,069h,069h
         db       069h,069h,06Ah,06Ah,06Ah,06Bh,06Bh,06Bh,06Ch,06Ch,06Ch,06Ch,06Dh,06Dh,06Dh,06Eh,06Eh,06Eh,06Fh,06Fh
         db       06Fh,06Fh,070h,070h,070h,071h,071h,071h,072h,072h,072h,072h,073h,073h,073h,074h,074h,074h,075h,075h
         db       075h,075h,076h,076h,076h,077h,077h,077h,078h,078h,078h,078h,079h,079h,079h,07Ah,07Ah,07Ah,07Bh,07Bh
         db       07Bh,07Bh,07Ch,07Ch,07Ch,07Dh,07Dh,07Dh,07Eh,07Eh,07Eh,07Eh,07Fh,07Fh,07Fh,080h,080h,080h,081h,081h
         db       081h,082h,082h,082h,083h,083h,083h,083h,084h,084h,084h,085h,085h,085h,086h,086h,086h,087h,087h,087h
         db       088h,088h,088h,089h,089h,089h,089h,08Ah,08Ah,08Ah,08Bh,08Bh,08Bh,08Ch,08Ch,08Ch,08Dh,08Dh,08Dh,08Eh
         db       08Eh,08Eh,08Fh,08Fh,08Fh,090h,090h,090h,090h,091h,091h,091h,092h,092h,092h,093h,093h,093h,094h,094h
         db       094h,095h,095h,095h,096h,096h,096h,096h,097h,097h,097h,098h,098h,098h,099h,099h,099h,09Ah,09Ah,09Ah
         db       09Bh,09Bh,09Bh,09Ch,09Ch,09Ch,09Ch,09Dh,09Dh,09Dh,09Eh,09Eh,09Eh,09Fh,09Fh,09Fh,0A0h,0A0h,0A0h,0A1h
         db       0A1h,0A1h,0A2h,0A2h,0A2h,0A3h,0A3h,0A3h,0A3h,0A4h,0A4h,0A4h,0A5h,0A5h,0A5h,0A6h,0A6h,0A6h,0A7h,0A7h
         db       0A7h,0A8h,0A8h,0A8h,057h,058h,058h,058h,059h,059h,059h,05Ah,05Ah,05Ah,05Bh,05Bh,05Bh,05Ch,05Ch,05Ch
         db       05Dh,05Dh,05Dh,05Dh,05Eh,05Eh,05Eh,05Fh,05Fh,05Fh,060h,060h,060h,061h,061h,061h,062h,062h,062h,063h
         db       063h,063h,064h,064h,064h,064h,065h,065h,065h,066h,066h,066h,067h,067h,067h,068h,068h,068h,069h,069h
         db       069h,06Ah,06Ah,06Ah,06Ah,06Bh,06Bh,06Bh,06Ch,06Ch,06Ch,06Dh,06Dh,06Dh,06Eh,06Eh,06Eh,06Fh,06Fh,06Fh
         db       070h,070h,070h,070h,071h,071h,071h,072h,072h,072h,073h,073h,073h,074h,074h,074h,075h,075h,075h,076h
         db       076h,076h,077h,077h,077h,077h,078h,078h,078h,079h,079h,079h,07Ah,07Ah,07Ah,07Bh,07Bh,07Bh,07Ch,07Ch
         db       07Ch,07Dh,07Dh,07Dh,07Dh,07Eh,07Eh,07Eh,07Fh,07Fh,07Fh,080h,080h,080h,081h,081h,081h,082h,082h,082h
         db       083h,083h,083h,084h,084h,084h,085h,085h,085h,086h,086h,086h,087h,087h,087h,088h,088h,088h,089h,089h
         db       089h,08Ah,08Ah,08Ah,08Bh,08Bh,08Bh,08Ch,08Ch,08Ch,08Dh,08Dh,08Dh,08Eh,08Eh,08Eh,08Fh,08Fh,08Fh,090h
         db       090h,090h,091h,091h,091h,092h,092h,092h,093h,093h,093h,094h,094h,094h,095h,095h,095h,096h,096h,096h
         db       097h,097h,097h,098h,098h,098h,099h,099h,099h,09Ah,09Ah,09Ah,09Bh,09Bh,09Bh,09Ch,09Ch,09Ch,09Dh,09Dh
         db       09Dh,09Eh,09Eh,09Eh,09Fh,09Fh,09Fh,0A0h,0A0h,0A0h,0A1h,0A1h,0A1h,0A2h,0A2h,0A2h,0A3h,0A3h,0A3h,0A4h
         db       0A4h,0A4h,0A5h,0A5h,0A5h,0A6h,0A6h,0A6h,0A7h,0A7h,0A7h,0A8h,0A8h,0A8h,0A9h,0A9h,0A9h,0AAh,0AAh,0AAh
         db       055h,056h,056h,056h,057h,057h,057h,058h,058h,058h,059h,059h,059h,05Ah,05Ah,05Ah,05Bh,05Bh,05Bh,05Ch
         db       05Ch,05Ch,05Dh,05Dh,05Dh,05Eh,05Eh,05Eh,05Fh,05Fh,05Fh,060h,060h,060h,061h,061h,061h,062h,062h,062h
         db       063h,063h,063h,064h,064h,064h,065h,065h,065h,066h,066h,066h,067h,067h,067h,068h,068h,068h,069h,069h
         db       069h,06Ah,06Ah,06Ah,06Bh,06Bh,06Bh,06Ch,06Ch,06Ch,06Dh,06Dh,06Dh,06Eh,06Eh,06Eh,06Fh,06Fh,06Fh,070h
         db       070h,070h,071h,071h,071h,072h,072h,072h,073h,073h,073h,074h,074h,074h,075h,075h,075h,076h,076h,076h
         db       077h,077h,077h,078h,078h,078h,079h,079h,079h,07Ah,07Ah,07Ah,07Bh,07Bh,07Bh,07Ch,07Ch,07Ch,07Dh,07Dh
         db       07Dh,07Eh,07Eh,07Eh,07Fh,07Fh,07Fh,080h,080h,080h,081h,081h,081h,082h,082h,082h,083h,083h,083h,084h
         db       084h,085h,085h,085h,086h,086h,086h,087h,087h,087h,088h,088h,088h,089h,089h,089h,08Ah,08Ah,08Ah,08Bh
         db       08Bh,08Ch,08Ch,08Ch,08Dh,08Dh,08Dh,08Eh,08Eh,08Eh,08Fh,08Fh,08Fh,090h,090h,090h,091h,091h,091h,092h
         db       092h,093h,093h,093h,094h,094h,094h,095h,095h,095h,096h,096h,096h,097h,097h,097h,098h,098h,098h,099h
         db       099h,09Ah,09Ah,09Ah,09Bh,09Bh,09Bh,09Ch,09Ch,09Ch,09Dh,09Dh,09Dh,09Eh,09Eh,09Eh,09Fh,09Fh,09Fh,0A0h
         db       0A0h,0A1h,0A1h,0A1h,0A2h,0A2h,0A2h,0A3h,0A3h,0A3h,0A4h,0A4h,0A4h,0A5h,0A5h,0A5h,0A6h,0A6h,0A6h,0A7h
         db       0A7h,0A8h,0A8h,0A8h,0A9h,0A9h,0A9h,0AAh,0AAh,0AAh,0ABh,0ABh,0ABh,0ACh,0ACh,0ACh,053h,054h,054h,054h
         db       055h,055h,055h,056h,056h,056h,057h,057h,057h,058h,058h,058h,059h,059h,05Ah,05Ah,05Ah,05Bh,05Bh,05Bh
         db       05Ch,05Ch,05Ch,05Dh,05Dh,05Dh,05Eh,05Eh,05Eh,05Fh,05Fh,05Fh,060h,060h,061h,061h,061h,062h,062h,062h
         db       063h,063h,063h,064h,064h,064h,065h,065h,065h,066h,066h,066h,067h,067h,068h,068h,068h,069h,069h,069h
         db       06Ah,06Ah,06Ah,06Bh,06Bh,06Bh,06Ch,06Ch,06Ch,06Dh,06Dh,06Dh,06Eh,06Eh,06Fh,06Fh,06Fh,070h,070h,070h
         db       071h,071h,071h,072h,072h,072h,073h,073h,073h,074h,074h,074h,075h,075h,076h,076h,076h,077h,077h,077h
         db       078h,078h,078h,079h,079h,079h,07Ah,07Ah,07Ah,07Bh,07Bh,07Bh,07Ch,07Ch,07Dh,07Dh,07Dh,07Eh,07Eh,07Eh
         db       07Fh,07Fh,07Fh,080h,080h,080h,081h,081h,081h,082h,082h,083h,083h,083h,084h,084h,084h,085h,085h,085h
         db       086h,086h,087h,087h,087h,088h,088h,088h,089h,089h,089h,08Ah,08Ah,08Bh,08Bh,08Bh,08Ch,08Ch,08Ch,08Dh
         db       08Dh,08Dh,08Eh,08Eh,08Fh,08Fh,08Fh,090h,090h,090h,091h,091h,091h,092h,092h,093h,093h,093h,094h,094h
         db       094h,095h,095h,095h,096h,096h,097h,097h,097h,098h,098h,098h,099h,099h,099h,09Ah,09Ah,09Bh,09Bh,09Bh
         db       09Ch,09Ch,09Ch,09Dh,09Dh,09Eh,09Eh,09Eh,09Fh,09Fh,09Fh,0A0h,0A0h,0A0h,0A1h,0A1h,0A2h,0A2h,0A2h,0A3h
         db       0A3h,0A3h,0A4h,0A4h,0A4h,0A5h,0A5h,0A6h,0A6h,0A6h,0A7h,0A7h,0A7h,0A8h,0A8h,0A8h,0A9h,0A9h,0AAh,0AAh
         db       0AAh,0ABh,0ABh,0ABh,0ACh,0ACh,0ACh,0ADh,0ADh,0AEh,0AEh,0AEh,051h,052h,052h,052h,053h,053h,054h,054h
         db       054h,055h,055h,055h,056h,056h,056h,057h,057h,058h,058h,058h,059h,059h,059h,05Ah,05Ah,05Ah,05Bh,05Bh
         db       05Ch,05Ch,05Ch,05Dh,05Dh,05Dh,05Eh,05Eh,05Eh,05Fh,05Fh,060h,060h,060h,061h,061h,061h,062h,062h,062h
         db       063h,063h,064h,064h,064h,065h,065h,065h,066h,066h,067h,067h,067h,068h,068h,068h,069h,069h,069h,06Ah
         db       06Ah,06Bh,06Bh,06Bh,06Ch,06Ch,06Ch,06Dh,06Dh,06Dh,06Eh,06Eh,06Fh,06Fh,06Fh,070h,070h,070h,071h,071h
         db       071h,072h,072h,073h,073h,073h,074h,074h,074h,075h,075h,075h,076h,076h,077h,077h,077h,078h,078h,078h
         db       079h,079h,079h,07Ah,07Ah,07Bh,07Bh,07Bh,07Ch,07Ch,07Ch,07Dh,07Dh,07Dh,07Eh,07Eh,07Fh,07Fh,07Fh,080h
         db       080h,080h,081h,081h,082h,082h,082h,083h,083h,083h,084h,084h,085h,085h,085h,086h,086h,086h,087h,087h
         db       088h,088h,088h,089h,089h,089h,08Ah,08Ah,08Bh,08Bh,08Bh,08Ch,08Ch,08Dh,08Dh,08Dh,08Eh,08Eh,08Eh,08Fh
         db       08Fh,090h,090h,090h,091h,091h,091h,092h,092h,093h,093h,093h,094h,094h,094h,095h,095h,096h,096h,096h
         db       097h,097h,098h,098h,098h,099h,099h,099h,09Ah,09Ah,09Bh,09Bh,09Bh,09Ch,09Ch,09Ch,09Dh,09Dh,09Eh,09Eh
         db       09Eh,09Fh,09Fh,09Fh,0A0h,0A0h,0A1h,0A1h,0A1h,0A2h,0A2h,0A2h,0A3h,0A3h,0A4h,0A4h,0A4h,0A5h,0A5h,0A6h
         db       0A6h,0A6h,0A7h,0A7h,0A7h,0A8h,0A8h,0A9h,0A9h,0A9h,0AAh,0AAh,0AAh,0ABh,0ABh,0ACh,0ACh,0ACh,0ADh,0ADh
         db       0ADh,0AEh,0AEh,0AFh,0AFh,0AFh,0B0h,0B0h,04Fh,050h,050h,051h,051h,051h,052h,052h,053h,053h,053h,054h
         db       054h,054h,055h,055h,056h,056h,056h,057h,057h,057h,058h,058h,059h,059h,059h,05Ah,05Ah,05Ah,05Bh,05Bh
         db       05Ch,05Ch,05Ch,05Dh,05Dh,05Eh,05Eh,05Eh,05Fh,05Fh,05Fh,060h,060h,061h,061h,061h,062h,062h,062h,063h
         db       063h,064h,064h,064h,065h,065h,065h,066h,066h,067h,067h,067h,068h,068h,068h,069h,069h,06Ah,06Ah,06Ah
         db       06Bh,06Bh,06Ch,06Ch,06Ch,06Dh,06Dh,06Dh,06Eh,06Eh,06Fh,06Fh,06Fh,070h,070h,070h,071h,071h,072h,072h
         db       072h,073h,073h,073h,074h,074h,075h,075h,075h,076h,076h,077h,077h,077h,078h,078h,078h,079h,079h,07Ah
         db       07Ah,07Ah,07Bh,07Bh,07Bh,07Ch,07Ch,07Dh,07Dh,07Dh,07Eh,07Eh,07Eh,07Fh,07Fh,080h,080h,080h,081h,081h
         db       082h,082h,082h,083h,083h,084h,084h,084h,085h,085h,086h,086h,086h,087h,087h,087h,088h,088h,089h,089h
         db       089h,08Ah,08Ah,08Bh,08Bh,08Bh,08Ch,08Ch,08Dh,08Dh,08Dh,08Eh,08Eh,08Fh,08Fh,08Fh,090h,090h,091h,091h
         db       091h,092h,092h,093h,093h,093h,094h,094h,095h,095h,095h,096h,096h,096h,097h,097h,098h,098h,098h,099h
         db       099h,09Ah,09Ah,09Ah,09Bh,09Bh,09Ch,09Ch,09Ch,09Dh,09Dh,09Eh,09Eh,09Eh,09Fh,09Fh,0A0h,0A0h,0A0h,0A1h
         db       0A1h,0A2h,0A2h,0A2h,0A3h,0A3h,0A4h,0A4h,0A4h,0A5h,0A5h,0A5h,0A6h,0A6h,0A7h,0A7h,0A7h,0A8h,0A8h,0A9h
         db       0A9h,0A9h,0AAh,0AAh,0ABh,0ABh,0ABh,0ACh,0ACh,0ADh,0ADh,0ADh,0AEh,0AEh,0AFh,0AFh,0AFh,0B0h,0B0h,0B1h
         db       0B1h,0B1h,0B2h,0B2h,04Dh,04Eh,04Eh,04Fh,04Fh,04Fh,050h,050h,051h,051h,051h,052h,052h,053h,053h,053h
         db       054h,054h,055h,055h,055h,056h,056h,057h,057h,057h,058h,058h,059h,059h,059h,05Ah,05Ah,05Bh,05Bh,05Bh
         db       05Ch,05Ch,05Ch,05Dh,05Dh,05Eh,05Eh,05Eh,05Fh,05Fh,060h,060h,060h,061h,061h,062h,062h,062h,063h,063h
         db       064h,064h,064h,065h,065h,066h,066h,066h,067h,067h,068h,068h,068h,069h,069h,06Ah,06Ah,06Ah,06Bh,06Bh
         db       06Bh,06Ch,06Ch,06Dh,06Dh,06Dh,06Eh,06Eh,06Fh,06Fh,06Fh,070h,070h,071h,071h,071h,072h,072h,073h,073h
         db       073h,074h,074h,075h,075h,075h,076h,076h,077h,077h,077h,078h,078h,079h,079h,079h,07Ah,07Ah,07Ah,07Bh
         db       07Bh,07Ch,07Ch,07Ch,07Dh,07Dh,07Eh,07Eh,07Eh,07Fh,07Fh,080h,080h,080h,081h,081h,082h,082h,082h,083h
         db       083h,084h,084h,085h,085h,085h,086h,086h,087h,087h,087h,088h,088h,089h,089h,089h,08Ah,08Ah,08Bh,08Bh
         db       08Bh,08Ch,08Ch,08Dh,08Dh,08Eh,08Eh,08Eh,08Fh,08Fh,090h,090h,090h,091h,091h,092h,092h,092h,093h,093h
         db       094h,094h,095h,095h,095h,096h,096h,097h,097h,097h,098h,098h,099h,099h,099h,09Ah,09Ah,09Bh,09Bh,09Ch
         db       09Ch,09Ch,09Dh,09Dh,09Eh,09Eh,09Eh,09Fh,09Fh,0A0h,0A0h,0A0h,0A1h,0A1h,0A2h,0A2h,0A2h,0A3h,0A3h,0A4h
         db       0A4h,0A5h,0A5h,0A5h,0A6h,0A6h,0A7h,0A7h,0A7h,0A8h,0A8h,0A9h,0A9h,0A9h,0AAh,0AAh,0ABh,0ABh,0ACh,0ACh
         db       0ACh,0ADh,0ADh,0AEh,0AEh,0AEh,0AFh,0AFh,0B0h,0B0h,0B0h,0B1h,0B1h,0B2h,0B2h,0B3h,0B3h,0B3h,0B4h,0B4h
         db       04Bh,04Ch,04Ch,04Dh,04Dh,04Dh,04Eh,04Eh,04Fh,04Fh,050h,050h,050h,051h,051h,052h,052h,052h,053h,053h
         db       054h,054h,054h,055h,055h,056h,056h,057h,057h,057h,058h,058h,059h,059h,059h,05Ah,05Ah,05Bh,05Bh,05Bh
         db       05Ch,05Ch,05Dh,05Dh,05Eh,05Eh,05Eh,05Fh,05Fh,060h,060h,060h,061h,061h,062h,062h,062h,063h,063h,064h
         db       064h,064h,065h,065h,066h,066h,067h,067h,067h,068h,068h,069h,069h,069h,06Ah,06Ah,06Bh,06Bh,06Bh,06Ch
         db       06Ch,06Dh,06Dh,06Eh,06Eh,06Eh,06Fh,06Fh,070h,070h,070h,071h,071h,072h,072h,072h,073h,073h,074h,074h
         db       075h,075h,075h,076h,076h,077h,077h,077h,078h,078h,079h,079h,079h,07Ah,07Ah,07Bh,07Bh,07Bh,07Ch,07Ch
         db       07Dh,07Dh,07Eh,07Eh,07Eh,07Fh,07Fh,080h,080h,080h,081h,081h,082h,082h,083h,083h,083h,084h,084h,085h
         db       085h,086h,086h,086h,087h,087h,088h,088h,089h,089h,089h,08Ah,08Ah,08Bh,08Bh,08Ch,08Ch,08Ch,08Dh,08Dh
         db       08Eh,08Eh,08Fh,08Fh,08Fh,090h,090h,091h,091h,092h,092h,092h,093h,093h,094h,094h,095h,095h,095h,096h
         db       096h,097h,097h,098h,098h,098h,099h,099h,09Ah,09Ah,09Ah,09Bh,09Bh,09Ch,09Ch,09Dh,09Dh,09Dh,09Eh,09Eh
         db       09Fh,09Fh,0A0h,0A0h,0A0h,0A1h,0A1h,0A2h,0A2h,0A3h,0A3h,0A3h,0A4h,0A4h,0A5h,0A5h,0A6h,0A6h,0A6h,0A7h
         db       0A7h,0A8h,0A8h,0A9h,0A9h,0A9h,0AAh,0AAh,0ABh,0ABh,0ACh,0ACh,0ACh,0ADh,0ADh,0AEh,0AEh,0AFh,0AFh,0AFh
         db       0B0h,0B0h,0B1h,0B1h,0B2h,0B2h,0B2h,0B3h,0B3h,0B4h,0B4h,0B5h,0B5h,0B5h,0B6h,0B6h,049h,04Ah,04Ah,04Bh
         db       04Bh,04Bh,04Ch,04Ch,04Dh,04Dh,04Eh,04Eh,04Eh,04Fh,04Fh,050h,050h,051h,051h,051h,052h,052h,053h,053h
         db       054h,054h,054h,055h,055h,056h,056h,057h,057h,057h,058h,058h,059h,059h,05Ah,05Ah,05Ah,05Bh,05Bh,05Ch
         db       05Ch,05Dh,05Dh,05Dh,05Eh,05Eh,05Fh,05Fh,060h,060h,060h,061h,061h,062h,062h,063h,063h,063h,064h,064h
         db       065h,065h,066h,066h,066h,067h,067h,068h,068h,068h,069h,069h,06Ah,06Ah,06Bh,06Bh,06Bh,06Ch,06Ch,06Dh
         db       06Dh,06Eh,06Eh,06Eh,06Fh,06Fh,070h,070h,071h,071h,071h,072h,072h,073h,073h,074h,074h,074h,075h,075h
         db       076h,076h,077h,077h,077h,078h,078h,079h,079h,07Ah,07Ah,07Ah,07Bh,07Bh,07Ch,07Ch,07Dh,07Dh,07Dh,07Eh
         db       07Eh,07Fh,07Fh,080h,080h,080h,081h,081h,082h,082h,083h,083h,084h,084h,084h,085h,085h,086h,086h,087h
         db       087h,087h,088h,088h,089h,089h,08Ah,08Ah,08Bh,08Bh,08Bh,08Ch,08Ch,08Dh,08Dh,08Eh,08Eh,08Fh,08Fh,08Fh
         db       090h,090h,091h,091h,092h,092h,092h,093h,093h,094h,094h,095h,095h,096h,096h,096h,097h,097h,098h,098h
         db       099h,099h,09Ah,09Ah,09Ah,09Bh,09Bh,09Ch,09Ch,09Dh,09Dh,09Eh,09Eh,09Eh,09Fh,09Fh,0A0h,0A0h,0A1h,0A1h
         db       0A1h,0A2h,0A2h,0A3h,0A3h,0A4h,0A4h,0A5h,0A5h,0A5h,0A6h,0A6h,0A7h,0A7h,0A8h,0A8h,0A9h,0A9h,0A9h,0AAh
         db       0AAh,0ABh,0ABh,0ACh,0ACh,0ACh,0ADh,0ADh,0AEh,0AEh,0AFh,0AFh,0B0h,0B0h,0B0h,0B1h,0B1h,0B2h,0B2h,0B3h
         db       0B3h,0B4h,0B4h,0B4h,0B5h,0B5h,0B6h,0B6h,0B7h,0B7h,0B7h,0B8h,048h,048h,049h,049h,049h,04Ah,04Ah,04Bh
         db       04Bh,04Ch,04Ch,04Ch,04Dh,04Dh,04Eh,04Eh,04Fh,04Fh,050h,050h,050h,051h,051h,052h,052h,053h,053h,054h
         db       054h,054h,055h,055h,056h,056h,057h,057h,057h,058h,058h,059h,059h,05Ah,05Ah,05Bh,05Bh,05Bh,05Ch,05Ch
         db       05Dh,05Dh,05Eh,05Eh,05Fh,05Fh,05Fh,060h,060h,061h,061h,062h,062h,062h,063h,063h,064h,064h,065h,065h
         db       066h,066h,066h,067h,067h,068h,068h,069h,069h,06Ah,06Ah,06Ah,06Bh,06Bh,06Ch,06Ch,06Dh,06Dh,06Eh,06Eh
         db       06Eh,06Fh,06Fh,070h,070h,071h,071h,071h,072h,072h,073h,073h,074h,074h,075h,075h,075h,076h,076h,077h
         db       077h,078h,078h,079h,079h,079h,07Ah,07Ah,07Bh,07Bh,07Ch,07Ch,07Ch,07Dh,07Dh,07Eh,07Eh,07Fh,07Fh,080h
         db       080h,080h,081h,081h,082h,082h,083h,083h,084h,084h,085h,085h,086h,086h,086h,087h,087h,088h,088h,089h
         db       089h,08Ah,08Ah,08Bh,08Bh,08Bh,08Ch,08Ch,08Dh,08Dh,08Eh,08Eh,08Fh,08Fh,090h,090h,091h,091h,091h,092h
         db       092h,093h,093h,094h,094h,095h,095h,096h,096h,096h,097h,097h,098h,098h,099h,099h,09Ah,09Ah,09Bh,09Bh
         db       09Ch,09Ch,09Ch,09Dh,09Dh,09Eh,09Eh,09Fh,09Fh,0A0h,0A0h,0A1h,0A1h,0A1h,0A2h,0A2h,0A3h,0A3h,0A4h,0A4h
         db       0A5h,0A5h,0A6h,0A6h,0A7h,0A7h,0A7h,0A8h,0A8h,0A9h,0A9h,0AAh,0AAh,0ABh,0ABh,0ACh,0ACh,0ACh,0ADh,0ADh
         db       0AEh,0AEh,0AFh,0AFh,0B0h,0B0h,0B1h,0B1h,0B2h,0B2h,0B2h,0B3h,0B3h,0B4h,0B4h,0B5h,0B5h,0B6h,0B6h,0B7h
         db       0B7h,0B7h,0B8h,0B8h,0B9h,0B9h,0BAh,0BAh,045h,046h,046h,047h,047h,048h,048h,049h,049h,049h,04Ah,04Ah
         db       04Bh,04Bh,04Ch,04Ch,04Dh,04Dh,04Eh,04Eh,04Eh,04Fh,04Fh,050h,050h,051h,051h,052h,052h,053h,053h,054h
         db       054h,054h,055h,055h,056h,056h,057h,057h,058h,058h,059h,059h,059h,05Ah,05Ah,05Bh,05Bh,05Ch,05Ch,05Dh
         db       05Dh,05Eh,05Eh,05Fh,05Fh,05Fh,060h,060h,061h,061h,062h,062h,063h,063h,064h,064h,064h,065h,065h,066h
         db       066h,067h,067h,068h,068h,069h,069h,06Ah,06Ah,06Ah,06Bh,06Bh,06Ch,06Ch,06Dh,06Dh,06Eh,06Eh,06Fh,06Fh
         db       06Fh,070h,070h,071h,071h,072h,072h,073h,073h,074h,074h,075h,075h,075h,076h,076h,077h,077h,078h,078h
         db       079h,079h,07Ah,07Ah,07Ah,07Bh,07Bh,07Ch,07Ch,07Dh,07Dh,07Eh,07Eh,07Fh,07Fh,080h,080h,080h,081h,081h
         db       082h,082h,083h,083h,084h,084h,085h,085h,086h,086h,087h,087h,088h,088h,089h,089h,089h,08Ah,08Ah,08Bh
         db       08Bh,08Ch,08Ch,08Dh,08Dh,08Eh,08Eh,08Fh,08Fh,090h,090h,091h,091h,091h,092h,092h,093h,093h,094h,094h
         db       095h,095h,096h,096h,097h,097h,098h,098h,099h,099h,09Ah,09Ah,09Ah,09Bh,09Bh,09Ch,09Ch,09Dh,09Dh,09Eh
         db       09Eh,09Fh,09Fh,0A0h,0A0h,0A1h,0A1h,0A2h,0A2h,0A2h,0A3h,0A3h,0A4h,0A4h,0A5h,0A5h,0A6h,0A6h,0A7h,0A7h
         db       0A8h,0A8h,0A9h,0A9h,0AAh,0AAh,0ABh,0ABh,0ABh,0ACh,0ACh,0ADh,0ADh,0AEh,0AEh,0AFh,0AFh,0B0h,0B0h,0B1h
         db       0B1h,0B2h,0B2h,0B3h,0B3h,0B3h,0B4h,0B4h,0B5h,0B5h,0B6h,0B6h,0B7h,0B7h,0B8h,0B8h,0B9h,0B9h,0BAh,0BAh
         db       0BBh,0BBh,0BCh,0BCh,044h,044h,044h,045h,045h,046h,046h,047h,047h,048h,048h,049h,049h,04Ah,04Ah,04Bh
         db       04Bh,04Ch,04Ch,04Dh,04Dh,04Dh,04Eh,04Eh,04Fh,04Fh,050h,050h,051h,051h,052h,052h,053h,053h,054h,054h
         db       055h,055h,055h,056h,056h,057h,057h,058h,058h,059h,059h,05Ah,05Ah,05Bh,05Bh,05Ch,05Ch,05Dh,05Dh,05Eh
         db       05Eh,05Eh,05Fh,05Fh,060h,060h,061h,061h,062h,062h,063h,063h,064h,064h,065h,065h,066h,066h,066h,067h
         db       067h,068h,068h,069h,069h,06Ah,06Ah,06Bh,06Bh,06Ch,06Ch,06Dh,06Dh,06Eh,06Eh,06Fh,06Fh,06Fh,070h,070h
         db       071h,071h,072h,072h,073h,073h,074h,074h,075h,075h,076h,076h,077h,077h,077h,078h,078h,079h,079h,07Ah
         db       07Ah,07Bh,07Bh,07Ch,07Ch,07Dh,07Dh,07Eh,07Eh,07Fh,07Fh,080h,080h,080h,081h,081h,082h,082h,083h,083h
         db       084h,084h,085h,085h,086h,086h,087h,087h,088h,088h,089h,089h,08Ah,08Ah,08Bh,08Bh,08Ch,08Ch,08Dh,08Dh
         db       08Eh,08Eh,08Fh,08Fh,090h,090h,091h,091h,092h,092h,092h,093h,093h,094h,094h,095h,095h,096h,096h,097h
         db       097h,098h,098h,099h,099h,09Ah,09Ah,09Bh,09Bh,09Ch,09Ch,09Dh,09Dh,09Eh,09Eh,09Fh,09Fh,0A0h,0A0h,0A1h
         db       0A1h,0A2h,0A2h,0A3h,0A3h,0A4h,0A4h,0A5h,0A5h,0A5h,0A6h,0A6h,0A7h,0A7h,0A8h,0A8h,0A9h,0A9h,0AAh,0AAh
         db       0ABh,0ABh,0ACh,0ACh,0ADh,0ADh,0AEh,0AEh,0AFh,0AFh,0B0h,0B0h,0B1h,0B1h,0B2h,0B2h,0B3h,0B3h,0B4h,0B4h
         db       0B5h,0B5h,0B6h,0B6h,0B7h,0B7h,0B7h,0B8h,0B8h,0B9h,0B9h,0BAh,0BAh,0BBh,0BBh,0BCh,0BCh,0BDh,0BDh,0BEh
         db       042h,042h,043h,043h,044h,044h,045h,045h,046h,046h,047h,047h,048h,048h,049h,049h,049h,04Ah,04Ah,04Bh
         db       04Bh,04Ch,04Ch,04Dh,04Dh,04Eh,04Eh,04Fh,04Fh,050h,050h,051h,051h,052h,052h,053h,053h,054h,054h,055h
         db       055h,056h,056h,057h,057h,058h,058h,059h,059h,05Ah,05Ah,05Bh,05Bh,05Bh,05Ch,05Ch,05Dh,05Dh,05Eh,05Eh
         db       05Fh,05Fh,060h,060h,061h,061h,062h,062h,063h,063h,064h,064h,065h,065h,066h,066h,067h,067h,068h,068h
         db       069h,069h,06Ah,06Ah,06Bh,06Bh,06Ch,06Ch,06Dh,06Dh,06Eh,06Eh,06Eh,06Fh,06Fh,070h,070h,071h,071h,072h
         db       072h,073h,073h,074h,074h,075h,075h,076h,076h,077h,077h,078h,078h,079h,079h,07Ah,07Ah,07Bh,07Bh,07Ch
         db       07Ch,07Dh,07Dh,07Eh,07Eh,07Fh,07Fh,080h,080h,081h,081h,082h,082h,083h,083h,084h,084h,085h,085h,086h
         db       086h,087h,087h,088h,088h,089h,089h,08Ah,08Ah,08Bh,08Bh,08Ch,08Ch,08Dh,08Dh,08Eh,08Eh,08Fh,08Fh,090h
         db       090h,091h,091h,092h,092h,093h,093h,094h,094h,095h,095h,096h,096h,097h,097h,098h,098h,099h,099h,09Ah
         db       09Ah,09Bh,09Bh,09Ch,09Ch,09Dh,09Dh,09Eh,09Eh,09Fh,09Fh,0A0h,0A0h,0A1h,0A1h,0A2h,0A2h,0A3h,0A3h,0A4h
         db       0A4h,0A5h,0A5h,0A6h,0A6h,0A7h,0A7h,0A8h,0A8h,0A9h,0A9h,0AAh,0AAh,0ABh,0ABh,0ACh,0ACh,0ADh,0ADh,0AEh
         db       0AEh,0AFh,0AFh,0B0h,0B0h,0B1h,0B1h,0B2h,0B2h,0B3h,0B3h,0B4h,0B4h,0B5h,0B5h,0B6h,0B6h,0B7h,0B7h,0B8h
         db       0B8h,0B9h,0B9h,0BAh,0BAh,0BBh,0BBh,0BCh,0BCh,0BDh,0BDh,0BEh,0BEh,0BFh,0BFh,0C0h,040h,040h,041h,041h
         db       042h,042h,043h,043h,044h,044h,045h,045h,046h,046h,047h,047h,048h,048h,049h,049h,04Ah,04Ah,04Bh,04Bh
         db       04Ch,04Ch,04Dh,04Dh,04Eh,04Eh,04Fh,04Fh,050h,050h,051h,051h,052h,052h,053h,053h,054h,054h,055h,055h
         db       056h,056h,057h,057h,058h,058h,059h,059h,05Ah,05Ah,05Bh,05Bh,05Ch,05Ch,05Dh,05Dh,05Eh,05Eh,05Fh,05Fh
         db       060h,060h,061h,061h,062h,062h,063h,063h,064h,064h,065h,065h,066h,066h,067h,067h,068h,068h,069h,069h
         db       06Ah,06Ah,06Bh,06Bh,06Ch,06Ch,06Dh,06Dh,06Eh,06Eh,06Fh,06Fh,070h,070h,071h,071h,072h,072h,073h,073h
         db       074h,074h,075h,075h,076h,076h,077h,077h,078h,078h,079h,079h,07Ah,07Ah,07Bh,07Bh,07Ch,07Ch,07Dh,07Dh
         db       07Eh,07Eh,07Fh,07Fh,080h,081h,081h,082h,082h,083h,083h,084h,084h,085h,085h,086h,086h,087h,087h,088h
         db       088h,089h,089h,08Ah,08Ah,08Bh,08Bh,08Ch,08Ch,08Dh,08Dh,08Eh,08Eh,08Fh,090h,090h,091h,091h,092h,092h
         db       093h,093h,094h,094h,095h,095h,096h,096h,097h,097h,098h,098h,099h,099h,09Ah,09Ah,09Bh,09Bh,09Ch,09Ch
         db       09Dh,09Dh,09Eh,09Eh,09Fh,0A0h,0A0h,0A1h,0A1h,0A2h,0A2h,0A3h,0A3h,0A4h,0A4h,0A5h,0A5h,0A6h,0A6h,0A7h
         db       0A7h,0A8h,0A8h,0A9h,0A9h,0AAh,0AAh,0ABh,0ABh,0ACh,0ACh,0ADh,0ADh,0AEh,0AFh,0AFh,0B0h,0B0h,0B1h,0B1h
         db       0B2h,0B2h,0B3h,0B3h,0B4h,0B4h,0B5h,0B5h,0B6h,0B6h,0B7h,0B7h,0B8h,0B8h,0B9h,0B9h,0BAh,0BAh,0BBh,0BBh
         db       0BCh,0BCh,0BDh,0BEh,0BEh,0BFh,0BFh,0C0h,0C0h,0C1h,0C1h,0C2h,03Eh,03Eh,03Fh,03Fh,040h,040h,041h,041h
         db       042h,042h,043h,044h,044h,045h,045h,046h,046h,047h,047h,048h,048h,049h,049h,04Ah,04Ah,04Bh,04Bh,04Ch
         db       04Ch,04Dh,04Dh,04Eh,04Eh,04Fh,04Fh,050h,050h,051h,051h,052h,053h,053h,054h,054h,055h,055h,056h,056h
         db       057h,057h,058h,058h,059h,059h,05Ah,05Ah,05Bh,05Bh,05Ch,05Ch,05Dh,05Dh,05Eh,05Eh,05Fh,05Fh,060h,060h
         db       061h,062h,062h,063h,063h,064h,064h,065h,065h,066h,066h,067h,067h,068h,068h,069h,069h,06Ah,06Ah,06Bh
         db       06Bh,06Ch,06Ch,06Dh,06Dh,06Eh,06Eh,06Fh,06Fh,070h,070h,071h,072h,072h,073h,073h,074h,074h,075h,075h
         db       076h,076h,077h,077h,078h,078h,079h,079h,07Ah,07Ah,07Bh,07Bh,07Ch,07Ch,07Dh,07Dh,07Eh,07Eh,07Fh,07Fh
         db       080h,081h,081h,082h,082h,083h,083h,084h,084h,085h,085h,086h,086h,087h,087h,088h,089h,089h,08Ah,08Ah
         db       08Bh,08Bh,08Ch,08Ch,08Dh,08Dh,08Eh,08Eh,08Fh,08Fh,090h,091h,091h,092h,092h,093h,093h,094h,094h,095h
         db       095h,096h,096h,097h,097h,098h,098h,099h,09Ah,09Ah,09Bh,09Bh,09Ch,09Ch,09Dh,09Dh,09Eh,09Eh,09Fh,09Fh
         db       0A0h,0A0h,0A1h,0A2h,0A2h,0A3h,0A3h,0A4h,0A4h,0A5h,0A5h,0A6h,0A6h,0A7h,0A7h,0A8h,0A8h,0A9h,0AAh,0AAh
         db       0ABh,0ABh,0ACh,0ACh,0ADh,0ADh,0AEh,0AEh,0AFh,0AFh,0B0h,0B0h,0B1h,0B2h,0B2h,0B3h,0B3h,0B4h,0B4h,0B5h
         db       0B5h,0B6h,0B6h,0B7h,0B7h,0B8h,0B8h,0B9h,0BAh,0BAh,0BBh,0BBh,0BCh,0BCh,0BDh,0BDh,0BEh,0BEh,0BFh,0BFh
         db       0C0h,0C0h,0C1h,0C2h,0C2h,0C3h,0C3h,0C4h,03Ch,03Ch,03Dh,03Dh,03Eh,03Eh,03Fh,040h,040h,041h,041h,042h
         db       042h,043h,043h,044h,044h,045h,045h,046h,046h,047h,048h,048h,049h,049h,04Ah,04Ah,04Bh,04Bh,04Ch,04Ch
         db       04Dh,04Dh,04Eh,04Eh,04Fh,050h,050h,051h,051h,052h,052h,053h,053h,054h,054h,055h,055h,056h,056h,057h
         db       058h,058h,059h,059h,05Ah,05Ah,05Bh,05Bh,05Ch,05Ch,05Dh,05Dh,05Eh,05Eh,05Fh,060h,060h,061h,061h,062h
         db       062h,063h,063h,064h,064h,065h,065h,066h,066h,067h,068h,068h,069h,069h,06Ah,06Ah,06Bh,06Bh,06Ch,06Ch
         db       06Dh,06Dh,06Eh,06Eh,06Fh,06Fh,070h,071h,071h,072h,072h,073h,073h,074h,074h,075h,075h,076h,076h,077h
         db       077h,078h,079h,079h,07Ah,07Ah,07Bh,07Bh,07Ch,07Ch,07Dh,07Dh,07Eh,07Eh,07Fh,07Fh,080h,081h,081h,082h
         db       082h,083h,083h,084h,084h,085h,085h,086h,087h,087h,088h,088h,089h,089h,08Ah,08Ah,08Bh,08Ch,08Ch,08Dh
         db       08Dh,08Eh,08Eh,08Fh,08Fh,090h,090h,091h,092h,092h,093h,093h,094h,094h,095h,095h,096h,097h,097h,098h
         db       098h,099h,099h,09Ah,09Ah,09Bh,09Bh,09Ch,09Dh,09Dh,09Eh,09Eh,09Fh,09Fh,0A0h,0A0h,0A1h,0A1h,0A2h,0A3h
         db       0A3h,0A4h,0A4h,0A5h,0A5h,0A6h,0A6h,0A7h,0A8h,0A8h,0A9h,0A9h,0AAh,0AAh,0ABh,0ABh,0ACh,0ACh,0ADh,0AEh
         db       0AEh,0AFh,0AFh,0B0h,0B0h,0B1h,0B1h,0B2h,0B2h,0B3h,0B4h,0B4h,0B5h,0B5h,0B6h,0B6h,0B7h,0B7h,0B8h,0B9h
         db       0B9h,0BAh,0BAh,0BBh,0BBh,0BCh,0BCh,0BDh,0BDh,0BEh,0BFh,0BFh,0C0h,0C0h,0C1h,0C1h,0C2h,0C2h,0C3h,0C4h
         db       0C4h,0C5h,0C5h,0C6h,03Ah,03Ah,03Bh,03Bh,03Ch,03Ch,03Dh,03Eh,03Eh,03Fh,03Fh,040h,040h,041h,041h,042h
         db       043h,043h,044h,044h,045h,045h,046h,046h,047h,047h,048h,049h,049h,04Ah,04Ah,04Bh,04Bh,04Ch,04Ch,04Dh
         db       04Eh,04Eh,04Fh,04Fh,050h,050h,051h,051h,052h,052h,053h,054h,054h,055h,055h,056h,056h,057h,057h,058h
         db       058h,059h,05Ah,05Ah,05Bh,05Bh,05Ch,05Ch,05Dh,05Dh,05Eh,05Fh,05Fh,060h,060h,061h,061h,062h,062h,063h
         db       063h,064h,065h,065h,066h,066h,067h,067h,068h,068h,069h,069h,06Ah,06Bh,06Bh,06Ch,06Ch,06Dh,06Dh,06Eh
         db       06Eh,06Fh,070h,070h,071h,071h,072h,072h,073h,073h,074h,074h,075h,076h,076h,077h,077h,078h,078h,079h
         db       079h,07Ah,07Bh,07Bh,07Ch,07Ch,07Dh,07Dh,07Eh,07Eh,07Fh,07Fh,080h,081h,081h,082h,082h,083h,083h,084h
         db       084h,085h,086h,086h,087h,087h,088h,088h,089h,08Ah,08Ah,08Bh,08Bh,08Ch,08Ch,08Dh,08Dh,08Eh,08Fh,08Fh
         db       090h,090h,091h,091h,092h,092h,093h,094h,094h,095h,095h,096h,096h,097h,098h,098h,099h,099h,09Ah,09Ah
         db       09Bh,09Bh,09Ch,09Dh,09Dh,09Eh,09Eh,09Fh,09Fh,0A0h,0A0h,0A1h,0A2h,0A2h,0A3h,0A3h,0A4h,0A4h,0A5h,0A6h
         db       0A6h,0A7h,0A7h,0A8h,0A8h,0A9h,0A9h,0AAh,0ABh,0ABh,0ACh,0ACh,0ADh,0ADh,0AEh,0AEh,0AFh,0B0h,0B0h,0B1h
         db       0B1h,0B2h,0B2h,0B3h,0B4h,0B4h,0B5h,0B5h,0B6h,0B6h,0B7h,0B7h,0B8h,0B9h,0B9h,0BAh,0BAh,0BBh,0BBh,0BCh
         db       0BCh,0BDh,0BEh,0BEh,0BFh,0BFh,0C0h,0C0h,0C1h,0C2h,0C2h,0C3h,0C3h,0C4h,0C4h,0C5h,0C5h,0C6h,0C7h,0C7h
         db       038h,039h,039h,03Ah,03Bh,03Bh,03Ch,03Ch,03Dh,03Dh,03Eh,03Eh,03Fh,040h,040h,041h,041h,042h,042h,043h
         db       044h,044h,045h,045h,046h,046h,047h,047h,048h,049h,049h,04Ah,04Ah,04Bh,04Bh,04Ch,04Ch,04Dh,04Eh,04Eh
         db       04Fh,04Fh,050h,050h,051h,052h,052h,053h,053h,054h,054h,055h,055h,056h,057h,057h,058h,058h,059h,059h
         db       05Ah,05Ah,05Bh,05Ch,05Ch,05Dh,05Dh,05Eh,05Eh,05Fh,060h,060h,061h,061h,062h,062h,063h,063h,064h,065h
         db       065h,066h,066h,067h,067h,068h,068h,069h,06Ah,06Ah,06Bh,06Bh,06Ch,06Ch,06Dh,06Eh,06Eh,06Fh,06Fh,070h
         db       070h,071h,071h,072h,073h,073h,074h,074h,075h,075h,076h,076h,077h,078h,078h,079h,079h,07Ah,07Ah,07Bh
         db       07Ch,07Ch,07Dh,07Dh,07Eh,07Eh,07Fh,07Fh,080h,081h,081h,082h,082h,083h,083h,084h,085h,085h,086h,086h
         db       087h,088h,088h,089h,089h,08Ah,08Ah,08Bh,08Ch,08Ch,08Dh,08Dh,08Eh,08Eh,08Fh,090h,090h,091h,091h,092h
         db       092h,093h,094h,094h,095h,095h,096h,097h,097h,098h,098h,099h,099h,09Ah,09Bh,09Bh,09Ch,09Ch,09Dh,09Dh
         db       09Eh,09Fh,09Fh,0A0h,0A0h,0A1h,0A1h,0A2h,0A3h,0A3h,0A4h,0A4h,0A5h,0A6h,0A6h,0A7h,0A7h,0A8h,0A8h,0A9h
         db       0AAh,0AAh,0ABh,0ABh,0ACh,0ACh,0ADh,0AEh,0AEh,0AFh,0AFh,0B0h,0B0h,0B1h,0B2h,0B2h,0B3h,0B3h,0B4h,0B5h
         db       0B5h,0B6h,0B6h,0B7h,0B7h,0B8h,0B9h,0B9h,0BAh,0BAh,0BBh,0BBh,0BCh,0BDh,0BDh,0BEh,0BEh,0BFh,0BFh,0C0h
         db       0C1h,0C1h,0C2h,0C2h,0C3h,0C4h,0C4h,0C5h,0C5h,0C6h,0C6h,0C7h,0C8h,0C8h,0C9h,0C9h,036h,037h,037h,038h
         db       038h,039h,03Ah,03Ah,03Bh,03Bh,03Ch,03Ch,03Dh,03Eh,03Eh,03Fh,03Fh,040h,041h,041h,042h,042h,043h,043h
         db       044h,045h,045h,046h,046h,047h,047h,048h,049h,049h,04Ah,04Ah,04Bh,04Bh,04Ch,04Dh,04Dh,04Eh,04Eh,04Fh
         db       050h,050h,051h,051h,052h,052h,053h,054h,054h,055h,055h,056h,056h,057h,058h,058h,059h,059h,05Ah,05Ah
         db       05Bh,05Ch,05Ch,05Dh,05Dh,05Eh,05Fh,05Fh,060h,060h,061h,061h,062h,063h,063h,064h,064h,065h,065h,066h
         db       067h,067h,068h,068h,069h,069h,06Ah,06Bh,06Bh,06Ch,06Ch,06Dh,06Eh,06Eh,06Fh,06Fh,070h,070h,071h,072h
         db       072h,073h,073h,074h,074h,075h,076h,076h,077h,077h,078h,078h,079h,07Ah,07Ah,07Bh,07Bh,07Ch,07Dh,07Dh
         db       07Eh,07Eh,07Fh,07Fh,080h,081h,081h,082h,082h,083h,084h,084h,085h,085h,086h,087h,087h,088h,088h,089h
         db       08Ah,08Ah,08Bh,08Bh,08Ch,08Ch,08Dh,08Eh,08Eh,08Fh,08Fh,090h,091h,091h,092h,092h,093h,094h,094h,095h
         db       095h,096h,097h,097h,098h,098h,099h,09Ah,09Ah,09Bh,09Bh,09Ch,09Dh,09Dh,09Eh,09Eh,09Fh,0A0h,0A0h,0A1h
         db       0A1h,0A2h,0A2h,0A3h,0A4h,0A4h,0A5h,0A5h,0A6h,0A7h,0A7h,0A8h,0A8h,0A9h,0AAh,0AAh,0ABh,0ABh,0ACh,0ADh
         db       0ADh,0AEh,0AEh,0AFh,0B0h,0B0h,0B1h,0B1h,0B2h,0B3h,0B3h,0B4h,0B4h,0B5h,0B6h,0B6h,0B7h,0B7h,0B8h,0B8h
         db       0B9h,0BAh,0BAh,0BBh,0BBh,0BCh,0BDh,0BDh,0BEh,0BEh,0BFh,0C0h,0C0h,0C1h,0C1h,0C2h,0C3h,0C3h,0C4h,0C4h
         db       0C5h,0C6h,0C6h,0C7h,0C7h,0C8h,0C9h,0C9h,0CAh,0CAh,0CBh,0CCh,034h,034h,035h,036h,036h,037h,037h,038h
         db       039h,039h,03Ah,03Ah,03Bh,03Ch,03Ch,03Dh,03Dh,03Eh,03Fh,03Fh,040h,040h,041h,042h,042h,043h,043h,044h
         db       045h,045h,046h,046h,047h,048h,048h,049h,049h,04Ah,04Ah,04Bh,04Ch,04Ch,04Dh,04Dh,04Eh,04Fh,04Fh,050h
         db       050h,051h,052h,052h,053h,053h,054h,055h,055h,056h,056h,057h,058h,058h,059h,059h,05Ah,05Bh,05Bh,05Ch
         db       05Ch,05Dh,05Eh,05Eh,05Fh,05Fh,060h,060h,061h,062h,062h,063h,063h,064h,065h,065h,066h,066h,067h,068h
         db       068h,069h,069h,06Ah,06Bh,06Bh,06Ch,06Ch,06Dh,06Eh,06Eh,06Fh,06Fh,070h,071h,071h,072h,072h,073h,074h
         db       074h,075h,075h,076h,076h,077h,078h,078h,079h,079h,07Ah,07Bh,07Bh,07Ch,07Ch,07Dh,07Eh,07Eh,07Fh,07Fh
         db       080h,081h,081h,082h,082h,083h,084h,084h,085h,085h,086h,087h,087h,088h,088h,089h,08Ah,08Ah,08Bh,08Ch
         db       08Ch,08Dh,08Dh,08Eh,08Fh,08Fh,090h,090h,091h,092h,092h,093h,093h,094h,095h,095h,096h,096h,097h,098h
         db       098h,099h,099h,09Ah,09Bh,09Bh,09Ch,09Dh,09Dh,09Eh,09Eh,09Fh,0A0h,0A0h,0A1h,0A1h,0A2h,0A3h,0A3h,0A4h
         db       0A4h,0A5h,0A6h,0A6h,0A7h,0A7h,0A8h,0A9h,0A9h,0AAh,0AAh,0ABh,0ACh,0ACh,0ADh,0ADh,0AEh,0AFh,0AFh,0B0h
         db       0B1h,0B1h,0B2h,0B2h,0B3h,0B4h,0B4h,0B5h,0B5h,0B6h,0B7h,0B7h,0B8h,0B8h,0B9h,0BAh,0BAh,0BBh,0BBh,0BCh
         db       0BDh,0BDh,0BEh,0BEh,0BFh,0C0h,0C0h,0C1h,0C2h,0C2h,0C3h,0C3h,0C4h,0C5h,0C5h,0C6h,0C6h,0C7h,0C8h,0C8h
         db       0C9h,0C9h,0CAh,0CBh,0CBh,0CCh,0CCh,0CDh,032h,033h,034h,034h,035h,035h,036h,037h,037h,038h,038h,039h
         db       03Ah,03Ah,03Bh,03Bh,03Ch,03Dh,03Dh,03Eh,03Eh,03Fh,040h,040h,041h,042h,042h,043h,043h,044h,045h,045h
         db       046h,046h,047h,048h,048h,049h,049h,04Ah,04Bh,04Bh,04Ch,04Ch,04Dh,04Eh,04Eh,04Fh,04Fh,050h,051h,051h
         db       052h,053h,053h,054h,054h,055h,056h,056h,057h,057h,058h,059h,059h,05Ah,05Ah,05Bh,05Ch,05Ch,05Dh,05Dh
         db       05Eh,05Fh,05Fh,060h,060h,061h,062h,062h,063h,063h,064h,065h,065h,066h,067h,067h,068h,068h,069h,06Ah
         db       06Ah,06Bh,06Bh,06Ch,06Dh,06Dh,06Eh,06Eh,06Fh,070h,070h,071h,071h,072h,073h,073h,074h,074h,075h,076h
         db       076h,077h,078h,078h,079h,079h,07Ah,07Bh,07Bh,07Ch,07Ch,07Dh,07Eh,07Eh,07Fh,07Fh,080h,081h,081h,082h
         db       082h,083h,084h,084h,085h,086h,086h,087h,087h,088h,089h,089h,08Ah,08Bh,08Bh,08Ch,08Ch,08Dh,08Eh,08Eh
         db       08Fh,08Fh,090h,091h,091h,092h,093h,093h,094h,094h,095h,096h,096h,097h,098h,098h,099h,099h,09Ah,09Bh
         db       09Bh,09Ch,09Ch,09Dh,09Eh,09Eh,09Fh,0A0h,0A0h,0A1h,0A1h,0A2h,0A3h,0A3h,0A4h,0A5h,0A5h,0A6h,0A6h,0A7h
         db       0A8h,0A8h,0A9h,0A9h,0AAh,0ABh,0ABh,0ACh,0ADh,0ADh,0AEh,0AEh,0AFh,0B0h,0B0h,0B1h,0B2h,0B2h,0B3h,0B3h
         db       0B4h,0B5h,0B5h,0B6h,0B6h,0B7h,0B8h,0B8h,0B9h,0BAh,0BAh,0BBh,0BBh,0BCh,0BDh,0BDh,0BEh,0BEh,0BFh,0C0h
         db       0C0h,0C1h,0C2h,0C2h,0C3h,0C3h,0C4h,0C5h,0C5h,0C6h,0C7h,0C7h,0C8h,0C8h,0C9h,0CAh,0CAh,0CBh,0CBh,0CCh
         db       0CDh,0CDh,0CEh,0CFh,031h,031h,032h,033h,033h,034h,035h,035h,036h,036h,037h,038h,038h,039h,039h,03Ah
         db       03Bh,03Bh,03Ch,03Dh,03Dh,03Eh,03Eh,03Fh,040h,040h,041h,042h,042h,043h,043h,044h,045h,045h,046h,046h
         db       047h,048h,048h,049h,04Ah,04Ah,04Bh,04Bh,04Ch,04Dh,04Dh,04Eh,04Eh,04Fh,050h,050h,051h,052h,052h,053h
         db       053h,054h,055h,055h,056h,057h,057h,058h,058h,059h,05Ah,05Ah,05Bh,05Bh,05Ch,05Dh,05Dh,05Eh,05Fh,05Fh
         db       060h,060h,061h,062h,062h,063h,064h,064h,065h,065h,066h,067h,067h,068h,068h,069h,06Ah,06Ah,06Bh,06Ch
         db       06Ch,06Dh,06Dh,06Eh,06Fh,06Fh,070h,071h,071h,072h,072h,073h,074h,074h,075h,075h,076h,077h,077h,078h
         db       079h,079h,07Ah,07Ah,07Bh,07Ch,07Ch,07Dh,07Eh,07Eh,07Fh,07Fh,080h,081h,081h,082h,083h,083h,084h,084h
         db       085h,086h,086h,087h,088h,088h,089h,08Ah,08Ah,08Bh,08Bh,08Ch,08Dh,08Dh,08Eh,08Fh,08Fh,090h,091h,091h
         db       092h,092h,093h,094h,094h,095h,096h,096h,097h,098h,098h,099h,09Ah,09Ah,09Bh,09Bh,09Ch,09Dh,09Dh,09Eh
         db       09Fh,09Fh,0A0h,0A1h,0A1h,0A2h,0A2h,0A3h,0A4h,0A4h,0A5h,0A6h,0A6h,0A7h,0A8h,0A8h,0A9h,0A9h,0AAh,0ABh
         db       0ABh,0ACh,0ADh,0ADh,0AEh,0AFh,0AFh,0B0h,0B0h,0B1h,0B2h,0B2h,0B3h,0B4h,0B4h,0B5h,0B6h,0B6h,0B7h,0B7h
         db       0B8h,0B9h,0B9h,0BAh,0BBh,0BBh,0BCh,0BDh,0BDh,0BEh,0BEh,0BFh,0C0h,0C0h,0C1h,0C2h,0C2h,0C3h,0C4h,0C4h
         db       0C5h,0C6h,0C6h,0C7h,0C7h,0C8h,0C9h,0C9h,0CAh,0CBh,0CBh,0CCh,0CDh,0CDh,0CEh,0CEh,0CFh,0D0h,0D0h,0D1h
         db       02Eh,02Fh,030h,030h,031h,032h,032h,033h,033h,034h,035h,035h,036h,037h,037h,038h,039h,039h,03Ah,03Ah
         db       03Bh,03Ch,03Ch,03Dh,03Eh,03Eh,03Fh,040h,040h,041h,042h,042h,043h,043h,044h,045h,045h,046h,047h,047h
         db       048h,049h,049h,04Ah,04Ah,04Bh,04Ch,04Ch,04Dh,04Eh,04Eh,04Fh,050h,050h,051h,051h,052h,053h,053h,054h
         db       055h,055h,056h,057h,057h,058h,058h,059h,05Ah,05Ah,05Bh,05Ch,05Ch,05Dh,05Eh,05Eh,05Fh,05Fh,060h,061h
         db       061h,062h,063h,063h,064h,065h,065h,066h,066h,067h,068h,068h,069h,06Ah,06Ah,06Bh,06Ch,06Ch,06Dh,06Eh
         db       06Eh,06Fh,06Fh,070h,071h,071h,072h,073h,073h,074h,075h,075h,076h,076h,077h,078h,078h,079h,07Ah,07Ah
         db       07Bh,07Ch,07Ch,07Dh,07Dh,07Eh,07Fh,07Fh,080h,081h,081h,082h,083h,083h,084h,085h,085h,086h,087h,087h
         db       088h,088h,089h,08Ah,08Ah,08Bh,08Ch,08Ch,08Dh,08Eh,08Eh,08Fh,090h,090h,091h,092h,092h,093h,094h,094h
         db       095h,095h,096h,097h,097h,098h,099h,099h,09Ah,09Bh,09Bh,09Ch,09Dh,09Dh,09Eh,09Fh,09Fh,0A0h,0A1h,0A1h
         db       0A2h,0A2h,0A3h,0A4h,0A4h,0A5h,0A6h,0A6h,0A7h,0A8h,0A8h,0A9h,0AAh,0AAh,0ABh,0ACh,0ACh,0ADh,0AEh,0AEh
         db       0AFh,0AFh,0B0h,0B1h,0B1h,0B2h,0B3h,0B3h,0B4h,0B5h,0B5h,0B6h,0B7h,0B7h,0B8h,0B9h,0B9h,0BAh,0BBh,0BBh
         db       0BCh,0BCh,0BDh,0BEh,0BEh,0BFh,0C0h,0C0h,0C1h,0C2h,0C2h,0C3h,0C4h,0C4h,0C5h,0C6h,0C6h,0C7h,0C8h,0C8h
         db       0C9h,0CAh,0CAh,0CBh,0CBh,0CCh,0CDh,0CDh,0CEh,0CFh,0CFh,0D0h,0D1h,0D1h,0D2h,0D3h,02Dh,02Dh,02Eh,02Fh
         db       02Fh,030h,031h,031h,032h,033h,033h,034h,035h,035h,036h,036h,037h,038h,038h,039h,03Ah,03Ah,03Bh,03Ch
         db       03Ch,03Dh,03Eh,03Eh,03Fh,040h,040h,041h,042h,042h,043h,044h,044h,045h,045h,046h,047h,047h,048h,049h
         db       049h,04Ah,04Bh,04Bh,04Ch,04Dh,04Dh,04Eh,04Fh,04Fh,050h,051h,051h,052h,052h,053h,054h,054h,055h,056h
         db       056h,057h,058h,058h,059h,05Ah,05Ah,05Bh,05Ch,05Ch,05Dh,05Eh,05Eh,05Fh,05Fh,060h,061h,061h,062h,063h
         db       063h,064h,065h,065h,066h,067h,067h,068h,069h,069h,06Ah,06Bh,06Bh,06Ch,06Ch,06Dh,06Eh,06Eh,06Fh,070h
         db       070h,071h,072h,072h,073h,074h,074h,075h,076h,076h,077h,078h,078h,079h,079h,07Ah,07Bh,07Bh,07Ch,07Dh
         db       07Dh,07Eh,07Fh,07Fh,080h,081h,081h,082h,083h,083h,084h,085h,085h,086h,087h,087h,088h,089h,089h,08Ah
         db       08Bh,08Bh,08Ch,08Dh,08Dh,08Eh,08Fh,08Fh,090h,091h,091h,092h,093h,093h,094h,095h,095h,096h,097h,097h
         db       098h,099h,099h,09Ah,09Bh,09Bh,09Ch,09Dh,09Dh,09Eh,09Fh,09Fh,0A0h,0A1h,0A1h,0A2h,0A3h,0A3h,0A4h,0A5h
         db       0A5h,0A6h,0A6h,0A7h,0A8h,0A8h,0A9h,0AAh,0AAh,0ABh,0ACh,0ACh,0ADh,0AEh,0AEh,0AFh,0B0h,0B0h,0B1h,0B2h
         db       0B2h,0B3h,0B4h,0B4h,0B5h,0B6h,0B6h,0B7h,0B8h,0B8h,0B9h,0BAh,0BAh,0BBh,0BCh,0BCh,0BDh,0BEh,0BEh,0BFh
         db       0C0h,0C0h,0C1h,0C2h,0C2h,0C3h,0C4h,0C4h,0C5h,0C6h,0C6h,0C7h,0C8h,0C8h,0C9h,0CAh,0CAh,0CBh,0CCh,0CCh
         db       0CDh,0CEh,0CEh,0CFh,0D0h,0D0h,0D1h,0D2h,0D2h,0D3h,0D4h,0D4h,02Bh,02Ch,02Ch,02Dh,02Eh,02Eh,02Fh,030h
         db       030h,031h,032h,032h,033h,034h,034h,035h,036h,036h,037h,038h,038h,039h,03Ah,03Ah,03Bh,03Ch,03Ch,03Dh
         db       03Eh,03Eh,03Fh,040h,040h,041h,042h,042h,043h,044h,044h,045h,046h,046h,047h,048h,048h,049h,04Ah,04Ah
         db       04Bh,04Ch,04Ch,04Dh,04Eh,04Eh,04Fh,050h,050h,051h,052h,052h,053h,054h,054h,055h,056h,056h,057h,058h
         db       058h,059h,05Ah,05Ah,05Bh,05Bh,05Ch,05Dh,05Dh,05Eh,05Fh,05Fh,060h,061h,061h,062h,063h,063h,064h,065h
         db       065h,066h,067h,067h,068h,069h,069h,06Ah,06Bh,06Bh,06Ch,06Dh,06Dh,06Eh,06Fh,06Fh,070h,071h,071h,072h
         db       073h,073h,074h,075h,075h,076h,077h,077h,078h,079h,079h,07Ah,07Bh,07Bh,07Ch,07Dh,07Dh,07Eh,07Fh,07Fh
         db       080h,081h,081h,082h,083h,083h,084h,085h,085h,086h,087h,087h,088h,089h,089h,08Ah,08Bh,08Ch,08Ch,08Dh
         db       08Eh,08Eh,08Fh,090h,090h,091h,092h,092h,093h,094h,094h,095h,096h,096h,097h,098h,098h,099h,09Ah,09Ah
         db       09Bh,09Ch,09Ch,09Dh,09Eh,09Eh,09Fh,0A0h,0A0h,0A1h,0A2h,0A3h,0A3h,0A4h,0A5h,0A5h,0A6h,0A7h,0A7h,0A8h
         db       0A9h,0A9h,0AAh,0ABh,0ABh,0ACh,0ADh,0ADh,0AEh,0AFh,0AFh,0B0h,0B1h,0B1h,0B2h,0B3h,0B3h,0B4h,0B5h,0B5h
         db       0B6h,0B7h,0B8h,0B8h,0B9h,0BAh,0BAh,0BBh,0BCh,0BCh,0BDh,0BEh,0BEh,0BFh,0C0h,0C0h,0C1h,0C2h,0C2h,0C3h
         db       0C4h,0C4h,0C5h,0C6h,0C6h,0C7h,0C8h,0C8h,0C9h,0CAh,0CAh,0CBh,0CCh,0CDh,0CDh,0CEh,0CFh,0CFh,0D0h,0D1h
         db       0D1h,0D2h,0D3h,0D3h,0D4h,0D5h,0D5h,0D6h,029h,02Ah,02Bh,02Bh,02Ch,02Dh,02Dh,02Eh,02Fh,02Fh,030h,031h
         db       031h,032h,033h,033h,034h,035h,036h,036h,037h,038h,038h,039h,03Ah,03Ah,03Bh,03Ch,03Ch,03Dh,03Eh,03Eh
         db       03Fh,040h,040h,041h,042h,042h,043h,044h,044h,045h,046h,046h,047h,048h,048h,049h,04Ah,04Bh,04Bh,04Ch
         db       04Dh,04Dh,04Eh,04Fh,04Fh,050h,051h,051h,052h,053h,053h,054h,055h,055h,056h,057h,057h,058h,059h,059h
         db       05Ah,05Bh,05Bh,05Ch,05Dh,05Dh,05Eh,05Fh,060h,060h,061h,062h,062h,063h,064h,064h,065h,066h,066h,067h
         db       068h,068h,069h,06Ah,06Ah,06Bh,06Ch,06Ch,06Dh,06Eh,06Eh,06Fh,070h,070h,071h,072h,072h,073h,074h,074h
         db       075h,076h,077h,077h,078h,079h,079h,07Ah,07Bh,07Bh,07Ch,07Dh,07Dh,07Eh,07Fh,07Fh,080h,081h,081h,082h
         db       083h,083h,084h,085h,086h,086h,087h,088h,088h,089h,08Ah,08Ah,08Bh,08Ch,08Ch,08Dh,08Eh,08Fh,08Fh,090h
         db       091h,091h,092h,093h,093h,094h,095h,095h,096h,097h,097h,098h,099h,09Ah,09Ah,09Bh,09Ch,09Ch,09Dh,09Eh
         db       09Eh,09Fh,0A0h,0A0h,0A1h,0A2h,0A3h,0A3h,0A4h,0A5h,0A5h,0A6h,0A7h,0A7h,0A8h,0A9h,0A9h,0AAh,0ABh,0ACh
         db       0ACh,0ADh,0AEh,0AEh,0AFh,0B0h,0B0h,0B1h,0B2h,0B2h,0B3h,0B4h,0B4h,0B5h,0B6h,0B7h,0B7h,0B8h,0B9h,0B9h
         db       0BAh,0BBh,0BBh,0BCh,0BDh,0BDh,0BEh,0BFh,0C0h,0C0h,0C1h,0C2h,0C2h,0C3h,0C4h,0C4h,0C5h,0C6h,0C6h,0C7h
         db       0C8h,0C9h,0C9h,0CAh,0CBh,0CBh,0CCh,0CDh,0CDh,0CEh,0CFh,0CFh,0D0h,0D1h,0D2h,0D2h,0D3h,0D4h,0D4h,0D5h
         db       0D6h,0D6h,0D7h,0D8h,028h,028h,029h,02Ah,02Ah,02Bh,02Ch,02Ch,02Dh,02Eh,02Eh,02Fh,030h,031h,031h,032h
         db       033h,033h,034h,035h,035h,036h,037h,037h,038h,039h,03Ah,03Ah,03Bh,03Ch,03Ch,03Dh,03Eh,03Eh,03Fh,040h
         db       040h,041h,042h,043h,043h,044h,045h,045h,046h,047h,047h,048h,049h,049h,04Ah,04Bh,04Ch,04Ch,04Dh,04Eh
         db       04Eh,04Fh,050h,050h,051h,052h,052h,053h,054h,054h,055h,056h,057h,057h,058h,059h,059h,05Ah,05Bh,05Bh
         db       05Ch,05Dh,05Dh,05Eh,05Fh,060h,060h,061h,062h,062h,063h,064h,064h,065h,066h,066h,067h,068h,069h,069h
         db       06Ah,06Bh,06Bh,06Ch,06Dh,06Dh,06Eh,06Fh,06Fh,070h,071h,071h,072h,073h,074h,074h,075h,076h,076h,077h
         db       078h,078h,079h,07Ah,07Ah,07Bh,07Ch,07Dh,07Dh,07Eh,07Fh,07Fh,080h,081h,081h,082h,083h,084h,084h,085h
         db       086h,086h,087h,088h,088h,089h,08Ah,08Bh,08Bh,08Ch,08Dh,08Dh,08Eh,08Fh,090h,090h,091h,092h,092h,093h
         db       094h,094h,095h,096h,097h,097h,098h,099h,099h,09Ah,09Bh,09Bh,09Ch,09Dh,09Eh,09Eh,09Fh,0A0h,0A0h,0A1h
         db       0A2h,0A3h,0A3h,0A4h,0A5h,0A5h,0A6h,0A7h,0A7h,0A8h,0A9h,0AAh,0AAh,0ABh,0ACh,0ACh,0ADh,0AEh,0AFh,0AFh
         db       0B0h,0B1h,0B1h,0B2h,0B3h,0B3h,0B4h,0B5h,0B6h,0B6h,0B7h,0B8h,0B8h,0B9h,0BAh,0BAh,0BBh,0BCh,0BDh,0BDh
         db       0BEh,0BFh,0BFh,0C0h,0C1h,0C2h,0C2h,0C3h,0C4h,0C4h,0C5h,0C6h,0C6h,0C7h,0C8h,0C9h,0C9h,0CAh,0CBh,0CBh
         db       0CCh,0CDh,0CEh,0CEh,0CFh,0D0h,0D0h,0D1h,0D2h,0D2h,0D3h,0D4h,0D5h,0D5h,0D6h,0D7h,0D7h,0D8h,0D9h,0D9h
         db       026h,027h,027h,028h,029h,029h,02Ah,02Bh,02Bh,02Ch,02Dh,02Eh,02Eh,02Fh,030h,030h,031h,032h,032h,033h
         db       034h,035h,035h,036h,037h,037h,038h,039h,03Ah,03Ah,03Bh,03Ch,03Ch,03Dh,03Eh,03Eh,03Fh,040h,041h,041h
         db       042h,043h,043h,044h,045h,046h,046h,047h,048h,048h,049h,04Ah,04Ah,04Bh,04Ch,04Dh,04Dh,04Eh,04Fh,04Fh
         db       050h,051h,051h,052h,053h,054h,054h,055h,056h,056h,057h,058h,059h,059h,05Ah,05Bh,05Bh,05Ch,05Dh,05Dh
         db       05Eh,05Fh,060h,060h,061h,062h,062h,063h,064h,065h,065h,066h,067h,067h,068h,069h,069h,06Ah,06Bh,06Ch
         db       06Ch,06Dh,06Eh,06Eh,06Fh,070h,070h,071h,072h,073h,073h,074h,075h,075h,076h,077h,078h,078h,079h,07Ah
         db       07Ah,07Bh,07Ch,07Ch,07Dh,07Eh,07Fh,07Fh,080h,081h,081h,082h,083h,084h,084h,085h,086h,086h,087h,088h
         db       089h,089h,08Ah,08Bh,08Ch,08Ch,08Dh,08Eh,08Eh,08Fh,090h,091h,091h,092h,093h,093h,094h,095h,096h,096h
         db       097h,098h,098h,099h,09Ah,09Bh,09Bh,09Ch,09Dh,09Dh,09Eh,09Fh,0A0h,0A0h,0A1h,0A2h,0A3h,0A3h,0A4h,0A5h
         db       0A5h,0A6h,0A7h,0A8h,0A8h,0A9h,0AAh,0AAh,0ABh,0ACh,0ADh,0ADh,0AEh,0AFh,0AFh,0B0h,0B1h,0B2h,0B2h,0B3h
         db       0B4h,0B4h,0B5h,0B6h,0B7h,0B7h,0B8h,0B9h,0BAh,0BAh,0BBh,0BCh,0BCh,0BDh,0BEh,0BFh,0BFh,0C0h,0C1h,0C1h
         db       0C2h,0C3h,0C4h,0C4h,0C5h,0C6h,0C6h,0C7h,0C8h,0C9h,0C9h,0CAh,0CBh,0CBh,0CCh,0CDh,0CEh,0CEh,0CFh,0D0h
         db       0D1h,0D1h,0D2h,0D3h,0D3h,0D4h,0D5h,0D6h,0D6h,0D7h,0D8h,0D8h,0D9h,0DAh,0DBh,0DBh,024h,025h,025h,026h
         db       027h,028h,028h,029h,02Ah,02Ah,02Bh,02Ch,02Dh,02Dh,02Eh,02Fh,02Fh,030h,031h,032h,032h,033h,034h,035h
         db       035h,036h,037h,037h,038h,039h,03Ah,03Ah,03Bh,03Ch,03Ch,03Dh,03Eh,03Fh,03Fh,040h,041h,041h,042h,043h
         db       044h,044h,045h,046h,046h,047h,048h,049h,049h,04Ah,04Bh,04Ch,04Ch,04Dh,04Eh,04Eh,04Fh,050h,051h,051h
         db       052h,053h,053h,054h,055h,056h,056h,057h,058h,058h,059h,05Ah,05Bh,05Bh,05Ch,05Dh,05Dh,05Eh,05Fh,060h
         db       060h,061h,062h,063h,063h,064h,065h,065h,066h,067h,068h,068h,069h,06Ah,06Ah,06Bh,06Ch,06Dh,06Dh,06Eh
         db       06Fh,06Fh,070h,071h,072h,072h,073h,074h,074h,075h,076h,077h,077h,078h,079h,07Ah,07Ah,07Bh,07Ch,07Ch
         db       07Dh,07Eh,07Fh,07Fh,080h,081h,081h,082h,083h,084h,084h,085h,086h,087h,087h,088h,089h,08Ah,08Ah,08Bh
         db       08Ch,08Ch,08Dh,08Eh,08Fh,08Fh,090h,091h,092h,092h,093h,094h,095h,095h,096h,097h,097h,098h,099h,09Ah
         db       09Ah,09Bh,09Ch,09Dh,09Dh,09Eh,09Fh,0A0h,0A0h,0A1h,0A2h,0A2h,0A3h,0A4h,0A5h,0A5h,0A6h,0A7h,0A8h,0A8h
         db       0A9h,0AAh,0ABh,0ABh,0ACh,0ADh,0ADh,0AEh,0AFh,0B0h,0B0h,0B1h,0B2h,0B3h,0B3h,0B4h,0B5h,0B6h,0B6h,0B7h
         db       0B8h,0B8h,0B9h,0BAh,0BBh,0BBh,0BCh,0BDh,0BEh,0BEh,0BFh,0C0h,0C1h,0C1h,0C2h,0C3h,0C3h,0C4h,0C5h,0C6h
         db       0C6h,0C7h,0C8h,0C9h,0C9h,0CAh,0CBh,0CCh,0CCh,0CDh,0CEh,0CEh,0CFh,0D0h,0D1h,0D1h,0D2h,0D3h,0D4h,0D4h
         db       0D5h,0D6h,0D7h,0D7h,0D8h,0D9h,0D9h,0DAh,0DBh,0DCh,0DCh,0DDh,022h,023h,024h,024h,025h,026h,027h,027h
         db       028h,029h,029h,02Ah,02Bh,02Ch,02Ch,02Dh,02Eh,02Fh,02Fh,030h,031h,032h,032h,033h,034h,034h,035h,036h
         db       037h,037h,038h,039h,03Ah,03Ah,03Bh,03Ch,03Dh,03Dh,03Eh,03Fh,03Fh,040h,041h,042h,042h,043h,044h,045h
         db       045h,046h,047h,048h,048h,049h,04Ah,04Ah,04Bh,04Ch,04Dh,04Dh,04Eh,04Fh,050h,050h,051h,052h,053h,053h
         db       054h,055h,055h,056h,057h,058h,058h,059h,05Ah,05Bh,05Bh,05Ch,05Dh,05Eh,05Eh,05Fh,060h,060h,061h,062h
         db       063h,063h,064h,065h,066h,066h,067h,068h,069h,069h,06Ah,06Bh,06Bh,06Ch,06Dh,06Eh,06Eh,06Fh,070h,071h
         db       071h,072h,073h,074h,074h,075h,076h,076h,077h,078h,079h,079h,07Ah,07Bh,07Ch,07Ch,07Dh,07Eh,07Fh,07Fh
         db       080h,081h,081h,082h,083h,084h,084h,085h,086h,087h,087h,088h,089h,08Ah,08Ah,08Bh,08Ch,08Dh,08Dh,08Eh
         db       08Fh,090h,090h,091h,092h,093h,093h,094h,095h,096h,096h,097h,098h,099h,099h,09Ah,09Bh,09Ch,09Ch,09Dh
         db       09Eh,09Fh,09Fh,0A0h,0A1h,0A2h,0A2h,0A3h,0A4h,0A5h,0A5h,0A6h,0A7h,0A8h,0A8h,0A9h,0AAh,0ABh,0ABh,0ACh
         db       0ADh,0AEh,0AEh,0AFh,0B0h,0B1h,0B1h,0B2h,0B3h,0B4h,0B4h,0B5h,0B6h,0B7h,0B7h,0B8h,0B9h,0BAh,0BAh,0BBh
         db       0BCh,0BDh,0BDh,0BEh,0BFh,0C0h,0C0h,0C1h,0C2h,0C3h,0C3h,0C4h,0C5h,0C6h,0C6h,0C7h,0C8h,0C9h,0C9h,0CAh
         db       0CBh,0CCh,0CCh,0CDh,0CEh,0CFh,0CFh,0D0h,0D1h,0D2h,0D2h,0D3h,0D4h,0D5h,0D5h,0D6h,0D7h,0D8h,0D8h,0D9h
         db       0DAh,0DBh,0DBh,0DCh,0DDh,0DEh,0DEh,0DFh,020h,021h,022h,022h,023h,024h,025h,025h,026h,027h,028h,028h
         db       029h,02Ah,02Bh,02Bh,02Ch,02Dh,02Eh,02Eh,02Fh,030h,031h,031h,032h,033h,034h,034h,035h,036h,037h,037h
         db       038h,039h,03Ah,03Ah,03Bh,03Ch,03Dh,03Dh,03Eh,03Fh,040h,040h,041h,042h,043h,043h,044h,045h,046h,046h
         db       047h,048h,049h,049h,04Ah,04Bh,04Ch,04Ch,04Dh,04Eh,04Fh,04Fh,050h,051h,052h,052h,053h,054h,055h,055h
         db       056h,057h,058h,058h,059h,05Ah,05Bh,05Bh,05Ch,05Dh,05Eh,05Eh,05Fh,060h,061h,061h,062h,063h,064h,064h
         db       065h,066h,067h,067h,068h,069h,06Ah,06Ah,06Bh,06Ch,06Dh,06Dh,06Eh,06Fh,070h,070h,071h,072h,073h,073h
         db       074h,075h,076h,076h,077h,078h,079h,079h,07Ah,07Bh,07Ch,07Ch,07Dh,07Eh,07Fh,07Fh,080h,081h,082h,082h
         db       083h,084h,085h,085h,086h,087h,088h,088h,089h,08Ah,08Bh,08Bh,08Ch,08Dh,08Eh,08Fh,08Fh,090h,091h,092h
         db       092h,093h,094h,095h,095h,096h,097h,098h,098h,099h,09Ah,09Bh,09Bh,09Ch,09Dh,09Eh,09Fh,09Fh,0A0h,0A1h
         db       0A2h,0A2h,0A3h,0A4h,0A5h,0A5h,0A6h,0A7h,0A8h,0A8h,0A9h,0AAh,0ABh,0ACh,0ACh,0ADh,0AEh,0AFh,0AFh,0B0h
         db       0B1h,0B2h,0B2h,0B3h,0B4h,0B5h,0B5h,0B6h,0B7h,0B8h,0B8h,0B9h,0BAh,0BBh,0BCh,0BCh,0BDh,0BEh,0BFh,0BFh
         db       0C0h,0C1h,0C2h,0C2h,0C3h,0C4h,0C5h,0C5h,0C6h,0C7h,0C8h,0C9h,0C9h,0CAh,0CBh,0CCh,0CCh,0CDh,0CEh,0CFh
         db       0CFh,0D0h,0D1h,0D2h,0D2h,0D3h,0D4h,0D5h,0D5h,0D6h,0D7h,0D8h,0D9h,0D9h,0DAh,0DBh,0DCh,0DCh,0DDh,0DEh
         db       0DFh,0DFh,0E0h,0E1h,01Eh,01Fh,020h,021h,021h,022h,023h,024h,024h,025h,026h,027h,027h,028h,029h,02Ah
         db       02Bh,02Bh,02Ch,02Dh,02Eh,02Eh,02Fh,030h,031h,031h,032h,033h,034h,034h,035h,036h,037h,037h,038h,039h
         db       03Ah,03Bh,03Bh,03Ch,03Dh,03Eh,03Eh,03Fh,040h,041h,041h,042h,043h,044h,044h,045h,046h,047h,048h,048h
         db       049h,04Ah,04Bh,04Bh,04Ch,04Dh,04Eh,04Eh,04Fh,050h,051h,051h,052h,053h,054h,054h,055h,056h,057h,058h
         db       058h,059h,05Ah,05Bh,05Bh,05Ch,05Dh,05Eh,05Eh,05Fh,060h,061h,061h,062h,063h,064h,065h,065h,066h,067h
         db       068h,068h,069h,06Ah,06Bh,06Bh,06Ch,06Dh,06Eh,06Eh,06Fh,070h,071h,071h,072h,073h,074h,075h,075h,076h
         db       077h,078h,078h,079h,07Ah,07Bh,07Bh,07Ch,07Dh,07Eh,07Eh,07Fh,080h,081h,082h,082h,083h,084h,085h,085h
         db       086h,087h,088h,089h,089h,08Ah,08Bh,08Ch,08Ch,08Dh,08Eh,08Fh,090h,090h,091h,092h,093h,093h,094h,095h
         db       096h,097h,097h,098h,099h,09Ah,09Ah,09Bh,09Ch,09Dh,09Eh,09Eh,09Fh,0A0h,0A1h,0A1h,0A2h,0A3h,0A4h,0A5h
         db       0A5h,0A6h,0A7h,0A8h,0A8h,0A9h,0AAh,0ABh,0ACh,0ACh,0ADh,0AEh,0AFh,0B0h,0B0h,0B1h,0B2h,0B3h,0B3h,0B4h
         db       0B5h,0B6h,0B7h,0B7h,0B8h,0B9h,0BAh,0BAh,0BBh,0BCh,0BDh,0BEh,0BEh,0BFh,0C0h,0C1h,0C1h,0C2h,0C3h,0C4h
         db       0C5h,0C5h,0C6h,0C7h,0C8h,0C8h,0C9h,0CAh,0CBh,0CCh,0CCh,0CDh,0CEh,0CFh,0CFh,0D0h,0D1h,0D2h,0D3h,0D3h
         db       0D4h,0D5h,0D6h,0D6h,0D7h,0D8h,0D9h,0DAh,0DAh,0DBh,0DCh,0DDh,0DDh,0DEh,0DFh,0E0h,0E1h,0E1h,0E2h,0E3h
         db       01Ch,01Dh,01Eh,01Fh,01Fh,020h,021h,022h,023h,023h,024h,025h,026h,026h,027h,028h,029h,02Ah,02Ah,02Bh
         db       02Ch,02Dh,02Dh,02Eh,02Fh,030h,031h,031h,032h,033h,034h,034h,035h,036h,037h,038h,038h,039h,03Ah,03Bh
         db       03Bh,03Ch,03Dh,03Eh,03Fh,03Fh,040h,041h,042h,042h,043h,044h,045h,046h,046h,047h,048h,049h,049h,04Ah
         db       04Bh,04Ch,04Dh,04Dh,04Eh,04Fh,050h,050h,051h,052h,053h,054h,054h,055h,056h,057h,058h,058h,059h,05Ah
         db       05Bh,05Bh,05Ch,05Dh,05Eh,05Fh,05Fh,060h,061h,062h,062h,063h,064h,065h,066h,066h,067h,068h,069h,069h
         db       06Ah,06Bh,06Ch,06Dh,06Dh,06Eh,06Fh,070h,070h,071h,072h,073h,074h,074h,075h,076h,077h,077h,078h,079h
         db       07Ah,07Bh,07Bh,07Ch,07Dh,07Eh,07Eh,07Fh,080h,081h,082h,082h,083h,084h,085h,086h,086h,087h,088h,089h
         db       08Ah,08Ah,08Bh,08Ch,08Dh,08Eh,08Eh,08Fh,090h,091h,091h,092h,093h,094h,095h,095h,096h,097h,098h,099h
         db       099h,09Ah,09Bh,09Ch,09Dh,09Dh,09Eh,09Fh,0A0h,0A1h,0A1h,0A2h,0A3h,0A4h,0A5h,0A5h,0A6h,0A7h,0A8h,0A9h
         db       0A9h,0AAh,0ABh,0ACh,0ACh,0ADh,0AEh,0AFh,0B0h,0B0h,0B1h,0B2h,0B3h,0B4h,0B4h,0B5h,0B6h,0B7h,0B8h,0B8h
         db       0B9h,0BAh,0BBh,0BCh,0BCh,0BDh,0BEh,0BFh,0C0h,0C0h,0C1h,0C2h,0C3h,0C4h,0C4h,0C5h,0C6h,0C7h,0C8h,0C8h
         db       0C9h,0CAh,0CBh,0CBh,0CCh,0CDh,0CEh,0CFh,0CFh,0D0h,0D1h,0D2h,0D3h,0D3h,0D4h,0D5h,0D6h,0D7h,0D7h,0D8h
         db       0D9h,0DAh,0DBh,0DBh,0DCh,0DDh,0DEh,0DFh,0DFh,0E0h,0E1h,0E2h,0E3h,0E3h,0E4h,0E5h,01Ah,01Bh,01Ch,01Dh
         db       01Dh,01Eh,01Fh,020h,021h,021h,022h,023h,024h,025h,025h,026h,027h,028h,029h,029h,02Ah,02Bh,02Ch,02Dh
         db       02Dh,02Eh,02Fh,030h,031h,031h,032h,033h,034h,035h,035h,036h,037h,038h,038h,039h,03Ah,03Bh,03Ch,03Ch
         db       03Dh,03Eh,03Fh,040h,040h,041h,042h,043h,044h,044h,045h,046h,047h,048h,048h,049h,04Ah,04Bh,04Ch,04Ch
         db       04Dh,04Eh,04Fh,050h,050h,051h,052h,053h,054h,054h,055h,056h,057h,057h,058h,059h,05Ah,05Bh,05Bh,05Ch
         db       05Dh,05Eh,05Fh,05Fh,060h,061h,062h,063h,063h,064h,065h,066h,067h,067h,068h,069h,06Ah,06Bh,06Bh,06Ch
         db       06Dh,06Eh,06Fh,06Fh,070h,071h,072h,072h,073h,074h,075h,076h,076h,077h,078h,079h,07Ah,07Ah,07Bh,07Ch
         db       07Dh,07Eh,07Eh,07Fh,080h,081h,082h,082h,083h,084h,085h,086h,086h,087h,088h,089h,08Ah,08Bh,08Bh,08Ch
         db       08Dh,08Eh,08Fh,08Fh,090h,091h,092h,093h,093h,094h,095h,096h,097h,098h,098h,099h,09Ah,09Bh,09Ch,09Ch
         db       09Dh,09Eh,09Fh,0A0h,0A0h,0A1h,0A2h,0A3h,0A4h,0A4h,0A5h,0A6h,0A7h,0A8h,0A9h,0A9h,0AAh,0ABh,0ACh,0ADh
         db       0ADh,0AEh,0AFh,0B0h,0B1h,0B1h,0B2h,0B3h,0B4h,0B5h,0B5h,0B6h,0B7h,0B8h,0B9h,0BAh,0BAh,0BBh,0BCh,0BDh
         db       0BEh,0BEh,0BFh,0C0h,0C1h,0C2h,0C2h,0C3h,0C4h,0C5h,0C6h,0C7h,0C7h,0C8h,0C9h,0CAh,0CBh,0CBh,0CCh,0CDh
         db       0CEh,0CFh,0CFh,0D0h,0D1h,0D2h,0D3h,0D3h,0D4h,0D5h,0D6h,0D7h,0D8h,0D8h,0D9h,0DAh,0DBh,0DCh,0DCh,0DDh
         db       0DEh,0DFh,0E0h,0E0h,0E1h,0E2h,0E3h,0E4h,0E5h,0E5h,0E6h,0E7h,018h,019h,01Ah,01Bh,01Bh,01Ch,01Dh,01Eh
         db       01Fh,020h,020h,021h,022h,023h,024h,024h,025h,026h,027h,028h,028h,029h,02Ah,02Bh,02Ch,02Dh,02Dh,02Eh
         db       02Fh,030h,031h,031h,032h,033h,034h,035h,035h,036h,037h,038h,039h,039h,03Ah,03Bh,03Ch,03Dh,03Eh,03Eh
         db       03Fh,040h,041h,042h,042h,043h,044h,045h,046h,046h,047h,048h,049h,04Ah,04Bh,04Bh,04Ch,04Dh,04Eh,04Fh
         db       04Fh,050h,051h,052h,053h,053h,054h,055h,056h,057h,057h,058h,059h,05Ah,05Bh,05Ch,05Ch,05Dh,05Eh,05Fh
         db       060h,060h,061h,062h,063h,064h,064h,065h,066h,067h,068h,068h,069h,06Ah,06Bh,06Ch,06Dh,06Dh,06Eh,06Fh
         db       070h,071h,071h,072h,073h,074h,075h,075h,076h,077h,078h,079h,07Ah,07Ah,07Bh,07Ch,07Dh,07Eh,07Eh,07Fh
         db       080h,081h,082h,082h,083h,084h,085h,086h,087h,087h,088h,089h,08Ah,08Bh,08Bh,08Ch,08Dh,08Eh,08Fh,090h
         db       090h,091h,092h,093h,094h,094h,095h,096h,097h,098h,099h,099h,09Ah,09Bh,09Ch,09Dh,09Dh,09Eh,09Fh,0A0h
         db       0A1h,0A2h,0A2h,0A3h,0A4h,0A5h,0A6h,0A6h,0A7h,0A8h,0A9h,0AAh,0ABh,0ABh,0ACh,0ADh,0AEh,0AFh,0AFh,0B0h
         db       0B1h,0B2h,0B3h,0B4h,0B4h,0B5h,0B6h,0B7h,0B8h,0B8h,0B9h,0BAh,0BBh,0BCh,0BDh,0BDh,0BEh,0BFh,0C0h,0C1h
         db       0C1h,0C2h,0C3h,0C4h,0C5h,0C6h,0C6h,0C7h,0C8h,0C9h,0CAh,0CBh,0CBh,0CCh,0CDh,0CEh,0CFh,0CFh,0D0h,0D1h
         db       0D2h,0D3h,0D4h,0D4h,0D5h,0D6h,0D7h,0D8h,0D8h,0D9h,0DAh,0DBh,0DCh,0DDh,0DDh,0DEh,0DFh,0E0h,0E1h,0E1h
         db       0E2h,0E3h,0E4h,0E5h,0E6h,0E6h,0E7h,0E8h,017h,018h,019h,01Ah,01Ah,01Bh,01Ch,01Dh,01Eh,01Fh,01Fh,020h
         db       021h,022h,023h,023h,024h,025h,026h,027h,028h,028h,029h,02Ah,02Bh,02Ch,02Ch,02Dh,02Eh,02Fh,030h,031h
         db       031h,032h,033h,034h,035h,035h,036h,037h,038h,039h,03Ah,03Ah,03Bh,03Ch,03Dh,03Eh,03Fh,03Fh,040h,041h
         db       042h,043h,043h,044h,045h,046h,047h,048h,048h,049h,04Ah,04Bh,04Ch,04Ch,04Dh,04Eh,04Fh,050h,051h,051h
         db       052h,053h,054h,055h,055h,056h,057h,058h,059h,05Ah,05Ah,05Bh,05Ch,05Dh,05Eh,05Eh,05Fh,060h,061h,062h
         db       063h,063h,064h,065h,066h,067h,067h,068h,069h,06Ah,06Bh,06Ch,06Ch,06Dh,06Eh,06Fh,070h,070h,071h,072h
         db       073h,074h,075h,075h,076h,077h,078h,079h,079h,07Ah,07Bh,07Ch,07Dh,07Eh,07Eh,07Fh,080h,081h,082h,083h
         db       083h,084h,085h,086h,087h,088h,088h,089h,08Ah,08Bh,08Ch,08Dh,08Dh,08Eh,08Fh,090h,091h,092h,092h,093h
         db       094h,095h,096h,097h,097h,098h,099h,09Ah,09Bh,09Ch,09Ch,09Dh,09Eh,09Fh,0A0h,0A1h,0A1h,0A2h,0A3h,0A4h
         db       0A5h,0A6h,0A6h,0A7h,0A8h,0A9h,0AAh,0ABh,0ABh,0ACh,0ADh,0AEh,0AFh,0B0h,0B0h,0B1h,0B2h,0B3h,0B4h,0B5h
         db       0B5h,0B6h,0B7h,0B8h,0B9h,0BAh,0BAh,0BBh,0BCh,0BDh,0BEh,0BFh,0BFh,0C0h,0C1h,0C2h,0C3h,0C4h,0C4h,0C5h
         db       0C6h,0C7h,0C8h,0C9h,0CAh,0CAh,0CBh,0CCh,0CDh,0CEh,0CFh,0CFh,0D0h,0D1h,0D2h,0D3h,0D4h,0D4h,0D5h,0D6h
         db       0D7h,0D8h,0D9h,0D9h,0DAh,0DBh,0DCh,0DDh,0DEh,0DEh,0DFh,0E0h,0E1h,0E2h,0E3h,0E3h,0E4h,0E5h,0E6h,0E7h
         db       0E8h,0E8h,0E9h,0EAh,015h,016h,017h,018h,018h,019h,01Ah,01Bh,01Ch,01Dh,01Dh,01Eh,01Fh,020h,021h,022h
         db       022h,023h,024h,025h,026h,027h,027h,028h,029h,02Ah,02Bh,02Ch,02Ch,02Dh,02Eh,02Fh,030h,031h,031h,032h
         db       033h,034h,035h,036h,036h,037h,038h,039h,03Ah,03Bh,03Ch,03Ch,03Dh,03Eh,03Fh,040h,041h,041h,042h,043h
         db       044h,045h,046h,046h,047h,048h,049h,04Ah,04Bh,04Bh,04Ch,04Dh,04Eh,04Fh,050h,050h,051h,052h,053h,054h
         db       055h,055h,056h,057h,058h,059h,05Ah,05Ah,05Bh,05Ch,05Dh,05Eh,05Fh,05Fh,060h,061h,062h,063h,064h,064h
         db       065h,066h,067h,068h,069h,069h,06Ah,06Bh,06Ch,06Dh,06Eh,06Eh,06Fh,070h,071h,072h,073h,073h,074h,075h
         db       076h,077h,078h,078h,079h,07Ah,07Bh,07Ch,07Dh,07Dh,07Eh,07Fh,080h,081h,082h,083h,083h,084h,085h,086h
         db       087h,088h,089h,089h,08Ah,08Bh,08Ch,08Dh,08Eh,08Eh,08Fh,090h,091h,092h,093h,094h,094h,095h,096h,097h
         db       098h,099h,09Ah,09Ah,09Bh,09Ch,09Dh,09Eh,09Fh,0A0h,0A0h,0A1h,0A2h,0A3h,0A4h,0A5h,0A5h,0A6h,0A7h,0A8h
         db       0A9h,0AAh,0ABh,0ABh,0ACh,0ADh,0AEh,0AFh,0B0h,0B1h,0B1h,0B2h,0B3h,0B4h,0B5h,0B6h,0B7h,0B7h,0B8h,0B9h
         db       0BAh,0BBh,0BCh,0BDh,0BDh,0BEh,0BFh,0C0h,0C1h,0C2h,0C2h,0C3h,0C4h,0C5h,0C6h,0C7h,0C8h,0C8h,0C9h,0CAh
         db       0CBh,0CCh,0CDh,0CEh,0CEh,0CFh,0D0h,0D1h,0D2h,0D3h,0D4h,0D4h,0D5h,0D6h,0D7h,0D8h,0D9h,0D9h,0DAh,0DBh
         db       0DCh,0DDh,0DEh,0DFh,0DFh,0E0h,0E1h,0E2h,0E3h,0E4h,0E5h,0E5h,0E6h,0E7h,0E8h,0E9h,0EAh,0EBh,0EBh,0ECh
         db       013h,014h,015h,015h,016h,017h,018h,019h,01Ah,01Bh,01Bh,01Ch,01Dh,01Eh,01Fh,020h,021h,021h,022h,023h
         db       024h,025h,026h,027h,027h,028h,029h,02Ah,02Bh,02Ch,02Ch,02Dh,02Eh,02Fh,030h,031h,032h,032h,033h,034h
         db       035h,036h,037h,038h,038h,039h,03Ah,03Bh,03Ch,03Dh,03Eh,03Eh,03Fh,040h,041h,042h,043h,043h,044h,045h
         db       046h,047h,048h,049h,049h,04Ah,04Bh,04Ch,04Dh,04Eh,04Fh,04Fh,050h,051h,052h,053h,054h,055h,055h,056h
         db       057h,058h,059h,05Ah,05Bh,05Bh,05Ch,05Dh,05Eh,05Fh,060h,060h,061h,062h,063h,064h,065h,066h,066h,067h
         db       068h,069h,06Ah,06Bh,06Ch,06Ch,06Dh,06Eh,06Fh,070h,071h,072h,072h,073h,074h,075h,076h,077h,077h,078h
         db       079h,07Ah,07Bh,07Ch,07Dh,07Dh,07Eh,07Fh,080h,081h,082h,083h,083h,084h,085h,086h,087h,088h,089h,089h
         db       08Ah,08Bh,08Ch,08Dh,08Eh,08Fh,08Fh,090h,091h,092h,093h,094h,095h,096h,096h,097h,098h,099h,09Ah,09Bh
         db       09Ch,09Ch,09Dh,09Eh,09Fh,0A0h,0A1h,0A2h,0A2h,0A3h,0A4h,0A5h,0A6h,0A7h,0A8h,0A8h,0A9h,0AAh,0ABh,0ACh
         db       0ADh,0AEh,0AEh,0AFh,0B0h,0B1h,0B2h,0B3h,0B4h,0B5h,0B5h,0B6h,0B7h,0B8h,0B9h,0BAh,0BBh,0BBh,0BCh,0BDh
         db       0BEh,0BFh,0C0h,0C1h,0C1h,0C2h,0C3h,0C4h,0C5h,0C6h,0C7h,0C7h,0C8h,0C9h,0CAh,0CBh,0CCh,0CDh,0CDh,0CEh
         db       0CFh,0D0h,0D1h,0D2h,0D3h,0D3h,0D4h,0D5h,0D6h,0D7h,0D8h,0D9h,0DAh,0DAh,0DBh,0DCh,0DDh,0DEh,0DFh,0E0h
         db       0E0h,0E1h,0E2h,0E3h,0E4h,0E5h,0E6h,0E6h,0E7h,0E8h,0E9h,0EAh,0EBh,0ECh,0ECh,0EDh,012h,013h,014h,014h
         db       015h,016h,017h,018h,019h,01Ah,01Ah,01Bh,01Ch,01Dh,01Eh,01Fh,020h,020h,021h,022h,023h,024h,025h,026h
         db       026h,027h,028h,029h,02Ah,02Bh,02Ch,02Dh,02Dh,02Eh,02Fh,030h,031h,032h,033h,033h,034h,035h,036h,037h
         db       038h,039h,039h,03Ah,03Bh,03Ch,03Dh,03Eh,03Fh,03Fh,040h,041h,042h,043h,044h,045h,045h,046h,047h,048h
         db       049h,04Ah,04Bh,04Bh,04Ch,04Dh,04Eh,04Fh,050h,051h,052h,052h,053h,054h,055h,056h,057h,058h,058h,059h
         db       05Ah,05Bh,05Ch,05Dh,05Eh,05Eh,05Fh,060h,061h,062h,063h,064h,064h,065h,066h,067h,068h,069h,06Ah,06Ah
         db       06Bh,06Ch,06Dh,06Eh,06Fh,070h,071h,071h,072h,073h,074h,075h,076h,077h,077h,078h,079h,07Ah,07Bh,07Ch
         db       07Dh,07Dh,07Eh,07Fh,080h,081h,082h,083h,084h,084h,085h,086h,087h,088h,089h,08Ah,08Bh,08Bh,08Ch,08Dh
         db       08Eh,08Fh,090h,091h,092h,092h,093h,094h,095h,096h,097h,098h,099h,099h,09Ah,09Bh,09Ch,09Dh,09Eh,09Fh
         db       0A0h,0A0h,0A1h,0A2h,0A3h,0A4h,0A5h,0A6h,0A7h,0A8h,0A8h,0A9h,0AAh,0ABh,0ACh,0ADh,0AEh,0AFh,0AFh,0B0h
         db       0B1h,0B2h,0B3h,0B4h,0B5h,0B6h,0B6h,0B7h,0B8h,0B9h,0BAh,0BBh,0BCh,0BDh,0BDh,0BEh,0BFh,0C0h,0C1h,0C2h
         db       0C3h,0C4h,0C4h,0C5h,0C6h,0C7h,0C8h,0C9h,0CAh,0CBh,0CCh,0CCh,0CDh,0CEh,0CFh,0D0h,0D1h,0D2h,0D3h,0D3h
         db       0D4h,0D5h,0D6h,0D7h,0D8h,0D9h,0DAh,0DAh,0DBh,0DCh,0DDh,0DEh,0DFh,0E0h,0E1h,0E1h,0E2h,0E3h,0E4h,0E5h
         db       0E6h,0E7h,0E8h,0E8h,0E9h,0EAh,0EBh,0ECh,0EDh,0EEh,0EFh,0F0h,010h,010h,011h,012h,013h,014h,015h,016h
         db       017h,018h,018h,019h,01Ah,01Bh,01Ch,01Dh,01Eh,01Fh,01Fh,020h,021h,022h,023h,024h,025h,026h,026h,027h
         db       028h,029h,02Ah,02Bh,02Ch,02Dh,02Dh,02Eh,02Fh,030h,031h,032h,033h,034h,034h,035h,036h,037h,038h,039h
         db       03Ah,03Bh,03Ch,03Ch,03Dh,03Eh,03Fh,040h,041h,042h,043h,043h,044h,045h,046h,047h,048h,049h,04Ah,04Ah
         db       04Bh,04Ch,04Dh,04Eh,04Fh,050h,051h,051h,052h,053h,054h,055h,056h,057h,058h,058h,059h,05Ah,05Bh,05Ch
         db       05Dh,05Eh,05Fh,060h,060h,061h,062h,063h,064h,065h,066h,067h,067h,068h,069h,06Ah,06Bh,06Ch,06Dh,06Eh
         db       06Eh,06Fh,070h,071h,072h,073h,074h,075h,075h,076h,077h,078h,079h,07Ah,07Bh,07Ch,07Ch,07Dh,07Eh,07Fh
         db       080h,081h,082h,083h,084h,084h,085h,086h,087h,088h,089h,08Ah,08Bh,08Ch,08Ch,08Dh,08Eh,08Fh,090h,091h
         db       092h,093h,094h,094h,095h,096h,097h,098h,099h,09Ah,09Bh,09Bh,09Ch,09Dh,09Eh,09Fh,0A0h,0A1h,0A2h,0A3h
         db       0A3h,0A4h,0A5h,0A6h,0A7h,0A8h,0A9h,0AAh,0ABh,0ABh,0ACh,0ADh,0AEh,0AFh,0B0h,0B1h,0B2h,0B3h,0B3h,0B4h
         db       0B5h,0B6h,0B7h,0B8h,0B9h,0BAh,0BBh,0BBh,0BCh,0BDh,0BEh,0BFh,0C0h,0C1h,0C2h,0C3h,0C3h,0C4h,0C5h,0C6h
         db       0C7h,0C8h,0C9h,0CAh,0CBh,0CBh,0CCh,0CDh,0CEh,0CFh,0D0h,0D1h,0D2h,0D2h,0D3h,0D4h,0D5h,0D6h,0D7h,0D8h
         db       0D9h,0DAh,0DAh,0DBh,0DCh,0DDh,0DEh,0DFh,0E0h,0E1h,0E2h,0E2h,0E3h,0E4h,0E5h,0E6h,0E7h,0E8h,0E9h,0EAh
         db       0EAh,0EBh,0ECh,0EDh,0EEh,0EFh,0F0h,0F1h,00Eh,00Fh,010h,011h,012h,013h,014h,015h,016h,016h,017h,018h
         db       019h,01Ah,01Bh,01Ch,01Dh,01Eh,01Eh,01Fh,020h,021h,022h,023h,024h,025h,026h,026h,027h,028h,029h,02Ah
         db       02Bh,02Ch,02Dh,02Eh,02Eh,02Fh,030h,031h,032h,033h,034h,035h,035h,036h,037h,038h,039h,03Ah,03Bh,03Ch
         db       03Dh,03Dh,03Eh,03Fh,040h,041h,042h,043h,044h,045h,045h,046h,047h,048h,049h,04Ah,04Bh,04Ch,04Dh,04Dh
         db       04Eh,04Fh,050h,051h,052h,053h,054h,055h,055h,056h,057h,058h,059h,05Ah,05Bh,05Ch,05Dh,05Dh,05Eh,05Fh
         db       060h,061h,062h,063h,064h,065h,065h,066h,067h,068h,069h,06Ah,06Bh,06Ch,06Ch,06Dh,06Eh,06Fh,070h,071h
         db       072h,073h,074h,074h,075h,076h,077h,078h,079h,07Ah,07Bh,07Ch,07Ch,07Dh,07Eh,07Fh,080h,081h,082h,083h
         db       084h,085h,085h,086h,087h,088h,089h,08Ah,08Bh,08Ch,08Dh,08Eh,08Eh,08Fh,090h,091h,092h,093h,094h,095h
         db       096h,097h,098h,098h,099h,09Ah,09Bh,09Ch,09Dh,09Eh,09Fh,0A0h,0A1h,0A1h,0A2h,0A3h,0A4h,0A5h,0A6h,0A7h
         db       0A8h,0A9h,0AAh,0ABh,0ABh,0ACh,0ADh,0AEh,0AFh,0B0h,0B1h,0B2h,0B3h,0B4h,0B4h,0B5h,0B6h,0B7h,0B8h,0B9h
         db       0BAh,0BBh,0BCh,0BDh,0BEh,0BEh,0BFh,0C0h,0C1h,0C2h,0C3h,0C4h,0C5h,0C6h,0C7h,0C7h,0C8h,0C9h,0CAh,0CBh
         db       0CCh,0CDh,0CEh,0CFh,0D0h,0D1h,0D1h,0D2h,0D3h,0D4h,0D5h,0D6h,0D7h,0D8h,0D9h,0DAh,0DAh,0DBh,0DCh,0DDh
         db       0DEh,0DFh,0E0h,0E1h,0E2h,0E3h,0E4h,0E4h,0E5h,0E6h,0E7h,0E8h,0E9h,0EAh,0EBh,0ECh,0EDh,0EDh,0EEh,0EFh
         db       0F0h,0F1h,0F2h,0F3h,00Ch,00Dh,00Eh,00Fh,010h,011h,012h,013h,013h,014h,015h,016h,017h,018h,019h,01Ah
         db       01Bh,01Ch,01Ch,01Dh,01Eh,01Fh,020h,021h,022h,023h,024h,025h,026h,026h,027h,028h,029h,02Ah,02Bh,02Ch
         db       02Dh,02Eh,02Fh,02Fh,030h,031h,032h,033h,034h,035h,036h,037h,038h,039h,039h,03Ah,03Bh,03Ch,03Dh,03Eh
         db       03Fh,040h,041h,042h,042h,043h,044h,045h,046h,047h,048h,049h,04Ah,04Bh,04Ch,04Ch,04Dh,04Eh,04Fh,050h
         db       051h,052h,053h,054h,055h,055h,056h,057h,058h,059h,05Ah,05Bh,05Ch,05Dh,05Eh,05Fh,05Fh,060h,061h,062h
         db       063h,064h,065h,066h,067h,068h,068h,069h,06Ah,06Bh,06Ch,06Dh,06Eh,06Fh,070h,071h,072h,072h,073h,074h
         db       075h,076h,077h,078h,079h,07Ah,07Bh,07Bh,07Ch,07Dh,07Eh,07Fh,080h,081h,082h,083h,084h,085h,085h,086h
         db       087h,088h,089h,08Ah,08Bh,08Ch,08Dh,08Eh,08Fh,090h,090h,091h,092h,093h,094h,095h,096h,097h,098h,099h
         db       09Ah,09Bh,09Bh,09Ch,09Dh,09Eh,09Fh,0A0h,0A1h,0A2h,0A3h,0A4h,0A5h,0A5h,0A6h,0A7h,0A8h,0A9h,0AAh,0ABh
         db       0ACh,0ADh,0AEh,0AFh,0B0h,0B0h,0B1h,0B2h,0B3h,0B4h,0B5h,0B6h,0B7h,0B8h,0B9h,0BAh,0BAh,0BBh,0BCh,0BDh
         db       0BEh,0BFh,0C0h,0C1h,0C2h,0C3h,0C4h,0C5h,0C5h,0C6h,0C7h,0C8h,0C9h,0CAh,0CBh,0CCh,0CDh,0CEh,0CFh,0D0h
         db       0D0h,0D1h,0D2h,0D3h,0D4h,0D5h,0D6h,0D7h,0D8h,0D9h,0DAh,0DAh,0DBh,0DCh,0DDh,0DEh,0DFh,0E0h,0E1h,0E2h
         db       0E3h,0E4h,0E5h,0E5h,0E6h,0E7h,0E8h,0E9h,0EAh,0EBh,0ECh,0EDh,0EEh,0EFh,0EFh,0F0h,0F1h,0F2h,0F3h,0F4h
         db       00Bh,00Ch,00Dh,00Eh,00Fh,010h,011h,011h,012h,013h,014h,015h,016h,017h,018h,019h,01Ah,01Bh,01Bh,01Ch
         db       01Dh,01Eh,01Fh,020h,021h,022h,023h,024h,025h,026h,026h,027h,028h,029h,02Ah,02Bh,02Ch,02Dh,02Eh,02Fh
         db       030h,030h,031h,032h,033h,034h,035h,036h,037h,038h,039h,03Ah,03Bh,03Bh,03Ch,03Dh,03Eh,03Fh,040h,041h
         db       042h,043h,044h,045h,046h,046h,047h,048h,049h,04Ah,04Bh,04Ch,04Dh,04Eh,04Fh,050h,050h,051h,052h,053h
         db       054h,055h,056h,057h,058h,059h,05Ah,05Bh,05Bh,05Ch,05Dh,05Eh,05Fh,060h,061h,062h,063h,064h,065h,065h
         db       066h,067h,068h,069h,06Ah,06Bh,06Ch,06Dh,06Eh,06Fh,070h,070h,071h,072h,073h,074h,075h,076h,077h,078h
         db       079h,07Ah,07Bh,07Bh,07Ch,07Dh,07Eh,07Fh,080h,081h,082h,083h,084h,085h,086h,087h,087h,088h,089h,08Ah
         db       08Bh,08Ch,08Dh,08Eh,08Fh,090h,091h,092h,093h,094h,095h,095h,096h,097h,098h,099h,09Ah,09Bh,09Ch,09Dh
         db       09Eh,09Fh,0A0h,0A1h,0A2h,0A2h,0A3h,0A4h,0A5h,0A6h,0A7h,0A8h,0A9h,0AAh,0ABh,0ACh,0ADh,0AEh,0AFh,0B0h
         db       0B0h,0B1h,0B2h,0B3h,0B4h,0B5h,0B6h,0B7h,0B8h,0B9h,0BAh,0BBh,0BCh,0BDh,0BEh,0BEh,0BFh,0C0h,0C1h,0C2h
         db       0C3h,0C4h,0C5h,0C6h,0C7h,0C8h,0C9h,0CAh,0CBh,0CCh,0CCh,0CDh,0CEh,0CFh,0D0h,0D1h,0D2h,0D3h,0D4h,0D5h
         db       0D6h,0D7h,0D8h,0D9h,0DAh,0DAh,0DBh,0DCh,0DDh,0DEh,0DFh,0E0h,0E1h,0E2h,0E3h,0E4h,0E5h,0E6h,0E7h,0E7h
         db       0E8h,0E9h,0EAh,0EBh,0ECh,0EDh,0EEh,0EFh,0F0h,0F1h,0F2h,0F3h,0F4h,0F5h,0F5h,0F6h,009h,00Ah,00Bh,00Bh
         db       00Ch,00Dh,00Eh,00Fh,010h,011h,012h,013h,014h,015h,016h,017h,018h,019h,019h,01Ah,01Bh,01Ch,01Dh,01Eh
         db       01Fh,020h,021h,022h,023h,024h,025h,026h,026h,027h,028h,029h,02Ah,02Bh,02Ch,02Dh,02Eh,02Fh,030h,031h
         db       032h,033h,034h,034h,035h,036h,037h,038h,039h,03Ah,03Bh,03Ch,03Dh,03Eh,03Fh,040h,041h,042h,042h,043h
         db       044h,045h,046h,047h,048h,049h,04Ah,04Bh,04Ch,04Dh,04Eh,04Fh,050h,050h,051h,052h,053h,054h,055h,056h
         db       057h,058h,059h,05Ah,05Bh,05Ch,05Dh,05Eh,05Eh,05Fh,060h,061h,062h,063h,064h,065h,066h,067h,068h,069h
         db       06Ah,06Bh,06Bh,06Ch,06Dh,06Eh,06Fh,070h,071h,072h,073h,074h,075h,076h,077h,078h,079h,079h,07Ah,07Bh
         db       07Ch,07Dh,07Eh,07Fh,080h,081h,082h,083h,084h,085h,086h,087h,088h,088h,089h,08Ah,08Bh,08Ch,08Dh,08Eh
         db       08Fh,090h,091h,092h,093h,094h,095h,096h,097h,098h,098h,099h,09Ah,09Bh,09Ch,09Dh,09Eh,09Fh,0A0h,0A1h
         db       0A2h,0A3h,0A4h,0A5h,0A6h,0A7h,0A8h,0A8h,0A9h,0AAh,0ABh,0ACh,0ADh,0AEh,0AFh,0B0h,0B1h,0B2h,0B3h,0B4h
         db       0B5h,0B6h,0B7h,0B8h,0B9h,0B9h,0BAh,0BBh,0BCh,0BDh,0BEh,0BFh,0C0h,0C1h,0C2h,0C3h,0C4h,0C5h,0C6h,0C7h
         db       0C8h,0C9h,0C9h,0CAh,0CBh,0CCh,0CDh,0CEh,0CFh,0D0h,0D1h,0D2h,0D3h,0D4h,0D5h,0D6h,0D7h,0D8h,0D9h,0D9h
         db       0DAh,0DBh,0DCh,0DDh,0DEh,0DFh,0E0h,0E1h,0E2h,0E3h,0E4h,0E5h,0E6h,0E7h,0E8h,0E9h,0E9h,0EAh,0EBh,0ECh
         db       0EDh,0EEh,0EFh,0F0h,0F1h,0F2h,0F3h,0F4h,0F5h,0F6h,0F7h,0F8h,007h,008h,009h,00Ah,00Bh,00Ch,00Dh,00Eh
         db       00Fh,010h,011h,012h,013h,014h,015h,016h,017h,017h,018h,019h,01Ah,01Bh,01Ch,01Dh,01Eh,01Fh,020h,021h
         db       022h,023h,024h,025h,026h,027h,027h,028h,029h,02Ah,02Bh,02Ch,02Dh,02Eh,02Fh,030h,031h,032h,033h,034h
         db       035h,036h,037h,037h,038h,039h,03Ah,03Bh,03Ch,03Dh,03Eh,03Fh,040h,041h,042h,043h,044h,045h,046h,047h
         db       047h,048h,049h,04Ah,04Bh,04Ch,04Dh,04Eh,04Fh,050h,051h,052h,053h,054h,055h,056h,057h,058h,058h,059h
         db       05Ah,05Bh,05Ch,05Dh,05Eh,05Fh,060h,061h,062h,063h,064h,065h,066h,067h,068h,068h,069h,06Ah,06Bh,06Ch
         db       06Dh,06Eh,06Fh,070h,071h,072h,073h,074h,075h,076h,077h,078h,078h,079h,07Ah,07Bh,07Ch,07Dh,07Eh,07Fh
         db       080h,081h,082h,083h,084h,085h,086h,087h,088h,089h,08Ah,08Bh,08Ch,08Ch,08Dh,08Eh,08Fh,090h,091h,092h
         db       093h,094h,095h,096h,097h,098h,099h,09Ah,09Bh,09Ch,09Dh,09Eh,09Fh,0A0h,0A1h,0A2h,0A3h,0A4h,0A5h,0A5h
         db       0A6h,0A7h,0A8h,0A9h,0AAh,0ABh,0ACh,0ADh,0AEh,0AFh,0B0h,0B1h,0B2h,0B3h,0B4h,0B5h,0B6h,0B7h,0B8h,0B9h
         db       0BAh,0BBh,0BCh,0BDh,0BDh,0BEh,0BFh,0C0h,0C1h,0C2h,0C3h,0C4h,0C5h,0C6h,0C7h,0C8h,0C9h,0CAh,0CBh,0CCh
         db       0CDh,0CEh,0CFh,0D0h,0D1h,0D2h,0D3h,0D4h,0D5h,0D6h,0D6h,0D7h,0D8h,0D9h,0DAh,0DBh,0DCh,0DDh,0DEh,0DFh
         db       0E0h,0E1h,0E2h,0E3h,0E4h,0E5h,0E6h,0E7h,0E8h,0E9h,0EAh,0EBh,0ECh,0EDh,0EEh,0EEh,0EFh,0F0h,0F1h,0F2h
         db       0F3h,0F4h,0F5h,0F6h,0F7h,0F8h,0F9h,0FAh,005h,006h,007h,008h,009h,00Ah,00Bh,00Ch,00Dh,00Eh,00Fh,010h
         db       011h,012h,012h,013h,014h,015h,016h,017h,018h,019h,01Ah,01Bh,01Ch,01Dh,01Eh,01Fh,020h,021h,022h,023h
         db       024h,025h,026h,027h,028h,029h,02Ah,02Ah,02Bh,02Ch,02Dh,02Eh,02Fh,030h,031h,032h,033h,034h,035h,036h
         db       037h,038h,039h,03Ah,03Bh,03Ch,03Dh,03Eh,03Fh,040h,041h,042h,043h,043h,044h,045h,046h,047h,048h,049h
         db       04Ah,04Bh,04Ch,04Dh,04Eh,04Fh,050h,051h,052h,053h,054h,055h,056h,057h,058h,059h,05Ah,05Bh,05Bh,05Ch
         db       05Dh,05Eh,05Fh,060h,061h,062h,063h,064h,065h,066h,067h,068h,069h,06Ah,06Bh,06Ch,06Dh,06Eh,06Fh,070h
         db       071h,072h,073h,074h,074h,075h,076h,077h,078h,079h,07Ah,07Bh,07Ch,07Dh,07Eh,07Fh,080h,081h,082h,083h
         db       084h,085h,086h,087h,088h,089h,08Ah,08Bh,08Ch,08Dh,08Eh,08Fh,090h,090h,091h,092h,093h,094h,095h,096h
         db       097h,098h,099h,09Ah,09Bh,09Ch,09Dh,09Eh,09Fh,0A0h,0A1h,0A2h,0A3h,0A4h,0A5h,0A6h,0A7h,0A8h,0A9h,0AAh
         db       0ABh,0ACh,0ADh,0AEh,0AFh,0B0h,0B1h,0B1h,0B2h,0B3h,0B4h,0B5h,0B6h,0B7h,0B8h,0B9h,0BAh,0BBh,0BCh,0BDh
         db       0BEh,0BFh,0C0h,0C1h,0C2h,0C3h,0C4h,0C5h,0C6h,0C7h,0C8h,0C9h,0CAh,0CBh,0CCh,0CDh,0CEh,0CFh,0D0h,0D1h
         db       0D2h,0D2h,0D3h,0D4h,0D5h,0D6h,0D7h,0D8h,0D9h,0DAh,0DBh,0DCh,0DDh,0DEh,0DFh,0E0h,0E1h,0E2h,0E3h,0E4h
         db       0E5h,0E6h,0E7h,0E8h,0E9h,0EAh,0EBh,0ECh,0EDh,0EEh,0EFh,0F0h,0F1h,0F2h,0F3h,0F3h,0F4h,0F5h,0F6h,0F7h
         db       0F8h,0F9h,0FAh,0FBh,004h,005h,006h,007h,008h,009h,00Ah,00Bh,00Ch,00Dh,00Dh,00Eh,00Fh,010h,011h,012h
         db       013h,014h,015h,016h,017h,018h,019h,01Ah,01Bh,01Ch,01Dh,01Eh,01Fh,020h,021h,022h,023h,024h,025h,026h
         db       027h,028h,029h,02Ah,02Bh,02Ch,02Dh,02Eh,02Eh,02Fh,030h,031h,032h,033h,034h,035h,036h,037h,038h,039h
         db       03Ah,03Bh,03Ch,03Dh,03Eh,03Fh,040h,041h,042h,043h,044h,045h,046h,047h,048h,049h,04Ah,04Bh,04Ch,04Dh
         db       04Eh,04Fh,04Fh,050h,051h,052h,053h,054h,055h,056h,057h,058h,059h,05Ah,05Bh,05Ch,05Dh,05Eh,05Fh,060h
         db       061h,062h,063h,064h,065h,066h,067h,068h,069h,06Ah,06Bh,06Ch,06Dh,06Eh,06Fh,070h,070h,071h,072h,073h
         db       074h,075h,076h,077h,078h,079h,07Ah,07Bh,07Ch,07Dh,07Eh,07Fh,080h,081h,082h,083h,084h,085h,086h,087h
         db       088h,089h,08Ah,08Bh,08Ch,08Dh,08Eh,08Fh,090h,091h,092h,093h,094h,095h,096h,097h,098h,099h,099h,09Ah
         db       09Bh,09Ch,09Dh,09Eh,09Fh,0A0h,0A1h,0A2h,0A3h,0A4h,0A5h,0A6h,0A7h,0A8h,0A9h,0AAh,0ABh,0ACh,0ADh,0AEh
         db       0AFh,0B0h,0B1h,0B2h,0B3h,0B4h,0B5h,0B6h,0B7h,0B8h,0B9h,0BAh,0BBh,0BCh,0BDh,0BEh,0BFh,0C0h,0C1h,0C2h
         db       0C3h,0C4h,0C5h,0C6h,0C7h,0C8h,0C9h,0CAh,0CAh,0CBh,0CCh,0CDh,0CEh,0CFh,0D0h,0D1h,0D2h,0D3h,0D4h,0D5h
         db       0D6h,0D7h,0D8h,0D9h,0DAh,0DBh,0DCh,0DDh,0DEh,0DFh,0E0h,0E1h,0E2h,0E3h,0E4h,0E5h,0E6h,0E7h,0E8h,0E9h
         db       0EAh,0EBh,0ECh,0EDh,0EEh,0EFh,0F0h,0F1h,0F2h,0F3h,0F4h,0F5h,0F6h,0F7h,0F8h,0F9h,0FAh,0FBh,0FCh,0FCh
         db       003h,004h,004h,005h,006h,007h,008h,009h,00Ah,00Bh,00Ch,00Dh,00Eh,00Fh,010h,011h,012h,013h,014h,015h
         db       016h,017h,018h,019h,01Ah,01Bh,01Ch,01Dh,01Eh,01Fh,020h,021h,022h,023h,024h,025h,026h,027h,028h,029h
         db       02Ah,02Bh,02Ch,02Dh,02Eh,02Fh,030h,031h,032h,033h,034h,035h,036h,036h,037h,038h,039h,03Ah,03Bh,03Ch
         db       03Dh,03Eh,03Fh,040h,041h,042h,043h,044h,045h,046h,047h,048h,049h,04Ah,04Bh,04Ch,04Dh,04Eh,04Fh,050h
         db       051h,052h,053h,054h,055h,056h,057h,058h,059h,05Ah,05Bh,05Ch,05Dh,05Eh,05Fh,060h,061h,062h,063h,064h
         db       065h,066h,067h,067h,068h,069h,06Ah,06Bh,06Ch,06Dh,06Eh,06Fh,070h,071h,072h,073h,074h,075h,076h,077h
         db       078h,079h,07Ah,07Bh,07Ch,07Dh,07Eh,07Fh,080h,081h,082h,083h,084h,085h,086h,087h,088h,089h,08Ah,08Bh
         db       08Ch,08Dh,08Eh,08Fh,090h,091h,092h,093h,094h,095h,096h,097h,098h,099h,09Ah,09Bh,09Ch,09Dh,09Eh,09Fh
         db       0A0h,0A1h,0A2h,0A3h,0A4h,0A5h,0A6h,0A7h,0A8h,0A9h,0AAh,0ABh,0ACh,0ADh,0AEh,0AFh,0B0h,0B1h,0B2h,0B2h
         db       0B3h,0B4h,0B5h,0B6h,0B7h,0B8h,0B9h,0BAh,0BBh,0BCh,0BDh,0BEh,0BFh,0C0h,0C1h,0C2h,0C3h,0C4h,0C5h,0C6h
         db       0C7h,0C8h,0C9h,0CAh,0CBh,0CCh,0CDh,0CEh,0CFh,0D0h,0D1h,0D2h,0D3h,0D4h,0D5h,0D6h,0D7h,0D8h,0D9h,0DAh
         db       0DBh,0DCh,0DDh,0DEh,0DFh,0E0h,0E1h,0E2h,0E3h,0E4h,0E5h,0E6h,0E7h,0E8h,0E9h,0EAh,0EBh,0ECh,0EDh,0EEh
         db       0EFh,0F0h,0F1h,0F2h,0F3h,0F4h,0F5h,0F6h,0F7h,0F8h,0F9h,0FAh,0FBh,0FCh,0FDh,0FEh,001h,002h,003h,004h
         db       005h,006h,007h,008h,009h,00Ah,00Bh,00Ch,00Dh,00Eh,00Fh,010h,011h,012h,013h,014h,015h,016h,017h,018h
         db       019h,01Ah,01Bh,01Ch,01Dh,01Eh,01Fh,020h,021h,022h,023h,024h,025h,026h,027h,028h,029h,02Ah,02Bh,02Ch
         db       02Dh,02Eh,02Fh,030h,031h,032h,033h,034h,035h,036h,037h,038h,039h,03Ah,03Bh,03Ch,03Dh,03Eh,03Fh,040h
         db       041h,042h,043h,044h,045h,046h,047h,048h,049h,04Ah,04Bh,04Ch,04Dh,04Eh,04Eh,04Fh,050h,051h,052h,053h
         db       054h,055h,056h,057h,058h,059h,05Ah,05Bh,05Ch,05Dh,05Eh,05Fh,060h,061h,062h,063h,064h,065h,066h,067h
         db       068h,069h,06Ah,06Bh,06Ch,06Dh,06Eh,06Fh,070h,071h,072h,073h,074h,075h,076h,077h,078h,079h,07Ah,07Bh
         db       07Ch,07Dh,07Eh,07Fh,080h,081h,082h,083h,084h,085h,086h,087h,088h,089h,08Ah,08Bh,08Ch,08Dh,08Eh,08Fh
         db       090h,091h,092h,093h,094h,095h,096h,097h,098h,099h,09Ah,09Bh,09Ch,09Dh,09Eh,09Fh,0A0h,0A1h,0A2h,0A3h
         db       0A4h,0A5h,0A6h,0A7h,0A8h,0A9h,0AAh,0ABh,0ACh,0ADh,0AEh,0AFh,0B0h,0B1h,0B2h,0B3h,0B4h,0B5h,0B6h,0B7h
         db       0B8h,0B9h,0BAh,0BBh,0BCh,0BDh,0BEh,0BFh,0C0h,0C1h,0C2h,0C3h,0C4h,0C5h,0C6h,0C7h,0C8h,0C9h,0CAh,0CBh
         db       0CCh,0CDh,0CEh,0CFh,0D0h,0D1h,0D2h,0D3h,0D4h,0D5h,0D6h,0D7h,0D8h,0D9h,0DAh,0DBh,0DCh,0DDh,0DEh,0DFh
         db       0E0h,0E1h,0E2h,0E3h,0E4h,0E5h,0E6h,0E7h,0E8h,0E9h,0EAh,0EBh,0ECh,0EDh,0EEh,0EFh,0F0h,0F1h,0F2h,0F3h
         db       0F4h,0F5h,0F6h,0F7h,0F8h,0F9h,0FAh,0FBh,0FCh,0FDh,0FEh,0FFh,000h,001h,002h,003h,004h,005h,006h,007h
         db       008h,009h,00Ah,00Bh,00Ch,00Dh,00Eh,00Fh,010h,011h,012h,013h,014h,015h,016h,017h,018h,019h,01Ah,01Bh
         db       01Ch,01Dh,01Eh,01Fh,020h,021h,022h,023h,024h,025h,026h,027h,028h,029h,02Ah,02Bh,02Ch,02Dh,02Eh,02Fh
         db       030h,031h,032h,033h,034h,035h,036h,037h,038h,039h,03Ah,03Bh,03Ch,03Dh,03Eh,03Fh,040h,041h,042h,043h
         db       044h,045h,046h,047h,048h,049h,04Ah,04Bh,04Ch,04Dh,04Eh,04Fh,050h,051h,052h,053h,054h,055h,056h,057h
         db       058h,059h,05Ah,05Bh,05Ch,05Dh,05Eh,05Fh,060h,061h,062h,063h,064h,065h,066h,067h,068h,069h,06Ah,06Bh
         db       06Ch,06Dh,06Eh,06Fh,070h,071h,072h,073h,074h,075h,076h,077h,078h,079h,07Ah,07Bh,07Ch,07Dh,07Eh,07Fh

;
;  Voice Repartition Info (VRI) table (pannings from 00h to 0Fh)
;  size: 4 KB
;

VRItab   db       000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
         db       000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
         db       000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
         db       000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
         db       000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
         db       000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
         db       000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
         db       000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
         db       000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
         db       000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
         db       000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
         db       000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
         db       000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
         db       000h,000h,000h,000h,001h,001h,001h,001h,001h,001h,001h,001h,002h,002h,002h,002h,002h,002h,002h,002h
         db       003h,003h,003h,003h,003h,003h,003h,003h,004h,004h,004h,004h,004h,004h,004h,004h,005h,005h,005h,005h
         db       005h,005h,005h,005h,006h,006h,006h,006h,006h,006h,006h,006h,007h,007h,007h,007h,007h,007h,007h,007h
         db       008h,008h,008h,008h,008h,008h,008h,008h,009h,009h,009h,009h,009h,009h,009h,009h,00Ah,00Ah,00Ah,00Ah
         db       00Ah,00Ah,00Ah,00Ah,00Bh,00Bh,00Bh,00Bh,00Bh,00Bh,00Bh,00Bh,00Ch,00Ch,00Ch,00Ch,00Ch,00Ch,00Ch,00Ch
         db       00Dh,00Dh,00Dh,00Dh,00Dh,00Dh,00Dh,00Dh,00Eh,00Eh,00Eh,00Eh,00Eh,00Eh,00Eh,00Eh,00Fh,00Fh,00Fh,00Fh
         db       00Fh,00Fh,00Fh,00Fh,010h,010h,010h,010h,010h,010h,010h,010h,011h,011h,011h,011h,011h,011h,011h,011h
         db       012h,012h,012h,012h,012h,012h,012h,012h,013h,013h,013h,013h,013h,013h,013h,013h,014h,014h,014h,014h
         db       014h,014h,014h,014h,015h,015h,015h,015h,015h,015h,015h,015h,016h,016h,016h,016h,016h,016h,016h,016h
         db       017h,017h,017h,017h,017h,017h,017h,017h,018h,018h,018h,018h,018h,018h,018h,018h,019h,019h,019h,019h
         db       019h,019h,019h,019h,01Ah,01Ah,01Ah,01Ah,01Ah,01Ah,01Ah,01Ah,01Bh,01Bh,01Bh,01Bh,01Bh,01Bh,01Bh,01Bh
         db       01Ch,01Ch,01Ch,01Ch,01Ch,01Ch,01Ch,01Ch,01Dh,01Dh,01Dh,01Dh,01Dh,01Dh,01Dh,01Dh,01Eh,01Eh,01Eh,01Eh
         db       01Eh,01Eh,01Eh,01Eh,01Fh,01Fh,01Fh,01Fh,01Fh,01Fh,01Fh,01Fh,000h,000h,000h,000h,000h,000h,000h,000h
         db       001h,001h,001h,001h,001h,001h,001h,001h,002h,002h,002h,002h,002h,002h,002h,002h,003h,003h,003h,003h
         db       003h,003h,003h,003h,004h,004h,004h,004h,004h,004h,004h,004h,005h,005h,005h,005h,005h,005h,005h,005h
         db       006h,006h,006h,006h,006h,006h,006h,006h,007h,007h,007h,007h,007h,007h,007h,007h,008h,008h,008h,008h
         db       008h,008h,008h,008h,009h,009h,009h,009h,009h,009h,009h,009h,00Ah,00Ah,00Ah,00Ah,00Ah,00Ah,00Ah,00Ah
         db       00Bh,00Bh,00Bh,00Bh,00Bh,00Bh,00Bh,00Bh,00Ch,00Ch,00Ch,00Ch,00Ch,00Ch,00Ch,00Ch,00Dh,00Dh,00Dh,00Dh
         db       00Dh,00Dh,00Dh,00Dh,00Eh,00Eh,00Eh,00Eh,00Eh,00Eh,00Eh,00Eh,00Fh,00Fh,00Fh,00Fh,00Fh,00Fh,00Fh,00Fh
         db       010h,010h,010h,010h,010h,010h,010h,010h,011h,011h,011h,011h,011h,011h,011h,011h,012h,012h,012h,012h
         db       012h,012h,012h,012h,013h,013h,013h,013h,013h,013h,013h,013h,014h,014h,014h,014h,014h,014h,014h,014h
         db       015h,015h,015h,015h,015h,015h,015h,015h,016h,016h,016h,016h,016h,016h,016h,016h,017h,017h,017h,017h
         db       017h,017h,017h,017h,018h,018h,018h,018h,018h,018h,018h,018h,019h,019h,019h,019h,019h,019h,019h,019h
         db       01Ah,01Ah,01Ah,01Ah,01Ah,01Ah,01Ah,01Ah,01Bh,01Bh,01Bh,01Bh,01Bh,01Bh,01Bh,01Bh,01Ch,01Ch,01Ch,01Ch
         db       01Ch,01Ch,01Ch,01Ch,01Dh,01Dh,01Dh,01Dh,01Dh,01Dh,01Dh,01Dh,01Eh,01Eh,01Eh,01Eh,01Eh,01Eh,01Eh,01Eh
         db       01Fh,01Fh,01Fh,01Fh,01Fh,01Fh,01Fh,01Fh,000h,000h,000h,000h,001h,001h,001h,001h,002h,002h,002h,002h
         db       003h,003h,003h,003h,004h,004h,004h,004h,005h,005h,005h,005h,006h,006h,006h,006h,007h,007h,007h,007h
         db       008h,008h,008h,008h,009h,009h,009h,009h,00Ah,00Ah,00Ah,00Ah,00Bh,00Bh,00Bh,00Bh,00Ch,00Ch,00Ch,00Ch
         db       00Dh,00Dh,00Dh,00Dh,00Eh,00Eh,00Eh,00Eh,00Fh,00Fh,00Fh,00Fh,010h,010h,010h,010h,011h,011h,011h,011h
         db       012h,012h,012h,012h,013h,013h,013h,013h,014h,014h,014h,014h,015h,015h,015h,015h,016h,016h,016h,016h
         db       017h,017h,017h,017h,018h,018h,018h,018h,019h,019h,019h,019h,01Ah,01Ah,01Ah,01Ah,01Bh,01Bh,01Bh,01Bh
         db       01Ch,01Ch,01Ch,01Ch,01Dh,01Dh,01Dh,01Dh,01Eh,01Eh,01Eh,01Eh,01Fh,01Fh,01Fh,01Fh,020h,020h,020h,020h
         db       021h,021h,021h,021h,022h,022h,022h,022h,023h,023h,023h,023h,024h,024h,024h,024h,025h,025h,025h,025h
         db       026h,026h,026h,026h,027h,027h,027h,027h,028h,028h,028h,028h,029h,029h,029h,029h,02Ah,02Ah,02Ah,02Ah
         db       02Bh,02Bh,02Bh,02Bh,02Ch,02Ch,02Ch,02Ch,02Dh,02Dh,02Dh,02Dh,02Eh,02Eh,02Eh,02Eh,02Fh,02Fh,02Fh,02Fh
         db       030h,030h,030h,030h,031h,031h,031h,031h,032h,032h,032h,032h,033h,033h,033h,033h,034h,034h,034h,034h
         db       035h,035h,035h,035h,036h,036h,036h,036h,037h,037h,037h,037h,038h,038h,038h,038h,039h,039h,039h,039h
         db       03Ah,03Ah,03Ah,03Ah,03Bh,03Bh,03Bh,03Bh,03Ch,03Ch,03Ch,03Ch,03Dh,03Dh,03Dh,03Dh,03Eh,03Eh,03Eh,03Eh
         db       03Fh,03Fh,03Fh,03Fh,000h,000h,000h,000h,001h,001h,001h,001h,002h,002h,002h,002h,003h,003h,003h,003h
         db       004h,004h,004h,004h,005h,005h,005h,005h,006h,006h,006h,006h,007h,007h,007h,007h,008h,008h,008h,008h
         db       009h,009h,009h,009h,00Ah,00Ah,00Ah,00Ah,00Bh,00Bh,00Bh,00Bh,00Ch,00Ch,00Ch,00Ch,00Dh,00Dh,00Dh,00Dh
         db       00Eh,00Eh,00Eh,00Eh,00Fh,00Fh,00Fh,00Fh,010h,010h,010h,010h,011h,011h,011h,011h,012h,012h,012h,012h
         db       013h,013h,013h,013h,014h,014h,014h,014h,015h,015h,015h,015h,016h,016h,016h,016h,017h,017h,017h,017h
         db       018h,018h,018h,018h,019h,019h,019h,019h,01Ah,01Ah,01Ah,01Ah,01Bh,01Bh,01Bh,01Bh,01Ch,01Ch,01Ch,01Ch
         db       01Dh,01Dh,01Dh,01Dh,01Eh,01Eh,01Eh,01Eh,01Fh,01Fh,01Fh,01Fh,020h,020h,020h,020h,021h,021h,021h,021h
         db       022h,022h,022h,022h,023h,023h,023h,023h,024h,024h,024h,024h,025h,025h,025h,025h,026h,026h,026h,026h
         db       027h,027h,027h,027h,028h,028h,028h,028h,029h,029h,029h,029h,02Ah,02Ah,02Ah,02Ah,02Bh,02Bh,02Bh,02Bh
         db       02Ch,02Ch,02Ch,02Ch,02Dh,02Dh,02Dh,02Dh,02Eh,02Eh,02Eh,02Eh,02Fh,02Fh,02Fh,02Fh,030h,030h,030h,030h
         db       031h,031h,031h,031h,032h,032h,032h,032h,033h,033h,033h,033h,034h,034h,034h,034h,035h,035h,035h,035h
         db       036h,036h,036h,036h,037h,037h,037h,037h,038h,038h,038h,038h,039h,039h,039h,039h,03Ah,03Ah,03Ah,03Ah
         db       03Bh,03Bh,03Bh,03Bh,03Ch,03Ch,03Ch,03Ch,03Dh,03Dh,03Dh,03Dh,03Eh,03Eh,03Eh,03Eh,03Fh,03Fh,03Fh,03Fh
         db       000h,000h,000h,001h,001h,001h,002h,002h,003h,003h,003h,004h,004h,004h,005h,005h,006h,006h,006h,007h
         db       007h,007h,008h,008h,009h,009h,009h,00Ah,00Ah,00Ah,00Bh,00Bh,00Ch,00Ch,00Ch,00Dh,00Dh,00Dh,00Eh,00Eh
         db       00Fh,00Fh,00Fh,010h,010h,010h,011h,011h,012h,012h,012h,013h,013h,013h,014h,014h,015h,015h,015h,016h
         db       016h,016h,017h,017h,018h,018h,018h,019h,019h,019h,01Ah,01Ah,01Bh,01Bh,01Bh,01Ch,01Ch,01Ch,01Dh,01Dh
         db       01Eh,01Eh,01Eh,01Fh,01Fh,01Fh,020h,020h,021h,021h,021h,022h,022h,022h,023h,023h,024h,024h,024h,025h
         db       025h,025h,026h,026h,027h,027h,027h,028h,028h,028h,029h,029h,02Ah,02Ah,02Ah,02Bh,02Bh,02Bh,02Ch,02Ch
         db       02Dh,02Dh,02Dh,02Eh,02Eh,02Eh,02Fh,02Fh,030h,030h,030h,031h,031h,031h,032h,032h,033h,033h,033h,034h
         db       034h,034h,035h,035h,036h,036h,036h,037h,037h,037h,038h,038h,039h,039h,039h,03Ah,03Ah,03Ah,03Bh,03Bh
         db       03Ch,03Ch,03Ch,03Dh,03Dh,03Dh,03Eh,03Eh,03Fh,03Fh,03Fh,040h,040h,040h,041h,041h,042h,042h,042h,043h
         db       043h,043h,044h,044h,045h,045h,045h,046h,046h,046h,047h,047h,048h,048h,048h,049h,049h,049h,04Ah,04Ah
         db       04Bh,04Bh,04Bh,04Ch,04Ch,04Ch,04Dh,04Dh,04Eh,04Eh,04Eh,04Fh,04Fh,04Fh,050h,050h,051h,051h,051h,052h
         db       052h,052h,053h,053h,054h,054h,054h,055h,055h,055h,056h,056h,057h,057h,057h,058h,058h,058h,059h,059h
         db       05Ah,05Ah,05Ah,05Bh,05Bh,05Bh,05Ch,05Ch,05Dh,05Dh,05Dh,05Eh,05Eh,05Eh,05Fh,05Fh,000h,000h,000h,001h
         db       001h,001h,002h,002h,003h,003h,003h,004h,004h,004h,005h,005h,006h,006h,006h,007h,007h,007h,008h,008h
         db       009h,009h,009h,00Ah,00Ah,00Ah,00Bh,00Bh,00Ch,00Ch,00Ch,00Dh,00Dh,00Dh,00Eh,00Eh,00Fh,00Fh,00Fh,010h
         db       010h,010h,011h,011h,012h,012h,012h,013h,013h,013h,014h,014h,015h,015h,015h,016h,016h,016h,017h,017h
         db       018h,018h,018h,019h,019h,019h,01Ah,01Ah,01Bh,01Bh,01Bh,01Ch,01Ch,01Ch,01Dh,01Dh,01Eh,01Eh,01Eh,01Fh
         db       01Fh,01Fh,020h,020h,021h,021h,021h,022h,022h,022h,023h,023h,024h,024h,024h,025h,025h,025h,026h,026h
         db       027h,027h,027h,028h,028h,028h,029h,029h,02Ah,02Ah,02Ah,02Bh,02Bh,02Bh,02Ch,02Ch,02Dh,02Dh,02Dh,02Eh
         db       02Eh,02Eh,02Fh,02Fh,030h,030h,030h,031h,031h,031h,032h,032h,033h,033h,033h,034h,034h,034h,035h,035h
         db       036h,036h,036h,037h,037h,037h,038h,038h,039h,039h,039h,03Ah,03Ah,03Ah,03Bh,03Bh,03Ch,03Ch,03Ch,03Dh
         db       03Dh,03Dh,03Eh,03Eh,03Fh,03Fh,03Fh,040h,040h,040h,041h,041h,042h,042h,042h,043h,043h,043h,044h,044h
         db       045h,045h,045h,046h,046h,046h,047h,047h,048h,048h,048h,049h,049h,049h,04Ah,04Ah,04Bh,04Bh,04Bh,04Ch
         db       04Ch,04Ch,04Dh,04Dh,04Eh,04Eh,04Eh,04Fh,04Fh,04Fh,050h,050h,051h,051h,051h,052h,052h,052h,053h,053h
         db       054h,054h,054h,055h,055h,055h,056h,056h,057h,057h,057h,058h,058h,058h,059h,059h,05Ah,05Ah,05Ah,05Bh
         db       05Bh,05Bh,05Ch,05Ch,05Dh,05Dh,05Dh,05Eh,05Eh,05Eh,05Fh,05Fh,000h,000h,001h,001h,002h,002h,003h,003h
         db       004h,004h,005h,005h,006h,006h,007h,007h,008h,008h,009h,009h,00Ah,00Ah,00Bh,00Bh,00Ch,00Ch,00Dh,00Dh
         db       00Eh,00Eh,00Fh,00Fh,010h,010h,011h,011h,012h,012h,013h,013h,014h,014h,015h,015h,016h,016h,017h,017h
         db       018h,018h,019h,019h,01Ah,01Ah,01Bh,01Bh,01Ch,01Ch,01Dh,01Dh,01Eh,01Eh,01Fh,01Fh,020h,020h,021h,021h
         db       022h,022h,023h,023h,024h,024h,025h,025h,026h,026h,027h,027h,028h,028h,029h,029h,02Ah,02Ah,02Bh,02Bh
         db       02Ch,02Ch,02Dh,02Dh,02Eh,02Eh,02Fh,02Fh,030h,030h,031h,031h,032h,032h,033h,033h,034h,034h,035h,035h
         db       036h,036h,037h,037h,038h,038h,039h,039h,03Ah,03Ah,03Bh,03Bh,03Ch,03Ch,03Dh,03Dh,03Eh,03Eh,03Fh,03Fh
         db       040h,040h,041h,041h,042h,042h,043h,043h,044h,044h,045h,045h,046h,046h,047h,047h,048h,048h,049h,049h
         db       04Ah,04Ah,04Bh,04Bh,04Ch,04Ch,04Dh,04Dh,04Eh,04Eh,04Fh,04Fh,050h,050h,051h,051h,052h,052h,053h,053h
         db       054h,054h,055h,055h,056h,056h,057h,057h,058h,058h,059h,059h,05Ah,05Ah,05Bh,05Bh,05Ch,05Ch,05Dh,05Dh
         db       05Eh,05Eh,05Fh,05Fh,060h,060h,061h,061h,062h,062h,063h,063h,064h,064h,065h,065h,066h,066h,067h,067h
         db       068h,068h,069h,069h,06Ah,06Ah,06Bh,06Bh,06Ch,06Ch,06Dh,06Dh,06Eh,06Eh,06Fh,06Fh,070h,070h,071h,071h
         db       072h,072h,073h,073h,074h,074h,075h,075h,076h,076h,077h,077h,078h,078h,079h,079h,07Ah,07Ah,07Bh,07Bh
         db       07Ch,07Ch,07Dh,07Dh,07Eh,07Eh,07Fh,07Fh,000h,000h,001h,001h,002h,002h,003h,003h,004h,004h,005h,005h
         db       006h,006h,007h,007h,008h,008h,009h,009h,00Ah,00Ah,00Bh,00Bh,00Ch,00Ch,00Dh,00Dh,00Eh,00Eh,00Fh,00Fh
         db       010h,010h,011h,011h,012h,012h,013h,013h,014h,014h,015h,015h,016h,016h,017h,017h,018h,018h,019h,019h
         db       01Ah,01Ah,01Bh,01Bh,01Ch,01Ch,01Dh,01Dh,01Eh,01Eh,01Fh,01Fh,020h,020h,021h,021h,022h,022h,023h,023h
         db       024h,024h,025h,025h,026h,026h,027h,027h,028h,028h,029h,029h,02Ah,02Ah,02Bh,02Bh,02Ch,02Ch,02Dh,02Dh
         db       02Eh,02Eh,02Fh,02Fh,030h,030h,031h,031h,032h,032h,033h,033h,034h,034h,035h,035h,036h,036h,037h,037h
         db       038h,038h,039h,039h,03Ah,03Ah,03Bh,03Bh,03Ch,03Ch,03Dh,03Dh,03Eh,03Eh,03Fh,03Fh,040h,040h,041h,041h
         db       042h,042h,043h,043h,044h,044h,045h,045h,046h,046h,047h,047h,048h,048h,049h,049h,04Ah,04Ah,04Bh,04Bh
         db       04Ch,04Ch,04Dh,04Dh,04Eh,04Eh,04Fh,04Fh,050h,050h,051h,051h,052h,052h,053h,053h,054h,054h,055h,055h
         db       056h,056h,057h,057h,058h,058h,059h,059h,05Ah,05Ah,05Bh,05Bh,05Ch,05Ch,05Dh,05Dh,05Eh,05Eh,05Fh,05Fh
         db       060h,060h,061h,061h,062h,062h,063h,063h,064h,064h,065h,065h,066h,066h,067h,067h,068h,068h,069h,069h
         db       06Ah,06Ah,06Bh,06Bh,06Ch,06Ch,06Dh,06Dh,06Eh,06Eh,06Fh,06Fh,070h,070h,071h,071h,072h,072h,073h,073h
         db       074h,074h,075h,075h,076h,076h,077h,077h,078h,078h,079h,079h,07Ah,07Ah,07Bh,07Bh,07Ch,07Ch,07Dh,07Dh
         db       07Eh,07Eh,07Fh,07Fh,000h,000h,001h,001h,002h,003h,003h,004h,005h,005h,006h,006h,007h,008h,008h,009h
         db       00Ah,00Ah,00Bh,00Bh,00Ch,00Dh,00Dh,00Eh,00Fh,00Fh,010h,010h,011h,012h,012h,013h,014h,014h,015h,015h
         db       016h,017h,017h,018h,019h,019h,01Ah,01Ah,01Bh,01Ch,01Ch,01Dh,01Eh,01Eh,01Fh,01Fh,020h,021h,021h,022h
         db       023h,023h,024h,024h,025h,026h,026h,027h,028h,028h,029h,029h,02Ah,02Bh,02Bh,02Ch,02Dh,02Dh,02Eh,02Eh
         db       02Fh,030h,030h,031h,032h,032h,033h,033h,034h,035h,035h,036h,037h,037h,038h,038h,039h,03Ah,03Ah,03Bh
         db       03Ch,03Ch,03Dh,03Dh,03Eh,03Fh,03Fh,040h,041h,041h,042h,042h,043h,044h,044h,045h,046h,046h,047h,047h
         db       048h,049h,049h,04Ah,04Bh,04Bh,04Ch,04Ch,04Dh,04Eh,04Eh,04Fh,050h,050h,051h,051h,052h,053h,053h,054h
         db       055h,055h,056h,056h,057h,058h,058h,059h,05Ah,05Ah,05Bh,05Bh,05Ch,05Dh,05Dh,05Eh,05Fh,05Fh,060h,060h
         db       061h,062h,062h,063h,064h,064h,065h,065h,066h,067h,067h,068h,069h,069h,06Ah,06Ah,06Bh,06Ch,06Ch,06Dh
         db       06Eh,06Eh,06Fh,06Fh,070h,071h,071h,072h,073h,073h,074h,074h,075h,076h,076h,077h,078h,078h,079h,079h
         db       07Ah,07Bh,07Bh,07Ch,07Dh,07Dh,07Eh,07Eh,07Fh,080h,080h,081h,082h,082h,083h,083h,084h,085h,085h,086h
         db       087h,087h,088h,088h,089h,08Ah,08Ah,08Bh,08Ch,08Ch,08Dh,08Dh,08Eh,08Fh,08Fh,090h,091h,091h,092h,092h
         db       093h,094h,094h,095h,096h,096h,097h,097h,098h,099h,099h,09Ah,09Bh,09Bh,09Ch,09Ch,09Dh,09Eh,09Eh,09Fh
         db       000h,000h,001h,001h,002h,003h,003h,004h,005h,005h,006h,006h,007h,008h,008h,009h,00Ah,00Ah,00Bh,00Bh
         db       00Ch,00Dh,00Dh,00Eh,00Fh,00Fh,010h,010h,011h,012h,012h,013h,014h,014h,015h,015h,016h,017h,017h,018h
         db       019h,019h,01Ah,01Ah,01Bh,01Ch,01Ch,01Dh,01Eh,01Eh,01Fh,01Fh,020h,021h,021h,022h,023h,023h,024h,024h
         db       025h,026h,026h,027h,028h,028h,029h,029h,02Ah,02Bh,02Bh,02Ch,02Dh,02Dh,02Eh,02Eh,02Fh,030h,030h,031h
         db       032h,032h,033h,033h,034h,035h,035h,036h,037h,037h,038h,038h,039h,03Ah,03Ah,03Bh,03Ch,03Ch,03Dh,03Dh
         db       03Eh,03Fh,03Fh,040h,041h,041h,042h,042h,043h,044h,044h,045h,046h,046h,047h,047h,048h,049h,049h,04Ah
         db       04Bh,04Bh,04Ch,04Ch,04Dh,04Eh,04Eh,04Fh,050h,050h,051h,051h,052h,053h,053h,054h,055h,055h,056h,056h
         db       057h,058h,058h,059h,05Ah,05Ah,05Bh,05Bh,05Ch,05Dh,05Dh,05Eh,05Fh,05Fh,060h,060h,061h,062h,062h,063h
         db       064h,064h,065h,065h,066h,067h,067h,068h,069h,069h,06Ah,06Ah,06Bh,06Ch,06Ch,06Dh,06Eh,06Eh,06Fh,06Fh
         db       070h,071h,071h,072h,073h,073h,074h,074h,075h,076h,076h,077h,078h,078h,079h,079h,07Ah,07Bh,07Bh,07Ch
         db       07Dh,07Dh,07Eh,07Eh,07Fh,080h,080h,081h,082h,082h,083h,083h,084h,085h,085h,086h,087h,087h,088h,088h
         db       089h,08Ah,08Ah,08Bh,08Ch,08Ch,08Dh,08Dh,08Eh,08Fh,08Fh,090h,091h,091h,092h,092h,093h,094h,094h,095h
         db       096h,096h,097h,097h,098h,099h,099h,09Ah,09Bh,09Bh,09Ch,09Ch,09Dh,09Eh,09Eh,09Fh,000h,000h,001h,002h
         db       003h,003h,004h,005h,006h,006h,007h,008h,009h,009h,00Ah,00Bh,00Ch,00Ch,00Dh,00Eh,00Fh,00Fh,010h,011h
         db       012h,012h,013h,014h,015h,015h,016h,017h,018h,018h,019h,01Ah,01Bh,01Bh,01Ch,01Dh,01Eh,01Eh,01Fh,020h
         db       021h,021h,022h,023h,024h,024h,025h,026h,027h,027h,028h,029h,02Ah,02Ah,02Bh,02Ch,02Dh,02Dh,02Eh,02Fh
         db       030h,030h,031h,032h,033h,033h,034h,035h,036h,036h,037h,038h,039h,039h,03Ah,03Bh,03Ch,03Ch,03Dh,03Eh
         db       03Fh,03Fh,040h,041h,042h,042h,043h,044h,045h,045h,046h,047h,048h,048h,049h,04Ah,04Bh,04Bh,04Ch,04Dh
         db       04Eh,04Eh,04Fh,050h,051h,051h,052h,053h,054h,054h,055h,056h,057h,057h,058h,059h,05Ah,05Ah,05Bh,05Ch
         db       05Dh,05Dh,05Eh,05Fh,060h,060h,061h,062h,063h,063h,064h,065h,066h,066h,067h,068h,069h,069h,06Ah,06Bh
         db       06Ch,06Ch,06Dh,06Eh,06Fh,06Fh,070h,071h,072h,072h,073h,074h,075h,075h,076h,077h,078h,078h,079h,07Ah
         db       07Bh,07Bh,07Ch,07Dh,07Eh,07Eh,07Fh,080h,081h,081h,082h,083h,084h,084h,085h,086h,087h,087h,088h,089h
         db       08Ah,08Ah,08Bh,08Ch,08Dh,08Dh,08Eh,08Fh,090h,090h,091h,092h,093h,093h,094h,095h,096h,096h,097h,098h
         db       099h,099h,09Ah,09Bh,09Ch,09Ch,09Dh,09Eh,09Fh,09Fh,0A0h,0A1h,0A2h,0A2h,0A3h,0A4h,0A5h,0A5h,0A6h,0A7h
         db       0A8h,0A8h,0A9h,0AAh,0ABh,0ABh,0ACh,0ADh,0AEh,0AEh,0AFh,0B0h,0B1h,0B1h,0B2h,0B3h,0B4h,0B4h,0B5h,0B6h
         db       0B7h,0B7h,0B8h,0B9h,0BAh,0BAh,0BBh,0BCh,0BDh,0BDh,0BEh,0BFh,000h,000h,001h,002h,003h,003h,004h,005h
         db       006h,006h,007h,008h,009h,009h,00Ah,00Bh,00Ch,00Ch,00Dh,00Eh,00Fh,00Fh,010h,011h,012h,012h,013h,014h
         db       015h,015h,016h,017h,018h,018h,019h,01Ah,01Bh,01Bh,01Ch,01Dh,01Eh,01Eh,01Fh,020h,021h,021h,022h,023h
         db       024h,024h,025h,026h,027h,027h,028h,029h,02Ah,02Ah,02Bh,02Ch,02Dh,02Dh,02Eh,02Fh,030h,030h,031h,032h
         db       033h,033h,034h,035h,036h,036h,037h,038h,039h,039h,03Ah,03Bh,03Ch,03Ch,03Dh,03Eh,03Fh,03Fh,040h,041h
         db       042h,042h,043h,044h,045h,045h,046h,047h,048h,048h,049h,04Ah,04Bh,04Bh,04Ch,04Dh,04Eh,04Eh,04Fh,050h
         db       051h,051h,052h,053h,054h,054h,055h,056h,057h,057h,058h,059h,05Ah,05Ah,05Bh,05Ch,05Dh,05Dh,05Eh,05Fh
         db       060h,060h,061h,062h,063h,063h,064h,065h,066h,066h,067h,068h,069h,069h,06Ah,06Bh,06Ch,06Ch,06Dh,06Eh
         db       06Fh,06Fh,070h,071h,072h,072h,073h,074h,075h,075h,076h,077h,078h,078h,079h,07Ah,07Bh,07Bh,07Ch,07Dh
         db       07Eh,07Eh,07Fh,080h,081h,081h,082h,083h,084h,084h,085h,086h,087h,087h,088h,089h,08Ah,08Ah,08Bh,08Ch
         db       08Dh,08Dh,08Eh,08Fh,090h,090h,091h,092h,093h,093h,094h,095h,096h,096h,097h,098h,099h,099h,09Ah,09Bh
         db       09Ch,09Ch,09Dh,09Eh,09Fh,09Fh,0A0h,0A1h,0A2h,0A2h,0A3h,0A4h,0A5h,0A5h,0A6h,0A7h,0A8h,0A8h,0A9h,0AAh
         db       0ABh,0ABh,0ACh,0ADh,0AEh,0AEh,0AFh,0B0h,0B1h,0B1h,0B2h,0B3h,0B4h,0B4h,0B5h,0B6h,0B7h,0B7h,0B8h,0B9h
         db       0BAh,0BAh,0BBh,0BCh,0BDh,0BDh,0BEh,0BFh,000h,000h,001h,002h,003h,004h,005h,006h,007h,007h,008h,009h
         db       00Ah,00Bh,00Ch,00Dh,00Eh,00Eh,00Fh,010h,011h,012h,013h,014h,015h,015h,016h,017h,018h,019h,01Ah,01Bh
         db       01Ch,01Ch,01Dh,01Eh,01Fh,020h,021h,022h,023h,023h,024h,025h,026h,027h,028h,029h,02Ah,02Ah,02Bh,02Ch
         db       02Dh,02Eh,02Fh,030h,031h,031h,032h,033h,034h,035h,036h,037h,038h,038h,039h,03Ah,03Bh,03Ch,03Dh,03Eh
         db       03Fh,03Fh,040h,041h,042h,043h,044h,045h,046h,046h,047h,048h,049h,04Ah,04Bh,04Ch,04Dh,04Dh,04Eh,04Fh
         db       050h,051h,052h,053h,054h,054h,055h,056h,057h,058h,059h,05Ah,05Bh,05Bh,05Ch,05Dh,05Eh,05Fh,060h,061h
         db       062h,062h,063h,064h,065h,066h,067h,068h,069h,069h,06Ah,06Bh,06Ch,06Dh,06Eh,06Fh,070h,070h,071h,072h
         db       073h,074h,075h,076h,077h,077h,078h,079h,07Ah,07Bh,07Ch,07Dh,07Eh,07Eh,07Fh,080h,081h,082h,083h,084h
         db       085h,085h,086h,087h,088h,089h,08Ah,08Bh,08Ch,08Ch,08Dh,08Eh,08Fh,090h,091h,092h,093h,093h,094h,095h
         db       096h,097h,098h,099h,09Ah,09Ah,09Bh,09Ch,09Dh,09Eh,09Fh,0A0h,0A1h,0A1h,0A2h,0A3h,0A4h,0A5h,0A6h,0A7h
         db       0A8h,0A8h,0A9h,0AAh,0ABh,0ACh,0ADh,0AEh,0AFh,0AFh,0B0h,0B1h,0B2h,0B3h,0B4h,0B5h,0B6h,0B6h,0B7h,0B8h
         db       0B9h,0BAh,0BBh,0BCh,0BDh,0BDh,0BEh,0BFh,0C0h,0C1h,0C2h,0C3h,0C4h,0C4h,0C5h,0C6h,0C7h,0C8h,0C9h,0CAh
         db       0CBh,0CBh,0CCh,0CDh,0CEh,0CFh,0D0h,0D1h,0D2h,0D2h,0D3h,0D4h,0D5h,0D6h,0D7h,0D8h,0D9h,0D9h,0DAh,0DBh
         db       0DCh,0DDh,0DEh,0DFh,000h,000h,001h,002h,003h,004h,005h,006h,007h,007h,008h,009h,00Ah,00Bh,00Ch,00Dh
         db       00Eh,00Eh,00Fh,010h,011h,012h,013h,014h,015h,015h,016h,017h,018h,019h,01Ah,01Bh,01Ch,01Ch,01Dh,01Eh
         db       01Fh,020h,021h,022h,023h,023h,024h,025h,026h,027h,028h,029h,02Ah,02Ah,02Bh,02Ch,02Dh,02Eh,02Fh,030h
         db       031h,031h,032h,033h,034h,035h,036h,037h,038h,038h,039h,03Ah,03Bh,03Ch,03Dh,03Eh,03Fh,03Fh,040h,041h
         db       042h,043h,044h,045h,046h,046h,047h,048h,049h,04Ah,04Bh,04Ch,04Dh,04Dh,04Eh,04Fh,050h,051h,052h,053h
         db       054h,054h,055h,056h,057h,058h,059h,05Ah,05Bh,05Bh,05Ch,05Dh,05Eh,05Fh,060h,061h,062h,062h,063h,064h
         db       065h,066h,067h,068h,069h,069h,06Ah,06Bh,06Ch,06Dh,06Eh,06Fh,070h,070h,071h,072h,073h,074h,075h,076h
         db       077h,077h,078h,079h,07Ah,07Bh,07Ch,07Dh,07Eh,07Eh,07Fh,080h,081h,082h,083h,084h,085h,085h,086h,087h
         db       088h,089h,08Ah,08Bh,08Ch,08Ch,08Dh,08Eh,08Fh,090h,091h,092h,093h,093h,094h,095h,096h,097h,098h,099h
         db       09Ah,09Ah,09Bh,09Ch,09Dh,09Eh,09Fh,0A0h,0A1h,0A1h,0A2h,0A3h,0A4h,0A5h,0A6h,0A7h,0A8h,0A8h,0A9h,0AAh
         db       0ABh,0ACh,0ADh,0AEh,0AFh,0AFh,0B0h,0B1h,0B2h,0B3h,0B4h,0B5h,0B6h,0B6h,0B7h,0B8h,0B9h,0BAh,0BBh,0BCh
         db       0BDh,0BDh,0BEh,0BFh,0C0h,0C1h,0C2h,0C3h,0C4h,0C4h,0C5h,0C6h,0C7h,0C8h,0C9h,0CAh,0CBh,0CBh,0CCh,0CDh
         db       0CEh,0CFh,0D0h,0D1h,0D2h,0D2h,0D3h,0D4h,0D5h,0D6h,0D7h,0D8h,0D9h,0D9h,0DAh,0DBh,0DCh,0DDh,0DEh,0DFh
         db       000h,001h,002h,003h,004h,005h,006h,007h,008h,009h,00Ah,00Bh,00Ch,00Dh,00Eh,00Fh,010h,011h,012h,013h
         db       014h,015h,016h,017h,018h,019h,01Ah,01Bh,01Ch,01Dh,01Eh,01Fh,020h,021h,022h,023h,024h,025h,026h,027h
         db       028h,029h,02Ah,02Bh,02Ch,02Dh,02Eh,02Fh,030h,031h,032h,033h,034h,035h,036h,037h,038h,039h,03Ah,03Bh
         db       03Ch,03Dh,03Eh,03Fh,040h,041h,042h,043h,044h,045h,046h,047h,048h,049h,04Ah,04Bh,04Ch,04Dh,04Eh,04Fh
         db       050h,051h,052h,053h,054h,055h,056h,057h,058h,059h,05Ah,05Bh,05Ch,05Dh,05Eh,05Fh,060h,061h,062h,063h
         db       064h,065h,066h,067h,068h,069h,06Ah,06Bh,06Ch,06Dh,06Eh,06Fh,070h,071h,072h,073h,074h,075h,076h,077h
         db       078h,079h,07Ah,07Bh,07Ch,07Dh,07Eh,07Fh,080h,081h,082h,083h,084h,085h,086h,087h,088h,089h,08Ah,08Bh
         db       08Ch,08Dh,08Eh,08Fh,090h,091h,092h,093h,094h,095h,096h,097h,098h,099h,09Ah,09Bh,09Ch,09Dh,09Eh,09Fh
         db       0A0h,0A1h,0A2h,0A3h,0A4h,0A5h,0A6h,0A7h,0A8h,0A9h,0AAh,0ABh,0ACh,0ADh,0AEh,0AFh,0B0h,0B1h,0B2h,0B3h
         db       0B4h,0B5h,0B6h,0B7h,0B8h,0B9h,0BAh,0BBh,0BCh,0BDh,0BEh,0BFh,0C0h,0C1h,0C2h,0C3h,0C4h,0C5h,0C6h,0C7h
         db       0C8h,0C9h,0CAh,0CBh,0CCh,0CDh,0CEh,0CFh,0D0h,0D1h,0D2h,0D3h,0D4h,0D5h,0D6h,0D7h,0D8h,0D9h,0DAh,0DBh
         db       0DCh,0DDh,0DEh,0DFh,0E0h,0E1h,0E2h,0E3h,0E4h,0E5h,0E6h,0E7h,0E8h,0E9h,0EAh,0EBh,0ECh,0EDh,0EEh,0EFh
         db       0F0h,0F1h,0F2h,0F3h,0F4h,0F5h,0F6h,0F7h,0F8h,0F9h,0FAh,0FBh,0FCh,0FDh,0FEh,0FFh

