;     Ŀ
;        Sound Deluxe System 5, a Maple Leaf production               
;        1996-1997                                                    
;           
;        IRQ specific routines                                        
;     

irqMask     dw       0
irqOldIRQ   dd       0

;
; The following routine redirects the IRQ entry to a user's specified
; routine, whose offset is given in DX
;
; In: DX=offset of the IRQ handler routine (interrupt type)
;

nproc   irqRedirectIRQ

        push     ds es ax bx cx dx

        mov      cl,cs:mxIRQ    ;-\
        mov      bx,1           ; | - Compute mask
        shl      bx,cl          ; |
        not      bx             ;-/

        in       al,0a1h        ;-\
        mov      ah,al          ; | - Get IRQ masks
        in       al,21h         ;-/

        mov      cs:IRQmask,ax   ; Store'em

        and      ax,bx
        out      21h,al         ;-\
        mov      al,ah          ; |- Mask interrupts
        out      0a1h,al        ;-/

        mov      ax,3508h
        add      al,cs:mxIRQ
        cmp      cs:mxIRQ,7
        sjbe     irqe18
        add      al,60h  ; pm irq
irqe18: push     ax
        int      21h            ; Get old interrupt vector in ES:BX
        pop      ax

        mov      word ptr cs:irqOldIRQ,bx     ;
        mov      word ptr cs:irqOldIRQ[2],es  ; Store it

        cli
        mov      ah,25h
        mov      dx,cs
        mov      ds,dx
        pop      dx     ; restore original !
        int      21h                  ; Set new IRQ vector
        sti

        pop      cx bx ax es ds

        retn
nendp   irqRedirectIRQ

;
; The following routine restores the original IRQ entry (interrupt vector)
; and the original IRQ mask word.
;
; In: nothing
;

nproc   irqRestoreIRQ
        push     ax dx ds
        cli
        lds      dx,cs:irqOldIRQ
        mov      ax,2508h
        add      al,cs:mxIRQ
        cmp      cs:mxIRQ,7
        sjbe     irqe21
        add      al,60h
irqe21: int      21h           ; Restore old IRQ vector
        mov      ax,cs:irqMask
        out      21h,al        ;
        mov      al,ah         ;  Restore old IRQ mask
        out      0a1h,al       ;
        pop      ds dx ax
        sti
        retn
nendp   irqRestoreIRQ
