{$M 20000,0,0} {don't forget to reduce the heap!}
uses sdslite, sds_det, crt, alloc, esb, strings;
{ Note that, since this is a SDM player, we don't need the loaders for
  a thousand module formats, so we use SDSLITE instead of SDS ! }

{
  Sound Deluxe System 5, a Maple Leaf production, 1996-1997
  Simple module player
}

var module   : pointer;
    services : pointer;
    ch       : char;
    k        : word;
    stat     : longint;

function choosecard:word;
begin
  choosecard:= DetectSoundCard(Base, Irq, Dma);
end;

procedure incvolume;near;assembler;
asm
  mov ah,6
  call dword ptr services
end;

procedure decvolume;near;assembler;
asm
  mov ah,7
  call dword ptr services
end;

procedure incAmplification;near;
var amp:integer;
begin
   amp:=getESBword(32) + 5;
   asm
     mov ah,3
     mov bx,amp
     call dword ptr services
   end
end;

procedure decAmplification;near;
var amp:integer;
begin
   amp:=getESBword(32) - 5;
   if amp<25 then amp:=25;
   asm
     mov ah,3
     mov bx,amp
     call dword ptr services
   end
end;

procedure incmastervol;near;
var vol:byte;
begin
   vol:=getesbbyte(31);
   if vol+$8<256 then inc(vol,$8) else vol:=$FF;
   asm
     mov ah,2
     mov al,vol
     call dword ptr services
   end
end;

procedure decmastervol;near;
var vol:byte;
begin
   vol:=getesbbyte(31);
   if vol-$8>=0 then dec(vol,$8) else vol:=0;
   asm
     mov ah,2
     mov al,vol
     call dword ptr services
   end
end;

procedure MyFuckinRoutine;far;
begin
  asm mov ax,seg @DATA; mov ds,ax end;
  write(#13,'Loading ');
  case Action of
    1 : write ('header');
    2 : write ('pattern ',actionPARA);
    3 : write ('sample ',actionPARA);
    4 : write ('channel ',actionPARA);
    5 : write ('text');
    6 : write ('descriptor #',actionPARA);
    else write('something (unknown)');
  end;
  write(', Available mem: ',sds_mavail div 1024,' kb');
  clreol;
end;

var temp:byte;

begin
  writeln('Ŀ');
  writeln('  Sound Deluxe System 5, a Maple Leaf production, 1996-1997      ');
  writeln('  SDM player 1.0, using SDS Lite (example program)               ');
  writeln('    ');
  writeln('  For problems/questions concerning this program or any other    ');
  writeln('  part of Sound Deluxe System, please contact me.                ');
  writeln('');
  writeln;

  if paramcount=0 then begin
    writeln(#13#10'Usage: PLAYER module_name');
    halt;
  end;

  card:=choosecard;

  writeln('Init sound system (using port ',dec2Hex(base),', IRQ',irq,', DMA #',Dma,') ...');
  sds_init(Card{Card#},Base{BasePort},Irq{IRQ},DMA{DMA#});

  write('Loading module ...');
  UseEMS:=true;
  UseUMB:=true;

  UserRoutine:=@MyFuckinRoutine;
  module:=sds_load(ParamStr(1),(card<>Silence){load samples only if card is NOT UltraSilence});

  if loaderror<>0 then begin
    writeln(#13#10'Error loading module (errorcode=',loaderror,')');
    sds_done; {don't forget to close SDS before exit!}
    halt
  end;

  if card=GUS then writeln(#13#10,round(gus_DRAM/1024),' kb of GUS DRAM detected');

  services:=pointer(GetESBdword(44));

  writeln;
  textattr:=15;
  writeln('"',ModuleName,'"');
  textattr:=10;
  writeln(channels,' channels, ',patterns,' patterns, ',entries,' orders, ',Samples,' samples');

  textattr:=7;

  writeln('Some settings...');
  sds_setsurround(on);
  sds_setpollmix(on);

  writeln('Starting play...');
  sds_startplay(module, 0{InitSpeed(0=auto)}, 44000{MixSpeed}, NTSC{1=Pal,0=NTSC});

  writeln('Press ESC to stop.');

  repeat

    repeat

      if getesbbyte(35) and 4 <> 0 then
        write(#13'PAUSED. Press "u" to resume.')
      else
        write(#13,getesbword(20):2,'(',
                  getesbword(22):2,'):',
                  getesbword(26):2,'/',
                  getesbword(24)-1:2,
                  ',Spd=',getesbword(36),
                  ',BPM=',dec2hex(getesbword(38)),
                  ',UC=',dec2hex(getesbdword(53)),
                  ',V=',dec2hex(getesbbyte(30)),
                  ',MV=',dec2hex(getesbbyte(31)),
                  ',A=',getesbword(32),
                  {',Dst=',dec2hex(getesbword(58)),{}
                  ',PattOffs=',dec2hex(getesbword(40)),{}
                  ',S:',getesbbyte(34));

      temp:=getesbbyte(38);

      clreol;

      {do a new poll mixing}
      asm
        {music can be polled now}
          {call sds_poll  {has effect only in POLL mode}
          mov ah,0a0h
          mov dh,24
          int 2fh  {*********POLL MIX USING API #2***********}
          cmp temp,174  { if BPM>174, do this again ! (see docs) }
          jbe @3
          mov ah,0a0h
          mov dh,24
          int 2fh  {*********POLL MIX USING API #2***********}
      @3:
        {wait for vertical retrace to finish}
          mov dx,3dah
      @2: in al,dx
          test al,8
          jnz @2
        {wait for a vertical retrace to start}
      @1: in al,dx
          test al,8
          jz @1
      end;
    until keypressed;

    repeat ch:=ReadKey until ch<>#0;

    case ch of
      '+' : incvolume;
      '-' : decvolume;
      '[' : decamplification;
      ']' : incamplification;
      'p' : sds_setpollmix(not(bytebool(getesbbyte(48))));
      '{' : decmastervol;
      '}' : incmastervol;
      's' : begin  {surround/normal}
              k:=getesbbyte(34);
              k:=word(not wordbool(k));
              asm
                mov ax,k
                mov ah,04h
                call dword ptr services
              end
            end;
      '>' : begin {skip pattern}
              asm
                mov ah,17
                call dword ptr services
              end
            end;
      '1'..'9' : begin { on/off channel - Dxx command still has problems w/ it ! }
              stat:=getesbdword(49);
              k:=byte(ch)-byte('1');
              if (stat and (1 shl k) = 0) then
                asm
                  mov ax,k
                  mov ah,9
                  call dword ptr services
                end
              else
                asm
                  mov ax,k
                  mov ah,10
                  call dword ptr services
                end
            end;
      'u' : begin {pause/restart}
              k:=getesbbyte(35); {flags byte}
              if (k and 2 = 2) and (k and 4 = 0) then
                asm {sds is playing, must be paused}
                  mov ah,20
                  call dword ptr services
                end
              else
                asm {sds is paused, must be restarted}
                  mov ah,21
                  call dword ptr services
                end;
            end;
    end;
  until ch=#27;

  writeln(#13#10#13#10'Stopping ...');  sds_stopplay;
  writeln('Shuting down SDS ...');      sds_done;
  writeln('Unloading module ...');      sds_unload(module);

  if loaderror<>0 then writeln('Deallocation error.');
end.