 unit NewTypes;

 interface

 uses
     EMS;


   const
       PanPosition : integer = 32; {0-64}

       FreqMOD         = 8287 {3546895 div 214}; {16574 Hz ; ! indpendant du rglage fin}
       Freq669         = 8740;
       FreqXM          = 8363;
       F0_All          = 1712;   {1712}
       Cst_ST3:longint = 1712*8363;
       NPistesMax      =  32; {Nbre max de pistes}
       Motif_Lu_Max    = 255; {Indx max d'arrangements}
       Motif_Max       = 255; {Indx max de motifs}
       Max_Inst        = 127; {Indx max d'instruments}
       Max_Smp         = 127; {Indx max d'chantillons doit etre >= MaxInst}

       Base_Tempo_669  =  75;
       Freq_Default    = 125; { 125 }
       TicksDefault    =   6; {Impulsions par note (6)}

       Sample_Min_Size =     4;
       Sample_Max_Size = 64000;
       Sample_Suffix_Size = 512; {! Attention  la pagination EMS }

       Period_Max:word = 27392;
       Period_Min:word = 28;
       Max_Notes       = 119; { >95 (XM) }
       NoteMax   : byte = Max_Notes;
       NoteMaxXM : byte = 95;
   type
       Octave_Array = array[0..Max_Notes] of word;
   const
       Octaves : Octave_Array = {C-0 - B-9}
     (27392,25856,24384,23040,21696,20480,19328,18240,17216,16256,15360,14512,
      13696,12928,12192,11520,10848,10240, 9664, 9120, 8608, 8128, 7680, 7256,
       6848, 6464, 6096, 5760, 5424, 5120, 4832, 4560, 4304, 4064, 3840, 3628,
       3424, 3232, 3048, 2880, 2712, 2560, 2416, 2280, 2152, 2032, 1920, 1814,
       1712, 1616, 1524, 1440, 1356, 1280, 1208, 1140, 1076, 1016,  960,  907,
        856,  808,  762,  720,  678,  640,  604,  570,  538,  508,  480,  453,
        428,  404,  381,  360,  339,  320,  302,  285,  269,  254,  240,  226,
        214,  202,  190,  180,  169,  160,  151,  142,  134,  127,  120,  113,
        107,  101,   95,   90,   84,   80,   75,   71,   67,   63,   60,   56,
         53,   50,   47,   45,   42,   40,   37,   35,   33,   31,   30,   28);
       Sinus : array[0..31] of byte =
       ($00,$19,$32,$4A,$62,$78,$8E,$A2,$B4,$C5,$D4,$E1,$EC,$F4,$FA,$FE,$FF,
        $FE,$FA,$F4,$EC,$E1,$D4,$C5,$B4,$A2,$8E,$78,$62,$4A,$32,$19);
       Fine_Tune : array[0..15] of word =
       (8287,8326,8405,8485,8526,8609,8651,8693,
        7847,7882,7953,7989,8061,8098,8173,8210);
       Fine_Tune_XM : array[0..15] of word =
       (8363,8413,8463,8529,8581,8651,8723,8757,
        7895,7941,7985,8046,8107,8169,8232,8280);
       Retrig_Data : array[0..15] of shortint =
       (0,-1,-2,-4,-8,-16,0,0,0,1,2,4,8,16,0,0);

       Keyb_Table_1 : array[0..53] of byte =
       ($FF,$FF,$FF,49,51,$FF,54,56,58,$FF,$FF,$FF,$FF,$FF,$FF,$FF,
       48,50,52,53,55,57,59,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,
       $FF,$FF,61,63,$FF,66,68,70,$FF,$FF,$FF,$FF,$FF,$FF,$FF,60,
       62,64,65,67,69,71);

  type
      BuffD    = array[0..1083] of byte;
      PBuff    = ^BuffD;
      Buff2D   = array[0..2293] of byte;
      PBuff2   = ^Buff2D;

      TEMSBlock = array[0..Max_Smp] of PEMSBlock;

      Instruments = record
                          Nom_Instrument   : array[1..22] of char;
                          Long             : word;
                          Reg_Fin          : shortint;
                          Vol              : byte;
                          Debut_B          : word;
                          Longueur_B       : word;
                    end;

      InstrS3M = record
		      InstType    : byte;
                      DOS_Name    : array[1..12] of char;
                      MemSegHi    : byte;
                      MemSeg      : word;
                      Length      : longint;
                      LoopBegin   : longint;
                      LoopEnd     : longint;
                      Vol         : byte;
                      Dummy       : byte;
                      Pack        : byte;
                      Flags       : byte;
                      Frequency   : word;
                      FrequencyHi : word;
                      Dummy2      : longint;
                      Dummy3      : array[1..8] of byte;
                      Inst_Name   : array[1..28] of char;
                      Ident       : array[1..4] of char;
                end;

      EchantXM = record
                      Length      : longint;
                      Debut_B     : longint;
                      Long_B      : longint;
                      Vol         : byte;
                      Reg_Fin     : shortint;
                      Flags       : byte;
		      Pan_Pos     : byte;
                      Note_Pos    : shortint;
                      Dummy       : byte;
                      Inst_Name   : array[1..22] of char;
                 end;

      InstrMTM = record
                       Nom_Instrument  : array[1..22] of char;
                       Longueur        : longint;
                       Debut_B         : longint;
                       Fin_B           : longint;
                       Reglage_Fin     : byte;
                       Vol             : byte;
                       Attribut        : byte;
                 end;

      Instr669 = record
		       Nom_Instrument  : array[1..13] of char;
                       Longueur        : longint;
                       Debut_B         : word;
                       Vide            : word;
                       Fin_B           : word;
                       Vide_           : word;
                 end;

      PInstruments = ^Instruments;
      PInstS3M = ^InstrS3M;
      PInstMTM = ^InstrMTM;
      PInst669 = ^Instr669;
      PInstXM  = ^EchantXM;

      TName    = array[1..28] of char;
      Inst_Names = array[0..Max_Inst] of TName;

      TMotif = array[0..Motif_Max] of word;
      P_TMotif = ^TMotif;

      TMotifPointer = array[0..Motif_Max] of pointer;
      P_TempMotif = ^TMotifPointer;

      TPosMotif = array[0..Motif_Max] of longint;
      P_TPosMotif = ^TPosMotif;

      TPosSmp = array[0..Max_Smp] of longint;
      P_TPosSmp = ^TPosSmp;

      TInstSmp = array[0..95] of byte;
      P_TInstSmp = ^TInstSmp;

      TLinear_Table = array[0..767] of longint;
      P_TLinear_Table = ^TLinear_Table;
      Track_Array_W = array[0..NPistesMax-1] of word;
      Inst_Array_D = array[0..Max_Smp] of longint;
      Inst_Array_Bool = array[0..Max_Inst] of boolean;
      Inst_Array_B = array[0..Max_Inst] of byte;
      SComType = array[0..$0F] of byte;
      ComType = array[0..24] of byte;

  var
     Nom_Morceau          : TName;
     Nombre_Motifs_Lus    : byte;
     Extra_Patterns       : word;
     Arrangement          : array[0..Motif_Lu_Max] of byte;
     Marquage             : string[20];

  var
     Nombre_Instruments      ,
     Nombre_Echantillons     ,
     Global_Volume           ,
     Master_Volume           : byte;
     Nom_Inst                : ^Inst_Names;
     Bouclage_Echant         : array[0..Max_Smp] of word;
     Nombre_Motifs           ,
     Adresse_1er_Motif       ,
     Adresse_1er_Echantillon ,
     Donnees_Echantillons    ,
     Donnees_Motifs          ,
     Comp_Donnees_Motifs     ,
     Mem_Samples_Used        ,
     Mem_Samples16_Used      ,
     Taille_Module           : longint;

  var
     Longueur_F          ,
     Longueur_M          ,
     Debut_Boucle        ,
     Longueur_Boucle     : Inst_Array_D;
  var
     Freq_Echant       ,
     Volume_Echant     : array[0..Max_Smp] of word;
     Inst_Fading       : array[0..Max_Inst] of word;
     Inst_Used         : Inst_Array_Bool;
     SmpPointer        : array[0..Max_Smp] of pointer;
     Inst_Vol_Pointers ,
     Inst_Pan_Pointers : array[0..Max_Inst] of pointer;
     Inst_Smp_Pointers : array[0..Max_Smp] of P_TInstSmp;
     Smp_Res           ,
     Smp_Tune          ,
     Smp_Shift         ,
     Smp_Pan           : array[0..Max_Smp] of byte;
     Inst_Vol_Type     ,
     Inst_Vol_NPoints  ,
     Inst_Vol_SustainPoint,
     Inst_Vol_LoopEnd  ,
     Inst_Vol_LoopStart,
     Inst_Pan_Type     ,
     Inst_Pan_NPoints  ,
     Inst_Pan_SustainPoint,
     Inst_Pan_LoopEnd  ,
     Inst_Pan_LoopStart,
     Inst_Sample       : Inst_Array_B;

  var
     I,J                              ,
     BytesPerNote                     : byte;
     SamplesSigned                    ,
     Delta_Samples                    ,
     Man_Pattern_Break                ,
     Data_Present                     ,
     Filter,Ok                        : boolean;
     Module_Sample                    ,
     Module_XM,Module_WAV,Module_XI   ,
     Module_MOD,Module_S3M            ,
     Module_MTM,Module_669            ,
     Full_16bit_Samples               : boolean;
     Fade_Out_Delay                   : word;
     BytesPerRow,BytesPerPattern      : word;
     Elapsed_Time,Point_Motif         ,
     Memory_Avail,MaxMemInst          : longint;
     Motif_Courant,InitPointer        ,
     Patt_loop_start,PCompress        ,
     Current_Patt_P                   : pointer;
     Longueur_Motif_Max               ,
     Leng                             : word;
     Longueur_Inst_Max                ,
     MTMTracksPos,MTMSeq,TempL        : longint;

  var
     TBuffer    ,                                 {Buffer MTM + Liste tempo 669}
     PBreakList : array[0..Motif_Lu_Max] of byte; {Liste des P. break
      et longueur des patterns pour XM}

  const
       MIDIBufferMax : word = 127;
  var
     MIDIBuffer        : array[0..127] of byte;
     TrackOfNote       : array[0..127] of byte;
     NoteOnTrack       ,
     Turn_Off_Note     : array[0..NPistesMax-1] of byte;
     Select_Instrument : byte;
     MIDI_Mode         ,
     Keyb_Mode         ,
     MIDI_Sustain      : boolean;
     Delta_Octave      : shortint;

  var
     Motif_Lu            ,
     Patt_Delay_Count    ,
     Patt_Delay          ,
     Patt_loop_count     ,
     Patt_loop           ,
     Ligne_Motif_Start   ,
     Motif_Lu_Start      ,
     CountTicks          ,
     TicksPerNote        ,
     Freq_Base           ,
     Freq_Display        ,
     Vibrato_Wave        ,
     Tremolo_Wave        ,
     Loop_Mode           : byte;
  var
     Ligne_Motif         ,
     MTMTracks           ,
     NPistes,NPistes2    ,
     NPistes4            ,
     Init_Sortie         ,
     Count_Base          ,
     Div_Base            ,
     Note_MinL,Note_MaxL ,
     NInst_Pres          ,
     NInst_Used          ,
     NPatt_Used          ,
     Fine_Delta          : word;

  var
     Taille_Motif        ,
     Comp_Size           : P_TMotif;
     TempMotif           : P_TempMotif;
     Pos_Motif           : P_TPosMotif;
     Pos_Smp             : P_TPosSmp;
     P_Motif             : array[0..Motif_Lu_Max] of pointer;

     Track_KeyOff        ,
     Track_Vol_Sustain   ,
     Track_Pan_Sustain   : array[0..NPistesMax-1] of boolean;

     Note_Date		 ,
     Glissando           ,
     Note_MOD            ,
     Aux_Notes_MOD       ,
     Delta_Vol           ,
     Count_Pitch         ,
     Tempo_Pitch         ,
     Cut_Note_Ticks      ,
     Cut_Note_Count      ,
     Retrig_Note         ,
     Delay_Note          ,
     Delay_Note_Ticks    ,
     Delay_Note_Count    ,
     D_Note              ,
     D_Inst              ,
     D_Vol               ,
     Sample              ,
     Instrument          ,
     Current_Smp         ,
     Effect              ,
     Tremor              ,
     Tremor_On           ,
     Tremor_Count        ,
     Tremor_Data         ,
     Arp_On              ,
     Arp_Count           ,
     Arp_Data            ,
     Vibrato_On          ,
     Vib_Pos             ,
     Vib_Speed           ,
     Vib_Depth           ,
     Tremolo_On          ,
     Trem_Vol            ,
     Trem_Pos            ,
     Trem_Speed          ,
     Trem_Depth          ,
     Volume_Slide        ,
     Pitch_Slide         ,
     Slide_Vol_Down      ,
     Slide_Pitch_Down    ,
     Note_Min,Note_Max   ,
     Pan_Slide           ,
     Pan_Speed           ,
     Pitch_Delta         ,
     Pitch_Speed         ,
     Pitch_Cursor        ,
     Pitch_Data          ,
     Porta_On            ,
     Porta_Speed         ,
     Cut_Note            ,
     EData               ,
     Track_GV            ,
     Track_Fading        ,
     Track_Vol_Pos       ,
     Track_Pan_Pos       : Track_Array_W;
var
     Rien                : word;  {alignement 32 bits}
     Volume              ,
     ESegment,SVolume    ,
     Volume_G,Volume_D   ,
     Limite,Bouclage     ,
     Compteur_Acc        ,
     Acc_32              ,
     Track_On            ,
     Track_State         ,
     LDI_ratio           ,
     Save_Data_L         ,
     Old_Data_L          ,
     Save_Data_R         ,
     Old_Data_R          ,
     Inc_R,Inc_L         ,
     Q_R_Notes,Panning   ,
     Real_Pan            ,
     Real_Vol            : array[0..NPistesMax-1] of longint;
     Limite_Echant       ,
     Offset_Boucle       : array[0..Max_Smp] of longint;
     R_32,Q_32           ,
     Sesp,Sedx,Seax      : longint;

     Init_Cursor         : array[0..Max_Notes] of word;
     Play_Motif          ,
     Arret_Module        ,
     Pattern_Delay       ,
     Pattern_loop        ,
     Loop_Enable         ,
     Pan_Enabled         ,
     Fine_Slide          ,
     WaitP,Global_Surround_On ,
     GV_Slide,GV_Slide_Up,
     Linear_Table_Used   ,
     RetrigTick0         : boolean;
     GV_Speed            : byte;
     Liste               : text;
     Fichier             : file;
     Buff                : PBuff;
     Buff2               : PBuff2;
     Inst                : PInstruments;
     InstS3M             : PInstS3M;
     InstMTM             : PInstMTM;
     Inst669             : PInst669;
     InstXM              : PInstXM;
     Nom                 ,
     Strg,DatTim         : string[80];

  var
     Data_Aux            ,
     Tmp_Inst            ,
     Iter_Filtre,F0      ,
     Max_Motif           ,
     Set_Volume          : word;
     Summ                : longint;
     VolMax              ,
     Max_Pistes          ,
     S3MPatternError     : byte;
     FreqSortie          ,
     FreqSortieR         : word;
     TailleFichier       : longint;
     BytesRead           : word;
     Multi_Sample        ,
     MIDI_Allowed        ,
     Amiga_Limits        ,
     Inhibit_Keyboard    : boolean;
     Linear_Table        : P_TLinear_Table;

  var
     BuffPointer         ,
     VBuffPointer        ,
     DummyP,Data_Pointer ,
     Loader_Init_Pointer ,
     EMS_Window          : pointer;
     WriteOffset         ,
     SetBuffLimit        ,
     BuffLimit,VBuffLimit,
     BuffStart,VBuffStart,
     BuffPos             ,
     DMABufferSize       ,
     Segm,Offs,TempW     ,
     MemXMSBefore,MemXMSAfter,
     MemEMSBefore,MemEMSAfter,
     RMemHandle          ,
     Data_Seg,Data_Offs  ,
     ClipBuffSeg         ,
     ClipBuffOfs         ,
     Buffer_Signed       ,
     BufferIndex         ,
     DataIndex           : word;
     RMem_Pos            : longint;
  var
     Data_Valid	         ,
     MIDI_Datum		 ,
     NoteOnOff,Velocity	 ,
     Command_Found	 ,
     Damp_Speed          ,
     Action_Changed 	 : byte;
     AuxDataIndex        ,
     Current_Track       ,
     MIDI_Channel        : word;
     InstOnChannel       : array[0..15] of byte;

     Straddling          ,
     EnableTest,CountDiv8,
     Action,Save_Master  ,
     MMP_Mode            : byte;
     Digital_Ampl        : word;
     DMA_Count_Got       ,
     EMSUse,EMSPresent   ,
     DOSMemUse           ,
     XMS32Use            ,
     LDIModeOn           ,
     Started_Mod         ,
     Truncated_Inst      ,
     VirtualBuffer       ,
     Loaded_Mod          : boolean;
     EMSInst             : TEMSBlock;
     EMS_Page            : word;
     Pages_Index         ,
     EMS_Handles         : array[0..Max_Smp] of word;

  var
      DMABuffWriteSeg          ,
      Sax,Sbx,Sdx,Ses,Sdi,Ssi  : word;
  var
     DMAIndex           : byte;
     ErrMsg             : string[80];
  const
     Hardware_Init      : word = 0;

  implementation

  end.
