//***************************************************************************
//
// this file is (c) '94-'96 Niklas Beisert
//
// this file is part of the cubic player development kit.
// you may only use/modify/spread this file under the terms stated
// in the cubic player development kit accompanying documentation.
//
//***************************************************************************

//[general]
//  link=smptwin
//[screen]
//  deftmodes=_cpiTModeWinTest

// textmode window example
// master volume example

#include <string.h>
#include "poutput.h"
#include "cpiface.h"

static int plMVolFirstLine;
static int plMVolHeight;
static int plMVolWidth;
static int plMVolType;

static void logvolbar(int &l, int &r)
{
  if (l>32)
    l=32+((l-32)>>1);
  if (l>48)
    l=48+((l-48)>>1);
  if (l>56)
    l=56+((l-56)>>1);
  if (l>64)
    l=64;
  if (r>32)
    r=32+((r-32)>>1);
  if (r>48)
    r=48+((r-48)>>1);
  if (r>56)
    r=56+((r-56)>>1);
  if (r>64)
    r=64;
}

static void drawpeakpower(int y, int x)
{
  short strbuf[40];
  writestring(strbuf, 0, plPause?0x08:0x07, " [ -- ] ", 40);
  int l,r;
  plGetRealMasterVolume(l, r);
  logvolbar(l, r);
  l=(l+2)>>2;
  r=(r+2)>>2;
  if (plPause)
  {
    writestring(strbuf, 18-l, 0x08, "", l);
    writestring(strbuf, 22, 0x08, "", r);
  }
  else
  {
    writestringattr(strbuf, 18-l, "\x0F\x0F\x0B\x0B\x0B\x0B\x09\x09\x09\x09\x01\x01\x01\x01\x01\x01"+32-l-l, l);
    writestringattr(strbuf, 22, "\x01\x01\x01\x01\x01\x01\x09\x09\x09\x09\x0B\x0B\x0B\x0B\x0F\x0F", r);
  }
  displaystrattr(y, x, strbuf, 40);
  if (plMVolHeight==2)
    displaystrattr(y+1, x, strbuf, 40);
}

static void drawbigpeakpower(int y, int x)
{
  short strbuf[80];
  writestring(strbuf, 0, plPause?0x08:0x07, "   [ -==- ]   ", 80);
  int l,r;
  plGetRealMasterVolume(l, r);
  logvolbar(l, r);
  l=(l+1)>>1;
  r=(r+1)>>1;
  if (plPause)
  {
    writestring(strbuf, 36-l, 0x08, "", l);
    writestring(strbuf, 44, 0x08, "", r);
  }
  else
  {
    writestringattr(strbuf, 36-l, "\x0F\x0F\x0F\x0F\x0B\x0B\x0B\x0B\x0B\x0B\x0B\x0B\x09\x09\x09\x09\x09\x09\x09\x09\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01"+64-l-l, l);
    writestringattr(strbuf, 44, "\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x09\x09\x09\x09\x09\x09\x09\x09\x0B\x0B\x0B\x0B\x0B\x0B\x0B\x0B\x0F\x0F\x0F\x0F", r);
  }
  displaystrattr(y, x, strbuf, 80);
  if (plMVolHeight==2)
    displaystrattr(y+1, x, strbuf, 80);
}

static void MVolDraw(int focus)
{
  if (plMVolType==3)
  {
    displayvoid(plMVolFirstLine, 80, 8);
    displayvoid(plMVolFirstLine, 128, 4);
    if (plMVolHeight==2)
    {
      displayvoid(plMVolFirstLine+1, 80, 8);
      displayvoid(plMVolFirstLine+1, 128, 4);
    }
    drawpeakpower(plMVolFirstLine, 88);
  }
  else
  {
    int l=(plMVolWidth==132)?26:20;
    displaystr(plMVolFirstLine, 0, plPause?0x08:0x07, "  peak power level:", l);
    displayvoid(plMVolFirstLine, plMVolWidth-l, l);
    if (plMVolHeight==2)
    {
      displayvoid(plMVolFirstLine+1, 0, l);
      displayvoid(plMVolFirstLine+1, plMVolWidth-l, l);
    }
    if (plMVolWidth==132)
      drawbigpeakpower(plMVolFirstLine, l);
    else
      drawpeakpower(plMVolFirstLine, l);
  }
}

static void MVolSetWin(int xpos, int wid, int ypos, int hgt)
{
  plMVolFirstLine=ypos;
  plMVolHeight=hgt;
  plMVolWidth=wid;
}

static int MVolGetWin(cpitextmodequerystruct &q)
{
  if (plMVolType==2)
    plMVolType=3;
  if ((plMVolType==3)&&(plScrWidth!=132))
    plMVolType=0;
  int pplheight=(plScrHeight>30)?2:1;

  switch (plMVolType)
  {
  case 0:
    return 0;
  case 1:
    q.xmode=3;
    break;
  case 2:
    q.xmode=1;
    break;
  case 3:
    q.xmode=2;
    break;
  }
  q.size=0;
  q.top=1;
  q.killprio=128;
  q.viewprio=176;
  q.hgtmax=pplheight;
  q.hgtmin=pplheight;
  return 1;
}

static int MVolIProcessKey(unsigned short key)
{
  switch (key)
  {
  case '%':
    cpiTextSetMode("wtest");
    break;
  case 'x': case 'X':
    plMVolType=3;
    return 0;
  case 0x2d00: //alt-x
    plMVolType=1;
    return 0;
  default:
    return 0;
  }
  return 1;
}

static int MVolAProcessKey(unsigned short key)
{
  switch (key)
  {
  case '%':
    plMVolType=(plMVolType+1)%4;
    cpiTextRecalc();
    break;
  default:
    return 0;
  }
  return 1;
}

static int MVolCan()
{
  return !!plGetRealMasterVolume;
}

static int MVolEvent(int ev)
{
  switch (ev)
  {
  case cpievInit: return MVolCan();
  }
  return 1;
}

extern "C"
{
  cpitextmoderegstruct cpiTModeWinTest = {"wtest", MVolGetWin, MVolSetWin, MVolDraw, MVolIProcessKey, MVolAProcessKey, MVolEvent};
};
