//***************************************************************************
//
// this file is (c) '94-'96 Niklas Beisert
//
// this file is part of the cubic player development kit.
// you may only use/modify/spread this file under the terms stated
// in the cubic player development kit accompanying documentation.
//
//***************************************************************************

//[devwMixQ]
//  link=postproc
//  postprocs=_postproctest

// devwmixq postprocessor example

#include "devwmixq.h"

int sinetab[]={0,12,24,36,45,53,59,63,64,63,59,53,45,36,24,12,0,-12,-24,-36,-45,-53,-59,-63,-64,-63,-59,-53,-45,-36,-24,-12};
int pos=0;

void x(int,int) {}
void y() {}

void process(long *buf, int len, int rate, int stereo)
{
  int i;
  if (stereo)
    for (i=0; i<len; i++)
    {
      buf[2*i]=(buf[2*i]*sinetab[pos&31])>>6;
      buf[2*i+1]=(buf[2*i+1]*sinetab[pos&31])>>6;
      pos++;
    }
  else
    for (i=0; i<len; i++)
      buf[i]=(buf[i]*sinetab[pos++&31])>>6;
}

extern "C"
{
  mixqpostprocregstruct postproctest={process, x, y};
}
