//***************************************************************************
//
// this file is (c) '94-'96 Niklas Beisert
//
// this file is part of the cubic player development kit.
// you may only use/modify/spread this file under the terms stated
// in the cubic player development kit accompanying documentation.
//
//***************************************************************************

#ifndef __POUTPUT_H
#define __POUTPUT_H

void plSetTextMode(unsigned char x);
void plSetBarFont();
void plSetGraphMode(unsigned char size);
void plSetGraphPage(unsigned char x);
char *convnum(unsigned long num, char *buf, unsigned char radix, unsigned short len, char clip0=1);
void writenum(short *buf, unsigned short ofs, unsigned char attr, unsigned long num, unsigned char radix, unsigned short len, char clip0=1);
void writestring(short *buf, unsigned short ofs, unsigned char attr, const char *str, unsigned short len);
void writestringattr(short *buf, unsigned short ofs, const void *str, unsigned short len);
void markstring(short *buf, unsigned short ofs, unsigned short len);
void displaystr(unsigned short y, unsigned short x, unsigned char attr, const char *str, unsigned short len);
void displaystrattr(unsigned short y, unsigned short x, const short *buf, unsigned short len);
void displaystrattrdi(unsigned short y, unsigned short x, const unsigned char *txt, const unsigned char *attr, unsigned short len);
void displayvoid(unsigned short y, unsigned short x, unsigned short len);
void gdrawchar(unsigned short x, unsigned short y, unsigned char c, unsigned char f, unsigned char b);
void gdrawchart(unsigned short x, unsigned short y, unsigned char c, unsigned char f);
void gdrawcharp(unsigned short x, unsigned short y, unsigned char c, unsigned char f, void *picp);
void gdrawchar8(unsigned short x, unsigned short y, unsigned char c, unsigned char f, unsigned char b);
void gdrawchar8t(unsigned short x, unsigned short y, unsigned char c, unsigned char f);
void gdrawchar8p(unsigned short x, unsigned short y, unsigned char c, unsigned char f, void *picp);
void gdrawstr(unsigned short y, unsigned short x, const char *s, unsigned short len, unsigned char f, unsigned char b);
void gupdatestr(unsigned short y, unsigned short x, const short *str, unsigned short len, short *old);

extern short plScrHeight;
extern short plScrWidth;
extern char plVidType;
enum { vidNorm, vidVESA, vidET4K };
extern unsigned char plScrType;
extern unsigned short plScrRowBytes;
extern int plScrMode;

#endif
