{***************************************************************************}
{   Here's a program's demonstration to make an AST player                  }
{   just give the name of the AST File on the command line                  }
{***************************************************************************}
program astplay;
uses crt,play_ast;
const h:string[16]='0123456789ABCDEF'; {For the HEX conversion}
var k,l:byte;
    filename:string;
    error:integer;
    tmps:string;
    user_awe_base, user_SB_base,user_midi_base:word;
    ch:char;
    rightsbvolume,leftsbvolume:byte;
{****************************************************************************}
function w2h(w:word):string; {return the hex expression of a number}
var k:byte;
    s:string;
begin
s[0]:=#5;
s[1]:='$';
s[2]:=h[(w and $f000) shr 12+1];
s[3]:=h[(w and $0f00) shr 8+1];
s[4]:=h[(w and $00f0) shr 4+1];
s[5]:=h[(w and $000f)+1];
w2h:=s;
end;
{*******************************  MAIN *************************************}
begin
clrscr;
{********** decode the command line ********};
k:=paramcount;{number of parameters pass in the command line}
if k>0 then
for l:=1 to k do
 begin
 tmps:=paramstr(l);
 if (tmps[1]='/') and (tmps[2]='a') then  {if you use /a:$xxx}
    begin
    tmps:=copy(tmps,4,4);
    val(tmps,user_awe_base,error);
    if (error=0) then force_awe32(user_awe_base);{don't use the autodetect base}
    end else
 if (tmps[1]='/') and (tmps[2]='s') then  {if you uses /s:$xxx}
    begin
    tmps:=copy(tmps,4,4);
    val(tmps,user_SB_base,error);
    if (error=0) then force_SB(user_SB_base);{don't use the autodetect base}
    end else
 if (tmps[1]='/') and (tmps[2]='m') then  {if you uses /m:$xxx}
    begin
    tmps:=copy(tmps,4,4);
    val(tmps,user_midi_base,error);
    if (error=0) then force_midi(user_midi_base);{don't use the autodetect base}
    end else
 filename:=tmps;
 end;
writeln
('Astplay command line player (play_ast.tpu demonstration),(c) Patrice bouchand');



{*********** Write the result of the detection *************}
if fmdt then writeln('FM found at $388') else writeln('FM not Found at $388');

if awedt then
writeln('EMU8000 found at ',w2h(awe_base),' with ',awemem,' onboard RAM') else
writeln('EMU8000 not found');

if mididt then writeln('MPU401 Interface found at ',w2h(midip)) else
   writeln('MPU401 not found');

if sbdt then writeln('Sound Blaster found at ',w2h(sbp)) else
             writeln('Sound Blaster not found');
writeln;
{******************** Try to play the song ******************************}
if k=0 then { No parameter ?..}
 begin
 writeln('You should try that !');
 writeln('ASTPLAY  name.AST ');
 writeln('ASTPLAY  name.AST  /a:$xxx  /s:$xxx  /m:$xxx');
 writeln;
 writeln('/a:$xxx  AWE32 base  address, usually /a:$620');
 writeln('/s:$xxx    SB  base  address, usually /s:$220');
 writeln('/m:$xxx  Midi  base  address, usually /m:$330');
 halt(0);
 end;
if not ast_load(filename) then  { try to load the file}
 begin
 writeln('Can''t open this file'); { Where are this file ?}
 halt(0);
 end;
leftsbvolume:=200;
ast_start; {Let's rock !}
writeln('Press  + to increase volume');
writeln('press  - to decrease volume');
writeln('Press ESC to stop music');

repeat
rightsbvolume:=leftsbvolume;  {right and left volume will always be the same}
setsbvolume(leftsbvolume,rightsbvolume);
gotoxy(1,wherey);write('volume :',rightsbvolume);
repeat until keypressed;
ch:=readkey;
case ch of
 '+':if leftsbvolume<255 then inc(leftsbvolume);
 '-':if leftsbvolume>0 then dec(leftsbvolume);
 end;
until ch=#27;
ast_exit; {don't forget to call this procedure}
end.