/*

  11-10-1995(DD-MM-YYYY)						      
		       S3M PLAYER FOR WATCOM C/386			  
	                 by P.G.M / EXTRAVAGANZA	 		  
			Gravis Ultrasound version		          
		  based on pascal player "PSX" by P.G.M		          
		     needs also GF1.C to be compiled 		          
     PS32 (C) 1995 Przemyslaw G. Marczyk All Rights Reserved                
*/

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <stdlib.h>
#include <malloc.h>
  

/*

									    
			   TYPE DEFINITIONS				  
									  
*/


/* 			miscellaneous type definitions			*/

typedef unsigned char  byte;
typedef unsigned short word;
typedef unsigned int  dword;

/* 			partiture type definitions 			*/

typedef struct ntype{			/* single note entry */
		byte pitchoct; 		/* pitch / octave */
		byte instr;	 	/* instrument number */
		byte volume;	 	/* volume / efx	*/
		byte command;	 	/* standard efx */
		byte vinfo;	  	/* volume /efx infobyte */
		byte info;	 	/* standard efx info */ 
		} Note;
typedef struct 	rowst{
		Note note[32];
		} Row;		/* single row */
typedef struct  patternst{
		Row row[64];
		} Pattern;		/* single pattern */

typedef struct {
		byte note;		/* last known note */
		byte octave;		/* last known octave */
		short pitch;		/* last known pitch */
		short tpitch;		/* for efx that destroy main pitch */
		byte instr;		/* last known instrument */
		char vol;		/* current volume */
		byte new;		/* 1 if new note found,should be cleared after play on */
                byte ninst;		/* 1 if new instrument entry found */
		byte off;		/* 1 if pitcoct=254="^^^"=noteoff */
		byte info;		/* last known info */
		byte efx;		/* last known efx */
		byte vsl;		/* last info at vslide ("D") */
		byte tdn;		/* last info at tone down */
		byte tup;		/* last info at tone up */
		byte prt;		/* last info at note port */
		short prtend;		/* portamento target */
		byte vib;		/* last info at vibrato*/
		byte sinepos;		/* vib sine position */
                byte trg;		/* last retrig */
		byte trgcnt;		/* retrig counter */
                byte cut;		/* notecut count */
	        byte dly;		/* notedelay count */
	       } channel;

			
/* 			instrument type definitions			*/

typedef struct	instype
		     {
		  dword gusoffset;	/* offset in gravis DRAM or in memory*/
		  dword loopstart;	/* loop start offset */
		  dword loopend;	/* loop end or end offset*/
		  byte	volume;		/* instrument volume */
		  byte  loop;		/* loop infobyte (on/off) */
		  word	c2spd;		/* s3m tunning value */	
		  word	tune[12];	/* low octave tunning */
		  char	dosname[12];	/* dos filename */
		  char	name[32];	/* instrument name */
      		  } instrument;

typedef instrument instrlist[99];

byte		     gvol=0x40;	      /* global volume thing */	

byte	MAXCHN;			      /* number of channels detected */
				      /* during unpack scan */	 
byte    FXCHN;			      /* channels to reserve for fx */
				      /* Ultra will be inited for MAXCHN+FXCHN */		
				/* low octave for precalc */
word loctave[12] = {1712,1616,1524,1440,
		    1356,1280,1208,1140,
	            1076,1016, 960, 907};
byte vibsine[32]={2,24,49,74,97,120,141,161,180,197,212,224,235,244,250,253,
	          255,253,250,244,235,224,212,197,180,161,141,120,97,74,49,24
		 };

/*

 		GRAVIS DRIVER COMES HERE !!!!!!!!!			
   it's included here because of instrument type that is just above     
   functions in gf1.c are using it					*/

#include"gf1.c"		

/*

*/

/*			file type definitions				*/

typedef struct	s3mfileheadtype				/* s3m header */
			{  
                    char Sname[28];
                    byte Byte1A; 
                    byte Typ ;  
                    word hole1;
                    word OrdNum ;
                    word InsNum ;
                    word PatNum ;
                    word Flags ;
                    word Version ;
                    word FileForm ;
                    char SCRM[4];
                    byte GlobVol;
                    byte InitSpd ;
                    byte InitTem;
                    byte MasterVol;
               	    byte UltrClkRem;
                    byte DefPan;
                    word hole2[4];
                    word Special;
                    byte ChnSet[32];
		   } s3mhead;

typedef struct ScrsHeadtype{		/* s3m & digiplayer instrument header */
                     byte Typ;
                     char DOSName[12];
                     byte MemSegHi; 
                     word MemSegLo; 
                     word Length;
                     word LengthHi;
                     word LoopBg;
                     word LoopBgHi;
                     word LoopNd;
                     word LoopNdHi;
                     byte Vol;
                     byte Hole1;
                     byte Pack;
                     byte Flags;
                     word C2spd;
                     word C2sHi;
                     byte Hole2[4];
                     word GravPos;
                     word SbLoop;
                     word LastUs;
                     word LastUsHi;
                     char Sname[28];
                     char SCRS[4];
		} s3minstr;            
/*

									    
			    VARIABLE DEFINITIONS			  
									  
*/

/* 	file related variables 		*/

FILE 		*s3mfile;	/* s3m to load */
s3mhead     	   *head;	/* s3m header */


/* 	player related variables	*/
word		 noteoffs;	      /* note offset */
char	      dirtyperiod;	      /* flag to reset perid on new note */	
byte		   played;	      /* set on new tick done */	
byte     tick,speed,tempo; 	      /* timing variables */
byte 		    lo,hi;	      /* temporary nibbles */	
byte		     gvol;	      /* global volume thing */	
byte PLAYCHN,PP,PO,CurRow;	      /* partiture data indexes */	
Pattern	   *patterns[100];	      /* list of pointers to patterns */
byte         ordlist[255];	
channel      channels[32];            /* channel replaydata */
void ( __interrupt __far *oldint8)();
/*


		IRQ stuff


*/
void cpreg(void);
#pragma aux cpreg="jmp getout",\
		"DD 32335350h",\ 
		"DD 29632820h",\ 
		"DD 39393120h",\ 
		"DD 2E502035h",\ 
		"DD 0ff4d2e47h",\ 
		"DD 19cd19cdh",\ 
		"getout:",\
		modify[eax];

void enableirq0(void);
#pragma aux enableirq0="in al,21h",\
		   "and al,254",\
		   "out 21h,al",\
		   modify [eax]; 

void disableirq0(void);
#pragma aux disableirq0="in al,21h",\
			"or al,1",\
			"out 21h,al",\
   			modify [eax];

void enableirq1(void);
#pragma aux enableirq1="in al,21h",\
   			"and al,253",\
   			"out 21h,al",\
			modify [eax];   					   
void disableirq1(void);
#pragma aux disableirq1="in al,21h",\
   			"or al,2",\
   			"out 21h,al",\
   			modify [eax];	
void timerinit(void);
#pragma aux timerinit="mov al,34h",\
   		  "out 43h,al",\
   		  modify [eax];	
void initfreq(word);
#pragma aux initfreq="out 40h,al",\
   		 "mov al,ah",\
   		 "out 40h,al",\
   		parm [ax] modify [eax]; 

/*

++ERREXIT
	       		QUIT FROM PROGRAM ON ERROR
char *ermsg=string to put on screen ; 

*/

void ErrExit(char *ermsg)
    {
     cpreg();	
     printf("%s\n",ermsg);
     exit(666);
    }	

/*

++SETUPS3M
         		SETUP S3M FILE FOR REPLAY
char *name=filename ; 
unsigned int position=start of s3m data in file (for overlays)

*/

byte SetupS3M(char *name,unsigned int position)
{
						/* open specified file */
 if ( (s3mfile = fopen(name,"rb")) == NULL) 
		ErrExit("Cannot Open File");
						/* alloc memory for header */
 if ( (head = calloc(1,sizeof(s3mhead))) == NULL)
		ErrExit("Memory Allocation failed in SetupS3M");
    
						/* read header */    	
 fseek(s3mfile , position, SEEK_SET);
 fread(head,1,sizeof(s3mhead),s3mfile);
 						/*checkout for SCRM tag */
 if (head->Byte1A != 0x1A) ErrExit("Bad File Type!");
         					
						/* output a name */
 fseek(s3mfile,position+0x60,SEEK_SET);
 fread(ordlist,1,head->OrdNum,s3mfile);
 SetupS3MPatterns(position); 
 SetupS3MInstruments(position);
 fclose(s3mfile);
 return(0);
}

/*

++SETUPS3MPATTERNS
		    	  SET UP PATTERNS 
unsigned int position = start of s3m data in file (for overlays)

*/
void SetupS3MPatterns(unsigned int position)
{
static word ParaPts[99]; 	/* parapointers to patterndata */
static word CurPkLen[1];	/* length of current packed pattern */
 word     CurByte;	/* current position in packed data */
 byte   FirstByte;	/* note packing control byte */
 byte      CurChn;	/* Current channel to write */
 byte      CurRow;	/* Current row to write */
 byte     CurNote;	/* Current note to write */
 byte	     *Buf;	/* buffer for unpacking */					
 byte	*StartBuf;
 byte	    i,j,k;	/* pattern counter */
		
					/* get parapointers from file */
					/* see tech.doc from ST3 for */
					/* information */ 
 fseek(s3mfile , position+0x60+head->OrdNum+head->InsNum*2 , SEEK_SET);


 fread(ParaPts,head->PatNum,sizeof(word),s3mfile);
 if ( (Buf = calloc(1, 32000)) == NULL) 	/* get temporary buffer */
    ErrExit("Memory Allocation fail in SetupS3MPatterns 02");
 StartBuf = Buf;
 for(i = 0;i < head->PatNum;i++)		/* start unpacking patterns */
    {
     Buf = StartBuf;
     fseek(s3mfile , position+ ((unsigned int)ParaPts[i] << 4) , SEEK_SET); /* move to start of pack */ 	 

     fread(CurPkLen, 1 ,sizeof(word),s3mfile);		   /* get length of pack */
     fread(Buf,1,CurPkLen[0],s3mfile); 			   /* load pack */    	
     if ( (patterns[i] = calloc(1,12288)) == NULL) /* alloc empty pattern */
	ErrExit("Memory Allocation fail in SetupS3MPatterns 03");  	 
    for( j=0 ; j<64 ; j++)		    
	for( k=0 ; k<32 ; k++)		     
 	   {    			      	
            patterns[i]->row[j].note[k].pitchoct = 0xFF;/* pre-clear notes */
            patterns[i]->row[j].note[k].volume   = 0xFF;/* and volumes*/	    	
	   }

     CurChn = 0;
     CurRow = 0;	
     CurByte = 0;
     while ( CurRow < 64 )
	   {
	    FirstByte = *Buf++;			/* get controll byte */
            if ((Buf-StartBuf) > 12288) ErrExit("S3M Pattern Length Overflow !");
	    if ( FirstByte == 0x0 ) 
		{
		 CurRow++;  
		}				/* if isn't zero entry is here*/
	    else	
	       {
		CurChn = FirstByte & 31;
		if (MAXCHN < CurChn ) MAXCHN = CurChn;
	        if ( (FirstByte & 32) == 32)	/* get note and instrument */
		   {
		    patterns[i]->row[CurRow].note[CurChn].pitchoct = *(Buf++);
		    patterns[i]->row[CurRow].note[CurChn].instr = *(Buf++);	
		   }
	        if ( (FirstByte & 64) == 64)	/* get volume */
		   {
		    patterns[i]->row[CurRow].note[CurChn].volume = *(Buf++);
		   }
	        if ( (FirstByte & 128) == 128)	/* get efx and info */
		   {
		    patterns[i]->row[CurRow].note[CurChn].command = *(Buf++);
		    patterns[i]->row[CurRow].note[CurChn].info	  = *(Buf++);
		   }
	       }
           }
    } 	
 Buf = StartBuf;
 free(Buf);
} 


/*

++SETUPS3MINSTRUMENTS
		    	  SET UP INSTRUMENTS
unsigned int position = start of s3m data in file (for overlays)

*/

void SetupS3MInstruments( unsigned int position )
{
static word 	ParaPts[99]; 	/* parapointers to sample headers */ 
 dword	  ParaToDat;	/* para(?)pointer to sampledata */
 dword	    i, j, k;	/* all purpose dwords */
 s3minstr   *CurIns;	/* SCRS header */
 
 fseek(s3mfile , position+0x60+head->OrdNum, SEEK_SET); /* read parapointers */
 fread(ParaPts,head->InsNum,sizeof(word),s3mfile); 

 if  ( (CurIns = calloc(1,sizeof(s3minstr) )) == NULL) 	/* get temporary header */
    ErrExit("Memory Allocation fail in SetupS3Minstruments 01");

 for( i=1; i < (head->InsNum+1); i++)
    {

     fseek(s3mfile , position+( (dword)ParaPts[i-1]  << 4), SEEK_SET); /*read header */
     fread(CurIns,1,sizeof(s3minstr),s3mfile); 		

     if( CurIns->Typ != 0 )			/* if zero then nothing to do */
       {
	ParaToDat = ((dword)CurIns->MemSegLo |  ( (dword)CurIns->MemSegHi << 16 ) )<< 4;
 	fseek(s3mfile , position+ParaToDat, SEEK_SET); 
	Gsetupinstr(i,s3mfile,		/* this is a part of my driver */
                   CurIns->C2spd,       /* concept, in which ONLY sound*/
                   CurIns->Vol,		/* driver knows about sampledata*/
	           CurIns->Flags,	/* it's placement,loop etc.     */
                   CurIns->Length,	/* while player uses ONLY number*/
                   CurIns->LoopBg,	/* of instrument, period, and vo-*/
                   CurIns->LoopNd);     /* lume. */

       }	
    }

}

/*

++VOLUME SLIDE
*/
void volslide(void)
{
 lo = (byte)channels[PLAYCHN].vsl & 0x0F;
 hi = (byte)channels[PLAYCHN].vsl >> 4;
 if( lo==0 )		/* normal up */
  {
   channels[PLAYCHN].vol+=hi;
  }					   
 if( hi==0 )		/* normal down */
  {
   channels[PLAYCHN].vol-=lo;
  }					   
 if( lo==0x0F )		/* fine up */
  {
   if(hi != 0)		
     if(tick==2) channels[PLAYCHN].vol+=hi;
  }					   
 if( hi==0x0F )		/* fine down */
  {
   if(lo != 0)		
     if(tick==2) channels[PLAYCHN].vol-=lo;
  }					   
			/* safety move... */
 if(channels[PLAYCHN].vol > 127) channels[PLAYCHN].vol = 0;
 if(channels[PLAYCHN].vol > 64) channels[PLAYCHN].vol = 64;
}
/*

++TONE SLIDE DOWN
*/

void tonedown()
{
 lo = (byte)channels[PLAYCHN].tdn & 0x0F;
 hi = (byte)channels[PLAYCHN].tdn >> 4;
 if( hi==0x0F )
   {
    if(tick==2) channels[PLAYCHN].pitch+=lo<<2;
   }
 else
   {	
    if( hi==0x0e )
      {
       if(tick==2) channels[PLAYCHN].pitch+=lo;
      }
    else
       {
	channels[PLAYCHN].pitch+=(word)channels[PLAYCHN].tdn<<2;
       }
    }
}

/*

++TONE SLIDE UP
*/

void toneup()
{
 lo = (byte)channels[PLAYCHN].tup & 0x0F;
 hi = (byte)channels[PLAYCHN].tup >> 4;
 if( hi==0x0F )
   {
    if(tick==2) channels[PLAYCHN].pitch-=lo<<2;
   }
 else
   {	
    if( hi==0x0e )
      {
       if(tick==2) channels[PLAYCHN].pitch-=lo;
      }
    else
       {
	channels[PLAYCHN].pitch-=(word)channels[PLAYCHN].tup<<2;
       }
    }
}
/*

++NOTE PORTAMENTO
*/
void noteport()
{

 if(channels[PLAYCHN].pitch != channels[PLAYCHN].prtend)
   {
    if(channels[PLAYCHN].prtend > channels[PLAYCHN].pitch)
      {
       channels[PLAYCHN].pitch+= (word)channels[PLAYCHN].prt<<2;
       if(channels[PLAYCHN].pitch > channels[PLAYCHN].prtend)
          channels[PLAYCHN].pitch = channels[PLAYCHN].prtend;
      }
    if(channels[PLAYCHN].prtend < channels[PLAYCHN].pitch)
      {
       channels[PLAYCHN].pitch-= (word)channels[PLAYCHN].prt<<2;
       if(channels[PLAYCHN].pitch < channels[PLAYCHN].prtend)
          channels[PLAYCHN].pitch = channels[PLAYCHN].prtend;
      }
   }
}
/*

++VIBRATO
*/

void vibrato()
{
 word vt;
 dirtyperiod = 1;
 vt = vibsine[channels[PLAYCHN].sinepos % 31] * channels[PLAYCHN].vib & 0x0F;
 vt>>=1;
 
 channels[PLAYCHN].sinepos += channels[PLAYCHN].vib >> 4;

 if(channels[PLAYCHN].sinepos < 32)
   {	
    channels[PLAYCHN].pitch = channels[PLAYCHN].tpitch + vt;
   }
 else
   {
    channels[PLAYCHN].pitch = channels[PLAYCHN].tpitch - vt;
   }

 if(channels[PLAYCHN].sinepos > 63) channels[PLAYCHN].sinepos = 0;
}

/*

++RETRIG
*/
void retrig()
{
 channels[PLAYCHN].trgcnt++;
 if( channels[PLAYCHN].trgcnt == channels[PLAYCHN].trg)
   {
    GStopVoice(PLAYCHN);
    GPlayVoice(PLAYCHN,channels[PLAYCHN].instr,0);
    channels[PLAYCHN].trgcnt = 0;
   }	
}
/*

++NOTECUT
*/
void notecut()
{
 channels[PLAYCHN].cut--;
 if(channels[PLAYCHN].cut == 0) GStopVoice(PLAYCHN);
}

/*

++NOTEDELAY -------------------- DOES __NOT__ WORK
*/
void ndelay()
{
}

/*

++DOONETICK
		void __interrupt __far DoOneTick(void);
		Actual replay process at IRQ0

*/

void doonetick(void)
{
 if ( tick == speed )		
  {
/*printf("%d row ",CurRow);*/
   tick=1;
   for( PLAYCHN=0; PLAYCHN<=MAXCHN; PLAYCHN++)
    {
         channels[PLAYCHN].efx = patterns[PP]->row[CurRow].note[PLAYCHN].command;
         channels[PLAYCHN].info = patterns[PP]->row[CurRow].note[PLAYCHN].info;
	               
     if(patterns[PP]->row[CurRow].note[PLAYCHN].instr != 0)		
	{
	channels[PLAYCHN].instr = patterns[PP]->row[CurRow].note[PLAYCHN].instr;
	channels[PLAYCHN].ninst = 1;
	}
     else
	{
	channels[PLAYCHN].ninst = 0; 	
	}

     if(patterns[PP]->row[CurRow].note[PLAYCHN].pitchoct < 254) 
        {	
        channels[PLAYCHN].octave = patterns[PP]->row[CurRow].note[PLAYCHN].pitchoct >> 4;
        channels[PLAYCHN].note =   patterns[PP]->row[CurRow].note[PLAYCHN].pitchoct & 0x0F;
        if(channels[PLAYCHN].efx != 0x07 )
	  {
           channels[PLAYCHN].pitch = 
	        instrs[channels[PLAYCHN].instr].tune[channels[PLAYCHN].note] >> 
	        channels[PLAYCHN].octave;
           channels[PLAYCHN].new = 1;
          }
        else	
	  {
           channels[PLAYCHN].prtend = 
	        instrs[channels[PLAYCHN].instr].tune[channels[PLAYCHN].note] >> 
	        channels[PLAYCHN].octave;
	   channels[PLAYCHN].vol = instrs[channels[PLAYCHN].instr].volume;
           channels[PLAYCHN].new = 0; 
           channels[PLAYCHN].ninst = 0; 
	  }
	}
      else
	{
	 channels[PLAYCHN].new = 0;
         if(patterns[PP]->row[CurRow].note[PLAYCHN].pitchoct == 254) 
        	channels[PLAYCHN].off = 1;
	}

/* most annoying,messy,horrifying,garbage,sick,ugh-yuck-bleah part of s3m=volume */
/* goes like that (my opinion...) :	*/
/* if there IS new note/instr entry -> empty volume row = default instr volume */
/* 				       otherwise volume = volume row entry     */
/* if ther is NO new note	    -> empty volume row = NOTHING to do	       */	
/*				       otherwise volume = volume row entry;    */
/* it also appears to have completely different behaviour when efx "G" is on   */


     if( (channels[PLAYCHN].new != 0) || (channels[PLAYCHN].ninst !=0) )
       {
        if(patterns[PP]->row[CurRow].note[PLAYCHN].volume != 255)
	   {		
 	    channels[PLAYCHN].vol = patterns[PP]->row[CurRow].note[PLAYCHN].volume;
           }
        else	
	   {
	   channels[PLAYCHN].vol = instrs[channels[PLAYCHN].instr].volume;
	   }
	}
     else
	{	
     	 if(patterns[PP]->row[CurRow].note[PLAYCHN].volume != 255)
 	    channels[PLAYCHN].vol = patterns[PP]->row[CurRow].note[PLAYCHN].volume;
	}		

	      /* play stuff if needed */
     GusSetVol(PLAYCHN,channels[PLAYCHN].vol);
     if( (channels[PLAYCHN].new != 0) || (channels[PLAYCHN].ninst !=0) )
	{
         GStopVoice(PLAYCHN);
         GusSetFrq(PLAYCHN,channels[PLAYCHN].pitch);
         if(channels[PLAYCHN].efx == 0x0F)/* chek for note offset */ 
	   {	
	    noteoffs = channels[PLAYCHN].info << 8;
	   }
	 else
	   {
	    noteoffs = 0;
	   }
         GPlayVoice(PLAYCHN,channels[PLAYCHN].instr,noteoffs);
         channels[PLAYCHN].tpitch =channels[PLAYCHN].pitch; 
  	} 	
    else
	{
	 if(channels[PLAYCHN].off == 1) GStopVoice(PLAYCHN);	
	 channels[PLAYCHN].off = 0;
	}

    	     /* now process "notetick" effects */
    switch(channels[PLAYCHN].efx)
	{					     	/* set speed */
	 case( 0x01 )	:  speed = channels[PLAYCHN].info;
			   break;
							/* jump to ord */
	 case( 0x02 )	:  CurRow = 0;			
			   PO = channels[PLAYCHN].info;
			   PP = ordlist[PO];
			   break;	

	 case( 0x03 )   :  CurRow = 63;		        /* break pattern */	
			   break;
							/* chek vsl parameter */			
	 case( 0x0B )	:
	 case( 0x0C )	:
	 case( 0x04 )	:  if(channels[PLAYCHN].info !=0) 
			      channels[PLAYCHN].vsl = channels[PLAYCHN].info;
			   break;		
							/* tdn parameter */

	 case( 0x05 )	:  if(channels[PLAYCHN].info !=0) 
			      channels[PLAYCHN].tdn = channels[PLAYCHN].info;
			   break;		
							/* tup parameter */
	 case( 0x06 )	:  if(channels[PLAYCHN].info !=0) 
			      channels[PLAYCHN].tup = channels[PLAYCHN].info;
			   break;		

	 case( 0x07 )	:  if(channels[PLAYCHN].info !=0) 
			      channels[PLAYCHN].prt = channels[PLAYCHN].info;
			   break;		

	 case( 0x08 )	:  if(channels[PLAYCHN].info !=0)      	
			      channels[PLAYCHN].vib = channels[PLAYCHN].info;
			   channels[PLAYCHN].tpitch = channels[PLAYCHN].pitch;
  		           break;		

	 case( 0x11 )	:  if(channels[PLAYCHN].info !=0) 
			      channels[PLAYCHN].trg = channels[PLAYCHN].info;
			      channels[PLAYCHN].trgcnt = 0;

			   break;		

	 case( 0x13 )   :  switch(channels[PLAYCHN].info >> 4)
				{
				 case( 0x08 )  :  GusSetPan(PLAYCHN,channels[PLAYCHN].info & 0x0F);
						  break;
				 case( 0x0C )  :  channels[PLAYCHN].cut = channels[PLAYCHN].info & 0x0F;
						  break;	
				 case( 0x0D )  :  channels[PLAYCHN].dly = channels[PLAYCHN].info & 0x0F;
						  break;	

			        }
			   break;
	 case( 0x14 )   :  		        /* set tempo */	
			   tempo = channels[PLAYCHN].info;
			   disableirq0();
 			   initfreq((word) (1193180/(tempo*24/60)) );
			   enableirq0();
			   break;
	 case( 0x16 )   :  		        /* set tempo */	
			   gvol = channels[PLAYCHN].info;
			   break;
	

        }

    }	

  if(CurRow < 63) 			/* watch for end of pattern */
    {
     CurRow++;
    } 
  else 
    {
     CurRow = 0;
     PO++;
     if( ordlist[PO] == 0xFF ) PO = 0;  /* loop if end of orders */
     PP = ordlist[PO];  
    }
 }

 else 					/* mean if (tick != speed) */

 {
  for( PLAYCHN=0; PLAYCHN<=MAXCHN; PLAYCHN++) /* process effects */
     { 
      switch(channels[PLAYCHN].efx)
	{		
				/* volume slide */
	 case( 0x04 )	:    	volslide();
				break;

				/* tone slide down */
	 case( 0x05 )   : 	tonedown();
				break;

				/* tone slide up */
	 case( 0x06 )	:    	toneup();
  			        break;

				/* note portamento */
	 case( 0x07 )	:	noteport();
				break;

	 case( 0x08 )	:	vibrato();
				break;
		
	 case( 0x11 )	:	retrig();
				break;

	 case( 0x0B )	:	volslide();
				vibrato();
				break;

	 case( 0x0C )	:	volslide();
				noteport();
				break;
	 case( 0x13 )   :  switch(channels[PLAYCHN].info >> 4)
				{
				 case( 0x0C )  :  notecut();
						  break;	
				 case( 0x0D )  :  ndelay();
						  break;	
			        }
			   break;
       }		
     GusSetVol(PLAYCHN,channels[PLAYCHN].vol);
     GusSetFrq(PLAYCHN,channels[PLAYCHN].pitch);
     if (dirtyperiod & 0x01)
        channels[PLAYCHN].pitch =channels[PLAYCHN].tpitch; 
     else
        channels[PLAYCHN].tpitch =channels[PLAYCHN].pitch; 
     dirtyperiod  = 0;
     }
  tick++;
 }
 played=0;
}	

/*********************************************** PLAY ON/OFF *****/
void __interrupt __far tickhandler(void)
{
	outp( 0x20,0x20 );
	doonetick();    // play 1 tick of the module
	played = 1;
}
 
void playon(void)
{
 if ( (MAXCHN+FXCHN) < 14) 
	Ginit(MAXCHN+1);
 else
	Ginit(MAXCHN+FXCHN+1);

 tempo = head->InitTem;
 speed = head->InitSpd;     
 tick  = speed;
 CurRow = 0;
 PO = 0;
 PP = ordlist[PO];
 played = 0;
 do
 {
  GusSetPan(played,0x03);
  played++;
  GusSetPan(played,0x0C);
  played++;
 }while(played<=MAXCHN);
				 	/* initilaize replay */
 oldint8=_dos_getvect(0x08);
 disableirq0();
 _dos_setvect(0x08,tickhandler);
 timerinit();
 initfreq((word) (1193180/(tempo*24/60)) );
 enableirq0();
}



void playoff(void)
{
 int i;
 _disable();
 disableirq0();
 _enable();
 timerinit();
 initfreq(0);
 _dos_setvect(8,oldint8);
 enableirq0();
 
 for( i =0 ; i < head->PatNum ; i++) free(patterns[i]);
 free(head); 
 Ginit(14);
}

/*finito*/
