/* !!!! DO NOT COMPILE IT - IT IS #INCLUDED IN PS32,C !!!! */
/* based on somethings by somebodies or whoever else (they will see reading it)*/
/* By PGM/EXA in 1995 */
/* PS32 (C) 1995 Przemyslaw G. Marczyk All Rights Reserved               */

#define	MK_DRAMHI(addr) ((word) ((word) ((addr >> 7L) & 0x1fffL)))
#define	MK_DRAMLO(addr) ((word) ((word) ((addr & 0x7fL) << 9L )))

byte 	GusLastInit;
word    GusVol[65]={ 0,
	         20000,39120,41376,42656,43936,45072,45696,46240,46848,47408,
		 47952,48528,49072,49360,49632,49920,50160,50432,50704,50928,
		 51168,51424,51680,51952,52160,52448,52672,52912,53152,53312,
		 53440,53584,53664,53808,53952,54048,54144,54288,54400,54496,
		 54608,54720,54832,54944,55072,55184,55312,55440,55552,55696,
		 55760,55888,56016,56096,56240,56304,56448,56528,56672,56752,
		 56896,56976,57136,57216};

dword	MainTuneFactor[32]={

/*Frequency   Active Voices  Mysterious value (1..13 are here for safety_*/

/*44100          1         */ 332879,
/*44100          2         */ 332879,
/*44100          3         */ 332879,
/*44100          4         */ 332879,
/*44100          5         */ 332879,
/*44100          6         */ 332879,
/*44100          7         */ 332879,
/*44100          8         */ 332879,
/*44100          9         */ 332879,
/*44100          11        */ 332879,
/*44100          12        */ 332879,
/*44100          13        */ 332879,
/*44100          14        */ 332879,
/*44100          14        */ 332879,
/*41160          15        */ 356656,
/*38587          16        */ 380439,
/*36317          17        */ 403118,
/*34300          18        */ 427988,
/*32494          19        */ 427988,
/*30870          20        */ 475542,
/*29400          21        */ 499319,
/*28063          22        */ 523108,
/*26843          23        */ 546883,
/*25725          24        */ 570651,
/*24696          25        */ 594428,
/*23746          26        */ 618209,
/*22866          27        */ 642001,
/*22050          28        */ 665759,
/*21289          29        */ 689557,
/*20580          30        */ 713313,
/*19916          31        */ 737094,
/*19293          32        */ 760875};

word	Gport;
dword   firstfree;
instrlist instrs;

/*
  CLI / STI   
*/

void _cli(void);
#pragma aux _cli = "pushf",\
		   "cli";

void _sti(void); 
#pragma aux _sti = "popf";		     

/*
  GUSSETFRQ   
*/
void GusSetFrq( byte  V, dword period )
{
 word f;
 
 f = MainTuneFactor[GusLastInit-1]/(period+1);
 _disable();
 outp ( Gport+0x102 , V );
 outp ( Gport+0x103 , 1 );
 outpw( Gport+0x104 , f );
 _enable();
}
/*
  GUSSETPAN  
*/
void GusSetPan( byte V, byte Pos )
{
 outp ( Gport+0x102 , V );
 outp ( Gport+0x103 , 0x0C );
 outp ( Gport+0x105 , Pos );
}
/*
  GUSSETVOL  
*/
void GusSetVol( byte V, byte Vol )
{
 word Volume;
 Vol = (Vol*gvol)>>6;
 Volume = GusVol[Vol];
 _disable();
 outp ( Gport+0x102, V );
 outp ( Gport+0x103, 9 );
 outpw( Gport+0x104, Volume);
 _enable();
}

/*
 GUSRAMPVOL  
*/
void GusRampVol( byte V, word Start, word End, byte Rate, byte mode )
{
 outp ( Gport+0x102, V );
 outp ( Gport+0x103, 0x06);		/* ramp rate register */
 outp ( Gport+0x105, Rate);
 outp ( Gport+0x103, 0x07);		/* ramp start register */
 outp ( Gport+0x105, (unsigned char)Start >> 4);
 outp ( Gport+0x103, 0x08);		/* ramp end register */
 outp ( Gport+0x105, (unsigned char)End >> 4);
 outp ( Gport+0x103, 0x0D);		/* volume ctrl register */
 outp ( Gport+0x105, mode);
}

/*
 DRAM PUT    
*/

void DramPut( dword Loc, byte B )
{
 _disable();
 outp ( Gport+0x103, 0x43 );
 outpw( Gport+0x104, (word)Loc & 0x0000FFFF);
 outp ( Gport+0x103, 0x44 );
 outp ( Gport+0x105, (byte)( (Loc & 0x00FF0000) >> 16 ) ); 
 outp ( Gport+0x107, B );
 _enable();
}

/*
 DRAMGET     
*/

byte DramGet( dword Loc )
{
 _disable();
 outp ( Gport+0x103, 0x43 );
 outpw( Gport+0x104, (word)Loc & 0x0000FFFF);
 outp ( Gport+0x103, 0x44 );
 outp ( Gport+0x105, (byte)(Loc & 0x00FF0000) >> 16 ); 
 return ( inp ( Gport+0x107 ) );
 _enable();
}

/*
 GRAVTEST    
*/

byte GravTest()
{
 byte B;
 byte i;

 _disable();					/* short gravis reset */
 outp ( Gport+0x103 , 0x4C );
 outp ( Gport+0x105 , 0x0 );
 for( i=0 ; i < 14 ; i++) B = inp( 0x300 );
 outp ( Gport+0x103 , 0x4C );
 outp ( Gport+0x105 , 0x1 );
 _enable();

 DramPut( 0, 0xAA );				/* DRAM write try */
 DramPut( 0x100, 0x55 );
 B = DramGet(0);
 if ( B == 0xAA ) return(1); else return(0);
}
 
/*
 GDETECT     
*/

byte Gdetect( void )
{
 word I;
 Gport = 0x200;
 while( ( GravTest() != 1 ) && ( Gport < 0x280) ) Gport += 0x20;
 printf( "GUS Port %x\n",Gport );
 if ( Gport < 0x270 ) return(1); else return(0);
 Ginit(14);
}

/*
 GUSDRAMAVL  
*/

dword GusDramAvl()
{
 dword I;
 
 DramPut( 0x40000, 0xAA );
 if ( DramGet( 0x40000 ) != 0xAA ) I = 256; else
    {
     DramPut( 0x80000, 0xAA );
     if ( DramGet( 0x80000 ) != 0xAA ) I = 512; else
        {
         DramPut( 0xC0000 , 0xAA );
         if ( DramGet( 0xC0000 ) != 0xAA ) I = 1024; 
         else I = 0xFFFFF;
        }
    }
 return(I); 
}  

/*
 GINIT       
*/

void Ginit( byte V )
{
 byte I;

 if ( V < 14 ) V = 14;
 GusLastInit = V;
 _disable();
 outp ( Gport+0x103, 0x4C ); 			/* initialize */
 outp ( Gport+0x105, 0 );
 for ( I=0 ; I < 7 ; I++ ) inp ( Gport );	/* wait */
 outp ( Gport+0x103, 0x4C ); 			/* initialize */
 outp ( Gport+0x105, 1 );
 for ( I=0 ; I < 7 ; I++ ) inp ( Gport ); 	/* wait */

 outp ( Gport+0x103, 0x41 );			/* Clear DMA */
 outp ( Gport+0x105, 0 );
 outp ( Gport+0x103, 0x45 );
 outp ( Gport+0x105, 0 );
 outp ( Gport+0x103, 0x49 );
 outp ( Gport+0x105, 0 );

 outp ( Gport+0x103, 0x0E );			/* set number of voices */
 outp ( Gport+0x105, (V -1) | 0xC0 );

 inp  ( Gport+0x06 );  
 outp ( Gport+0x103, 0x41 );			/* Clear DMA */
 inp  ( Gport+0x105 );
 outp ( Gport+0x103, 0x49 );
 inp  ( Gport+0x105 );
 outp ( Gport+0x103, 0x8F );
 inp  ( Gport+0x105 );
 
 for ( I=0 ; I < V ; I++)			/* clear voices */
     {        
      outp( Gport+0x102, I );	      
      outp( Gport+0x103, 0 );
      outp( Gport+0x105, 3 );			/* Voice off */
      outp( Gport+0x103, 0x0D );      
      outp( Gport+0x105, 3 );			/* ramp off */
     }
 
 outp ( Gport+0x103 ,0x41 );
 inp  ( Gport+0x105 ) ;
 outp ( Gport+0x103 ,0x49 );
 inp  ( Gport+0x105 ) ;
 outp ( Gport+0x103 ,0x8F );
 inp  ( Gport+0x105 ) ;
 
 outp ( Gport+0x103, 0x4C ); 			/* initialize */
 outp ( Gport+0x105, 7 );
  
 for ( I=0 ; I < V ; I++)			/* clear volume ramps */
     {        
      outp ( Gport+0x102, I );	      
      outp ( Gport+0x103, 6 );
      outp ( Gport+0x105, 0x3F );
      outp ( Gport+0x103, 9 );
      outpw( Gport+0x104, 0x0000 ); 
     }
 outp ( Gport ,     0x01 );
 outp ( Gport+103 , 0x4C );			/* _enable output */
 outp ( Gport+105 , 0x03 );  			/* _enable normal operations */
 _enable(); 
}

/*
 VOICECONTROL  
*/

void VoiceControl( byte V, byte B )
{
 outp ( Gport+0x102, V );
 outp ( Gport+0x102, V );
 outp ( Gport+0x103, 0 );
 outp ( Gport+0x102, B );
}

/*
 SETLOOPMODE 
*/

void SetLoopMode( byte V, byte Mode )
{
 byte B;

 outp ( Gport+0x102, V );
 outp ( Gport+0x102, V );
 outp ( Gport+0x103, 0x80 );
 B = inp ( Gport+0x105 );
 outp ( Gport+0x103, 0 ); 
 outp ( Gport+0x105, (B & 0xE7) | Mode );

}

/*
 PLAYVOICE   
*/
void GPlayVoice( byte V, byte Instr, word Offs )
{
 dword Vbegin;
 dword Vstart;
 dword Vend;
 byte  Mode; 

 Vbegin = instrs[Instr].gusoffset+Offs;
 Vstart = instrs[Instr].loopstart;
 Vend   = instrs[Instr].loopend;
 if (instrs[Instr].loop == 1)
    {
     Mode = 8;		
    }
 else
    {
     Mode = 0;			
    }
 	
 _disable();
 outp ( Gport+0x102, V );
 outp ( Gport+0x102, V );
 outp ( Gport+0x102, V );
					/* start address */
 outp ( Gport+0x103,0x0A);
 outpw( Gport+0x104,MK_DRAMHI(Vbegin));
 outp ( Gport+0x103,0x0B);
 outpw( Gport+0x104,MK_DRAMLO(Vbegin));

					/* loop start address  */
 outp ( Gport+0x103,0x02);
 outpw( Gport+0x104,MK_DRAMHI(Vstart));
 outp ( Gport+0x103,0x03);
 outpw( Gport+0x104,MK_DRAMLO(Vstart));

					/* loop end or end address */
 outp ( Gport+0x103,0x04);
 outpw( Gport+0x104,MK_DRAMHI(Vend));
 outp ( Gport+0x103,0x05);
 outpw( Gport+0x104,MK_DRAMLO(Vend));
					/* voice on */
 outp ( Gport+0x103, 0 ); 
 outp ( Gport+0x105, Mode); 
 _enable();

}
/*
 STOPVOICE   
*/

void GStopVoice( byte V )
{
 byte B;
 _disable();
 outp ( Gport+0x102, V );
 outp ( Gport+0x102, V );
 outp ( Gport+0x102, V );
 outp ( Gport+0x103, 0x80 );
 B = inp ( Gport+0x105 );
 outp ( Gport+0x103, 0 ); 
 outp ( Gport+0x105, ( B & 0xdf ) | 0x03 );

 inp  ( Gport+0x100 ); 
 inp  ( Gport+0x100 );  
 inp  ( Gport+0x100 );  
 inp  ( Gport+0x100 );  
 inp  ( Gport+0x100 );
 inp  ( Gport+0x100 );  
 inp  ( Gport+0x100 ); 

 outp ( Gport+0x103, 0 ); 
 outp ( Gport+0x105, ( B & 0xdf ) | 0x03 );
 _enable();
}
/*
 SETUPINSTR  
*/
void Gsetupinstr( byte instr,FILE *s3m,word C2spd, byte Vol,byte Flags,
		  word Length,word LoopBg, word LoopNd)
{
 dword CurStart;
 dword j,k;
 byte   *Buf;

 if ( (Buf = calloc(1, 64000)) == NULL) 	/* get temporary buffer */
    ErrExit("Memory Allocation fail in Gsetupinstr 01");

 fread(Buf,1,Length,s3m); 			/* read sampledata */  
 CurStart = firstfree;
 for( j=0; j<Length; j++)			/* convert/move to DRAM */
    {
     DramPut(firstfree,(*(Buf+j) + 128) & 255);		 
     firstfree++;
    }
 						/* assign variables */
 instrs[instr].c2spd  =  C2spd;
 instrs[instr].volume =  Vol;	
 instrs[instr].loop   =  Flags; 
 instrs[instr].gusoffset =  CurStart; 
 instrs[instr].loopstart =  CurStart + LoopBg; 
 if(  instrs[instr].loop == 0 )
   {
    instrs[instr].loopend = CurStart + Length;	
   }
 else
   {
    instrs[instr].loopend = CurStart + LoopNd;	       
    for( j=0; j<8; j++)				/* make anticlicker if */
       {					/* instrument is in loop */
	DramPut( instrs[instr].loopend+j, DramGet(instrs[instr].loopstart+j) );	   
	firstfree++;
       }	
   }  
 for( j=0; j<12;j++)			/* and precalculate tunning */
     instrs[instr].tune[j] = ( (8363 * 16 * loctave[j]) / C2spd );
 free(Buf);
}

/*
 putfx ****   
*/
byte chn;

void PutFx(byte ins,byte vol,byte pan)
{
 chn--;
 if  (chn > MAXCHN+FXCHN )chn = MAXCHN+FXCHN;
 if  (chn <= MAXCHN )  chn = MAXCHN+FXCHN;
 GusSetFrq(chn,instrs[ins].tune[0] >> 4);
 GusSetVol(chn,vol);
 GusSetPan(chn,pan);
 GPlayVoice(chn,ins,0);
}
