

GTrack_EventAdr_Table  DW Offset NO_GTrack_Entry
  DW Offset GTrack_Set_TickSpeed, Offset GTrack_Set_BPMSpeed, Offset GTrack_Set_Beat
  DW Offset GTrack_TickDelay, Offset GTrack_Set_Flag, Offset GTrack_Slidespeed_Up
  DW Offset GTrack_Slidespeed_Down


Instrument_EffectAdr_Table   DW Offset NO_Instrument_Effect
  DW Offset Set_Stop_Sample, Offset Set_Stop_Sample_Loop, Offset Override_Sample_Volume
  DW Offset Set_Sample_Delay, Offset Tremolo_Sample, Offset Set_Sample_Off0
  DW Offset Set_Sample_Off64, Offset Set_Sample_Off128, Offset Set_Sample_Off192
  DW Offset Invert_Sample_direction, Offset No_Instrument_effect, Offset No_Instrument_effect
  DW Offset No_Instrument_effect, Offset No_Instrument_effect, Offset No_Instrument_effect


Note_EffectAdr_Table   DW Offset NO_Note_Effect
  DW Offset Note_Finetune, Offset Set_Note_Delay, Offset Set_NoteArpeggio
  DW Offset Set_PortamentoUP, Offset Set_PortamentoDN, Offset Set_PortamentoNOTE
  DW Offset Set_Scratch_to_Note, Offset Set_VibratoSIN, Offset Set_VibratoSLIDE
  DW Offset Set_VibratoSQUARE, Offset Set_NoteTremolo, Offset Set_Note_Cut
  DW Offset NO_Note_Effect, Offset NO_Note_Effect, Offset NO_Note_Effect


Volume_EffectAdr_Table   DW Offset NO_Volume_Effect
  DW Offset Set_VolumeSlideUP, Offset Set_VolumeSlideDN, Offset Set_VolumeTremolo
  DW Offset Set_VolVibratoSIN, Offset Set_VolVibratoSLIDE, Offset Set_VolVibratoSQUARE
  DW Offset Set_VolumeBalance, Offset Slide_Balance_Left, Offset Slide_Balance_Right
  DW Offset Set_BalanceVibratoSIN, Offset NO_Volume_Effect, Offset NO_Volume_Effect
  DW Offset NO_Volume_Effect, Offset NO_Volume_Effect, Offset NO_Volume_Effect

external_channel_Status  DB  maxtracks DUP (0)  ; or'd copy of Channel.status


;Ŀ
; PROC Update_Music_Frame;                H32  INTERNAL 
;
PROC Update_Music_Frame NEAR

               mov    ax,ds    ; es = data segment
               mov    es,ax
               inc    [ds:ClickTimer]
               dec    [ds:ClickCounter]
               jz Tick_Update

;Ŀ
; CLICK Update             
;
EffectClick:
               mov    ch,[ds:Tracks]
               mov    si,offset channels

Next_Track_ClickUpdate:
;=== Process the Sample Effects
               mov    bx,[ds:si+Channel.Instr_ADR]
               jmp    bx

No_Instr_Effect_Update:
Instrument_Effect_Done:

;=== Process the Note Effects
               mov    bx,[ds:si+Channel.Note_ADR]
               jmp    bx

No_Note_Effect_Update:
Note_Effect_Done:

;=== Process the Volume Effect
               mov    bx,[ds:si+Channel.Volume_ADR]
               jmp    bx

NO_Volume_Effect_Update:
Volume_Effect_Done:
               add    si,32              ; address next track
               dec    ch
               jnz Next_Track_ClickUpdate

               jmp exit_Frame_Update

;Ŀ
; TICK Update              
;
Tick_Update:

; Tick Delay Support
               mov    ax,[ds:TickDelay]    ; check if TickDelay
               or     ax,ax
               jz @@NO_TickDelay
               dec    ax
               mov    [ds:TickDelay],ax
               mov    [ds:ClickCounter],1  ; route all clicks direkt to here...
               jmp exit_Frame_Update

@@NO_TickDelay:
               mov    al,[ds:clicks]
               inc    al
               mov    [ds:ClickCounter],al

; check position change request
               test   [ds:Playmode],80h    ; MSB set -> change play position
               jz no_change_position_req
               and    [ds:Playmode],7fh ; clear position change request
               mov    al,[ds:playmode]
               or     al,al
               jne not_sequencer_mode
               dec    [ds:SequencerPos] ; neutralize increment of set sequencer pos
not_sequencer_mode:
               mov    ax,[ds:Patternpos]
               cmp    ax,[ds:PatternEnd] ; pattern pos in range ?
               jae Sequencer_Update
               jmp set_play_position
no_change_position_req:
               mov    ax,[ds:Patternpos]
               inc    ax
               cmp    ax,[ds:PatternEnd]
               jae Sequencer_Update
               mov    [ds:Patternpos],ax
               mov    esi,[DWORD PTR ds:PatterndataADR]
               jmp Note_Update

; process Sequencer Commands
sequencer_update:
               xor    ax,ax           ; reset pattern pos to start
               mov    [ds:Patternpos],ax
set_play_position:
               mov    al,[ds:playmode]
; Playmodes:
;  0=Sequencer mode
;  1=stop music frame
;  2=Pattern mode no loop
;  3=Pattern mode loop
;  4=Pattern block mode
;  5=Pattern block mode loop
               or     al,al
               jne Pattern_mode
               mov    ax,[ds:SequencerPos]
               cmp    ax,[ds:Seq_Loop_End]
               jne @@No_loop_position
               cmp    [ds:Seq_loop],0
               je @@No_loop_position
               mov    ax,[ds:Seq_Loop_Start]
               mov    [ds:SequencerPos],ax
@@No_loop_position:
               cmp    ax,[ds:SequencerEnd]
               jb Music_continues
               jmp Stop_musicframe
Music_continues:
               inc    [ds:SequencerPos]  ; point to next position
               lds    si,[ds:SequencerADR]
               shl    ax,1
               add    si,ax              ; address the sequencer position
               lodsw                     ; read the pattern nr.
               mov    [es:PatternNr],ax
               jmp setup_pattern
Pattern_mode:
               cmp    al,1
               je Stop_musicframe
               cmp    al,2
               jne pattern_loop_mode
               mov    [ds:playmode],1  ; stop music in next frame
               mov    ax,[ds:PatternNr]
               jmp setup_pattern

pattern_loop_mode:
               cmp    al,3
               jne pattern_block_mode
               mov    ax,[ds:PatternNr]
               jmp setup_pattern

pattern_block_mode:
               cmp    al,4
               jne pattern_block_loop_mode
               mov    [ds:playmode],1  ; stop music in next frame
pattern_block_loop_mode:
               mov    ax,[ds:PatternPOS_Res]   ; PatternPos = restart position
               mov    [ds:Patternpos],ax
               jmp setup_pattern

Stop_musicframe:
               call Music_stop
               jmp exit_Frame_Update

; setup pattern
setup_pattern:  ; ax = Pattern nr
               lds    si,[es:PatternlistADR] ; address the pattern list
               shl    ax,2
               add    si,ax            ; address the pattern data
; read Pattern address
               lodsw                   ; read the pattern start address
               mov    [WORD PTR es:PatternstartADR],ax
               mov    bx,ax
               lodsw
               mov    [WORD PTR es:PatternstartADR+2],ax
               mov    si,bx
               mov    ds,ax

; Copy Pattern Header
               lodsb
               mov    [es:Tracks],al
               lodsb
               mov    [es:beat],al
               lodsw
               mov    [es:PatternEnd],ax
               add    si,4             ; jump over pattern size (not needed)
               lodsd                   ; read pattern address

               mov    [DWORD PTR es:PatterndataADR],eax
               mov    esi,eax          ; [gs:esi] pointer to pattern data

               mov    ax,es            ; ds = data segment
               mov    ds,ax

; clear Tick counters
               mov    cx,maxtracks
               mov    bx,offset Tick_Counters
               xor    ax,ax
@@clear_tickcounter:
               mov    [ds:bx],al  ; clear Tickcounter
               inc    bx
               loop @@clear_tickcounter
               mov    [ds:GTrack_tick_counter],al

               mov    ax,[ds:patternpos]
               or     ax,ax
               jz Pattern_set
; parse to correct pattern position

               xor    bx,bx        ; Tick Counter
@@parse_next_tick:
               mov    al,[ds:GTrack_tick_counter]
               or     al,al
               jz @@new_Gtrack_data

               dec    al           ; dec counter
               mov    [ds:GTrack_tick_counter],al
               jmp @@No_Gtrack_Entry

@@new_Gtrack_data:
               mov    al,[gs:esi]  ; read Global Track Effect nr.
               inc    esi
               test   al,80h
               jz @@no_Gtrack_counter
               mov    ah,[gs:esi]  ; read Global Track counter
               inc    esi
               mov    [ds:Gtrack_tick_counter],ah
@@no_Gtrack_counter:
               and    al,07fh      ; clear Counter bit
               or     al,al
               jz @@No_Gtrack_Entry
               inc    esi
@@No_Gtrack_Entry:
               movzx  cx,[ds:Tracks]
@@Parse_next_Track:
               movzx  ax,[ds:Tracks]
               sub    ax,cx         ; ax = tracknr
               mov    di,ax
               mov    al,[ds:tick_counters+di]
               or     al,al
               jz @@aktive_tick
               dec    al
               mov    [ds:tick_counters+di],al
               jmp @@No_Track_data
@@aktive_tick:
               mov    al,[gs:esi]   ; load track info byte
               inc    esi
; Tickcounter
               shl    al,1       ; tick counter
               jnc @@No_tick_counter
               mov    ah,[gs:esi] ; read tick counter
               inc    esi
               mov    [ds:tick_counters+di],ah
@@No_tick_counter:

; Instrument
               shl    al,1
               jnc @@No_Instrument
               inc    esi
@@No_Instrument:
; Note
               shl    al,1
               jnc @@No_Note
               inc    esi
@@No_Note:
; Volume
               shl    al,1
               jnc @@No_Volume
               inc    esi
@@No_Volume:
; Instrument effect
               shl    al,1
               jnc @@No_Instrument_Effect
               add    esi,2

@@No_Instrument_Effect:

; Note effect
               shl    al,1
               jnc @@No_Note_Effect
               add    esi,2
@@No_Note_Effect:

; Volume Effect
               shl    al,1
               jnc @@No_Volume_Effect
               add    esi,2
@@No_Volume_Effect:
@@No_Track_data:
               loop @@parse_next_Track

               inc    bx
               cmp    bx,[ds:Patternpos]
               jne @@parse_next_Tick

Pattern_set:

; Set new Speed if valid Speed Mode is BPM (BPM=0 ignore BPM, Mode=Tickspeed)
               mov    ax,[ds:BPM]
               call Set_BPMSpeed

;Ŀ
; NOTE Update              
;
; Copy all the note data of the track into the channels
; gs:esi = pattern data
Note_Update:

; read Global Track
               mov    al,[ds:GTrack_tick_counter]
               or     al,al
               jz new_Gtrack_data

               dec    al           ; dec counter
               mov    [ds:GTrack_tick_counter],al
               jmp No_Gtrack_Entry

new_Gtrack_data:
               mov    al,[gs:esi]  ; read Global Track Effect nr.
               inc    esi
               test   al,80h
               jz no_Gtrack_counter
               mov    ah,[gs:esi]   ; read Global Track counter
               inc    esi
               mov    [ds:Gtrack_tick_counter],ah
no_Gtrack_counter:
               and    al,07fh      ; clear Counter bit
               or     al,al
               jz No_Gtrack_Entry
               and    al,07h   ; only low nibble is need
               movzx  bx,al
               mov    al,[gs:esi]  ; read Global Track data
               inc    esi

               shl    bx,1
               mov    bx,[ds:GTRACK_EventAdr_TABLE+bx]
               jmp    bx              ; JUMP to correct Event

; GTRACK Event Exit - return JUMP address for all GTRACK Event routines
No_Gtrack_Entry:
               movzx  cx,[ds:Tracks]
               mov    di,offset channels

; Update Tracks
Next_Track:
               and    [ds:di+Channel.status],83h  ; Clear all Internal Status bits
               movzx  bx,[ds:Tracks]
               sub    bx,cx         ; bx = tracknr
               rol    ecx,16        ; push nr. Of Tracks
               mov    al,[ds:tick_counters+bx]
               or     al,al
               jz aktive_tick
               dec    al
               mov    [ds:tick_counters+bx],al
               xor    ch,ch         ; clear Track Info
               jmp inaktive_tick
aktive_tick:
               mov    al,[gs:esi]   ; load Track Info byte
               inc    esi
               mov    ch,al
inaktive_tick:
; Tickcounter
               shl    ch,1       ; tick counter
               jnc No_tick_counter
               mov    al,[gs:esi]   ; read tick counter
               inc    esi
               mov    [ds:tick_counters+bx],al
No_tick_counter:
; Instrument
               shl    ch,1
               jnc No_Instrument
               xor    ax,ax
               mov    al,[gs:esi]   ; read Instrument nr.
               inc    esi
               mov    [ds:di+Channel.Instrnr],al
               or     [ds:di+Channel.status],74h
                ; Set Instr. Trigger & Instr Chg & Note & Volume & Balance bit
                ; Because of a Voice Exchange !!!
               shl    ax,5
               push   si
               mov    si,offset Sample_List
               add    si,ax     ; address the sample data area
               mov    al,[ds:si+Sample.Volume]
               xchg   [ds:di+Channel.Volume],al
               mov    [ds:di+Channel.Instr_data1],ax ; save orginal volume
               mov    [ds:di+Channel.Volume_Last_Fx],0  ; reset last volume effect
               pop    si
No_Instrument:
; Note
               shl    ch,1
               jnc No_Note
               xor    ax,ax
               mov    al,[gs:esi]       ; read note
               inc    esi
;
               cmp    al,0ffh
               je Note_OFF
;
               shl    al,1       ; Marker bit in Carry (+Shift LSB Finetune)
               jc Note_to_Buffer
               shl    ax,3       ; Shift over Finetune (the 3 remaining bits }
               xchg   [ds:di+Channel.Note],ax
               mov    [ds:di+Channel.Note_data1],ax
               mov    [ds:di+Channel.Note_Last_Fx],0  ; reset Last Effect
               or     [ds:di+Channel.status],10h ; Set Note Change bit
               jmp No_note
Note_OFF:
               xor    ax,ax     ; Note Frequenz = 0
               mov    [ds:di+Channel.Note],ax
               or     [ds:di+Channel.status],10h ; Set Note Change bit
               jmp No_note

Note_to_Buffer:
               shr    al,1       ; convert back to normal note
               mov    [ds:di+Channel.NoteBuffer],al
No_Note:
; Volume
               shl    ch,1
               jnc No_Volume
               mov    al,[gs:esi]  ; read Volume
               inc    esi
               mov    [ds:di+Channel.Volume],al
               or     [ds:di+Channel.status],20h  ; Set Volume Change bit
               mov    [ds:di+Channel.Volume_Last_Fx],0  ; reset last effect
No_Volume:
; Instrument effect
               mov    ax,offset No_Instr_Effect_Update ; reset note click routine
               mov    [ds:di+Channel.Instr_Adr],ax
               shl    ch,1
               jnc No_Instrument_Effect
               mov    ax,[gs:esi] ; read Instrument effect
               add    esi,2
               mov    bl,al
               and    bx,0fh    ; only low nibble is needed now (overflow prevent)

               shl    bx,1
               mov    bx,[ds:Instrument_EffectAdr_TABLE+bx]
               jmp    bx              ; JUMP to correct Event

; Instrument Effect Exit - return jump address for all Instrument Effect routines
No_Instrument_Effect:

; Note effect
               mov    ax,offset No_Note_Effect_Update ; reset Note Click routine
               mov    [ds:di+Channel.Note_Adr],ax
               shl    ch,1
               jnc No_Note_Effect
               mov    ax,[gs:esi] ; Al = Note Effect nr. Ah = Note Effect data
               add    esi,2
               mov    bl,al
               xchg   bl,[ds:di+Channel.Note_Last_FX] ; store new effect, get old
               xor    cl,cl     ; same effect ?
               cmp    bl,al
               je @@Same_NoteEffect
               dec    cl        ; different effect cl = 0ffh
@@Same_NoteEffect:
               mov    bl,al
               and    bx,0fh    ; only low nibble is needed

               shl    bx,1
               mov    bx,[ds:Note_EffectAdr_TABLE+bx]
               jmp    bx              ; JUMP to correct Event

; Note Effect Exit - return jump address for all Note Effect routines
No_Note_Effect:

; Volume Effect
               mov    ax,offset No_Volume_Effect_Update ; reset Volume Click routine
               mov    [ds:di+Channel.Volume_Adr],ax
               shl    ch,1
               jnc No_Volume_Effect
               mov    ax,[gs:esi] ; Al = Volume Effect nr. Ah = Volume Effect data
               add    esi,2
               mov    bl,al
               xchg   bl,[ds:di+Channel.Volume_Last_FX] ; store new, get old
               xor    cl,cl     ; Same Effect ?
               cmp    bl,al
               je @@Same_VolumeEffect
               dec    cl        ; different effect  cl = 0ffh
@@Same_VolumeEffect:

               mov    bl,al
               and    bx,0fh    ; only low nibble is need

               shl    bx,1
               mov    bx,[ds:Volume_EffectAdr_TABLE+bx]
               jmp    bx              ; JUMP to correct Event

; Volume Effect Exit - return jump address for all Volume Effect routines
No_Volume_Effect:

; set external status
               rol    ecx,16             ; pop nr. of Tracks
               mov    al,[ds:di+Channel.status]   ; get channel status
               movzx  bx,[ds:Tracks]
               sub    bx,cx         ; bx = tracknr
               or     [ds:external_channel_status+bx],al ; or channel status
               add    di,32              ; address next track
               dec    cx
               jnz Next_Track

               mov    [DWORD PTR ds:PatterndataADR],esi ; save new pattern position

; End of Music Frame Update...
Exit_Frame_update:

               ret

ENDP Update_Music_Frame

; THE END 
