// PCX2RAW.CPP
// Converts bitmap and palette from a PCX file into raw binary files
// coded by Tumblin / Bodies In Motion '95

#include  <process.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<conio.h>
#include	<dos.h>
#include	"pcx.h"


FILE *fp;
char source_filename[80];
char bitmap_filename[80];
char palette_filename[80];

pcx_struct pcxbuf;  // Buffer for PCX data
Pcx pcxloader;      // PCX loader object

int main(void);

int main(void)
{

	int top_x,top_y,bot_x,bot_y; // defines the bitmap
	int x,y; // for looping

	printf("PCX to raw convertor\ncoded by Tumblin / Bodies In Motion '95\n\n");

	printf("Enter the filename of the source PCX file: ");
	gets(source_filename);

	printf("\nEnter the filename of the target raw bitmap file: ");
	gets(bitmap_filename);

	printf("Enter the filename of the target palette file: ");
	gets(palette_filename);


	printf("\nEnter top left x coordinate of bitmap: ");
	scanf("%i",&top_x);
	printf("Enter top left y coordinate of bitmap: ");
	scanf("%i",&top_y);
	printf("Enter bottom right x coordinate of bitmap: ");
	scanf("%i",&bot_x);
	printf("Enter botto right y coordinate of bitmap: ");
	scanf("%i",&bot_y);


	if (pcxloader.load(source_filename,&pcxbuf))
	{
		exit(1);
	}

	if( (fp=fopen(bitmap_filename,"wb")) == NULL)
	{
		printf("ERROR: Could not open raw bitmap file.\n");
		exit(1);
	}

	printf("\nWriting a %ix%i raw bitmap file...",bot_x-top_x+1,bot_y-top_y+1);

	for(y=top_y;y<=bot_y;y++)
	{
		for(x=top_x;x<=bot_x;x++)
		{
			fwrite(&pcxbuf.image[y*320+x],sizeof(char),1,fp);
		}
	}
	fclose(fp);
	printf("done.");

	printf("\nWriting palette file...");

	if( (fp=fopen(palette_filename,"wb")) == NULL)
	{
		printf("ERROR: Could not open raw palette file.\n");
		exit(1);
	}

	fwrite(&pcxbuf.palette[0],sizeof(char),768,fp);

	fclose(fp);
	printf("done.");

	printf("\n\nBitmap and palette data successfully converted.\n");
	return(0);
}
