


/*

First off, we need code to draw an ELLIPSE, Using X,Y co-ords...



*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <dos.h>
#include "gl.h"

unsigned char ibuffer[70000];

#define M_PI        3.14159265358979323846

int sin256[360];
int sin1024[1024];
/*
= { 0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,
8,8,9,9,9,10,10,11,11,12,12,12,13,13,13,14,14,14,15,
15,15,16,16,16,17,17,17,17,18,18,18,18,18,19,19,19,
19,19,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
20,20,20,20,20,19,19,19,19,19,19,18,18,18,18,18,17,
17,17,17,16,16,16,15,15,15,15,14,14,13,13,13,12,12,
12,11,11,10,10,9,9,9,8,8,7,7,6,6,5,5,4,
4,3,3,2,2,2,1,1,0,0,0,0,-1,-1,-2,-2,-3,
-3,-4,-4,-5,-5,-6,-6,-7,-7,-8,-8,-8,-9,-9,-10,-10,-10,
-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-15,-15,-15,-16,-16,-16,
-16,-17,-17,-17,-17,-17,-18,-18,-18,-18,-18,-18,-19,-19,-19,-19,-19,
-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-18,
-18,-18,-18,-17,-17,-17,-17,-17,-16,-16,-16,-16,-15,-15,-15,-14,-14,
-14,-14,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-9,-9,-8,-8,-8,
-7,-7,-6,-6,-5,-5,-4,-4,-3,-3,-2,-2,-2,-1,-1,0,0
 }; 
*/
int cos256[360];
int cos1024[1024];
/*
= { 20,20,20,20,20,20,20,20,20,20,19,19,19,19,19,19,18,
18,18,18,18,17,17,17,17,16,16,16,15,15,15,14,14,14,
13,13,13,12,12,12,11,11,10,10,9,9,9,8,8,7,7,
6,6,5,5,4,4,3,3,2,2,1,1,1,0,0,0,0,
-1,-1,-2,-2,-3,-3,-4,-4,-5,-5,-6,-6,-7,-7,-8,-8,-8,
-9,-9,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-15,
-15,-15,-16,-16,-16,-16,-17,-17,-17,-17,-17,-18,-18,-18,-18,-18,-18,
-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,
-19,-19,-18,-18,-18,-18,-18,-18,-17,-17,-17,-17,-17,-16,-16,-16,-16,
-15,-15,-15,-14,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,
-9,-9,-8,-8,-8,-7,-7,-6,-6,-5,-5,-4,-4,-3,-3,-2,-2,
-1,-1,-1,0,0,0,0,1,1,2,2,3,3,4,4,5,5,
6,6,7,7,8,8,9,9,9,10,10,11,11,11,12,12,13,
13,13,14,14,14,15,15,15,16,16,16,17,17,17,17,18,18,
18,18,18,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20
 };
*/


void make_sin(void)
{
    int i;
    float a,c;

    c=M_PI/128.0;
    for(i=0,a=0.0; i<256;i++,a+=c)
    {
        sin256[i]=(int)((sin(a)*256.0)+0.5);
        cos256[i]=(int)((cos(a)*256.0)+0.5);
    }
    c=M_PI/512.0;
    for(i=0,a=0.0; i<1024;i++,a+=c)
    {
        sin1024[i]=(int)((sin(a)*1024.0)+0.5);
        cos1024[i]=(int)((cos(a)*1024.0)+0.5);
    }
}

long RotateX(int x,int y,int angle)
{
    return(((sin1024[angle]*y)-(cos1024[angle]*x))/1024);
}

long RotateY(int x,int y,int angle)
{
    return(((sin1024[angle]*x)-(cos1024[angle]*y))/1024);
}

#define SHAPESIZE 190

unsigned char   ShapeBuffX[SHAPESIZE*SHAPESIZE],
                ShapeBuffY[SHAPESIZE*SHAPESIZE],
                ShapeBuffZ[SHAPESIZE*SHAPESIZE];

void Globe_Ellipse(unsigned char *gbuffX,unsigned char *gbuffY,
        unsigned char *gbuffZ,int cx,int cy,int rx,int ry,int rangle,int row)
{
    int i,j,k,x,y,fx,fy;

    for(i=0;i<1024;i++)   /* Drawing of "upper" portion always begins at 0 */
    {
        y=(cos1024[i]*ry)/16;  /* -127 to 127 */
        x=(sin1024[i]*rx)/16;  /* 8.6 fixed point.. */
        /* Now.. rotate and translate... */
        fx=cx+(RotateX(x,y,rangle)>>6); if(fx<0) fx=0; if(fx>127) fx=127;
        fy=cy-(RotateY(x,y,rangle)>>6); if(fy<0) fy=0; if(fy>127) fy=127;

        fx>>=1; fy>>=1;
        fx+=(fy<<6);
        gbuffX[fx]=i;
        gbuffY[fx]=row;
        gbuffZ[fx]=1;  /* mask temp buff */
    }
}

void YMake_Globe(float incr)
{
    float axis,xr,yr,xc,yc,el1,nx,ny;

    xc=160.0;
    for(axis=0.0;axis<1.0;axis+=incr)
    {
        yr=sin((M_PI*axis)); /* 0.0...1.0...0.0 */
        xr=yr*100.0;
        yr*=10.0;            /* Now, XR and YR are set... */
        yc=100.0+(cos((M_PI*axis))*90.0);
        for(el1=0.0;el1<=2.0;el1+=0.001)
        {
            nx=(sin(M_PI*el1)*xr)+xc;
            ny=(cos(M_PI*el1)*yr)+yc;
            GL_SetPixel((int)(nx+0.5),(int)(ny+0.5),(int)(axis*256.0));
        }
        if(kbhit())
            break;
    }
    while(kbhit()) getch();
}

void XMake_Globe(float incr)
{
    float axis,xr,yr,xc,yc,el1,nx,ny;

    xc=160.0;
    for(axis=0.0;axis<1.0;axis+=incr)
    {
        yr=sin((M_PI*axis)); /* 0.0...1.0...0.0 */
        xr=yr*100.0;
        yr*=10.0;            /* Now, XR and YR are set... */
        yc=100.0+(cos((M_PI*axis))*90.0);
        for(el1=0.0;el1<=2.0;el1+=0.001)
        {
            nx=(sin(M_PI*el1)*xr)+xc;
            ny=(cos(M_PI*el1)*yr)+yc;
            GL_SetPixel((int)(nx+0.5),(int)(ny+0.5),(int)(el1*128.0));
        }
        if(kbhit())
            break;
    }
    while(kbhit()) getch();
}

#if 0
void Make_Globe(void)
{
    int row,xr,yr,yc,xc;
    int i,j,k,x,y,fx,fy,rangle;

    rangle=0;
    for(row=0;row<100;row++)
    {
        yc=((cos1024[(row*512)/50]*25)/1024)+25;
        yc*=2;
        xr=(sin1024[(row*512)/50]*32)/1024;
        xr*=2;
        yr=(sin1024[(row*512)/50]*5)/1024;
        yr*=2;
        /* Globe_Ellipse(ShapeBuffX,ShapeBuffY,ShapeBuffZ,64,yc+14,xr,yr,0,row/2); */
        for(i=0;i<1024;i++)   /* Drawing of "upper" portion always begins at 0 */
        {
            y=(cos1024[i]*yr)/16;  /* -127 to 127 */
            x=(sin1024[i]*xr)/16;  /* 8.6 fixed point.. */
            /* Now.. rotate and translate... */
            fx=xc+(RotateX(xr,yr,rangle)>>6); if(fx<0) fx=0; if(fx>127) fx=127;
            fy=yc-(RotateY(xr,yr,rangle)>>6); if(fy<0) fy=0; if(fy>127) fy=127;

            fx>>=1; fy>>=1;
            fx+=(fy<<6);
            ShapeBuffX[fx]=i;
            ShapeBuffY[fx]=row;
            ShapeBuffZ[fx]=1;  /* mask temp buff */
        }
    }
}
#endif



void Make_Globe(float incr)
{
    float axis,xr,yr,xc,yc,el1,nx,ny,ShapeSize,RSize;
    int fx,fy;

    ShapeSize=SHAPESIZE;
    RSize=ShapeSize*0.44;
    xc=ShapeSize/2.0;
    for(axis=0.0;axis<1.0;axis+=incr)
    {
        yr=sin((M_PI*axis)); /* 0.0...1.0...0.0 */
        xr=yr*RSize;
        yr*=ShapeSize*0.1;            /* Now, XR and YR are set... */
        yc=xc-(cos((M_PI*axis))*RSize);
        for(el1=0.0;el1<=2.0;el1+=incr)
        {
            nx=((sin(M_PI*el1)*xr)+xc)+0.5;
            ny=((cos(M_PI*el1)*yr)+yc)+0.5;
            fx=(int)nx; fy=(int)ny;
            if(fx>=SHAPESIZE) fx=SHAPESIZE-1; if(fy>=SHAPESIZE) fy=SHAPESIZE-1;
            fx+=(fy*SHAPESIZE);
            ShapeBuffX[fx]=255-(int)(el1*256.0);
            ShapeBuffY[fx]=(int)(axis*256.0);
            ShapeBuffZ[fx]=1;  /* mask temp buff */
        }
    }
}


void XXMake_Globe(void)
{
    int row,xr,yr,yc;

    for(row=0;row<100;row++)
    {
        yc=((cos1024[(row*512)/50]*25)/1024)+25;
        yc*=2;
        xr=(sin1024[(row*512)/50]*32)/1024;
        xr*=2;
        yr=(sin1024[(row*512)/50]*5)/1024;
        yr*=2;
        Globe_Ellipse(ShapeBuffX,ShapeBuffY,ShapeBuffZ,64,yc+14,xr,yr,0,row/2);
    }
}

unsigned char ipal[768];
unsigned char opal[768];

void SCALE1( int X, int Y, int DW, int DY,int SW, int SH, unsigned char * Bitmap );

void main(void)
{
    int x,y,i,j,xr,yr,yc,nx,ny,ox,oy;

#if 0
    make_sin();
    x=RotateX(10,0,0);
    y=RotateY(10,0,0);
    printf("(10,0) Rotated: %d  X:%d  Y:%d \n",0,x,y);
    x=RotateX(10,0,40);
    y=RotateY(10,0,40);
    printf("(10,0) Rotated: %d  X:%d  Y:%d \n",40,x,y);
    x=RotateX(10,0,64);
    y=RotateY(10,0,64);
    printf("(10,0) Rotated: %d  X:%d  Y:%d \n",64,x,y);
    x=RotateX(10,0,80);
    y=RotateY(10,0,80);
    printf("(10,0) Rotated: %d  X:%d  Y:%d \n",80,x,y);
    x=RotateX(10,0,170);
    y=RotateY(10,0,170);
    printf("(10,0) Rotated: %d  X:%d  Y:%d \n",170,x,y);
    getch();
#endif
    printf("Please wait...\n");
    Make_Globe(0.003);
    GL_InitMode13();
    GL_Gif("bb256256.gif",ibuffer,ipal,&i,&j);
    /*
    YMake_Globe(0.005);
    getch();
    XMake_Globe(0.005);
    getch();
    */
#if 0
    for(j=0;j<256;j++)
    {
        xr=sin1024[j*2];
        if(j<128)
        {
            yr=(j*8);
        }
        else
        {
            yr=(128-(j%128))*8;
        }
        yc=((cos1024[(j*512)/256]*128)/1024)+128;
        for(i=0;i<1024;i++)
        {
            x=100+((RotateX(0,100,i)*xr)/1024);
            y=10+((yc*180)/256)+((RotateY(0,80,i)*yr)/1024);
            GL_SetPixel(x,y,j);
        }
        if(kbhit())
            break;
    }
    getch();
    x=0;
    for(i=0;i<128;i++)
    {
        for(j=0;j<128;j++)
        {
            if(ShapeBuffZ[x])
            {
                GL_SetPixel(j,i,ShapeBuffY[x]);
                GL_SetPixel(100+j,i,ShapeBuffX[x]);
            }
            x++;
        }
    }
    getch();
#endif
    memset(opal,0,768);
    GL_FadeInPal(opal,2000);
    GL_ClearScreenColor(GL_FindColor(ipal,0,0,0,9999));
    SCALE1(0,0,320,200,256,256,ibuffer);
    GL_FadeInPal(ipal,2000);
    yc=0;
    ox=(320-SHAPESIZE)/2;
    oy=(200-SHAPESIZE)/2;
    while(!kbhit())
    {
        x=0;
        for(i=0;i<SHAPESIZE;i++)
        {
            for(j=0;j<SHAPESIZE;j++)
            {
                if(ShapeBuffZ[x])
                {
                    nx=(ShapeBuffX[x]+yc)%256;
                    ny=ShapeBuffY[x]<<8;
                    GL_SetPixel(ox+j,oy+i,ibuffer[nx|ny]);
                }
                x++;
            }
        }
        yc++; yc%=256;
    }
    getch();
    GL_TextMode();
}



