#ifndef _WGTFLIC_
#define _WGTFLIC_

#include <wgt5.h>

/*
   WordUp Graphics Toolkit V5.0  FLI/FLC Routines
   Copyright 1995 Egerter Software
*/

#ifdef __cplusplus
  extern "C" {
#endif

typedef struct {                        /* MAIN FLI header */
    int         size;                   /* Size of file */
    unsigned short magic;               /* 44817 = FLI, 44818 = FLC */
    short       frames;                 /* Frames in animation */
    short       width;                  /* Animation width */
    short       height;                 /* Animation height */
    short       depth;                  /* Bits per pixel (8) */
    short       flags;                  /* Set to 0x0003 after ring frame */
    short       speed;                  /* Delay in msec between frames */
    short       reserved;               /* Unused word, set to 0 */
    int         created;                /* MSDOS format date/time */
    int         creator;                /* Serial # of AnimPro */
    int         updated;                /* MSDOS format date/time */
    int         updater;                /* Yet another serial # */
    short       aspectx;                /* Aspect ratio of x-axis */
    short       aspecty;                /* Aspect ratio of y-axis */
    unsigned short reserved2[19];       /* 38 unused bytes, set to zeroes */
    int         oframe1;                /* Offset of frame 1 in file */
    int         oframe2;                /* Offset of frame 2 in file */
    unsigned short reserved3[20];       /* 40 unused bytes, set to zeroes */
} flicheader;

#define FLIC_DISK               0
#define FLIC_MEMORY             1

#define FLIC_IGNOREPALETTE      0
#define FLIC_UPDATEPALETTE      1

#define FLIC_OK                 0
#define FLIC_NOTFOUND           1
#define FLIC_INVALIDRES         2
#define FLIC_INVALIDHEADER      3
#define FLIC_INVALIDFRAME       4
#define FLIC_INVALIDCHUNK       5
#define FLIC_DONE               6

extern flicheader flichdr;      /* Access this structure for general info */

extern block    flicscreen;     /* Logical screen for FLI/FLC updates */
extern int      flic_updatey;   /* Uppermost y position updated */
extern int      flic_updatey2;  /* Lowermost y position updated */
extern int      flic_update;    /* Indicates screen update */

                                /* Open up a FLI or FLC file */
int   openflic (char *filename, int mode_flic, int update_colors);
int   nextframe (void);         /* Advance to the next frame */
void  copyflic (void);          /* Copy the FLICSCREEN to the visual screen */
void  closeflic (void);         /* Close the FLI/FLC file */

#ifdef __cplusplus
}
#endif

#endif
