/*
==============================================================================
		      WordUp Graphics Toolkit Version 5.0                     
			     Demonstration Program 29                         
									      
 Demonstrate the use of wcopyscreen to simulate a text scroller.             
									     
 *** PROJECT ***                                                             
 This program requires the file WGT5_WC.LIB to be linked.                    
									      
 *** DATA FILES ***                                                          
 Make sure that LETTERS.SPR is in your executable directory.                 
							   WATCOM C++ VERSION 
==============================================================================
*/

#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <wgt5.h>

color p[256];                 /* Our palette */
block sprites[1001];          /* Pointers to blocks */


void main(void)
{
  char *scrolltext="THIS IS A SMALL TEXT SCROLLER CREATED WITH THE WCOPYSCREEN COMMAND.  PRESS A KEY TO END THIS SCROLLER...    ";

  short scrnum;                   /* Counter for current letter of scroller */
  short nextlet, i, j, k;         /* Counters */
  short oldmode;                  /* Stores intial video mode */

  if ( !vgadetected () )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit (0);
  }
  printf ("WGT Example #29\n\n");
  printf ("Virtual screens are used to create a tickertape scroller on the bottom of\n");
  printf ("the visual screen. Press a key to end the program at any time.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();


  oldmode = wgetmode ();         /* Gets the current mode */
  vga256 ();                     /* Initialize graphics mode */

  wloadsprites (p, "letters.spr", sprites, 0, 1000); /* Load our blocks */

  for (i = 0; i < 180; i++)      /* Draws a background for the screen */
  {
    wsetcolor (i);
    wline (0, 0, 319, i);
    wline (319, 199, 0, 180 - i);
  }

  wsetcolor (0);                    /* Draw with black */
  wbar (0, 189, 319, 199);          /* Clear area off bottom for scroller */
  do
  {
    scrnum = 0;           /* Start at first character of scroller string */
    do
    {
      /* Find pixel width of current letter in string */
      nextlet = wgetblockwidth (sprites[scrolltext[scrnum] + 1]);
      for (j = 0; j <= nextlet + 1; j += 2)
      {
	wbar (318, 189, 319, 199);  /* Erase right-hand side of scroller area */

	/* Now copy the last letter on at the end of the string */
	wputblock (319 - j, 189, sprites[scrolltext[scrnum] + 1], 0);

	/* Wait for monitor to finish vertical retrace */
	wretrace ();

	/* Shift scroller to the left */
	wcopyscreen (2, 189, 319, 199, NULL, 0, 189, NULL);
      }
      scrnum++;                                 /* Advance to next letter */
    } while ((scrolltext[scrnum + 1] != 0) & (!kbhit ()));
     /* Loop yet? */
  } while (!kbhit ());                          /* Abort if key pressed */

  wfreesprites (sprites, 0, 1000);              /* Free our sprites */
  wsetmode (oldmode);                    /* Restore initial video mode */
}
