/*
==============================================================================
                      WordUp Graphics Toolkit Version 5.0                     
                             Demonstration Program 16                         
                                                                              
 This program shows how to use wcopyscreen.                                   
                                                                              
 *** PROJECT ***                                                             
 This program requires the file WGT5_WC.LIB to be linked.                    
                                                                              
 *** DATA FILES ***                                                          
 NONE                                                                        
                                                           WATCOM C++ VERSION 
==============================================================================
*/

#include <wgt5.h>


void main(void)
{
  short x,y, tempx, tempy;
  short oldmode;
  block screen1;

  printf ("WGT Example #16\n\n");
  printf ("This program demonstrates virtual screen buffers.\n");
  printf ("It will copy data from a virtual screen to the current mouse location\n");
  printf ("on the visual screen. Press a key to end the demo at any time.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  if ( !vgadetected () )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit (0);
  }
  oldmode = wgetmode ();
  vga256 ();

  screen1 = wnewblock (0, 0, 319, 199);

  wsetscreen (screen1);          /* sets to screen1 */
  for (y = 0; y < 200; y++)
  {
    wsetcolor (y);
    wfline (0, 0, 319, y);          /* draw something on another screen */
    wfline (319, 199, 0, y);
  }

  minit ();
  moff ();
  wnormscreen ();                /* make the putblock go onto the default screen */

  do {
    tempx = mouse.mx;
    tempy = mouse.my;
    wcopyscreen (tempx, tempy, tempx+19, tempy+19, screen1, tempx, tempy, NULL);
    /* this means copy a square 20*20 from screen1 to the same spot
       on the default screen.  Move the mouse around and watch the black
       wipe away as screen1 copies over. */

    /* NULL means the default screen. */
  } while (!kbhit ());
  mdeinit ();                   /* Deinitialize the mouse handler */

  getch ();              /* wasn't that fun! */

  wfreeblock (screen1);
  wsetmode (oldmode);
}
