;
; Another TGA production.....				 Project Files :
;
; Project  	  :	RAWX_PM						  VGAFRAME.ASM
;Ķ  GFXRTS.ASM
; File		  : VGAFRAME.ASM				  FONTRTS.ASM
; Ver		  : (Pre-All) 0.13				  MOUSERTS.ASM
; Last Updated: 02.12.96                      INDRTS.ASM
; Code		  : Ghyll                       
;
; TAB = 4

		IDEAL
		P386
		MODEL Flat

;
; DATA:
;
; CurBuffer		- X_BUFFER array of current framebuffer
; VGABuffer		- X_BUFFER array of VGA buffer
;
; FUNCTIONS:
;
; i_getaddr		 - calculates offset into CurBuffer from X,Y coords. Internal
; x_setmode		 - sets video mode and initializes RAWX structs
; x_setbuffer	 - switches to new framebuffer
; x_wait4vrt	 - waits for verticle retrace
; x_setdispstart - sets display start address
; x_setscanlinelen - sets screen size
;
; REQUIRES:
;
; DS=CS=flat data/code selectors
; Some DPMI functions
;  - Alloc mem (ext. and low)
;  - Call realmode INT
;
; NOTES:
;
; ES is set to DS when calling x_setmode. It must remain so for the entire
; use of the RawX functions, as they excpect flat protected mode for both
; ES _and_ DS. (Using movs..)
;


MAJOR_VER	=	0h
MINOR_VER	=	13h


STRUC dscp
  D_lim1    	DW   	0
  D_base1   	DW    	0
  D_base2   	DB    	0
  D_type    	DB    	0
  D_lim2    	DB    	0
  D_base3   	DB    	0
ENDS  dscp

STRUC RMINT
	_edi		DD		?
	_esi		DD		?
	_ebp		DD		?
	_ignore		DD		?						;Reserved
	_ebx		DD		?
	_edx		DD		?
	_ecx		DD		?
	_eax		DD		?
	_cpu		DW		?						;Flags
	_es			DW		?
	_ds			DW		?
	_fs			DW		?
	_gs			DW		?
	_ip			DW		?
	_cs			DW		?
	_sp			DW		?
	_ss			DW		?
ENDS

STRUC  ModeInfoBlock

; Mandatory information for all VBE revisions

ModeAttributes		dw	?   ; mode attributes
WinAAttributes		db	?	; window A attributes
WinBAttributes		db	?	; window B attributes
WinGranularity		dw	?	; window granularity
WinSize	        	dw	?	; window size
WinASegment	    	dw	?	; window A start segment
WinBSegment	    	dw	?	; window B start segment
WinFuncPtr	    	dd	?	; pointer to window function
BytesPerScanLine 	dw	?	; bytes per scan line

; Mandatory information for VBE 1.2 and above

XResolution	    	dw	?	; horizontal resolution in pixels or characters
YResolution	    	dw	?	; vertical resolution in pixels or characters
XCharSize	    	db	?	; character cell width in pixels
YCharSize	    	db	?   ; character cell height in pixels
NumberOfPlanes		db	?	; number of memory planes
BitsPerPixel		db	?	; bits per pixel
NumberOfBanks		db	?	; number of banks
MemoryModel	    	db	?	; memory model type
BankSize	    	db	?	; bank size in KB
NumberOfImagePages 	db	?	; number of images
Reserved	    	db	1	; reserved for page function

; Direct Color fields (required for direct/6 and YUV/7 memory models)

RedMaskSize	        db	?   ; size of direct color red mask in bits
RedFieldPosition	db	?   ; bit position of lsb of red mask
GreenMaskSize	    db	?	; size of direct color green mask in bits
GreenFieldPosition	db	?	; bit position of lsb of green mask
BlueMaskSize	    db	?	; size of direct color blue mask in bits
BlueFieldPosition	db	?	; bit position of lsb of blue mask
RsvdMaskSize	    db	?	; size of direct color reserved mask in bits
RsvdFieldPosition	db	?	; bit position of lsb of reserved mask
DirectColorModeInfo db	?	; direct color mode attributes

; Mandatory information for VBE 2.0 and above

PhysBasePtr	        dd	?	; physical address for flat memory frame buffer
OffScreenMemOffset  dd	?	; pointer to start of off screen memory
OffScreenMemSize 	dw	?	; amount of off screen memory in 1k units
Ignore  	        db	206 dup (?)  ; remainder of ModeInfoBlock
ENDS

STRUC	VbeInfoBlock
VbeSignature		db	'VBE2' 	   	; VBE Signature
VbeVersion			dw	0200h	   	; VBE Version
OemStringPtr		dd	?			; Pointer to OEM String
Capabilities		db	4 dup (?)	; Capabilities of graphics controller
VideoModePtr		dd	?			; Pointer to VideoModeList
TotalMemory			dw	?			; Number of 64kb memory blocks
									; Added for VBE 2.0
OemSoftwareRev		dw	?			; VBE implementation Software revision
OemVendorNamePtr	dd	?			; Pointer to Vendor Name String
OemProductNamePtr	dd	?			; Pointer to Product Name String
OemProductRevPtr	dd	?			; Pointer to Product Revision String
Reserved			db	222 dup (?)	; Reserved for VBE implementation scratch
									;   area
OemData				db	256 dup (?)	; Data Area for OEM Strings
ENDS

			DATASEG

INCLUDE	"..\rawx.inc"


; RAWX_PM Selectors and addresses

ZDataSel		DW		?

regs			RMINT	<>

; RAWX_PM globals

_x_VGABuffer	X_BUFFER <>						;VGA Buffer
_x_CurBuffer	X_BUFFER <>						;Current frame buffer

_x_VFVersion	DB		MAJOR_VER,MINOR_VER
; RAWX_PM locals

VBESetWindow	DD		?						;VBE Func 05h
VBEDispStart	DD		?						;VBE Func 07h
VBEPrimPal		DD		?						;VBE Func 09h

; RAWX_PM public data

PUBLIC	_x_CurBuffer, _x_VGABuffer, ZDataSel, _x_VFVersion

		CODESEG

EXTRN	i_gfxinit8_:PROC, i_gfxinit16_:PROC, i_gfxinit32_:PROC


;
; i_getaddr		(internal) calculates offset of pixel
;
;INPUT:	EAX		= X
;		EDX		= Y
;RETURN:EDI		= offset in buffer
;REGS:	EAX EDX CL
;
PUBLIC	i_getaddr
PROC	i_getaddr

; This address calculation is called in all other gfx routines (once..)
; It allows the frame buffer to be of all dimensions, located anywhere
; within the first 4G. Works with all linear video modes.

		mov		edi,eax						;1
		mov  	eax,edx						;1
 		mul		[_x_CurBuffer.XLen]			;13-26, AMD K5: 4-11?
		add		edi,eax						;1
		mov		cl,[_x_CurBuffer.ShiftConst];1
		shl		edi,cl						;3
		add		edi,[_x_CurBuffer.BufferPtr];1
		ret									; = 19-32
ENDP


;
; x_setmode		sets video mode and initializes RAWX structs
;
;INPUT:	EAX		= XRes
;		EDX		= YRes
;		EBX		= BPP
;RETURN:EAX		= 0 : success, VGABuffer, CurBuffer initialized
;				= <0 : errorcode
;REGS:	EBX EDX
;
PUBLIC	x_setmode_
PROC	x_setmode_
		push	ecx edi esi ebp

		shl		edx,16							;Save YRes in upper 16 bits
		mov		dx,ax							; XRes in lower 16 bits

; To support old VGA cards and set text mode, 320x200 mode 13h and and
; mode 3h (text mode) is implemented as 320,200,4 and 80,25, respectively.

; Check for low-res 320x200 failsafe mode (use 320,200,4)

		cmp		bl,8
		jae		@@HiResMode						;If BPP < 8, use INT 10h
		cmp		edx,200*(1 SHL 16) + 320
		je		@@LowRes						;If 320x200, mode 13h
		jne		@@TextMode						;If not 320x200, mode 3h

@@HiResMode:
		push	edx ebx

; Set ES to 00000000h selector

		mov		[ZDataSel],ds
		mov		es,[ZDataSel]

; First off, we check whether the VESA BIOS Extensions 2.0 is present at
; all, if not, we cannot use this approach to set up a linear frame buffer
; in SVGA modes.

; Get Protected Mode interface

@@GetVBEinfo:									;Call VESA BIOS, ask for
		mov		[regs._eax],4F0Ah				;protected mode extensions
		mov		[regs._ebx],0

		mov		ax,0300h
		mov		bx,10h
		mov		cx,10

		mov		edi,OFFSET regs
		int		31h								;Simulate real mode INT

; Got ptr to VBE table, check settings

		movzx	esi,[regs._es]					;Convert to linear address
		shl		esi,4
		mov		ebx,esi
		add		esi,[regs._edi]

		or		esi,esi							;If NULL pointer, VESA 2.0
		jz		@@NoVESA2						; isn' present

		movzx	eax,[WORD esi]
		add		eax,ebx
		mov		[VBESetWindow],eax				;Save PM function SetWindow

		movzx	eax,[WORD esi+2]
		add		eax,ebx
		mov		[VBEDispStart],eax				;PM function SetDisplayStart

		movzx	eax,[WORD esi+6]
		add		eax,ebx
		mov		[VBEPrimPal],eax				;PM function SetPrimaryPalette

; Get VBE info

		mov		ax,0100h
		mov		bx,SIZE VbeInfoBlock/16+ SIZE ModeInfoBlock/16
		int		31h
		jc		@@Error							;Allocate memory for structs
		mov		[DWORD regs._ip],edx			;Save ptr for later freeing

		mov		[regs._eax],4F00h
		mov		[regs._es],ax
		mov		[regs._edi],0
		mov		ax,0300h
		mov		bx,10h
		xor		ecx,ecx
		mov		edi,OFFSET regs
		int		31h								;Ask for VBE Controller info

		movzx	edx,[regs._es]					;Convert to linear address
		shl		edx,4
		movzx	eax,[WORD HIGH edx + VbeInfoBlock.VideoModePtr]
		shl		eax,4
		movzx	esi,[WORD LOW edx + VbeInfoBlock.VideoModePtr]
		add		esi,eax

; ESI now points to a list of supported VESA modes (WORD size entries),
; terminated by 0FFFFh. Since these numbers don't neccessarily mean the
; same resolutions on all video cards, we must ask the VESA BIOS for each
; mode if this mode has our resolution!

; Loop through all supported mode, search for exact match

		add		[regs._es],SIZE VbeInfoBlock/16
		add		edx,SIZE VbeInfoBlock			;Set up loop vars

		pop		ecx ebp							;Pop BPP, YRes SHL 16 + XRes

@@Looper:
		mov		[regs._eax],4F01h				;VBE Mode info

		mov		ax,[esi]						;Loop trough mode list
		add		esi,2
		cmp		ax,-1							;End of mode list,
		je		@@ModeNotFound					; mode not found

		mov		[WORD regs._ecx],ax

		mov		ax,0300h
		mov		bx,10h							;Ask for specifics on current
		int		31h				   				; entry in list

		cmp		[DWORD edx + ModeInfoBlock.XResolution],ebp
		jne		@@Looper						;Check both XRes and YRes
		cmp		[edx + ModeInfoBlock.BitsPerPixel],cl
		jne		@@Looper						;Check bitsper pixel

		test	[edx + ModeInfoBlock.ModeAttributes],1
		jz		@@ModeNotSupported				;Is mode really supported?


; Resolution found, [regs._ecx] now contains the VESA mode for the requested
; resolution. Again, note that this mode number varies from gfx card to gfx
; card! (Some modes are fixed, like 640x480x256, 800x600x256 and some others,
; but not the low-res modes among others).


; Set mode
		push	edx
		mov		ebx,[regs._ecx]
		or		ebx,4000h						;Request linear frame buffer
		mov		ax,4F02h
		int		10h
		pop		edx
		or		ah,ah							;For some reason, the VBE won't
		jnz		@@VESAFail						; cooperate!


; The rest is mostly specific to the RawX implementation. It sets up the
; X_BUFFER struct so that the routines know the resoltion, bit depth, and
; some other misc info (like the base address of the buffer !)

; Find base address

		movzx	ebx,[edx + ModeInfoBlock.XResolution]
		mov		[_x_VGABuffer.XLen],ebx
		mov		[_x_VGABuffer.bXLen],ebx
		movzx	ebx,[edx + ModeInfoBlock.YResolution]
		mov		[_x_VGABuffer.YLen],ebx

		mov		cl,[edx + ModeInfoBlock.BitsPerPixel]
		shr		cl,4
		mov		[_x_VGABuffer.ShiftConst],cl

		shl		[_x_VGABuffer.bXLen],cl

; THIS IS REQUIRED! You have to tell the DPMI host you want to access the
; physical address of the linear frame buffer. The address you access to
; read/write to the frame buffer need not be the (and rarely is) the same
; as the physical address returned by the VESA BIOS. (Read some 386 protected
; mode info, if you're at loss about paging..;-)

; Map up display frame physically

		mov		eax,[edx + ModeInfoBlock.PhysBasePtr]

		xor		di,di
		mov		si,80h							;8MB window

		mov		cx,ax		  					;EAX = PhysBasePtr
		shr		eax,16
		mov		bx,ax
		mov		ax,0800h
		int		31h								;Map 8MB (overkill ??)

		shl		ebx,16
		mov		bx,cx
		mov		[_x_VGABuffer.BufferPtr],ebx	;Save this location for later

; Free allocated memory

		mov		edx,[DWORD regs._ip]
		mov		ax,0101h
		int		31h		   						;Fix up the previous mem alloc
		jc		@@FreeError

@@CommonExit:

		mov		eax,[_x_VGABuffer.bXLen]
		mul		[_x_VGABuffer.YLen]
		mov		[_x_VGABuffer.bSize],eax

		mov		eax,OFFSET _x_VGABuffer
		call	x_setbuffer_					;Sets up x_CurBuffer struct

		pop		ebp esi edi ecx

		call	i_initlibrary_					;Initializes function pointers

		xor		eax,eax
		ret

; Here, the old VGA mode 13h is set. Nothing magic around here.

@@LowRes:
		mov		ax,13h
		int		10h
		mov		[_x_VGABuffer.XLen],320
		mov		[_x_VGABuffer.bXLen],320
		mov		[_x_VGABuffer.YLen],200
		mov		[_x_VGABuffer.ShiftConst],0
		mov		[_x_VGABuffer.BufferPtr],0A0000h
		jmp		@@CommonExit

; Same goes for these lines. They clean up the stack and return.
; Note: You cannot access the text mode screen using this version of
; RawX, since the X_BUFFER structs aren't set up. (You can do this
; manually, if you really want to. You only need to set up the x_CurBuffer
; struct for the graphic routines to work).

@@TextMode:
		pop		ebp esi edi ecx
		mov		ax,3h
		int		10h
		ret

@@FreeError:									; Freeing memory error
		mov		eax,-6
		jmp		@@ErrEndeth

@@Error:										; Memory allocation error
		add		esp,8
		mov		eax,-5
		jmp		@@ErrEndeth

@@ModeNotSupported:		 						; Not supported (from BIOS)
		mov		eax,-4
		jmp		@@ErrEndeth

@@ModeNotFound:									; Mode not found
		mov		eax,-3
		jmp		@@ErrEndeth

@@NoVESA2:			 							; VESA 2.0 BIOS not found
		add		esp,8
		mov		eax,-2
		jmp		@@ErrEndeth

@@VESAFail:				 						; Couldn't switch mode
		mov		eax,-1

@@ErrEndeth:
		pop		ebp esi edi ecx
		ret										; Beam me up, Scotty!
ENDP

;
; x_setvesamode	sets video mode and initializes RAWX structs
;
;INPUT:	EAX		= VESA mode
;RETURN: 	0	= success, VGABuffer, CurBuffer initialized
;			-1	= general error
;			-2	= no/incorrect VESA driver present
;
PUBLIC	x_setvesamode_
PROC	x_setvesamode_
		push	ebx ecx edx edi esi

; Set ES to 00000000h selector

		mov		[ZDataSel],ds
		mov		es,[ZDataSel]

		cmp		ax,100h
		jb		@@LowRes

		push	eax

; Get Protected Mode interface (skip??)

@@GetVBEinfo:
		mov		[regs._eax],4F0Ah
		mov		[regs._ebx],0

		mov		ax,0300h
		mov		bx,10h
		mov		cx,10

		mov		edi,OFFSET regs
		int		31h								;Simulate real mode INT

		; Got ptr to VBE table, check settings

		movzx	esi,[regs._es]
		shl		esi,4
		mov		ebx,esi
		add		esi,[regs._edi]

		or		esi,esi
		jz		@@NoVESA2

		movzx	eax,[WORD esi]
		add		eax,ebx
		mov		[VBESetWindow],eax

		movzx	eax,[WORD es:esi+2]
		add		eax,ebx
		mov		[VBEDispStart],eax

		movzx	eax,[WORD esi+6]
		add		eax,ebx
		mov		[VBEPrimPal],eax

; Set mode

@@SetMode:
		pop		ebx
		mov		cx,bx
		or		bx,4000h						;Request linear frame buffer
		mov		ax,4F02h
		int		10h
		or		ah,ah
		jnz		@@VESAFail

; Find base address

		mov		ax,0100h
		mov		bx,SIZE ModeInfoBlock /16 +1
		int		31h								;Allocate low memory
		jc		@@Error
		mov		[DWORD regs._ip],edx			;Not used anyway..

		mov		[regs._es],ax					;Segment allocated
		mov		[regs._edi],0
		mov		[regs._eax],4F01h
		mov		[WORD regs._ecx],cx				;Mode number
		mov		ax,0300h
		mov		bx,10h
		mov		cx,0
		mov		edi,OFFSET regs
		int		31h								;Ask for mode specifics

		movzx	esi,[regs._es]
		shl		esi,4
		add		esi,[regs._edi]


		movzx	ebx,[esi + ModeInfoBlock.XResolution]
		mov		[_x_VGABuffer.XLen],ebx
		mov		[_x_VGABuffer.bXLen],ebx
		movzx	ebx,[esi + ModeInfoBlock.YResolution]
		mov		[_x_VGABuffer.YLen],ebx

		mov		cl,[esi + ModeInfoBlock.BitsPerPixel]
		shr		cl,4
		mov		[_x_VGABuffer.ShiftConst],cl
		shl		[_x_VGABuffer.bXLen],cl


; Map up display frame physically

		mov		eax,[es:esi + ModeInfoBlock.PhysBasePtr]

		xor		di,di
		mov		si,80h							;8MB window

		mov		cx,ax		  					;EAX = PhysBasePtr
		shr		eax,16
		mov		bx,ax
		mov		ax,0800h
		int		31h								;Map mem

		shl		ebx,16
		mov		bx,cx
		mov		[_x_VGABuffer.BufferPtr],ebx

		mov		edx,[DWORD regs._ip]
		mov		ax,0101h
		int		31h
		jc		@@FreeError

@@CommonExit:

		mov		eax,[_x_VGABuffer.bXLen]
		mul		[_x_VGABuffer.YLen]
		mov		[_x_VGABuffer.bSize],eax

		mov		eax,OFFSET _x_VGABuffer
		call	x_setbuffer_

; Free allocated memory

		call	i_initlibrary_

		xor		eax,eax
		jmp		@@ErrEndeth

@@LowRes:
		int		10h
		mov		[_x_VGABuffer.XLen],320
		mov		[_x_VGABuffer.bXLen],320
		mov		[_x_VGABuffer.YLen],200
		mov		[_x_VGABuffer.BufferPtr],0A0000h
		jmp		@@CommonExit

@@FreeError:									; Memory error
		mov		eax,-6
		jmp		@@ErrEndeth

@@Error:										; Memory error
		add		esp,8
		mov		eax,-5
		jmp		@@ErrEndeth

@@NoVESA2:										; No VESA 2.0 BIOS
		add		esp,8
		mov		eax,-2
		jmp		@@ErrEndeth

@@VESAFail:										; Couldn't switch mode
		mov		eax,-1

@@ErrEndeth:
		pop		esi edi edx ecx ebx
		ret

ENDP

;
; x_wait4vrt	Waits for vertical retrace, then returns
;
;INPUT:	None
;OUTPUT:None
;
PUBLIC	x_wait4vrt_
PROC	x_wait4vrt_
		push	eax edx
        mov     dx,3DAh
@@NoVRT:in      al,dx                           ;Wait for VRT to stop
        test    al,8
        jnz    	@@NoVRT
@@VRT:  in      al,dx                           ;Wait for VRT to start
        test    al,8
        jz     	@@VRT
        pop		edx eax
        ret
ENDP

;
; x_setbuffer Switches active framebuffer
;
;INPUT:	EAX		= ptr to new X_BUFFER struct
;RETURN:None
;
PUBLIC	x_setbuffer_
PROC	x_setbuffer_
		push	ecx edi esi
		mov		esi,eax
		mov		edi,OFFSET _x_CurBuffer
		mov		ecx,SIZE X_BUFFER /4
		rep movsd
		pop		esi edi ecx
		ret
ENDP


;
; x_setdispstart Sets x,y position of top left pixel in frame buffer
;
;INPUT:	EAX		= dispx
;		EDX		= dispy
;REGS:	EDX
;
PUBLIC	x_setdispstart_
PROC	x_setdispstart_
		push	ebx ecx

; The VESA BIOS has support for hardware scrolling, by calling INT 10h
; with AX=4707h, like this:

		mov		ecx,eax
		mov		ax,4F07h
		mov		bx,0080h
		int		10h

; Note, for some reason, horizontal scrolling is sometimes performed 8
; pixels at a time, disallowing smooth scrolling. I suppose there is a
; way around this, but I haven't found it. If you know, tell me ;-)

		pop		ecx ebx
		ret
ENDP

;
; x_setscanlinelen	Sets screen size
;
;INPUT:	EAX		= width in pixels
;		EDX		= height in pixels
;REGS:	EDX
;
PUBLIC	x_setscanlinelen_
PROC	x_setscanlinelen_
		push	ebx ecx

; You can make the frame buffer larger than the actual screen by using this
; VESA call. Note that the current contents on screen are skewed as soon as
; you mess with these settings, so you'll have to redraw the screen after-
; wards.

		mov		[_x_VGABuffer.XLen],eax
		mov		cl,[_x_VGABuffer.ShiftConst]
		shl		eax,cl
		mov		[_x_VGABuffer.bXLen],eax
		mov		[_x_VGABuffer.YLen],edx

		mov		ecx,eax
		mov		ax,4F06h
		xor		bl,bl
		int		10h

		pop		ecx ebx
		ret
ENDP

;
; i_initlibrary	Sets up the correct functions for current bit-depth
;
;INPUT:	None
;
PROC	i_initlibrary_

		cmp		[_x_CurBuffer.ShiftConst],1
		je		@@16Bit
		ja		@@32Bit

; To allow transparent run-time switching between bit-depths, I compile
; three versions of each routine, and fix the function pointers to these
; during each call to x_set(vesa)mode. This way, the application using
; RawX doens't bother about the currently set mode when calling the
; gfx routines.

		call	i_gfxinit8_
		ret
@@16Bit:
		call	i_gfxinit16_
		ret
@@32Bit:
		call	i_gfxinit32_
		ret
ENDP

		END

;
; INTERNAL NOTES:
;
; General:

; Next problem:
;

; Current problem:
;  - set dispstarts jumps 8 pixels in horiz dir.

; Current sticking point:
;  - prob. fix the mode info struct for current mode
