#include <stdio.h>
#include <stdlib.h>

#include <pr.h>
#include <prgui.h>

/*

       /=========\ /========\ ||        || /========  /=======\
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||   ||   || ||         ||      //
       |=========/ ||      || ||   ||   || |=======   |=====<<
       ||          ||      || ||   ||   || ||         ||      \\
       ||          ||      || ||   ||   || ||         ||       ||
       ||          ||      || ||   ||   || ||         ||       ||
       ||          \========/ \==========/ \========= ||       ||

--------------------------------<===>----------------------------------

    /=======\   /========= |\     || |======\  /========= /=======\
    ||      ||  ||         ||\    || ||    \ \ ||         ||      ||
    ||      ||  ||         || \   || ||     || ||         ||      ||
    ||      ||  ||         ||  \  || ||     || ||         ||      ||
    ||      //  ||         ||   \ || ||     || ||         ||      //
    |======<<   |======    ||\   \|| ||     || |======    |======<<
    ||      \\  ||         || \   || ||     || ||         ||      \\
    ||       || ||         ||  \  || ||     || ||         ||       ||
    ||       || ||         ||   \ || ||    / / ||         ||       ||
    ||       || |========= ||    \|| |======/  |========= ||       ||

Sprite File Mip Map Creation

Takes a sprite file and creates mip map for the first n sprites

 Revision History:
 August 19, 1996: Created

*/

#define MAXSPRITE 3999

PR_DWORD spread;
block sprites[MAXSPRITE+1];
color pal[256];

void main (int argc, char *argv[])
{
PR_DWORD i;

  PRGUI_InitPath (argv[0]);

  printf ("SPRMIP Utility    version 2.3\n");
  printf ("Copyright 1997 Egerter Software\n\n");

  if (argc < 2)
    {
     printf ("Usage: \n"
             "SPRMIP filename.spr\n");
     exit (1);
    }

  printf ("\nHow many sprites are there between each mip map set?\n");
  scanf ("%i", &spread);

  vga256 ();

  wloadsprites (pal, argv[1], sprites, 0, MAXSPRITE);

  for (i = 0; i < spread; i++)
    {
     if (sprites[i + spread] != NULL)
       wfreeblock (sprites[i + spread]);
     sprites[i + spread] = PR_MipMapCreate (sprites[i], 1, MIPMAP_AVERAGE, pal);

     if (sprites[i + spread*2] != NULL)
       wfreeblock (sprites[i + spread*2]);
     sprites[i + spread*2] = PR_MipMapCreate (sprites[i], 2, MIPMAP_AVERAGE, pal);

     if (sprites[i + spread*3] != NULL)
       wfreeblock (sprites[i + spread*3]);
     sprites[i + spread*3] = PR_MipMapCreate (sprites[i], 3, MIPMAP_AVERAGE, pal);
    
     if (sprites[i + spread] != NULL)
       wfreeblock (sprites[i + spread*4]);
     sprites[i + spread*4] = PR_MipMapCreate (sprites[i], 4, MIPMAP_AVERAGE, pal);
    }

  wsavesprites (pal, argv[1], sprites, 0, spread * 5);
  wfreesprites (sprites, 0, MAXSPRITE);
  wsetmode (3);
  printf ("Sprites saved to %s\n", argv[1]);
}



