#include <stdlib.h>
#include <malloc.h>
#include <string.h>

#include <wgtscrol.h>
#include <pr.h>
#include <prgui.h>

/*

       /=========\ /========\ ||        || /========  /=======\
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||   ||   || ||         ||      //
       |=========/ ||      || ||   ||   || |=======   |=====<<
       ||          ||      || ||   ||   || ||         ||      \\
       ||          ||      || ||   ||   || ||         ||       ||
       ||          ||      || ||   ||   || ||         ||       ||
       ||          \========/ \==========/ \========= ||       ||

--------------------------------<===>----------------------------------

    /=======\   /========= |\     || |======\  /========= /=======\
    ||      ||  ||         ||\    || ||    \ \ ||         ||      ||
    ||      ||  ||         || \   || ||     || ||         ||      ||
    ||      ||  ||         ||  \  || ||     || ||         ||      ||
    ||      //  ||         ||   \ || ||     || ||         ||      //
    |======<<   |======    ||\   \|| ||     || |======    |======<<
    ||      \\  ||         || \   || ||     || ||         ||      \\
    ||       || ||         ||  \  || ||     || ||         ||       ||
    ||       || ||         ||   \ || ||    / / ||         ||       ||
    ||       || |========= ||    \|| |======/  |========= ||       ||

PIC to WMP Utility

Converts a bitmap to a WGT map file.

 Revision History:
 Aug. 13, 1996: Created

*/

block    pic;                      /* Input picture */
color    palette[256];             /* A dummy palette */
PR_DWORD size;
PR_DWORD width, height;
wgtmap   map;
short    tiletypes[256];
scrollsprite wobjects[10];

void main (int argc, char *argv[])
{
PR_DWORD x, y;

  PRGUI_InitPath (argv[0]);

  printf ("PIC2WMP Utility    version 2.2\n");
  printf ("Copyright 1997 Egerter Software\n\n");

  if (argc < 3)
    {
     printf ("Usage: \n"
             "PIC2WMP filename.pcx filename.wmp\n");
     exit (1);
    }

  pic = wloadpcx (argv[1], palette);
  if (pic == NULL)
    {
     printf ("An error has occurred when loading the %s file.\n", argv[1]);
     exit (1);
    }

  width = wgetblockwidth (pic);
  height = wgetblockheight (pic);
  size = width * height * 2;
  map = (wgtmap)malloc (size);  

  pic += 4;             /* Skip over width and height */

  /* Let C do the conversion from byte to word */
  for (y = 0; y < height; y++)
    for (x = 0; x < width; x++)
      map[y * width + x] = pic[y * width + x];


  /* Set up the internal map dimensions */
  mapwidth[0] = width;
  mapheight[0] = height;
  wsavemap (0, argv[2], map, tiletypes, wobjects, 1);
  printf ("%s saved\n", argv[2]);
}



