#include <stdio.h>
#include <stdlib.h>
#include <direct.h>
#include <conio.h>
#include <mem.h>
#include <ctype.h>

#include <pr.h>
#include <prgui.h>

/*

       /=========\ /========\ ||        || /========  /=======\
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||   ||   || ||         ||      //
       |=========/ ||      || ||   ||   || |=======   |=====<<
       ||          ||      || ||   ||   || ||         ||      \\
       ||          ||      || ||   ||   || ||         ||       ||
       ||          ||      || ||   ||   || ||         ||       ||
       ||          \========/ \==========/ \========= ||       ||

--------------------------------<===>----------------------------------

    /=======\   /========= |\     || |======\  /========= /=======\
    ||      ||  ||         ||\    || ||    \ \ ||         ||      ||
    ||      ||  ||         || \   || ||     || ||         ||      ||
    ||      ||  ||         ||  \  || ||     || ||         ||      ||
    ||      //  ||         ||   \ || ||     || ||         ||      //
    |======<<   |======    ||\   \|| ||     || |======    |======<<
    ||      \\  ||         || \   || ||     || ||         ||      \\
    ||       || ||         ||  \  || ||     || ||         ||       ||
    ||       || ||         ||   \ || ||    / / ||         ||       ||
    ||       || |========= ||    \|| |======/  |========= ||       ||

Shade Table Generator

*/



color pal[256];
PR_DWORD numshades;
PR_DWORD type;
block texture;
PR_DWORD i;
PR_REAL light1, light2;
PR_REAL shine, spec;
PR_REAL startrange, endrange;
PR_TABLE *table;
PR_REAL r,g,b;
PR_REAL r2,g2,b2;


void main (int argc, char *argv[])
{

  printf ("MAKETAB Utility    version 2.3\n");
  printf ("Copyright 1997 Egerter Software\n\n");

  if (argc < 2)
    {
     printf ("Usage: maketab texture.[IMG] table.dat\n");
     exit (1);
    }

  /* Check for legal image types */
  type = PR_GetImageType (argv[1]);
  if (type == IMAGE_UNKNOWN)
    {
     printf ("Unknown Image Format: %s\n", argv[1]);
     exit (1);
    }

  if (PRGUI_FileExists (argv[2]))
    {
     printf ("%s already exists! Overwrite? (Y/N)\n",
            argv[2]);
     do {
       type = toupper (getch ());
     } while (type != 'N' && type != 'Y');

     if (type == 'N')
       exit (1);
    }

  PR_DetectVGA();
  PR_InitializeVGA ();

  PR_AllocTextures (1);

  printf ("Number of shades:");
  scanf ("%i", &numshades);

  printf ("\nType:\n"
          "1: Gouraud\n"
          "2: Phong\n"
          "3: Translucent\n"
          "4: Fog\n");

  scanf ("%i", &type);

  if (type == 1)
    {
     printf ("\nStart Range (0):");
     scanf ("%f", &startrange);
     printf ("\nEnd Range (1):");
     scanf ("%f", &endrange);
    }
  if (type == 2)
    {
     printf ("\nSpecular Amount: ");
     scanf ("%f", &spec);
     printf ("\nShine:");
     scanf ("%f", &shine);
    }
  else if (type == 3)
    {
     printf ("\nPercentage of foreground: (0.0-1.0)");
     scanf ("%f", &light1);
     printf ("\nPercentage of background: (0.0-1.0)");
     scanf ("%f", &light2);
    }
  else if (type == 4)
    {
     printf ("\nStart Red (0-63):");
     scanf ("%f", &r);
     printf ("\nStart Green (0-63):");
     scanf ("%f", &g);
     printf ("\nStart Blue (0-63):");
     scanf ("%f", &b);
     printf ("\nEnd Red (0-63):");
     scanf ("%f", &r2);
     printf ("\nEnd Green (0-63):");
     scanf ("%f", &g2);
     printf ("\nEnd Blue (0-63):");
     scanf ("%f", &b2);
    }

  vga256 ();
  PR_Settings.LoadPalette = 1;
  PR_LoadTexture (argv[1]);
  texture = PR_WorldTextures[0].image;
  wsetpalette (0, 255, global_palette);
  wreadpalette (0, 255, pal);
  wputblock (0, 0, texture, 0);

  PR_AllocShadeTables (1);
 
  if (type == 1)
    table = PR_BuildGouraudTable (numshades, pal, startrange, endrange);
  else if (type == 2)
    table = PR_BuildPhongTable (numshades, pal, shine, spec);
  else if (type == 3)
    table = PR_BuildTranslucentTable (pal, light1, light2);
  else if (type == 4)
    table = PR_BuildFogTable (numshades, pal, r, g, b, r2, g2, b2);

 
  PR_SaveTable (argv[2], table);

  for (i = 0; i < numshades; i++)
     memcpy (abuf+i*320, table->table + i * 256, 256);
  getch ();
  wsetmode (3);
}
