#include <stdlib.h>
#include <stdio.h>

#include <conio.h>

#include <pr.h>
#include <prgui.h>

#ifdef MSGLIDE
#include <pr3dfx.h>
#include <windows.h>
#endif


/*

       /=========\ /========\ ||        || /========  /=======\
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||   ||   || ||         ||      //
       |=========/ ||      || ||   ||   || |=======   |=====<<
       ||          ||      || ||   ||   || ||         ||      \\
       ||          ||      || ||   ||   || ||         ||       ||
       ||          ||      || ||   ||   || ||         ||       ||
       ||          \========/ \==========/ \========= ||       ||

--------------------------------<===>----------------------------------

    /=======\   /========= |\     || |======\  /========= /=======\
    ||      ||  ||         ||\    || ||    \ \ ||         ||      ||
    ||      ||  ||         || \   || ||     || ||         ||      ||
    ||      ||  ||         ||  \  || ||     || ||         ||      ||
    ||      //  ||         ||   \ || ||     || ||         ||      //
    |======<<   |======    ||\   \|| ||     || |======    |======<<
    ||      \\  ||         || \   || ||     || ||         ||      \\
    ||       || ||         ||  \  || ||     || ||         ||       ||
    ||       || ||         ||   \ || ||    / / ||         ||       ||
    ||       || |========= ||    \|| |======/  |========= ||       ||

Save Mesh Utility

Saves the vertices from a PRO file without texture information.

 Revision History:
 Aug 6, 1996: Created

*/

char outfile[80];               /* Name of the output file */
PR_OBJECT *object1;

void PR_LoadMesh (PR_OBJECT *obj, char *filename)
{
FILE *mesh;
PR_DWORD segnum;
PR_SEGMENT *seg;
PR_DWORD numverts;
PR_DWORD numsegs;

  mesh = fopen (filename, "rb");
  if (mesh == NULL)
    {
     printf ("Could not open %s\n", filename);
     exit (1);
    }

  fread (&numsegs, sizeof (PR_DWORD), 1, mesh);
  if (numsegs != obj->num_segments)
    {
     printf ("The number of segments in the mesh does not equal the"
             "number of segments in the PRO file.  Aborting...\n");
     exit (1);
    }

  for (segnum = 0; segnum < obj->num_segments; segnum++)
    {
     seg = obj->segment_list;
     fread (&numverts, sizeof (PR_DWORD), 1, mesh);
     if (numverts != seg->num_vertices)
       {
        printf ("The number of vertices in segment #%i does not equal the"
                "number of vertices in the PRO file.  Skipping...\n", segnum);
        fseek (mesh, numverts * sizeof (PR_VERTEX), SEEK_CUR);
       }
     else
       {
        fread (seg->vertex_list, sizeof (PR_VERTEX) * seg->num_vertices, 1, mesh);
       }
    }

  fclose (mesh);
}



void main (int argc, char *argv[])
{
  PRGUI_InitPath (argv[0]);

  if (argc < 3)
    {
	 PR_FatalError (
		"LOADMESH Utility    version 2.3\n"
		"Copyright 1997 Egerter Software\n\n"
		"Usage: \n"
        "LOADMESH filename.PRO mesh.PRM\n", "LOADMESH");
    }

  printf ("LOADMESH Utility    version 2.3\n");
  printf ("Copyright 1997 Egerter Software\n\n");

#ifdef MSGLIDE
  PR_Detect3Dfx();
  PR_Initialize3Dfx ();
#else
  PR_DetectVGA();
  PR_InitializeVGA ();
#endif

  PR_AllocMaterials (512);
  PR_AllocTextures (255);
  PR_AllocShadeTables (32);

  object1 = PR_LoadPRO (argv[1], LOAD_NORMAL);
  if (object1 == NULL)
    PR_FatalError ("An error has occurred when loading the file.\n", "LOADMESH");
    

  PR_LoadMesh (object1, argv[2]);
  printf ("%s now has mesh from %s", argv[1], argv[2]);

  PR_SavePRO (argv[1], object1, SAVE_ALL_MATERIALS);
}



