#include <stdlib.h>
#include <direct.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>

#include <pr.h>
#include <prgui.h>

#ifdef MSGLIDE
#include <pr3dfx.h>
#include <windows.h>
#endif

/*

       /=========\ /========\ ||        || /========  /=======\
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||   ||   || ||         ||      //
       |=========/ ||      || ||   ||   || |=======   |=====<<
       ||          ||      || ||   ||   || ||         ||      \\
       ||          ||      || ||   ||   || ||         ||       ||
       ||          ||      || ||   ||   || ||         ||       ||
       ||          \========/ \==========/ \========= ||       ||

--------------------------------<===>----------------------------------

    /=======\   /========= |\     || |======\  /========= /=======\
    ||      ||  ||         ||\    || ||    \ \ ||         ||      ||
    ||      ||  ||         || \   || ||     || ||         ||      ||
    ||      ||  ||         ||  \  || ||     || ||         ||      ||
    ||      //  ||         ||   \ || ||     || ||         ||      //
    |======<<   |======    ||\   \|| ||     || |======    |======<<
    ||      \\  ||         || \   || ||     || ||         ||      \\
    ||       || ||         ||  \  || ||     || ||         ||       ||
    ||       || ||         ||   \ || ||    / / ||         ||       ||
    ||       || |========= ||    \|| |======/  |========= ||       ||

Join PRO Utility

Combines the objects from two PRO files into one file.

 Revision History:
 July 18, 1996: Created

*/

char outfile[80];               /* Name of the output file */
PR_OBJECT *object1;
PR_OBJECT *object2;
PR_OBJECT *object3;             /* Output object */
PR_DWORD choice;

void main (int argc, char *argv[])
{
PR_SEGMENT *seg;
int i;

  PRGUI_InitPath (argv[0]);

  printf ("JOINPRO Utility    version 2.3\n");
  printf ("Copyright 1997 Egerter Software\n\n");

  if (argc < 3)
    {
     printf ("Usage: \n"
             "JOINPRO file1.PRO file2.PRO outfile.PRO\n");
	 
     #ifdef WIN32
	 PR_FatalError ("Usage: \n"
                    "JOINPRO file1.PRO file2.PRO outfile.PRO\n",
					"JoinPRO");
	 #endif
     exit (1);
    }

  if (PRGUI_FileExists (argv[3]))
    {
     #ifdef WIN32
     if (MessageBox(NULL, "The file already exists! Overwrite?\n",
                 "JoinPRO", MB_OKCANCEL) != IDOK)
		exit (1);
	 #else

     printf ("%s already exists! Overwrite? (Y/N)\n",
            argv[3]);
     do {
       choice = toupper (getch ());
     } while (choice != 'N' && choice != 'Y');

     if (choice == 'N')
       exit (1);
	 #endif
    }

#ifdef MSGLIDE
  PR_Detect3Dfx();
  PR_Initialize3Dfx ();
#else
  PR_DetectVGA();
  PR_InitializeVGA ();
#endif


  PR_AllocMaterials (512);
  PR_AllocTextures (255);
  PR_AllocShadeTables (32);

  object1 = PR_LoadPRO (argv[1], LOAD_NORMAL);
  if (object1 == NULL)
    PR_FatalError ("An error has occurred when loading the first file.", "JoinPRO");

  object2 = PR_LoadPRO (argv[2], LOAD_NORMAL);
  if (object2 == NULL)
    PR_FatalError ("An error has occurred when loading the second file.", "JoinPRO");
    

  object3 = PR_AllocObject ();
  if (object3 == NULL)
    PR_FatalError ("An error has occurred when allocating the combined object.", "JoinPRO");
    
  /* Make a copy of the first object's name */
  object3->name = strdup (object1->name);

  object3->segment_list = (PR_SEGMENT *)calloc(object1->num_segments +
                           object2->num_segments, sizeof (PR_SEGMENT));
  object3->num_segments = object1->num_segments + object2->num_segments;
  /* Allocate space for the segment structures */

  /* Copy the segments from the first object */
  seg = object3->segment_list;
  for (i = 0; i < object1->num_segments; i++)
    {
     memcpy (seg, &object1->segment_list[i], sizeof (PR_SEGMENT));
     seg->segment_number = i;
     seg++;
    }

  /* Copy the segments from the second object */
  for (i = 0; i < object2->num_segments; i++)
    {
     memcpy (seg, &object2->segment_list[i], sizeof (PR_SEGMENT));
     seg->segment_number = i + object1->num_segments;
     seg++;
    }

   
  PR_SavePRO (argv[3], object3, SAVE_ALL_MATERIALS);
}



