# Power Render Global Make Options

# version can be either RETAIL or DEBUG
version = RETAIL

# hardware can be one of NONE, 3DFX
hardware = 3DFX

# glide release can be one of GLIDE21, GLIDE23
# Higher versions of Glide will probably work with glide23 as well.
glide_rel = GLIDE23


# Change these to match the directories where you installed the software
# Glide directories are only needed if hardware is 3DFX.
INSTALL_DIR = d:\pr
! ifeq glide_rel GLIDE21
GLIDE21_DIR   = E:\glide2
! else ifeq glide_rel GLIDE23
GLIDE23_DIR   = D:\glide23
!endif


msg_RETAIL = Linking retail version...
msg_DEBUG  = Linking debug version...

CC       = wcc386
ASM      = wasm
LIBEXE   = wlib


!ifeq version DEBUG
!  ifeq hardware NONE

INC    = -I$(INSTALL_DIR)\include
CFLAGS = -d2 -5r -fp5 -w4 -zp1 $(INC)
LIBS   = $(EXTRALIBS) $(INSTALL_DIR)\lib\*.lib, wgt5_wc.lib

!  else ifeq hardware 3DFX

!    ifeq glide_rel GLIDE21
INC    = -I$(INSTALL_DIR)\include -I$(GLIDE21_DIR)\dos\include
CFLAGS = -d2 -5r -fp5 -zp1 $(INC) -D__3DFX__ -D__DOS32__ -DGLIDE_HARDWARE
GLIDE_LIBDIR = $(GLIDE21_DIR)\dos\lib\watreg
LIBS   = $(EXTRALIBS) $(INSTALL_DIR)\lib\*.lib, wgt5_wc.lib, &
         $(GLIDE_LIBDIR)\glide.lib, $(GLIDE_LIBDIR)\sst1init.lib, &
         $(GLIDE_LIBDIR)\texus.lib
! else ifeq glide_rel GLIDE23
INC    = -I$(INSTALL_DIR)\include -I$(GLIDE23_DIR)\glide\src\sst1\include
CFLAGS = -d2 -5r -fp5 -zp1 $(INC) -D__3DFX__ -D__DOS32__ -DGLIDE_HARDWARE &
         -D__GLIDE23__
GLIDE_LIBDIR = $(GLIDE23_DIR)\glide\lib\dos\register
LIBS   = $(EXTRALIBS) $(INSTALL_DIR)\lib\*.lib, wgt5_wc.lib, &
         $(GLIDE_LIBDIR)\glide2x.lib, $(GLIDE_LIBDIR)\texus.lib
!    endif

!  endif
!else ifeq version RETAIL
!  ifeq hardware NONE
INC    = -I$(INSTALL_DIR)\include
CFLAGS = -oneatx -5r -fp5 -w4 -zm -zp1 $(INC)
LIBS   = $(EXTRALIBS) $(INSTALL_DIR)\lib\*.lib, wgt5_wc.lib
!  else ifeq hardware 3DFX

!    ifeq glide_rel GLIDE21
INC    = -I$(INSTALL_DIR)\include -I$(GLIDE21_DIR)\dos\include
CFLAGS = -oneatx -5r -fp5 -w4 -zm -zp1 $(INC) -D__3DFX__ -D__DOS32__ &
         -DGLIDE_HARDWARE
GLIDE_LIBDIR = $(GLIDE21_DIR)\dos\lib\watreg
LIBS   = $(EXTRALIBS) $(INSTALL_DIR)\lib\*.lib, wgt5_wc.lib, &
         $(GLIDE_LIBDIR)\glide.lib, $(GLIDE_LIBDIR)\sst1init.lib, &
         $(GLIDE_LIBDIR)\texus.lib

! else ifeq glide_rel GLIDE23
INC    = -I$(INSTALL_DIR)\include -I$(GLIDE23_DIR)\glide\src\sst1\include
CFLAGS = -oneatx -5r -fp5 -w4 -zm -zp1 $(INC) -D__3DFX__ -D__DOS32__ &
         -DGLIDE_HARDWARE -D__GLIDE23__
GLIDE_LIBDIR = $(GLIDE23_DIR)\glide\lib\dos\register
LIBS   = $(EXTRALIBS) $(INSTALL_DIR)\lib\*.lib, wgt5_wc.lib, &
         $(GLIDE_LIBDIR)\glide2x.lib, $(GLIDE_LIBDIR)\texus.lib
!    endif

!  endif
!endif

.EXTENSIONS:
.EXTENSIONS:.exe 
.EXTENSIONS:.obj 
.EXTENSIONS:.c .asm .h

OBJS    =  $(EXENAME).obj

.SILENT

project :  $(EXENAME).exe

.c.obj:
        *$(CC) $(CFLAGS) $[* 
.asm.obj:
        $(ASM) $[*.asm


$(EXENAME).exe : $(OBJS)
             echo $(msg_$(version))

 @%write  $(EXENAME).LK1 NAME $(EXENAME)

!ifeq version DEBUG
 @%append $(EXENAME).LK1 DEBUG ALL
!else ifeq version RETAIL
 @%append $(EXENAME).LK1 OPTION ELIMINATE
!endif

 @%append $(EXENAME).LK1 FIL $(EXENAME).OBJ
 @%append $(EXENAME).LK1 LIBR $(LIBS)
 *wlink SYS dos4g @$(EXENAME).LK1

