#ifndef _WGTSVGA_
#define _WGTSVGA_

#include <wgt5.h>

#ifdef __cplusplus
 extern "C" {
#endif

/* Defines */
#define VESA_1 1
#define VESA_2 2

#define SVGA_FRONTBUFFER 0
#define SVGA_BACKBUFFER 1


/* VESA 1.2 video modes */
#define V640x350       0x11c            /* Mode     is 640x350x256 */
#define V640x400       0x100            /* Mode 256 is 640x400x256 */
#define V640x480       0x101            /* Mode 257 is 640x480x256 */
#define V800x600       0x103            /* Mode 259 is 800x600x256 */
#define V1024x768      0x105            /* Mode 261 is 1024x768x256 */
#define V1280x1024     0x107            /* Mode 263 is 1280x1024x256 */
#define V1600x1200     0x124            /* Mode     is 1600x1200x256 */

typedef struct {
    long EDI; 
    long ESI; 
    long EBP; 
    long reserved_by_system; 
    long EBX; 
    long EDX; 
    long ECX; 
    long EAX; 
    short flags; 
    short ES,DS,FS,GS,IP,CS,SP,SS; 
} rminfo;
extern rminfo RMI;



/* Structures */
/* SuperVGA information block */
typedef struct {
    char    VESASignature[4];       /* 'VESA' 4 byte signature          */
    short   VESAVersion;            /* VBE version number               */
    long    OemStringPtr;           /* Pointer to OEM string            */
    long    Capabilities;           /* Capabilities of video card       */
    long    VideoModePtr;           /* Pointer to supported modes       */
    short   TotalMemory;            /* Number of 64kb memory blocks     */

    /* VBE 2.0 extensions */
    short   OemSoftwareRev;         /* OEM Software revision number     */
    long    OemVendorNamePtr;       /* Pointer to Vendor Name string    */
    long    OemProductNamePtr;      /* Pointer to Product Name string   */
    long    OemProductRevPtr;       /* Pointer to Product Revision str  */
    char    reserved[222];          /* Pad to 256 byte block size       */
    char    OemDATA[256];           /* Scratch pad for OEM data         */
    } SVGAInfoBlock;

/* SuperVGA mode information block */
typedef struct {
    short   ModeAttributes;         /* Mode attributes                  */
    char    WinAAttributes;         /* Window A attributes              */
    char    WinBAttributes;         /* Window B attributes              */
    short   WinGranularity;         /* Window granularity in k          */
    short   WinSize;                /* Window size in k                 */
    short   WinASegment;            /* Window A segment                 */
    short   WinBSegment;            /* Window B segment                 */
    long    WinFuncPtr;             /* Pointer to window function       */
    short   BytesPerScanLine;       /* Bytes per scanline               */
    short   XResolution;            /* Horizontal resolution            */
    short   YResolution;            /* Vertical resolution              */
    char    XCharSize;              /* Character cell width             */
    char    YCharSize;              /* Character cell height            */
    char    NumberOfPlanes;         /* Number of memory planes          */
    char    BitsPerPixel;           /* Bits per pixel                   */
    char    NumberOfBanks;          /* Number of CGA style banks        */
    char    MemoryModel;            /* Memory model type                */
    char    BankSize;               /* Size of CGA style banks          */
    char    NumberOfImagePages;     /* Number of images pages           */
    char    res1;                   /* Reserved                         */
    char    RedMaskSize;            /* Size of direct color red mask    */
    char    RedFieldPosition;       /* Bit posn of lsb of red mask      */
    char    GreenMaskSize;          /* Size of direct color green mask  */
    char    GreenFieldPosition;     /* Bit posn of lsb of green mask    */
    char    BlueMaskSize;           /* Size of direct color blue mask   */
    char    BlueFieldPosition;      /* Bit posn of lsb of blue mask     */
    char    RsvdMaskSize;           /* Size of direct color res mask    */
    char    RsvdFieldPosition;      /* Bit posn of lsb of res mask      */
    char    DirectColorModeInfo;    /* Direct color mode attributes     */

    /* VBE 2.0 extensions */
    long    PhysBasePtr;            /* Physical address for linear buf  */
    long    OffScreenMemOffset;     /* Pointer to start of offscreen mem*/
    short   OffScreenMemSize;       /* Amount of offscreen mem in 1K's  */
    char    res2[206];              /* Pad to 256 byte block size       */
    } SVGAModeInfoBlock;


typedef struct {
  int mode_number;
  int width;
  int height;

  unsigned char bits;
  unsigned char linear;
  unsigned char available;
  unsigned char pages;
 } MODE_DESC;

/* Global variables */
extern SVGAInfoBlock SVGA;        /* VESA structure is declared as global */
extern SVGAModeInfoBlock SVGAmodeinfo;  /* Same with the mode info structure */ 
extern int VESAbanksize;        /* Size of bank in bytes */ 
extern int current_bank;

extern unsigned char *LFBptr;   /* Linear frame buffer pointer */
extern int VESAphysicalpage;    /* Current viewing page number */
extern int VESAlogicalpage;     /* Current writing page number */
extern int wvesa_version;       /* VESA_1 or VESA_2 set on detect */
extern short VGAseg, VGAselector, VESAseg, VESAselector; 

extern MODE_DESC VESAmodes[256];

/* Old Vesa 1.2 commands */

short wvesa12_bank (short bank);
/* -----------------------------------------------------------------------
   Function:   wvesa12_bank
   Purpose:    Performs a SVGA bank switch
   Parameters: bank - Bank number to use
   Return:     1 if successful, 0 failed
   ----------------------------------------------------------------------- */

void wvesa12_copyscreen(short sx, short sy, short sx2, short sy2, block src,
                        short dx, short dy, short mode);
void wvesa12_bar (short x, short y, short x2, short y2);
short wvesa12_getpixel (short x, short y);
void wvesa12_hline (short x, short x2, short y);
void wvesa12_line (short x, short y, short x2, short y2);
block wvesa12_newblock (short sx, short sy, short sx2, short sy2);
short wvesa12_outchar (short asc, short xc, short yc, wgtfont font);
void wvesa12_outtextxy (short x, short y, wgtfont fnt, char *printit);
void wvesa12_putpixel (short x, short y);



/* VESA 2.0 and VESA 1.2 commands */

void wvesa_bar (int x, int y, int x2, int y2);
/* -----------------------------------------------------------------------
   Function:   wvesa_bar
   Purpose:    Draws a solid rectangle
   Parameters: x,y,x2,y2 - Rectangular region to fill
   Return:     None
   ----------------------------------------------------------------------- */


void wvesa_clip (int x, int y, int x2, int y2);
/* -----------------------------------------------------------------------
   Function:   wvesa_clip
   Purpose:    Sets the clipping region
   Parameters: x,y,x2,y2 - Rectangular clipping region
   Return:     None
   ----------------------------------------------------------------------- */


void wvesa_cls (short color);
/* -----------------------------------------------------------------------
   Function:   wvesa_cls
   Purpose:    Clears the entire screen
   Parameters: color - Color index
   Return:     None
   ----------------------------------------------------------------------- */


void wvesa_copyscreen (int x0, int y0, int x1, int y1, block src, 
                       int dx, int dy);
/* -----------------------------------------------------------------------
   Function:   wvesa_copyscreen
   Purpose:    Copies a section of the source block to the current screen.
   Parameters: x0,y0,x1,y1 - Rectangular region of source
               src - Pointer to the source block
               dx,dy - Top left corner of destination
   Return:     None
   ----------------------------------------------------------------------- */


int wvesa_detect (void);
/* -----------------------------------------------------------------------
   Function:   wvesa_detect
   Purpose:    Detects which version of VESA is installed 
   Parameters: None
   Return:     0, VESA_1, VESA_2
   ----------------------------------------------------------------------- */


void wvesa_findmodeinfo (void);
/* -----------------------------------------------------------------------
   Function:   wvesa_findmodeinfo
   Purpose:    Stores the information for the available video modes
               in the VESAmodes array
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void wvesa_flip (int retrace);
/* -----------------------------------------------------------------------
   Function:   wvesa_flip
   Purpose:    Flips the display and active drawing pages 
   Parameters: retrace - Number of times to wait for the vertical retrace
   Return:     None
   ----------------------------------------------------------------------- */


unsigned char wvesa_getpixel (int x, int y);
/* -----------------------------------------------------------------------
   Function:   wvesa_getpixel
   Purpose:    Gets the color index of a single pixel
   Parameters: x,y - Coordinate of pixel
   Return:     Color index of pixel
   ----------------------------------------------------------------------- */


void wvesa_hline (int x, int x2, int y);
/* -----------------------------------------------------------------------
   Function:   wvesa_hline
   Purpose:    Draws a horizontal line
   Parameters: x,x2,y - Coordinates of line
   Return:     None
   ----------------------------------------------------------------------- */


void wvesa_line (int x, int y, int x2, int y2);
/* -----------------------------------------------------------------------
   Function:   wvesa_line
   Purpose:    Draws a diagonal line
   Parameters: x,y,x2,y2 - Endpoints of line
   Return:     None
   ----------------------------------------------------------------------- */


block wvesa_newblock (int x0, int y0, int x1, int y1);
/* -----------------------------------------------------------------------
   Function:   wvesa_newblock
   Purpose:    Copies a section of the screen to a new block
   Parameters: x0,y0,x1,y1 - Rectangular region of screen
   Return:     Pointer to the new block
   ----------------------------------------------------------------------- */


void wvesa_outtextxy (int x, int y, wgtfont fnt, char *printit);
/* -----------------------------------------------------------------------
   Function:   wvesa_outtextxy
   Purpose:    Prints a string with the given font
   Parameters: x,y - Top left corner of text
               fnt - Pointer to the font
               printit - Pointer to the string
   Return:     None
   ----------------------------------------------------------------------- */


void wvesa_printf (int x, int y, wgtfont font, char *fmt, ...);
/* -----------------------------------------------------------------------
   Function:   wvesa_printf
   Purpose:    Prints formatted text
   Parameters: x,y - Top left corner of text
               font - Pointer to the font
               fmt - Format string
               ... - parameters for format string
   Return:     None
   ----------------------------------------------------------------------- */


void wvesa_putblock (int x0, int y0, block src, int method);
/* -----------------------------------------------------------------------
   Function:   wvesa_putblock
   Purpose:    Pastes a block to the current screen
   Parameters: x0,y0 - Top left corner of the block on the destination screen
               src - Pointer to the source block
               method - NORMAL or XRAY
   Return:     None
   ----------------------------------------------------------------------- */


void wvesa_putpixel (int x, int y);
/* -----------------------------------------------------------------------
   Function:   wvesa_putpixel
   Purpose:    Draws a single pixel
   Parameters: x,y - Coordinate of pixel
   Return:     None
   ----------------------------------------------------------------------- */


void wvesa_rectangle (int x, int y, int x2, int y2);
/* -----------------------------------------------------------------------
   Function:   wvesa_rectangle
   Purpose:    Draws a hollow rectangle
   Parameters: x,y,x2,y2 - Rectangular region 
   Return:     None
   ----------------------------------------------------------------------- */

void wvesa_resize (int x, int y, int x2, int y2, block image, int mode);
/* -----------------------------------------------------------------------
   Function:   wvesa_resize
   Purpose:    Resizes a block
   Parameters: x,y,x2,y2 - Rectangular region
               mode - NORMAL or XRAY
   Return:     None
   ----------------------------------------------------------------------- */


int wvesa_setpan (int x,int y, int waitVRT);
/* -----------------------------------------------------------------------
   Function:   wvesa_setpan
   Purpose:    Sets the top left corner of the display start address 
   Parameters: x,y - Position of top left corner of display
               waitVRT - 1 if wait for the vertical retrace, 0 otherwise
   Return:     1 if successful, 0 failed
   ----------------------------------------------------------------------- */


int wvesa_setmode (int width, int height, int bits, int linear);
/* -----------------------------------------------------------------------
   Function:   wvesa_setmode
   Purpose:    Finds the video mode and attempts to initialize it 
   Parameters: width  - Width of screen
               height - Height of screen
               bits   - bits per pixel
               linear - 1 if linear frame buffer is to be used, 0 otherwise
   Return:     1 if successful, 0 failed
   ----------------------------------------------------------------------- */


void wvesa_setscreen (int page);
/* -----------------------------------------------------------------------
   Function:   wvesa_setscreen
   Purpose:    Sets the active drawing page for linear frame buffers 
   Parameters: page - SVGA_FRONTBUFFER or SVGA_BACKBUFFER
   Return:     None
   ----------------------------------------------------------------------- */

#ifdef __cplusplus
 }
#endif

#endif
