/* Power Render File Interface */

#ifndef _PRSET_
#define _PRSET_

#ifdef __cplusplus
  extern "C" {
#endif


#define NO_SORT        0
#define FARTHEST_ZSORT 1
#define NEAREST_ZSORT  2
#define AVERAGE_ZSORT  3


/* Used for viewport width and height info */
typedef struct
 {
  PR_DWORD              xhalf;          /* X Center of screen */
  PR_DWORD              yhalf;          /* Y Center of screen */

  PR_UCHAR              MipMap;         /* Mip Mapping toggle */
  PR_UCHAR              MipMapShrink;   /* if true, divides texture coords
                                           by two for every level */
  PR_REAL               MipDepth1;      /* Mip Mapping Z levels */
  PR_REAL               MipDepth2;      /* Mip Mapping Z levels */
  PR_REAL               MipDepth3;      /* Mip Mapping Z levels */
  PR_REAL               MipDepth4;      /* Mip Mapping Z levels */

  PR_DWORD              HardwareMipmaps;/* Number of mipmaps to generate */

  PR_UCHAR              FrontToBack;    /* 0 = back to front
                                           1 = front to back with no overdraw
                                           */
  PR_UCHAR              DepthSort;      /* NO_SORT, FARTHEST_ZSORT,
                                           NEAREST_ZSORT, AVERAGE_ZSORT */

  PR_UCHAR              RealUV;         /* Stores UV in floating point */
  PR_UCHAR              Hardware;       /* True if an accelerator is used */

  PR_REAL               Fog_Far;        /* Farthest fog distance (100%) */
  PR_REAL               Fog_Near;       /* Nearest fog distance (0%)    */
  PR_REAL               Fog_Spread;     /* Distance between far and near */
  PR_UCHAR              Fog_Enabled;    /* 1 if fog is enabled */

  PR_UCHAR              LoadPalette;    /* 1 if palette is loaded into
                                           global_palette with textures */
  PR_DWORD              FirstTexture;   /* First texture number for PRO saving
                                           routines.  Use to skip over the
                                           mouse cursor texture. */

 } PR_SettingsStruct;
extern PR_SettingsStruct PR_Settings;



#ifdef __cplusplus
}
#endif

#endif
