/* Power Render Object Interface */

#ifndef _PROBJECT_
#define _PROBJECT_         /* Mark this header already included */

#ifdef __cplusplus
 extern "C" {
#endif


PR_OBJECT *PR_AllocObject (void);
/* -----------------------------------------------------------------------
   Function:   PR_AllocObject
   Purpose:    Allocates space for an object 
   Parameters: None
   Return:     Pointer to the new object
   ----------------------------------------------------------------------- */


PR_OBJECT *PR_AllocSprite (PR_DWORD material);
/* -----------------------------------------------------------------------
   Function:   PR_AllocSprite
   Purpose:    Allocates space for a sprite
   Parameters: material - Material number
   Return:     Pointer to the new object
   ----------------------------------------------------------------------- */


void PR_CenterObject (PR_OBJECT *object, 
                      PR_REAL *x, PR_REAL *y, PR_REAL *z);
/* -----------------------------------------------------------------------
   Function:   PR_CenterObject
   Purpose:    Centers an object around 0,0,0
   Parameters: object - Pointer to the object
               x, y, z - Pointers to amount in each axis it was moved
   Return:     None
   ----------------------------------------------------------------------- */


PR_OBJECT *PR_DuplicateObject (PR_OBJECT *object);
/* -----------------------------------------------------------------------
   Function:   PR_DuplicateObject
   Purpose:    Duplicates an object
   Parameters: object - Original object
   Return:     Pointer to the new object
   ----------------------------------------------------------------------- */


void PR_FlipFaceNormals (PR_OBJECT *object);
/* -----------------------------------------------------------------------
   Function:   PR_FlipFaceNormals
   Purpose:    Flips all of the face normals for an object
   Parameters: object - Pointer to the object
   Return:     None
   ----------------------------------------------------------------------- */


void PR_FreeObject (PR_OBJECT *object);
/* -----------------------------------------------------------------------
   Function:   PR_FreeObject
   Purpose:    Frees an object and all its segments 
   Parameters: object - Pointer to the object
   Return:     None
   ----------------------------------------------------------------------- */


PR_DWORD PR_GetObjectFaces (PR_OBJECT *object);
/* -----------------------------------------------------------------------
   Function:   PR_GetObjectFaces
   Purpose:    Returns the number of faces in an object 
   Parameters: object - Pointer to the object
   Return:     Number of faces in the object
   ----------------------------------------------------------------------- */


PR_DWORD PR_GetObjectVertices (PR_OBJECT *object);
/* -----------------------------------------------------------------------
   Function:   PR_GetObjectVertices
   Purpose:    Returns the number of vertices in an object
   Parameters: object - Pointer to the object
   Return:     Number of vertices in the object  
   ----------------------------------------------------------------------- */


void PR_InitializeFaceNormals (PR_OBJECT *object);
/* -----------------------------------------------------------------------
   Function:   PR_InitializeFaceNormals
   Purpose:    Initializes the face normals of an object 
   Parameters: object - Pointer to the object
   Return:     None
   ----------------------------------------------------------------------- */


void PR_InitializeVertexNormals (PR_OBJECT *object);
/* -----------------------------------------------------------------------
   Function:   PR_InitializeVertexNormals
   Purpose:    Initializes the normals of all the vertices in an object 
   Parameters: object - Pointer to the object
   Return:     None
   ----------------------------------------------------------------------- */


void PR_ObjectCalcBoundingBox (PR_OBJECT *obj);
/* Calculates the bounding box and bounding sphere of an object */


void PR_SetObjectFaceFlags (PR_OBJECT *object, PR_UCHAR flags,
                            PR_DWORD operation);
/* -----------------------------------------------------------------------
   Function:   PR_SetObjectFaceFlags
   Purpose:    Sets the flags of all faces within an object 
   Parameters: object - Pointer to the object
               flags - Flags to modify
               operation - FLAG_SET, FLAG_CLEAR, FLAG_COPY
   Return:     None
   ----------------------------------------------------------------------- */ 




void PR_TranslateObjectVertices (PR_OBJECT *object, 
                                 PR_REAL x, PR_REAL y, PR_REAL z);
/* -----------------------------------------------------------------------
   Function:   PR_TranslateObjectVertices
   Purpose:    Translates all vertices in an object by x,y,z 
   Parameters: object - Pointer to the object
               x,y,z - Amount to translate
   Return:     None
   ----------------------------------------------------------------------- */


#ifdef __cplusplus
}
#endif

#endif


