/* Power Render Matrix Interface */

#ifndef _PRMATRIX_
#define _PRMATRIX_

#ifdef __cplusplus
  extern "C" {
#endif

extern PR_MATRIX                PR_TranMatrix;   /* Global transformation matrix */
extern PR_REAL                  tvector[4];


PR_REAL PR_GetAngle (PR_REAL x1, PR_REAL y1, PR_REAL x2, PR_REAL y2);
/* -----------------------------------------------------------------------
   Function:   PR_GetAngle
   Purpose:    Returns the angle between two coordinates 
   Parameters: x1,y1 - First coordinate
               x2,y2 - Second coordinate
   Return:     Degrees between points
   ----------------------------------------------------------------------- */

void PR_MatrixClear (PR_MATRIX m);
/* -----------------------------------------------------------------------
   Function:   PR_MatrixClear
   Purpose:    Fills a matrix with zero 
   Parameters: m - Pointer to matrix
   Return:     None
   ----------------------------------------------------------------------- */


void PR_MatrixIdentity (PR_MATRIX m);
/* -----------------------------------------------------------------------
   Function:   PR_MatrixIdentity
   Purpose:    Returns the identity 4x4 matrix 
   Parameters: m - Pointer to the matrix
   Return:     None
   ----------------------------------------------------------------------- */


void PR_MatrixMultiply (PR_MATRIX m2, PR_MATRIX m1, PR_MATRIX m);
/* -----------------------------------------------------------------------
   Function:   PR_MatrixMultiply
   Purpose:    Multiplies two matrices together to form another matrix 
   Parameters: m2 - Pointer to the second matrix
               m1 - Pointer to the first matrix
               m - Pointer to the resulting matrix
   Return:     None
   ----------------------------------------------------------------------- */


void PR_MatrixOrtho (PR_ORIENTATION *o);
/* -----------------------------------------------------------------------
   Function:   PR_MatrixOrtho
   Purpose:    Make the rotation matrix orthonormal.  This is needed
               for acculumated rotation matrices because they
               lose accuracy each time they are concatenated.
   Parameters: o - Pointer to the orientation structure
   Return:     None
   ----------------------------------------------------------------------- */


void PR_MatrixRotate (PR_MATRIX m, PR_REAL x, PR_REAL y, PR_REAL z);
/* -----------------------------------------------------------------------
   Function:   PR_MatrixRotate
   Purpose:    Returns a matrix for rotation 
   Parameters: m - Pointer to the matrix
               x,y,z - Amount to rotate in degrees
   Return:     None
   ----------------------------------------------------------------------- */


void PR_MatrixScale (PR_MATRIX m, PR_REAL x, PR_REAL y, PR_REAL z);
/* -----------------------------------------------------------------------
   Function:   PR_MatrixScale
   Purpose:    Returns a matrix for scaling 
   Parameters: m - Pointer to the matrix
               x,y,z - Scaling factors
   Return:     None
   ----------------------------------------------------------------------- */


void PR_MatrixTranslate (PR_MATRIX m, PR_REAL x, PR_REAL y, PR_REAL z);
/* -----------------------------------------------------------------------
   Function:   PR_MatrixTranslate
   Purpose:    Returns a matrix for translation 
   Parameters: m - Pointer to the matrix
               x,y,z - Amount to translate
   Return:     None
   ----------------------------------------------------------------------- */


void PR_MatrixTranspose (PR_MATRIX mat, PR_MATRIX m);
/* -----------------------------------------------------------------------
   Function:   PR_MatrixTranspose
   Purpose:    Makes a transpose of the 3x3 upper matrix mat 
   Parameters: mat - Pointer to the original matrix
               m - Pointer to the transpose of mat
   Return:     None
   ----------------------------------------------------------------------- */


void PR_Transform (PR_MATRIX t);
/* -----------------------------------------------------------------------
   Function:   PR_Transform
   Purpose:    Transform a vector through a matrix 
   Parameters: t - Pointer to the transformation matrix
   Return:     None
   ----------------------------------------------------------------------- */

#ifdef __cplusplus
}
#endif

#endif
