#include <conio.h>
#include <stdlib.h>

#include <pr.h>

#ifdef __3DFX__
#include <pr3dfx.h>
#include <glide.h>
#endif

#ifdef WIN32
#include <winutil.h>
#endif



/* Power Render Example 2

   Description:  Provides a minimal application which loads and rotate
                 a PRO file, in any video mode.
*/

                                             
PR_VIEWPORT viewport;                  /* Our viewport structure */
PR_CAMERA *camera;                     /* One camera */
PR_OBJECT *object_shape;               /* The shape loaded */
PR_ENTITY *entity;                     /* A single entity of the shape */
PR_DWORD  device=0;                    /* Display device */


void InitializeDevices (void)
{
  /* Attempt to find the device */

  #ifdef __3DFX__
  if ((device == DEVICE_3DFX) || (device == DEVICE_ANY))
    device = PR_Detect3Dfx ();
  #endif

#ifndef MSGLIDE
  if ((device == DEVICE_SVGA) || (device == DEVICE_ANY))
    device = PR_DetectSVGA ();   

  if ((device == DEVICE_VGA) || (device == DEVICE_ANY))
    device = PR_DetectVGA ();   
#endif

  /* Attempt to initialize the device */
  #ifdef __3DFX__
  if (device == DEVICE_3DFX)
    {
     PR_Initialize3Dfx ();
     atexit (PR_Shutdown3Dfx);
    }
  #endif

#ifndef MSGLIDE
  if (device == DEVICE_SVGA)
    {
     PR_InitializeSVGA ();
     atexit (PR_ShutdownSVGA);
    }
  else if (device == DEVICE_VGA)
    {
     PR_InitializeVGA ();
    }
#endif
}



void main (void)
{
PR_DWORD vwidth, vheight;
PR_REAL cenx, ceny, cenz;
PR_UDWORD BLACK;                       /* Color index/value for black */

#ifdef MSGLIDE
  device = 'y';
#else
  while (kbhit ()) getch ();
  #ifdef __3DFX__
  printf ("Use 3Dfx? (y/n)\n");
  device = getch ();
  #endif
#endif

  PR_Initialize (1000);                /* Maximum 1000 triangles per frame */

  if (device == 'y' || device == 'Y')
    device = DEVICE_3DFX;
  else
    device = DEVICE_SVGA;

  InitializeDevices ();

  PR_AllocMaterials (32);              /* Allocate the materials, */
  PR_AllocTextures (32);               /* textures, */
  PR_AllocShadeTables (2);             /* and shade tables */


  /* Try 640x480 first */
  vwidth = 640;
  vheight = 480;
  if (PR_SetMode (vwidth, vheight, 60) != MODE_SUCCESS)
    {
     /* If that doesn't work, try the first one in the mode list */
     vwidth = PR_VideoModes[0].width;     /* Initialize the video mode */
     vheight = PR_VideoModes[0].height;
     PR_SetMode (vwidth, vheight, 60);
    }


  PR_OpenViewport (&viewport, 0, 0, vwidth-1, vheight-1, VIEW_PLAIN);
  PR_SetViewport (&viewport);          /* Open a full screen viewport */

  /* Load the object */
  PR_SetTexturePath ("..\\data\\");
  object_shape = PR_LoadPRO ("..\\data\\cube.pro", LOAD_NORMAL);
  PR_CenterObject (object_shape, &cenx, &ceny, &cenz);

#ifndef MSGLIDE
  /* Set the palette from the textures loaded */
  wsetpalette (0, 255, global_palette);
#endif

  /* Create the main entity */
  entity = PR_CreateEntity (object_shape, "TEST ENTITY");


  camera = PR_AllocCamera ();          /* Initialize the camera */
  PR_InitializeCamera (camera);
  PR_PositionCameraSource (camera, 0, 0, 400);
  PR_PositionCameraTarget (camera, 0, 0, 0);
  PR_SetCameraMode (camera, CAMFLAG_AIM_TARGET); 
  PR_SetActiveCamera (camera);

  PR_OpenScreen (PR_BACKBUFFER);
  BLACK = PRGFX_MakeColor (0, 0, 0);

  installkbd ();

  /* main program loop */
  while (!kbdon[KEY_ESC])
    {
     #ifdef WIN32
       UpdateMessages ();
     #endif	 

     PR_NewFrame ();                   /* Begin a new frame */

     PRGFX_SetColor (BLACK);
     PRGFX_ClearScreen ();             /* Clear the last frame */

     PR_RotateEntity (entity, 3, 2, 1);/* Rotate the entity */
     PR_TransformEntity (entity);      /* Transform the entity */
     PR_RenderEntity (entity);         /* Render the entity */

     PR_RenderFrame ();                /* Draw the scene */

     PR_Flip (1);                      /* Show the background page */
    }

  uninstallkbd ();

  /* Free all allocated memory */
  PR_FreeCamera (camera);
  PR_FreeEntity (entity);
  PR_FreeObject (object_shape);
  PR_CloseViewport (&viewport);
  PR_DeleteAllShadeTables ();
  PR_DeleteAllTextures ();
  PR_DeleteAllMaterials ();
  PR_ShutDown ();

#ifndef WIN32
  wsetmode (3);                        /* Go back to text mode */
#endif
}

