// Not highly optimised, but I'm only interested in the idea.
#include "graph.h"
#include <conio.h>
#include <alloc.h>
#include <stdlib.h>
#include <math.h>

#define SCALING_FACTOR1		10
#define SCALING_FACTOR2    50
#define XOFFSET				160
#define YOFFSET				100
#define ZOFFSET				550
#define VERTICES				SCALING_FACTOR1 * SCALING_FACTOR2
#define PALSIZE				63
#define RADIUS1				25
#define RADIUS2				50
#define RADIUS3				25

typedef struct
{
int X, Y, Z;
} Point3D;
Point3D Shape[VERTICES], RotatedShape[VERTICES];
Point Shape2D[VERTICES], Face2D[3];
void Setup(void), RotateShape(void), Draw2DFaces(void);
void DrawFace(int Index1, int Index2, int Index3);
byte far *VirtualScreen, Colours[3];
int DrawOrder[VERTICES], MaxZ = RADIUS1 + RADIUS2 + RADIUS3, Vertices = 0;
int PolygonCoords[VERTICES][4], VertexCount, ZValue, Compare();

int main(void)
{
	Setup();
	while(!kbhit())
	{
		RotateShape();
		qsort(DrawOrder, Vertices, 2, Compare);
		ClearScreen();
		Draw2DFaces();
//		WaitForRetrace();
		Flip64000(0xA000, Segment);
	}
	(void) getch();
	farfree(VirtualScreen);
	SetVideoMode(0x03);
	return 0;
}

int Compare(Number1, Number2)
int *Number1, *Number2;
{
	return RotatedShape[*Number2].Z - RotatedShape[*Number1].Z;
}

void RotateShape(void)
{
	static float Phi = 0, Theta = 0;
	float SinePhi = sin(Phi), CosinePhi = cos(Phi), SineTheta = sin(Theta), CosineTheta = cos(Theta);

	for(VertexCount = 0; VertexCount < Vertices; VertexCount++)
	{
		RotatePoint(Shape[VertexCount].Y, Shape[VertexCount].Z, 0, 0, SinePhi, CosinePhi, &RotatedShape[VertexCount].Y, &RotatedShape[VertexCount].Z);
		RotatePoint(Shape[VertexCount].X, RotatedShape[VertexCount].Z, 0, 0, SineTheta, CosineTheta, &RotatedShape[VertexCount].X, &RotatedShape[VertexCount].Z);
	}
	Phi += 0.05; Theta += 0.04;
	return;
}

void Draw2DFaces(void)
{
	for(VertexCount = 0; VertexCount < Vertices; VertexCount++)
	{
		ZValue = (ZOFFSET + RotatedShape[VertexCount].Z) >> 2;
		Shape2D[VertexCount].X = XOFFSET + ((RotatedShape[VertexCount].X) << 7) / ZValue;
		Shape2D[VertexCount].Y = YOFFSET + ((RotatedShape[VertexCount].Y) << 7) / ZValue;
	}
	for(VertexCount = 0; VertexCount < Vertices; VertexCount++)
	{
		DrawFace(PolygonCoords[DrawOrder[VertexCount]][0], PolygonCoords[DrawOrder[VertexCount]][1], PolygonCoords[DrawOrder[VertexCount]][2]);
		DrawFace(PolygonCoords[DrawOrder[VertexCount]][0], PolygonCoords[DrawOrder[VertexCount]][2], PolygonCoords[DrawOrder[VertexCount]][3]);
	}
	return;
}

void DrawFace(int Index1, int Index2, int Index3)
{
	if((RotatedShape[Index2].X - RotatedShape[Index1].X) *
		(RotatedShape[Index1].Y - RotatedShape[Index3].Y) <
		(RotatedShape[Index2].Y - RotatedShape[Index1].Y) *
		(RotatedShape[Index1].X - RotatedShape[Index3].X)) return;
	Face2D[0].X = Shape2D[Index1].X;
	Face2D[0].Y = Shape2D[Index1].Y;
	Face2D[1].X = Shape2D[Index2].X;
	Face2D[1].Y = Shape2D[Index2].Y;
	Face2D[2].X = Shape2D[Index3].X;
	Face2D[2].Y = Shape2D[Index3].Y;
	Colours[0] = 1 + (PALSIZE - 1) * (RotatedShape[Index1].Z + MaxZ) / (MaxZ << 1);
	Colours[1] = 1 + (PALSIZE - 1) * (RotatedShape[Index2].Z + MaxZ) / (MaxZ << 1);
	Colours[2] = 1 + (PALSIZE - 1) * (RotatedShape[Index3].Z + MaxZ) / (MaxZ << 1);
	if(PolygonCoords[DrawOrder[VertexCount]][0] & 2)
	{
		Colours[0] += PALSIZE;
		Colours[1] += PALSIZE;
		Colours[2] += PALSIZE;
	}
	GouraudShade(Face2D, Colours);
	return;
}

void Setup(void)
{
	extern unsigned int Segment;
	double dx, dy, dz, Alpha, Beta, Modulus, Value, X, Y, Z;
	double Distance, MinDistance;
	int Count1, Count2, Index1, Index2, Rotation;

	for(Alpha = 0, Count2 = 0; Count2 < SCALING_FACTOR2; Count2++, Alpha += 2 * M_PI / SCALING_FACTOR2)
	{
/*
I'm very proud of the below formula which I derived completely myself. You
can get other shapes by changing X, Y, Z and dx, dy, dz. All it does is
plot a tube around an arbitrary space curve defined by the parametric
equations given in terms of Alpha to X, Y and Z. Note: it will only work
if dx, dy and dz are the derivatives of X, Y and Z with respect to Alpha.
*/
		X = RADIUS2 * cos(2 * Alpha) + RADIUS1 * sin(Alpha);
		Y = RADIUS2 * sin(2 * Alpha) + RADIUS1 * cos(Alpha);
		Z = RADIUS2 * cos(3 * Alpha);
		dx = -2 * RADIUS2 * sin(2 * Alpha) + RADIUS1 * cos(Alpha);
		dy = 2 * RADIUS2 * cos(2 * Alpha) - RADIUS1 * sin(Alpha);
		dz = -3 * RADIUS2 * sin(3 * Alpha);
		Value = sqrt(dx * dx + dz * dz);
		Modulus = sqrt(dx * dx + dy * dy + dz * dz);
		for(Beta = 0, Count1 = 0; Count1 < SCALING_FACTOR1; Count1++, Beta += 2 * M_PI / SCALING_FACTOR1)
		{
			Shape[Vertices].X =	X - RADIUS3 * (cos(Beta) * dz - sin(Beta) *
										dx * dy / Modulus) / Value;
			Shape[Vertices].Y =	Y - RADIUS3 * sin(Beta) * Value / Modulus;
			Shape[Vertices].Z =	Z + RADIUS3 * (cos(Beta) * dx + sin(Beta) *
										dy * dz / Modulus) / Value;
			Vertices++;
		}
	}
	for(Count1 = 0; Count1 < SCALING_FACTOR2; Count1++)
	{
		Index1 = Count1 * SCALING_FACTOR1;
		Index2 = Index1 + SCALING_FACTOR1;
		Index2 %= Vertices;
		Rotation = 0;
		MinDistance =
(Shape[Index1].X - Shape[Index2].X) * (Shape[Index1].X - Shape[Index2].X) +
(Shape[Index1].Y - Shape[Index2].Y) * (Shape[Index1].Y - Shape[Index2].Y) +
(Shape[Index1].Z - Shape[Index2].Z) * (Shape[Index1].Z - Shape[Index2].Z);
		for(Count2 = 1; Count2 < SCALING_FACTOR1; Count2++)
		{
			Index2 = Count2 + Index1 + SCALING_FACTOR1;
			if(Count1 == SCALING_FACTOR2 - 1) Index2 = Count2;
			Distance =
(Shape[Index1].X - Shape[Index2].X) * (Shape[Index1].X - Shape[Index2].X) +
(Shape[Index1].Y - Shape[Index2].Y) * (Shape[Index1].Y - Shape[Index2].Y) +
(Shape[Index1].Z - Shape[Index2].Z) * (Shape[Index1].Z - Shape[Index2].Z);
			if(Distance < MinDistance)
			{
				MinDistance = Distance;
				Rotation = Count2;
			}
		}
		for(Count2 = 0; Count2 < SCALING_FACTOR1; Count2++)
		{
			Index2 = (SCALING_FACTOR1 + Count2 + Rotation) % SCALING_FACTOR1;
			PolygonCoords[Index1 + Count2][0] = Index1 + Count2;
			Index2 = Count2 + 1;
			Index2 %= SCALING_FACTOR1;
			PolygonCoords[Index1 + Count2][1] = Index1 + Index2;
			Index2 = Count2 + Rotation + 1;
			Index2 %= SCALING_FACTOR1;
			PolygonCoords[Index1 + Count2][2] = (Index1 + Index2 + SCALING_FACTOR1) % Vertices;
			Index2 = Count2 + Rotation;
			Index2 %= SCALING_FACTOR1;
			PolygonCoords[Index1 + Count2][3] = (Index1 + Index2 + SCALING_FACTOR1) % Vertices;
		}
	}
	VirtualScreen = farmalloc(64000LU);
	Segment = FP_SEG(VirtualScreen);
	for(Count1 = 0; Count1 < Vertices; Count1++) DrawOrder[Count1] = Count1;
	SetVideoMode(0x13);
	for(Count1 = 1; Count1 <= PALSIZE; Count1++)
	{
		SetRgbPal(Count1, 63 - 63 * Count1 / PALSIZE, 0, 0);
		SetRgbPal(PALSIZE + Count1, 0, 0, 63 - 63 * Count1 / PALSIZE);
	}
	return;
}