// The necessary graphics functions for GSSHAPES.C.
#include <dos.h>
#include <math.h>

typedef unsigned char byte;
typedef struct
{
int X, Y;
} Point;
void PutPixel(unsigned int X, unsigned int Y, byte Colour);
void ClearScreen(void);
void Flip64000(unsigned int Destination, unsigned int Source);
void GouraudShade(Point Vertices[3], byte Colours[3]);
void SetVideoMode(int Mode);
void RotatePoint(int X, int Y, int XCenter, int YCenter, float SinAngle, float CosAngle, int *EndX, int *EndY);
void WaitForRetrace(void);
void SetRgbPal(byte Col, byte Red, byte Green, byte Blue);
unsigned int Segment = 0xA000;

void PutPixel(unsigned int X, unsigned int Y, byte Colour)
{
	_ES = Segment;
	asm {
		mov ax, Y
		shl ax, 6
		mov di, ax
		shl ax, 2
		add di, ax
		add di, X
		mov al, Colour
		mov [es:di], al
	}
	return;
}

void ClearScreen(void)
{
	_ES = Segment;
	asm {
		xor di, di
		xor ax, ax
		mov cx, 16000
	}
	__emit__(0x66, 0xC1, 0xE0, 0x10);	// shl eax, 16
	__emit__(0xF3, 0x66, 0xAB);			// rep stosd
	return;
}

void Flip64000(unsigned int Destination, unsigned int Source)
{
	asm {
		push ds
		mov ax, [Destination]
		mov es, ax
		mov ax, [Source]
		mov ds, ax
		xor si, si
		xor di, di
		mov cx, 16000
	}
	__emit__(0xF3, 0x66, 0xA5);	// rep movsd
	asm pop ds
	return;
}

void GouraudShade(Point Vertices[3], byte Colours[3])
{ // Not highly optimised, but sufficient.
	byte StartColour, EndColour;
	int MinY = 0, MaxY = 0, Count, ColourIncSign, ColourIncCount, ColourDiff;
	int Y, LineWidth, EndVertex1, EndVertex2, StartVertex1, StartVertex2;
	int XDiff1, XDiff2, YDiff1, YDiff2, X1, X2, ColourDiff1, ColourDiff2;
	int XCalc1 = 0, XCalc2 = 0, ColourCalc1 = 0, ColourCalc2 = 0;

	for(Count = 1; Count < 3; Count++)
	{
		if(Vertices[Count].Y < Vertices[MinY].Y) MinY = Count;
		else if(Vertices[Count].Y > Vertices[MaxY].Y) MaxY = Count;
	}
	StartVertex1 = StartVertex2 = MinY;
	EndVertex1 = MinY + 2;
	if(EndVertex1 >= 3) EndVertex1 -= 3;
	EndVertex2 = MinY + 1;
	if(EndVertex2 >= 3) EndVertex2 -= 3;
	XDiff1 = Vertices[EndVertex1].X - Vertices[StartVertex1].X;
	YDiff1 = Vertices[EndVertex1].Y - Vertices[StartVertex1].Y;
	XDiff2 = Vertices[EndVertex2].X - Vertices[StartVertex1].X;
	YDiff2 = Vertices[EndVertex2].Y - Vertices[StartVertex1].Y;
	ColourDiff1 = Colours[EndVertex1] - Colours[StartVertex1];
	ColourDiff2 = Colours[EndVertex2] - Colours[StartVertex2];
	if(YDiff1 == 0) YDiff1 = 1;
	if(YDiff2 == 0) YDiff2 = 1;
	for(Y = Vertices[MinY].Y; Y <= Vertices[MaxY].Y; Y++)
	{
		X2 = Vertices[StartVertex1].X + XCalc1 / YDiff1;
		XCalc1 += XDiff1;
		X1 = Vertices[StartVertex2].X + XCalc2 / YDiff2;
		XCalc2 += XDiff2;
		EndColour = Colours[StartVertex1] + ColourCalc1 / YDiff1;
		ColourCalc1 += ColourDiff1;
		StartColour = Colours[StartVertex2] + ColourCalc2 / YDiff2;
		ColourCalc2 += ColourDiff2;
		if(EndColour > StartColour) ColourIncSign = 1;
		else ColourIncSign = -1;
		ColourDiff = abs(StartColour - EndColour);
		LineWidth = X2 - X1;
		ColourIncCount = ColourDiff - (LineWidth >> 1);
		for(Count = X1; Count < X2; Count++)
		{
			PutPixel(Count, Y, StartColour);
			while(ColourIncCount >= 0)
			{
				StartColour += ColourIncSign;
				ColourIncCount -= LineWidth;
			}
			ColourIncCount += ColourDiff;
		}
		if(Y == Vertices[EndVertex1].Y)
		{
			StartVertex1 = EndVertex1;
			EndVertex1 = EndVertex2;
			XDiff1 = Vertices[EndVertex1].X - Vertices[StartVertex1].X;
			YDiff1 = Vertices[EndVertex1].Y - Vertices[StartVertex1].Y;
			ColourDiff1 = Colours[EndVertex1] - Colours[StartVertex1];
			if(YDiff1 == 0) YDiff1 = 1;
			XCalc1 = XDiff1;
			ColourCalc1 = ColourDiff1;
		}
		if(Y == Vertices[EndVertex2].Y)
		{
			StartVertex2 = EndVertex2;
			EndVertex2 = EndVertex1;
			XDiff2 = Vertices[EndVertex2].X - Vertices[StartVertex2].X;
			YDiff2 = Vertices[EndVertex2].Y - Vertices[StartVertex2].Y;
			ColourDiff2 = Colours[EndVertex2] - Colours[StartVertex2];
			if(YDiff2 == 0) YDiff2 = 1;
			XCalc2 = XDiff2;
			ColourCalc2 = ColourDiff2;
		}
	}
	return;
}

void SetVideoMode(int Mode)
{
	asm {
		mov ax, Mode
		int 10h
	}
	return;
}

void RotatePoint(int X, int Y, int XCenter, int YCenter, float SinAngle, float CosAngle, int *EndX, int *EndY)
{
	*EndX = (X - XCenter) * CosAngle - (Y - YCenter) * SinAngle + XCenter;
	*EndY = (Y - YCenter) * CosAngle + (X - XCenter) * SinAngle + YCenter;
	return;
}

void WaitForRetrace(void)
{
	while(inp(0x3DA) & 8) ;
	while(!(inp(0x3DA) & 8)) ;
	return;
}

void SetRgbPal(byte Col, byte Red, byte Green, byte Blue)
{
	asm {
		mov   dx, 0x3C8
		mov   al, [Col]
		out	dx, al
		inc   dx
		mov   al, [Red]
		out	dx, al
		mov   al, [Green]
		out   dx, al
		mov   al, [Blue]
		out   dx, al
	}
	return;
}