/************************************************************************/
/* tll on tapion vanhan vesa-kirjaston koodi.                        */
/* Copyright (c) 1997 Tapio Vuorinen aka Bull / Hubris.                 */
/* some modifications by Chem.                                          */
/************************************************************************/

#include <sys\nearptr.h>
#include "ialot.h"
#include "vesa.h"

#define PACKED __attribute__ ((packed))

typedef unsigned char uchar;
typedef unsigned short ushort;
typedef unsigned long ulong;
typedef unsigned int uint;

#pragma pack(1)
typedef struct _VBEvInfo
{
    char signature[4] PACKED;
    unsigned short version PACKED;
    unsigned long OEMnamepointer PACKED;
    unsigned long capabilities PACKED;
    unsigned long modelistpointer PACKED;
    unsigned short memoryblocks PACKED;
    char reserved[493] PACKED;
} VBEvInfo;

#pragma pack(1)
typedef struct _VBEmInfo
{
    ushort attributes PACKED;
    uchar AttrWinA PACKED;
    uchar AttrWinB PACKED;
    ushort granularityKB PACKED;
    ushort WindowSizeKB PACKED;
    ushort WinAstartSeg PACKED;
    ushort WinBstartSeg PACKED;
    ulong FARwinPosFunc PACKED;
    ushort bpl PACKED; // bytes per line
    ushort width PACKED;
    ushort height PACKED;
    uchar CharWidth PACKED;
    uchar CharHeight PACKED;
    uchar memPlanes PACKED;
    uchar bpp PACKED; // bits per pixel.. aktiivista bitti per pikseli.
    uchar banks PACKED;
    uchar memorymodel PACKED;
    uchar banksizeKB PACKED;
    uchar imagepages PACKED;
    uchar reserved1 PACKED;
    uchar RedMaskSize PACKED; // montako bitti punaista per pixel
    uchar RedFieldPos PACKED;
    uchar GreenMaskSize PACKED; // montako bitti vihre per pixel
    uchar GreenFieldSize PACKED;
    uchar BlueMaskSize PACKED; // montako sinist punaista per pixel
    uchar BlueFieldSize PACKED;
    uchar ResMaskSize PACKED; // montako bitti varattua per pixel
    uchar ResMaskPos PACKED;
    uchar DirColMInfo PACKED;
    ulong PhyAddrLFB PACKED;
    ulong offscreenmem PACKED;
    ushort offscreenKB PACKED;
    uchar reserved2[206] PACKED;
} VBEmInfo;

typedef struct _VBE32BitColor
{
    uchar b PACKED;
    uchar g PACKED;
    uchar r PACKED;
    uchar reserved PACKED;
} VBE32BitColor;

typedef struct _VBE24BitColor
{
    uchar b PACKED;
    uchar g PACKED;
    uchar r PACKED;
} VBE24BitColor;

typedef struct _VBE16BitColor
{
    unsigned b:5;
    unsigned g:6;
    unsigned r:5;
} VBE16BitColor;

typedef struct _VBE15BitColor
{
    unsigned b:5;
    unsigned g:5;
    unsigned r:5;
    unsigned reserved:1;
} VBE15BitColor;

#pragma pack()

#define TRUE 1
#define FALSE 0

VBEvInfo VBEinfo;
VBEmInfo VBEmodeinfo;

/* ******************************************************************** */
/* ********************************************************************
 Common VESA functions begin...
 ******************************************************************** */
/* ******************************************************************** */

void VESAgetinfo(VBEvInfo *vbeinfo);
void VESAgetmodeinfo(ushort mode, VBEmInfo *vbemodeinfo);
void VESAsetmode(ushort mode, int LFB);
void VESAswitchbank(short bank);
void VESAgetwingran();
void VESAgetlinearaddress();
void VESAinitmode(ushort mode);
int VESAcheckVBE2();
int VESAcheckmode(int mode);

unsigned char *VESAvidseg=(unsigned char *)0x0A0000;

void VESAgetinfo(VBEvInfo *vbeinfo)
{
    __dpmi_regs r;

    vbeinfo->signature[0]='V';
    vbeinfo->signature[1]='B';
    vbeinfo->signature[2]='E';
    vbeinfo->signature[3]='2';

    if (sizeof(VBEvInfo) > _go32_info_block.size_of_transfer_buffer)
    {
      printf("\n\n** internal error **\n");
      fflush(stdout);
    }

    r.x.ax = 0x4F00;
    r.x.di = __tb & 0x0F;
    r.x.es = (__tb >> 4) & 0xFFFF;
    dosmemput(vbeinfo, sizeof(VBEvInfo), __tb);
    __dpmi_int(0x10, &r);
    dosmemget(__tb, sizeof(VBEvInfo), vbeinfo);
}

void VESAgetmodeinfo(ushort mode, VBEmInfo *vbemodeinfo)
{
    __dpmi_regs r;
    
    r.x.ax = 0x4F01;
    r.x.cx = mode;
    r.x.di = __tb & 0x0F;
    r.x.es = (__tb >> 4) & 0xFFFF;
    
    dosmemput(vbemodeinfo, sizeof(VBEmInfo), __tb);
    __dpmi_int(0x10, &r);
    dosmemget(__tb, sizeof(VBEmInfo), vbemodeinfo);
}

void VESAsetmode(ushort mode, int LFB)
{
    __dpmi_regs r;

    r.x.ax=0x4F02;
    if (LFB)
    {
        r.x.bx=(mode | 0x4000);
    } else {
        r.x.bx=mode;
    }
    __dpmi_int(0x10,&r);
}

inline void VESAswitchbank(short bank)
{
    __dpmi_regs r;

    r.x.ax=0x4F05;
    r.x.bx=0x0000;
    r.x.dx=bank;
    __dpmi_int(0x10, &r);
}

void VESAgetwingran()
{
    VBECurrentMode.wingran=0;
    while ((unsigned)(64 >> VBECurrentMode.wingran) != VBEmodeinfo.granularityKB)
        VBECurrentMode.wingran++;
}

void VESAgetlinearaddress()
{
    __dpmi_meminfo mi;
    int buffersize;

    buffersize=((ulong)VBEmodeinfo.bpl * (ulong)VBEmodeinfo.height);
    mi.size=(ulong)buffersize;
    mi.address=VBEmodeinfo.PhyAddrLFB;
    __dpmi_physical_address_mapping(&mi);
    __dpmi_lock_linear_region(&mi);
    VBECurrentMode.linearaddress=mi.address;

    VBECurrentMode.linearselector=__dpmi_allocate_ldt_descriptors(1);
    __dpmi_set_segment_base_address(VBECurrentMode.linearselector, VBECurrentMode.linearaddress);
    __dpmi_set_segment_limit(VBECurrentMode.linearselector, buffersize-1);

    VBECurrentMode.LFBptr=(uchar *)0x0;
}

void VESAinitmode(ushort mode)
{
    int virscrsize=0;

    if (!VESAcheckmode(mode))
    {
        VESAgetmodeinfo(mode,&VBEmodeinfo);
/*
        printf("memPlanes %u\n", VBEmodeinfo.memPlanes);
        printf("banks %u\n", VBEmodeinfo.banks);
        printf("granularityKB %u\n", VBEmodeinfo.granularityKB);
        printf("banksizeKB %u\n", VBEmodeinfo.banksizeKB);
        printf("imagepages %u\n", VBEmodeinfo.imagepages);
        printf("reserved1 %u\n", VBEmodeinfo.reserved1);
        printf("bpp %u\n",VBEmodeinfo.bpp);
        printf("bpl %u\n",VBEmodeinfo.bpl);
        printf("width %u\n",VBEmodeinfo.width);
        printf("height %u\n",VBEmodeinfo.height);
        printf("RedMaskSize %u\n",VBEmodeinfo.RedMaskSize);
        printf("GreenMaskSize %u\n",VBEmodeinfo.GreenMaskSize);
        printf("BlueMaskSize %u\n",VBEmodeinfo.BlueMaskSize);
        printf("ResMaskSize %u\n",VBEmodeinfo.ResMaskSize);
        printf("DirColMInfo %u\n",VBEmodeinfo.DirColMInfo);

        getch();
*/

//        VBEmodeinfo.attributes&=(~128L); //remove LFB support.
        if ((VBEmodeinfo.attributes & 128) == 128)
        {
            VESAsetmode(mode,TRUE);
        } else {
            VESAsetmode(mode,FALSE);
        }

        VBECurrentMode.bytesperline=VBEmodeinfo.bpl;

        VBECurrentMode.bytesperpixel=(VBEmodeinfo.RedMaskSize +
                                      VBEmodeinfo.GreenMaskSize +
                                      VBEmodeinfo.BlueMaskSize +
                                      VBEmodeinfo.ResMaskSize) >> 3;

        VBECurrentMode.width=VBEmodeinfo.width;
        VBECurrentMode.height=VBEmodeinfo.height;

        VESAgetwingran();
        if ((VBEmodeinfo.attributes & 128) == 128)
        {
            VESAgetlinearaddress();
        } else {
            VBECurrentMode.linearaddress=0;
        }

        virscrsize=(int)VBEmodeinfo.bpl * (int)VBEmodeinfo.height;
        VESAvirscr=(unsigned char *)malloc(virscrsize);
    }
}

void VESAdeinitmode()
{
    free(VESAvirscr);
    VBECurrentMode.wingran=0;
    VBECurrentMode.linearaddress=0;
    VBECurrentMode.linearselector=0;
    VBECurrentMode.bytesperline=0;
    VBECurrentMode.bytesperpixel=0;
    VBECurrentMode.width=0;
    VBECurrentMode.height=0;
}

int VESAcheckVBE2()
{
    VESAgetinfo(&VBEinfo);
    if (VBEinfo.version >= 512)
        return 0;
    else
        return -1;
}

int VESAcheckmode(int mode)
{
    VESAgetmodeinfo(mode, &VBEmodeinfo);
    if ((VBEmodeinfo.attributes & 1) == 1)
    {
        return 0;
    } else {
        return -1;
    }
}

void setVESAmode(int mode)
{
 if ( VESAcheckVBE2() == -1 )
 {
   printf("VBE 2.0 not supported! (install univbe)\n");
   exit(1);
 }

 if ( VESAcheckmode(mode) == -1 )
 {
   printf("Requested mode (0x%X) not supported!\n",mode);
   exit(1);
 }

 VESAinitmode(mode);
 VESAclear(VESAvirscr);
}

void inline VESAclear10F(VBE24BitColor *dest)
{
    unsigned int *point = (unsigned int *)dest,
                  size  = (unsigned int)VBECurrentMode.bytesperline *
                          (unsigned int)VBECurrentMode.height,
                  count;

    size /= 4;

    for (count=0;count<size;count++)
        point[count]=0;
}

void inline VESALFBflip10F(VBE24BitColor *source)
{
    unsigned int size = (unsigned int)VBECurrentMode.bytesperline *
                        (unsigned int)VBECurrentMode.height;
    movedata(_my_ds(), (uint)source,
             VBECurrentMode.linearselector, (uint)VBECurrentMode.LFBptr,
             size);
    /*dosmemput(source, (64000*sizeof(VBE24BitColor)), linaddr);*/
}

/* ******************************************************************** */

void inline VESAbankflip10F(VBE24BitColor *source)
{ // banksize has to be 64kB.
    char *dest,*src;
    int i,size = (int)VBECurrentMode.bytesperline * (int)VBECurrentMode.height;
    
    src=(char *)source;
    dest=VESAvidseg + __djgpp_conventional_base;
    
    __djgpp_nearptr_enable();
    
    i = 0;
    while (size > 0) {
     VESAswitchbank(i << VBECurrentMode.wingran);
     i++;
     if (size > 65535L) memcpy(dest,src,65536L);
      else memcpy(dest,src,size);
     size -= 65536L;
     src += 65536L;
    }
    
    __djgpp_nearptr_disable();
}

void VESAflip10F(VBE24BitColor *source)
{
    if (VBECurrentMode.linearaddress)
    {
        VESALFBflip10F(source);
    } else {
        VESAbankflip10F(source);
    }
}

void VESAflip(void *ptr)
{
    VESAflip10F((VBE24BitColor *)ptr);
}

void VESAclear(void *ptr)
{
    VESAclear10F((VBE24BitColor *)ptr);
}
