// BlobsEfx.h: interface for the CBlobsEfx class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BLOBSEFX_H__CE6ED161_A447_11D5_AD0F_E0DA56C10027__INCLUDED_)
#define AFX_BLOBSEFX_H__CE6ED161_A447_11D5_AD0F_E0DA56C10027__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Efx.h"

class CBlobsEfx : public CEfx  
{
private:
	
	PDIRECT3DVERTEXBUFFER8	m_pvbBackFx;
	PDIRECT3DVERTEXBUFFER8	m_pvbWireframeCube;
	PDIRECT3DINDEXBUFFER8	m_pibWireframeCube;

	PDIRECT3DVERTEXBUFFER8	m_pvbSyncSphere;
	PDIRECT3DINDEXBUFFER8	m_pibSyncSphere;

	he3d_CVector			m_vSphereVector[38];
	he3d_CVector			m_vSphere[38][4];
	DWORD					m_dwSyncIndex[38];	

	he3d_CMatrix			m_mtxSphere;

	he3d_CVector			m_vCube[1000];
	he3d_CVector			m_vEmiterPos;
	
	he3d_CMatrix			m_mtxBackFx[5];

	CSimpleBlobSystem		m_bsSystem;
	CSimpleBlob3D			m_b3dBlobs[27];	

	CSimpleMesh				m_smGrid;

	he3d_CMatrix			m_mtxBlobs;
	he3d_CMatrix			m_mtxGrid;

	VECTORKEY				m_vSpline[27][20];
	DWORD					m_dwBlobSplineKeyCount[27];

	CImageQuad*				m_piqFace;
	CImageQuad*				m_piqVis;
	CImageQuad*				m_piqDispaly;

	FLOATKEY				m_fSync[6][100];
	DWORD					m_dwKeyCount[6];

	VOID LoadSplines();

public:
	CBlobsEfx( PDIRECT3DDEVICE8 pDevice );
	virtual ~CBlobsEfx();

	virtual BOOL UpdateFrame( FLOAT fTime );
	virtual BOOL RenderEfx();
};

#endif // !defined(AFX_BLOBSEFX_H__CE6ED161_A447_11D5_AD0F_E0DA56C10027__INCLUDED_)
