// SimpleMesh.h: interface for the CSimpleMesh class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SIMPLEMESH_H__A29D98E8_708B_11D5_AD0F_607057C10000__INCLUDED_)
#define AFX_SIMPLEMESH_H__A29D98E8_708B_11D5_AD0F_607057C10000__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CSimpleMesh  
{
private:

	DWORD					m_dwType;

	PDIRECT3DVERTEXBUFFER8	m_pvbVertices;
	PDIRECT3DINDEXBUFFER8	m_pibIndices;

	DWORD					m_dwVertexCount;
	DWORD					m_dwFacesCount;

	he3d_CVector			m_vCenter;

public:

	CSimpleMesh();	
	~CSimpleMesh();

	BOOL Load( PDIRECT3DDEVICE8 pDevice, TCHAR* name );
	// this function simply calls render function after seting apropiate streams, indices etc
	// so any desired render states should be set before calling it
	BOOL Render( PDIRECT3DDEVICE8 pDevice );

	// atrributes
	he3d_CVector GetCenter();
	DWORD GetFacesCount();
	DWORD GetVertexCount();
	PDIRECT3DVERTEXBUFFER8 GetVertexBuffer();
	PDIRECT3DINDEXBUFFER8 GetIndexBuffer();
	DWORD GetVertexStride();

	// locking
	BOOL LockMesh( LPBYTE* vertices, LPBYTE* indices );
	BOOL UnlockMesh();

	// operations
	VOID FlipNormals();
};

#endif // !defined(AFX_SIMPLEMESH_H__A29D98E8_708B_11D5_AD0F_607057C10000__INCLUDED_)
