// Projector.h: interface for the CProjector class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PROJECTOR_H__F8320541_A2AC_11D5_AD0F_70D456C10027__INCLUDED_)
#define AFX_PROJECTOR_H__F8320541_A2AC_11D5_AD0F_70D456C10027__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Efx.h"

class CProjector : public CEfx  
{
private:
	
	PDIRECT3DVERTEXBUFFER8	m_pvbProjector;	

	PDIRECT3DVERTEXBUFFER8	m_pvbBeams[4];

	PDIRECT3DVERTEXBUFFER8	m_pvbZoom;
	CTextureRenderer*		m_ptrZoom;

	BOOL					m_bRenderZoom;

	PDIRECT3DTEXTURE8		m_ptexDepthMap;
	PDIRECT3DTEXTURE8		m_ptexTemp;

	CSimpleMesh				m_smQuadric;
	CSimpleMesh				m_smRing;

	he3d_CMatrix			m_mtxRing[2];

	he3d_CMatrix			m_mtxCube;
	he3d_CMatrix			m_mtxLights[4];

	he3d_CMatrix			m_mtxBeams[4];

	he3d_CMatrix			m_mtxProjector;

	he3d_CVector			m_vProjectors[4];
	he3d_CVector			m_vOrgin[4];

	CTextureRenderer*		m_ptrProjector[4];
	CImageQuad*				m_piqSpot;	
	
	FLOAT					m_fBaseLenght[4][256];

	FLOATKEY				m_fSync[6][100];
	DWORD					m_dwKeyCount[6];

	FLOAT					m_fFalloff[4];

	CImageQuad*				m_piqGrid;
	CImageQuad*				m_piqEyes;

	CImageQuad*				m_piqFade;
	BOOL					m_bRenderFade;

public:

	CProjector( PDIRECT3DDEVICE8 );
	virtual ~CProjector();

	virtual BOOL UpdateFrame( FLOAT fTime );
	virtual BOOL RenderEfx();

};

#endif // !defined(AFX_PROJECTOR_H__F8320541_A2AC_11D5_AD0F_70D456C10027__INCLUDED_)
