// VertexTypes.cpp: implementation of the VertexTypes class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "VertexTypes.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

_TLVERTEX::_TLVERTEX( he3d_CVector& v, FLOAT fRhw, DWORD dwColor, FLOAT fU, FLOAT fV ) : m_vPos( v ),
																						 m_fRhw( fRhw ),
																						 m_dwColor( dwColor ),
																						 m_fU( fU ),
																						 m_fV( fV )
{
}

_TLVERTEX::_TLVERTEX( FLOAT x, FLOAT y, FLOAT z, FLOAT fRhw, DWORD dwColor, FLOAT fU, FLOAT fV ) : m_vPos( x, y, z ),
																								   m_fRhw( fRhw ),
																								   m_dwColor( dwColor ),
																								   m_fU( fU ),
																								   m_fV( fV )
																									
{
}

_LVERTEX::_LVERTEX( he3d_CVector& v, DWORD dwColor, FLOAT fU, FLOAT fV ) : m_vPos( v ),
																		   m_dwColor( dwColor ),
																		   m_fU( fU ),
																		   m_fV( fV )
{
}

_LVERTEX::_LVERTEX( FLOAT x, FLOAT y, FLOAT z, DWORD dwColor, FLOAT fU, FLOAT fV ) : m_vPos( x, y, z ),
																					 m_dwColor( dwColor ),
																					 m_fU( fU ),
																					 m_fV( fV )
{
}


_SIMPLEVERTEX::_SIMPLEVERTEX( he3d_CVector& v, DWORD dwColor ) : m_vPos( v ),
																 m_dwColor( dwColor )
{
}

_SIMPLEVERTEX::_SIMPLEVERTEX( FLOAT x, FLOAT y, FLOAT z, DWORD dwColor ) : m_vPos( x, y, z ),
																		   m_dwColor( dwColor )
{
}

_VERTEX::_VERTEX( he3d_CVector& v, he3d_CVector& n, FLOAT fU, FLOAT fV ) : m_vPos( v ),
																		   m_vN( n ),
																		   m_fU( fU ),
																		   m_fV( fV )
{
}

_VERTEX::_VERTEX( FLOAT px, FLOAT py, FLOAT pz, FLOAT nx, FLOAT ny, FLOAT nz, FLOAT fU, FLOAT fV ) : m_vPos( px, py, pz ),
																									 m_vN( nx, ny, nz ),
																									 m_fU( fU ),
																									 m_fV( fV )
{
}
						
_NPOSVERTEX::_NPOSVERTEX( FLOAT px, FLOAT py, FLOAT pz, FLOAT nx, FLOAT ny, FLOAT nz ) : m_vPos( px, py, pz ),
																						 m_vN( nx, ny, nz )
{
}

_NPOSVERTEX::_NPOSVERTEX( he3d_CVector& v, he3d_CVector& n ) : m_vPos( v ),
															   m_vN( n )
{
}