// SolarSystem.h: interface for the CSolarSystem class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SOLARSYSTEM_H__80A58C41_81BE_11D5_AD0F_C06357C12026__INCLUDED_)
#define AFX_SOLARSYSTEM_H__80A58C41_81BE_11D5_AD0F_C06357C12026__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CSolarSystem : public CEfx  
{
private:

	CSimpleMesh				m_mSphere;	

	LPDIRECT3DVERTEXBUFFER8	m_pvbRing;
	LPDIRECT3DVERTEXBUFFER8	m_pvbRays;
	LPDIRECT3DVERTEXBUFFER8	m_pvbSolarCrown;
	LPDIRECT3DVERTEXBUFFER8	m_pvbStars;
	LPDIRECT3DVERTEXBUFFER8	m_pvbSeed;

	he3d_CVector			m_vCrown[1000];
	he3d_CMatrix			m_mtxCrown;

	he3d_CMatrix			m_mtxPlanets[9];	
	PDIRECT3DTEXTURE8		m_ptextPlanets[9];

	he3d_CMatrix			m_mtxMoon;	

	he3d_CMatrix			m_mtxSaturnRings;
	he3d_CMatrix			m_mtxUranRings;

	he3d_CMatrix			m_mtxRays;

	CParticleSystem			m_psSeedSystem;	
	CPointEmiter			m_peSeedEmiter;
	CPointEmiter			m_peBeamEmiter[10];

	he3d_CVector			m_vBeamDir[10];

	he3d_CVector			m_vPrevPos;
	

	VECTORKEY				m_vsCamPos[10];
	VECTORKEY				m_vsCamTrg[10];
	VECTORKEY				m_vsSeedPos[10];

	CImageQuad*				m_piqFade;

public:
	CSolarSystem( PDIRECT3DDEVICE8 pDevice );
	virtual ~CSolarSystem();

	virtual BOOL InitEfx();
	virtual BOOL FinishEfx();
	virtual BOOL UpdateFrame( FLOAT fTime );
	virtual BOOL RenderEfx();

};

#endif // !defined(AFX_SOLARSYSTEM_H__80A58C41_81BE_11D5_AD0F_C06357C12026__INCLUDED_)
