// Blurer.h: interface for the CBlurer class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BLURER_H__162F9C42_717C_11D5_AD0F_E06357C10000__INCLUDED_)
#define AFX_BLURER_H__162F9C42_717C_11D5_AD0F_E06357C10000__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CBlurer  
{
private:
	
	PDIRECT3DTEXTURE8		m_ptextTargets[2];
	PDIRECT3DSURFACE8		m_psurfTargetZbuffer;

	PDIRECT3DSURFACE8		m_psurfPrevTarget;
	PDIRECT3DSURFACE8		m_psurfPrevZbuffer;	

	PDIRECT3DVERTEXBUFFER8	m_pvbBlurQuad;
	PDIRECT3DVERTEXBUFFER8	m_pvbOutQuad;

	PDIRECT3DDEVICE8		m_pDevice;

	BOOL					m_bBeginScene;
	DWORD					m_dwAlpha;

	DWORD					m_dwCurrentPage;

public:

	CBlurer( PDIRECT3DDEVICE8 pDevice, BOOL useZBuffer = TRUE, DWORD width = 512, DWORD height = 512, D3DFORMAT format = D3DFMT_A8R8G8B8, D3DFORMAT zformat = D3DFMT_D24S8 );
	~CBlurer();

	BOOL BeginScene();
	BOOL EndScene();

	BOOL SetBlurFactor( DWORD dwFactor );
	BOOL SetBlurFactor( FLOAT fFactor );	

	BOOL Clear();

	PDIRECT3DTEXTURE8 GetTargetTexture( DWORD dwPage );
	PDIRECT3DTEXTURE8 GetCurrentTargetTexture();
	PDIRECT3DTEXTURE8 GetPrevTargetTexture();
};

#endif // !defined(AFX_BLURER_H__162F9C42_717C_11D5_AD0F_E06357C10000__INCLUDED_)
