; fake.asm
; part of the woorlic Truecolor lib

;                     Mode    Width    Height   Bpp   Type
fake_default_mode dd   0   ,   320   ,  200   ,  14  , 1

fake_lut dd 0

fake_ofsA0000 dd 0

fake_outer    dd 0

; 1 - Init
; 2 - Startup
; 3 - Blit
; 4 - Killof
fake_handler:
 pushad
  cmp eax,1
  je fake_init
  cmp eax,2
  je fake_start
  cmp eax,3
  je fake_blit
  cmp eax,4
  je fake_kill
 popad
 mov eax,0
ret

fake_add_modes:
 mov ecx,1
 mov esi,offset fake_default_mode
ret

fake_init:
; Setup linear pointer

  mov fake_ofsA0000,0a0000h
  call i_getls
  add fake_ofsA0000,eax

; Allocate memory for lut
  mov eax,256*256
  call i_alloc
  mov fake_lut,eax

  mov ebx,0
  mov ecx,256*256
  mov edi,fake_lut
 fake_init_loop:
   mov eax,ebx
   shr ah,4
   shr ax,4
   cmp al,0
   jne fake_init_loop_nz
    jmp fake_init_loop_cnt
   fake_init_loop_nz:
   test al,07h
   jnz fake_init_loop_cnt
    inc al
   fake_init_loop_cnt:
   stosb
   inc ebx
  loop fake_init_loop

 popad
 mov eax,2
ret

fake_start:
   mov ax,013h
   int 010h

   mov dx,03c4h    ; Mode Y
   mov al,04
   out dx,al
   inc dx
   in al,dx
   and al,0f7h
   out dx,al

   mov dx,03d4h    ; Kill word mode
   mov al,017h
   out dx,al
   inc dx
   mov al,0e3h
   out dx,al

   mov dx,03d4h    ; Kill dword mode
   mov al,014h
   out dx,al
   inc dx
   mov al,0
   out dx,al

   mov dx,03d4h    ; Set multiview to 0
   mov al,9
   out dx,al
   inc dx
   in al,dx
   and al,0e0h
   out dx,al

 ; Now in unchained 320x400x8bpp, using this to fake..
   call fake_setpal
 popad
 mov eax,2
ret

fake_blit:
; mov edi,0a0000h
; call i_getls
; add edi,eax
; mov ebx,0
; mov ecx,64000
; mov esi,fake_lut
;fake_blit_loop:
;  mov al,[ebx+esi]
;  stosb
;  inc ebx
; loop fake_blit_loop

 mov al,1                ; 1 = page 1
 call fake_i_setpage

 mov esi,tcono
 call fake_copy1

 mov al,2                ; 2 = page 2
 call fake_i_setpage

 mov esi,tcono
 add esi,4
 call fake_copy2

 mov al,4                ; 4 = page 3
 call fake_i_setpage

 mov esi,tcono
 add esi,8
 call fake_copy1

 mov al,8                ; 8 = page 4
 call fake_i_setpage

 mov esi,tcono
 add esi,12
 call fake_copy2


 mov ax,0
 call fake_setvisible

 popad
 mov eax,2
ret

fake_i_setpage:
  pushad
   mov cl,al
   mov dx,03c4h
   mov al,02
   out dx,al
   inc dx
   mov al,cl
   out dx,al
  popad
ret

fake_kill:
 popad
 mov eax,2
ret

fake_setpal:
  mov al,0
  mov dx,3c8h
  out dx,al
  inc dx
  mov ecx,256
 fake_setpal_g:
   mov al,0
   out dx,al
   out dx,al
   mov eax,256
   sub eax,ecx
   shr eax,2
   out dx,al
  loop fake_setpal_g

  mov edi,0
  mov esi,16
 fake_setpal_r:
  mov ecx,16
  fake_setpal_b:
   test edi,07h
   jz fake_setpal_jrb
   mov eax,edi
   dec dx
   out dx,al
   inc dx

   mov eax,16
   sub eax,esi
   shl eax,2
   out dx,al                      ; Output, Ri*4.846

   mov eax,16
   sub eax,ecx
   shl eax,2
   out dx,al

   mov al,0
   out dx,al

   fake_setpal_jrb:
   inc edi
  loop fake_setpal_b
  dec esi
  jnz fake_setpal_r
ret

fake_copy1:
 pushad
  mov edi,fake_ofsA0000
  mov ebp,fake_lut

  mov fake_outer,200
  fake_copy1_loop2:
   mov ecx,20
   fake_copy1_loop1:

    mov ebx,[esi+32]
    mov dl,bl
    shr ebx,8
    movzx ebx,bx
    mov al,[ebx+ebp]

    mov ebx,[esi+48]
    mov dh,bl
    shr ebx,8
    movzx ebx,bx
    mov ah,[ebx+ebp]

    rol eax,16
    rol edx,16

    mov ebx,[esi]
    mov dl,bl
    shr ebx,8
    movzx ebx,bx
    mov al,[ebx+ebp]

    mov ebx,[esi+16]
    mov dh,bl
    shr ebx,8
    movzx ebx,bx
    mov ah,[ebx+ebp]

    rol edx,0
    rol eax,0

    and edx,0f8f8f8f8h
    mov [edi+80],edx
    stosd

    add esi,64

   loop fake_copy1_loop1
   add edi,80
  dec fake_outer
  jnz fake_copy1_loop2
 popad
ret

fake_copy2:
 pushad
  mov edi,fake_ofsA0000
  mov ebp,fake_lut
  add edi,80

  mov fake_outer,200
  fake_copy2_loop2:
   mov ecx,20
   fake_copy2_loop1:

    mov ebx,[esi+32]
    mov dl,bl
    shr ebx,8
    movzx ebx,bx
    mov al,[ebx+ebp]

    mov ebx,[esi+48]
    mov dh,bl
    shr ebx,8
    movzx ebx,bx
    mov ah,[ebx+ebp]

    rol eax,16
    rol edx,16

    mov ebx,[esi]
    mov dl,bl
    shr ebx,8
    movzx ebx,bx
    mov al,[ebx+ebp]

    mov ebx,[esi+16]
    mov dh,bl
    shr ebx,8
    movzx ebx,bx
    mov ah,[ebx+ebp]


    rol edx,0
    rol eax,0

    and edx,0f8f8f8f8h
    mov [edi-80],edx
    stosd

    add esi,64

   loop fake_copy2_loop1
   add edi,80
  dec fake_outer
  jnz fake_copy2_loop2
 popad
ret

fake_setvisible:
pushad
   mov bx,ax
   mov dx,03d4h

   mov al,0ch
   out dx,al
   mov al,bh
   inc dx
   out dx,al
   dec dx

   mov al,0dh
   out dx,al
   mov al,bl
   inc dx
   out dx,al
   dec dx
popad
ret
